unsupported = false

FLOOD_WATER = 0
FLOOD_LAVA  = 1
FLOOD_SAND  = 2
FLOOD_MUD   = 3

FLOOD_EASY_MODE_LEVELS = 0
FLOOD_LEVEL_COUNT = 0

----------------------------------------
             -- GAMES --
			 -----------
-------------
-- Agent X --
-------------
GAME_VANILLA                        = 0
GAME_STAR_ROAD                      = 1
------------------
-- MarcoGamerOJ --
------------------
GAME_SUPER_MARIO_74_AND_EE          = 2 -- added Extreme Edition
GAME_THE_GREEN_STARS                = 3
GAME_LUIGIS_MANSION_64              = 4
GAME_MOONSHINE                      = 5
------------------
-- New romhacks --
------------------
GAME_SUPER_MARIO_74_TEN_YEARS_AFTER = 6
GAME_KATZE_STUCK_IN_THE_TOILET_64   = 7
GAME_MARVEL_ADVENTURE               = 8
GAME_EUREKA                         = 9
GAME_SCROOGE_64                     = 10
GAME_SUPER_MARIO_PARALLEL_STARS     = 11
GAME_DREAMSCAPE                     = 12
GAME_COLORFUL_LANDS                 = 13
GAME_SM74EEEEEE                     = 14
GAME_SUPER_MARIO_64_SAPPHIRE        = 15
GAME_THE_MUSHROOM_CUP               = 16
GAME_THE_GALACTIC_JOURNEY           = 17
GAME_STAR_REVENGE_1_3_REDONE        = 18
GAME_STAR_REVENGE_3                 = 19
GAME_STAR_REVENGE_6                 = 20
GAME_BRUTAL_MARIO_64                = 21
GAME_SOME_KIND_OF_A_CRASH_GAME      = 22
GAME_BEAT_BLOCK_BEATDOWN            = 23
GAME_SUPER_LUIGI_64_THE_FLOWER_CUP  = 24
GAME_LUGS_DELIGHTFUL_DIORAMAS       = 25
GAME_PROJECT_REIMAGINED             = 26
GAME_STAR_REVENGE_1                 = 27
GAME_KAIZO_MARIO_64                 = 28
GAME_STAR_REVENGE_6_9               = 29
GAME_SUPER_MARIO_64_SHINING_STARS   = 30
GAME_BUILD_3313                     = 31
GAME_STAR_REVENGE_5                 = 32
GAME_STAR_REVENGE_7                 = 33
GAME_SUPER_MARIO_64_EXTRA           = 34 -- by SuperRodrigo0
GAME_SUPER_MARIO_64_ODYSSEY         = 35 -- by SuperRodrigo0
GAME_STAR_REVENGE_4_5               = 36
GAME_STAR_REVENGE_0_5               = 37
GAME_LUIGIS_MANSION_64_5_SUPER_MODE = 38
GAME_BLOSSOMING_BLUDS               = 39
GAME_WAIFU_CAULDRON                 = 40
GAME_LUIGI_AND_THE_FOREST_RUINS     = 41 -- by SuperRodrigo0
GAME_TYD64                          = 42 -- by SuperRodrigo0
GAME_NICE_MARIO_75                  = 43 -- by SuperRodrigo0
GAME_ZTAR_ATTACK_2                  = 44
GAME_DREAM64                        = 45 -- by SuperRodrigo0
GAME_SM64_TWISTED_ADVENTURES        = 46 -- by SuperRodrigo0
GAME_SUPER_MARIO_BROS_64            = 47 -- by SuperRodrigo0
GAME_WINTERBOTTOM_PIE_TRIALS        = 48
GAME_SERVUS_64                      = 49
GAME_CURSED_CASTLES                 = 50
GAME_MARIOS_NIGHTMARE_64            = 51
GAME_STAR_REVENGE_1_5_REDONE        = 52
GAME_MARIOS_TREASURE_DOME           = 53
GAME_SUPER_MARIO_RAINBOW_ROAD       = 54
GAME_LUIGI_AND_THE_VIOLET_STARS     = 55
GAME_SM64_INTO_BOWSERS_CASTLE       = 56
GAME_STAR_REVENGE_2_5               = 57
GAME_STAR_REVENGE_2                 = 58 -- by SuperRodrigo0
GAME_STAR_REVENGE_7_5               = 59
GAME_STAR_REVENGE_4_9               = 60
GAME_SM64_LAST_IMPACT               = 61
GAME_SM64_THE_DARK_STARS            = 62
GAME_ETERNAL_REALM                  = 63
GAME_THROUGH_THE_AGES               = 64
GAME_SUPER_TRUMP_64                 = 65
GAME_SM64_MASTERS_CHALLENGE         = 66 -- by SuperRodrigo0
GAME_YOSHIS_ADVENTURE_64            = 67
GAME_SUPER_MARIO_TREASURE_WORLD     = 68 -- by SuperRodrigo0
GAME_SUPER_MARIO_8MB                = 69
GAME_SONIC_ADVENTURE_64             = 70
GAME_SLEEPY_TIME_64                 = 71
GAME_SHINING_STARS_2                = 72
GAME_KAIZO_MARIO_64_2               = 73
GAME_SM74EEEE                       = 74
GAME_SM74EEEEEE_2                   = 75
GAME_COMPACT_CHALLENGES             = 76
GAME_SUPER_MARIO_AND_THE_GRAND_STAR = 77
GAME_DESPAIR_MARIOS_GAMBIT          = 78
GAME_SUPER_MARIO_FALLEN_STARS       = 79
GAME_JAMMIN_JOURNEY                 = 80
GAME_THE_STOLEN_STARS               = 81
GAME_SUPER_MARIO_64_LENTILEVELS     = 82
GAME_ROCKY_MOUNTAIN_REVISITED       = 83
GAME_SM64_TWISTED_ADVENTURES_2      = 84
GAME_THE_POWER_STAR_JOURNEY         = 85
GAME_BOWSERS_DANK_RAVE_1            = 86
GAME_BOWSERS_DANK_RAVE_2            = 87
GAME_BOWSERS_DANK_RAVE_3            = 88
GAME_SUPER_MARIO_STAR               = 89
GAME_WW_MOSTRECENT                  = 90
GAME_SM64_MADNESS                   = 91
GAME_YEAR_OF_THE_PLUMBER            = 92
GAME_KING_BOOS_REVENGE_2            = 93
GAME_SM64_ITS_A_CRASH               = 94 -- by SuperRodrigo0
GAME_RETURN_TO_RETROLAND            = 95 -- by SuperRodrigo0
GAME_LETTERFUL_WOOD_BLOCKS          = 96 -- by SuperRodrigo0
GAME_ROYAL_LEGACY                   = 97 -- by SuperRodrigo0
GAME_MARIO_HEROES_64                = 98
GAME_MUHLY_64                       = 99
GAME_UNKNOWN_ROMHACK_1              = 100
GAME_URANIUM_MARIO_64               = 101
GAME_SM64_LAND                      = 102
----------------------------------------

game = GAME_VANILLA

--- @class FloodLevel
--- @field public level integer
--- @field public name string
--- @field public goalPos Vec3f
--- @field public speed number
--- @field public area integer
--- @field public type integer
--- @field public time integer
--- @field public customStartPos Vec3f

--- @type FloodLevel[]
gLevels = {}
-- localize functions to improve performance
local table_insert,djui_popup_create = table.insert,djui_popup_create

local function flood_define_level(easy, level, name, goalPos, speed, area, type, customStartPos)
    table_insert(gLevels, { level = level, name = name, goalPos = goalPos, speed = speed, area = area, type = type, time = 0, customStartPos = customStartPos })

    if easy then FLOOD_EASY_MODE_LEVELS = FLOOD_EASY_MODE_LEVELS + 1 end
    FLOOD_LEVEL_COUNT = FLOOD_LEVEL_COUNT + 1
end
_G.flood_define_level = flood_define_level

--- @param o Object
local function obj_mark_for_deletion_on_sync(o)
    if gNetworkPlayers[0].currAreaSyncValid then obj_mark_for_deletion(o) end
end

local function flood_load_vanilla_levels()
  game = GAME_VANILLA
  LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
  romhackText = "Super Mario 64"
  TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")
  flood_define_level(true, LEVEL_CASTLE_GROUNDS, "?", { x = 0,  y = 0,  z = 0, a = 0x8000 }, 0.0,  1, FLOOD_WATER, nil)
end

local function flood_load_super_mario_74_ten_years_after_levels()
    game = GAME_SUPER_MARIO_74_TEN_YEARS_AFTER
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD		
    romhackText = "Super Mario 74 - Ten Years After"
    TEX_ROMHACK_LOGO = get_texture_info("sm74tya_logo")		
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

  flood_define_level(false, LEVEL_BOB,              "c1",          { x = -3065, y =  2680, z = -2660, a =  0x0000 }, 3.5,  1,   FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_WF,               "c2",          { x = -4030, y =  5800, z =  1330, a =  0x4000 }, 5.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_JRB,              "c3",          { x = -2995, y =  3690, z = -2405, a =  0x4000 }, 3.5,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_PSS,              "pss",         { x =  3535, y = 10120, z =   890, a =  0x8000 }, 4.0,  1,   FLOOD_WATER, { x =  2650, y =  -210, z =    320, a = 0x9000 })
  flood_define_level(false, LEVEL_BITDW,            "b1",          { x = -3690, y =  3445, z = -2300, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",    { x =  3690, y =  3445, z = -2300, a =  0x0000 }, 3.0,  1,   FLOOD_LAVA,  nil) 
  flood_define_level(false, LEVEL_CCM,              "c4",          { x =  5505, y =     0, z =  4290, a = -0x4000 }, 3.0,  1,   FLOOD_MUD,   { x = -3150, y = -1375, z =   5170, a = 0x8000 })
  flood_define_level(false, LEVEL_BBH,              "c5",          { x =   -80, y =  5020, z =  6010, a =  0x8000 }, 4.0,  1,   FLOOD_LAVA,  { x =    25, y =  -950, z =   6210, a = 0x8000 })
  flood_define_level(false, LEVEL_VCUTM,            "vc",          { x =  -460, y =  6590, z = -1435, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x = -5325, y =  1920, z =  -1240, a = 0x4000 })
  flood_define_level(false, LEVEL_COTMC,            "mc",          { x =  4355, y =  8350, z =   395, a = -0x6000 }, 2.75, 1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_LLL,              "c7",          { x =  1060, y = 12725, z =   570, a = -0x4000 }, 2.0,  1,   FLOOD_WATER, { x =  1800, y = -1800, z =  -2735, a = 0x8000 })
  flood_define_level(false, LEVEL_SSL,              "c8",          { x =  4480, y =  3810, z = -4500, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_DDD,              "c9",          { x =  3680, y =  5545, z =  4730, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x =  2895, y =   895, z =   5555, a = 0x8000 })
  flood_define_level(false, LEVEL_BITFS,            "b2",          { x = -4950, y =  1540, z = -4500, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x =  2595, y =  1340, z =   2225, a = 0x4000 })
  flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",    { x =  4430, y =  1780, z =  6280, a =  0x8000 }, 2.5,  1,   FLOOD_SAND,  nil)
  flood_define_level(false, LEVEL_SL,               "c10",         { x =  -260, y =  5135, z = -2440, a =  0x8000 }, 3.0,  1,   FLOOD_SAND,  nil)
  flood_define_level(false, LEVEL_WDW,              "c11",         { x = -5260, y =  3265, z =  6175, a =  0x4000 }, 4.0,  1,   FLOOD_MUD,   nil)  
  flood_define_level(false, LEVEL_TTM,              "c12",         { x =   -60, y =  6295, z =  1640, a =  0x8000 }, 2.0,  2,   FLOOD_WATER, { x =  -100, y =   450, z =   4405, a = 0x8000 })
  flood_define_level(false, LEVEL_TTM,              "c12-2",       { x =  4280, y =  7725, z = -4330, a =  0x0000 }, 2.5,  3,   FLOOD_WATER, { x =    10, y =  -140, z =   1055, a = 0x8000 })
  flood_define_level(false, LEVEL_THI,              "c13",         { x = -6270, y =  4825, z =  -810, a =  0x4000 }, 1.0,  1,   FLOOD_WATER, { x = -5000, y =   520, z =  -2765, a = 0x0000 })
  flood_define_level(false, LEVEL_TTC,              "c14",         { x =  1905, y =  9320, z =   615, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_RR,               "c15",         { x =  -910, y =  7865, z =  2570, a =  0x0000 }, 4.0,  1,   FLOOD_MUD,   nil)
  flood_define_level(false, LEVEL_SA,               "sa",          { x = -5760, y =  5240, z =  4685, a =  0x4000 }, 2.0,  1,   FLOOD_LAVA,  nil)  
  flood_define_level(false, LEVEL_ENDING,           "gm",          { x =   -10, y =  6165, z =  1865, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x =   105, y =  3340, z =   1965, a = 0x8000 }) 
  flood_define_level(false, LEVEL_ENDING,           "gm-2",        { x =  8240, y =  1780, z = -3960, a =  0x8000 }, 1.0,  2,   FLOOD_LAVA,  { x = -8405, y =  -635, z =  -7020, a = 0x4000 }) 
  flood_define_level(false, LEVEL_ENDING,           "gm-3",        { x =  8810, y =  4120, z = -5610, a =  0x8000 }, 1.0,  3,   FLOOD_WATER, { x =  6900, y =  1815, z =   6990, a = 0x0000 })
  flood_define_level(false, LEVEL_ENDING,           "gm-4",        { x = -4030, y =  7300, z =  7245, a =  0x4000 }, 1.75, 2,   FLOOD_LAVA,  { x = -1345, y =  -330, z =   8330, a = 0x4000 })     
  flood_define_level(false, LEVEL_ENDING,           "gm-5",        { x = -6715, y = 13290, z = 13400, a =  0x0000 }, 1.5,  3,   FLOOD_WATER, { x = -2585, y =  3365, z = -12030, a = 0x4000 })    
  flood_define_level(false, LEVEL_ENDING,           "t-b",         { x =   -10, y =  2710, z =  2710, a =  0x0000 }, 2.5,  6,   FLOOD_WATER, { x = -5650, y =   780, z =  -5475, a = 0x4000 })        
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",          { x = -3395, y =  2580, z =  7050, a =  0x8000 }, 4.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",       { x =   320, y =  3200, z =  2015, a = -0x4000 }, 3.5,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_CASTLE,           "c",           { x = -5630, y =  1750, z = -6905, a =  0x2000 }, 3.0,  1,   FLOOD_LAVA,  nil)    
end
  
 -- Super Mario 74 ported to Flood by MarcoGamerOJ
local function flood_load_super_mario_74_and_extreme_edition_levels()
    game = GAME_SUPER_MARIO_74_AND_EE
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Super Mario 74 & Extreme Edition"
	TEX_ROMHACK_LOGO = get_texture_info("sm74_logo")
	gLevelValues.metalCapDurationCotmc  = 1200
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

  flood_define_level(false, LEVEL_BOB,              "c1",             { x =  3185, y =  1670, z =  2240, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, { x = -3332, y =  -614, z = -4443, a =  0x0000 })
  flood_define_level(false, LEVEL_WF,               "c2",             { x = -5151, y =  3487, z =  1265, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x = -2457, y = -1174, z = -1530, a =  0x0000 })
  flood_define_level(false, LEVEL_JRB,              "c3",             { x = -3636, y =  4343, z =   365, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, { x = -4206, y =  3885, z = -5035, a =  0x0000 })
  flood_define_level(false, LEVEL_COTMC,            "mc",             { x = -3100, y =  1226, z = -2378, a =  0x4000 }, 3.5,  1,  FLOOD_LAVA,  { x = -1021, y =    58, z =  3059, a =  0x8000 })  
  flood_define_level(false, LEVEL_BITDW,            "b1",             { x =  2385, y =  3966, z =  1800, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x =  3622, y =  -565, z = -5287, a =  0x0000 })
  flood_define_level(false, LEVEL_CCM,              "c4",             { x = -5850, y =   737, z = -1245, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =  2652, y =  -310, z = -5266, a =  0x0000 })  
  flood_define_level(false, LEVEL_BBH,              "c5",             { x =   100, y =  3605, z = -4130, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =   -74, y = -2046, z = -5059, a =  0x0000 })
  flood_define_level(false, LEVEL_VCUTM,            "vc",             { x = -1487, y =  3615, z = -1080, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x = -6187, y = -1020, z =  -880, a =  0x4000 })
  flood_define_level(false, LEVEL_PSS,              "pss",            { x = -3300, y =  4670, z =  1390, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, { x =   144, y = -7482, z =  2111, a =  0x4000 })  
  flood_define_level(false, LEVEL_HMC,              "c6",             { x =  6395, y =  2290, z =  -970, a =  0x0000 }, 3.5,  1,  FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_LLL,              "c7",             { x =  1080, y = 11935, z =   570, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  1105, y = -2415, z = -2325, a =  0x0000 })
  flood_define_level(false, LEVEL_SSL,              "c8",             { x = -4660, y =  4630, z =  5450, a =  0x8000 }, 3.0,  1,  FLOOD_SAND,  { x =  4161, y =  -938, z = -4433, a =  0x0000 })
  flood_define_level(false, LEVEL_DDD,              "c9",             { x = -3970, y =  1910, z = -4250, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x = -3155, y = -3235, z = -5022, a =  0x0000 })
  flood_define_level(false, LEVEL_BITFS,            "b2",             { x = -3226, y =  1309, z =  5959, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, { x =  1068, y =   -68, z = -3178, a =  0x0000 })
  flood_define_level(false, LEVEL_SL,               "c10",            { x =  4405, y =  2648, z =  4878, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, { x = -4088, y = -1111, z = -6492, a =  0x0000 })  
  flood_define_level(false, LEVEL_WDW,              "c11",            { x =  -283, y =  3189, z = -4941, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x =  2615, y =  -111, z =  3153, a =  0x0000 })
  flood_define_level(false, LEVEL_TTM,              "c12",            { x =   155, y =  2840, z =  -650, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_THI,              "c13",            { x = -3410, y =  3185, z =  4600, a =  0x8000 }, 4.0,  1,  FLOOD_LAVA,  { x =     0, y =     0, z =     0, a =  0x0000 })
  flood_define_level(false, LEVEL_TTC,              "c14",            { x = -6225, y =  4158, z =  6678, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =   625, y = -1888, z =  -141, a =  0x0000 })
  flood_define_level(false, LEVEL_RR,               "c15",            { x =  3642, y =  3241, z = -6198, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x = -3050, y = -3050, z =  7205, a =  0x4000 })
  flood_define_level(false, LEVEL_SA,               "sa",             { x =   112, y =  1778, z = -1998, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =    51, y = -1504, z =  -631, a =  0x0000 })
  flood_define_level(false, LEVEL_BITS,             "b3",             { x =  1894, y =   857, z = -1188, a = -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x = -3380, y =  1570, z =  6165, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =  5880, y =  4763, z =  3997, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, { x =  -612, y = -1578, z =  3727, a =  0x8000 })
  flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  5600, y =  1750, z =  6850, a =  0x8000 }, 3.0,  1,  FLOOD_LAVA,  nil)
  -- EXTREME EDITION
  flood_define_level(false, LEVEL_BOB,              "c1-ee",          { x =   650, y =  2255, z = -2035, a =  0x0000 }, 2.5,  2,  FLOOD_LAVA,  { x =  3334, y =  -898, z = -5228, a =  0x0000 })
  flood_define_level(false, LEVEL_WF,               "c2-ee",          { x = -2177, y =  5569, z =  -716, a =  0x4000 }, 5.0,  2,  FLOOD_WATER, { x =  3802, y = -2720, z =  -749, a =  0x0000 })
  flood_define_level(false, LEVEL_JRB,              "c3-ee",          { x =  2277, y =  2996, z = -3056, a = -0x2000 }, 3.0,  2,  FLOOD_LAVA,  { x =  -957, y = -4379, z =  -811, a =  0x0000 })
  flood_define_level(false, LEVEL_COTMC,            "mc-ee",          { x =  3308, y =  7522, z =  -381, a = -0x1000 }, 3.5,  2,  FLOOD_LAVA,  nil)  
  flood_define_level(false, LEVEL_BITDW,            "b1-ee",          { x = -2552, y =  4095, z =  2189, a =  0x8000 }, 2.5,  2,  FLOOD_WATER, { x = -3622, y =  -565, z = -5287, a =  0x0000 })
  flood_define_level(false, LEVEL_CCM,              "c4-ee",          { x =  5205, y =  1037, z = -2058, a =  0x8000 }, 3.0,  2,  FLOOD_MUD,   { x = -2240, y =  -255, z = -5098, a =  0x4000 })
  flood_define_level(false, LEVEL_BBH,              "c5-ee",          { x =  -894, y =  6045, z =  2527, a = -0x4000 }, 3.0,  2,  FLOOD_WATER, { x =  -108, y = -4712, z =  5790, a =  0x8000 })
  flood_define_level(false, LEVEL_VCUTM,            "vc-ee",          { x =  1438, y =  3573, z = -1425, a =  0x0000 }, 2.0,  2,  FLOOD_WATER, { x =  6311, y = -1350, z = -1226, a =  0x0000 })
  flood_define_level(false, LEVEL_TOTWC,            "wc-ee",          { x =   715, y =  4600, z =  -200, a = -0x4000 }, 1.75, 2,  FLOOD_LAVA,  { x =  4430, y =   600, z =   -50, a = -0x4000 })  
  flood_define_level(false, LEVEL_PSS,              "pss-ee",         { x =  3615, y =  4020, z =  3625, a =  0x8000 }, 2.0,  2,  FLOOD_WATER, { x =  1424, y = -7202, z =  2110, a = -0x4000 })  
  flood_define_level(false, LEVEL_HMC,              "c6-ee",          { x = -6310, y =  2530, z = -1065, a =  0x0000 }, 3.5,  2,  FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_LLL,              "c7-ee",          { x = -1060, y = 11805, z =   510, a =  0x4000 }, 2.0,  2,  FLOOD_WATER, { x = -1875, y = -2845, z = -2703, a =  0x0000 })
  flood_define_level(false, LEVEL_SSL,              "c8-ee",          { x =  4925, y =  5165, z =  4600, a =  0x0000 }, 1.5,  2,  FLOOD_SAND,  { x = -2188, y =  -565, z = -5767, a =  0x0000 })
  flood_define_level(false, LEVEL_DDD,              "c9-ee",          { x =  3710, y =  2255, z = -4730, a =  0x0000 }, 3.0,  2,  FLOOD_LAVA,  { x =  2917, y = -3223, z = -5590, a =  0x0000 })
  flood_define_level(false, LEVEL_BITFS,            "b2-ee",          { x = -4878, y =  6639, z = -6502, a =  0x0000 }, 2.0,  2,  FLOOD_SAND,  { x =  -530, y =  3876, z = -1967, a =  0x0000 })
  flood_define_level(false, LEVEL_SL,               "c10-ee",         { x = -2261, y =  4320, z =  3279, a =  0x4000 }, 2.0,  2,  FLOOD_WATER, { x =  2239, y =  -253, z = -3367, a =  0x0000 })  
  flood_define_level(false, LEVEL_WDW,              "c11-ee",         { x =  3461, y =  3884, z = -5332, a =  0x4000 }, 2.0,  2,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_TTM,              "c12-ee",         { x = -4396, y =  3445, z = -3430, a =  0x0000 }, 2.0,  2,  FLOOD_WATER, { x =   -50, y = -4485, z =  2200, a =  0x0000 })
  flood_define_level(false, LEVEL_THI,              "c13-ee",         { x =  6374, y =  4826, z =  -928, a =  0x4000 }, 2.0,  2,  FLOOD_LAVA,  { x =     0, y =     0, z =     0, a =  0x0000 })
  flood_define_level(false, LEVEL_TTC,              "c14-ee",         { x = -2314, y = 11814, z =   663, a =  0x4000 }, 2.0,  2,  FLOOD_MUD,   nil)
  flood_define_level(false, LEVEL_RR,               "c15-ee",         { x =    90, y = 10815, z = -4320, a =  0x8000 }, 1.75, 2,  FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_SA,               "sa-ee",          { x =   400, y =  1939, z =  2610, a =  0x0000 }, 3.0,  2,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc-ee",          { x =  3980, y =  1710, z =  7110, a =  0x8000 }, 3.0,  2,  FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_WMOTR,            "wmotr-ee",       { x = -1800, y =  3430, z = -5485, a = -0x4000 }, 3.5,  2,  FLOOD_WATER, { x =  1095, y =  -780, z = -5550, a =  0x0000 })
  flood_define_level(false, LEVEL_CASTLE,           "c-ee",           { x =  -180, y =  2135, z =  3640, a =  0x8000 }, 7.0,  2,  FLOOD_LAVA,  { x =  -260, y = -1316, z = -4343, a =  0x0000 })
end

-- Star Road ported to Flood by Agent X
local function flood_load_star_road_levels()
    game = GAME_STAR_ROAD
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario Star Road"
	TEX_ROMHACK_LOGO = get_texture_info("star_road_logo")		
    LEVEL_ZERO_LIFE = level_register('level_zerolife_entry', COURSE_NONE, 'ZERO LIFE', 'zl', 28000, 0x28, 0x28, 0x28)	
	
    flood_define_level(false, LEVEL_BOB,            "c1",        { x =  5364, y =  1875, z =  2251, a = -0x6000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",        { x =   455, y =  2448, z = -2250, a =  0x4000 }, 5.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,            "c3",        { x = -4672, y =  3541, z = -3619, a = -0x4000 }, 4.0,  1,  FLOOD_WATER, { x =  2316, y =  -448, z = -5150, a =  0x0000 })
    flood_define_level(false, LEVEL_CCM,            "c4",        { x =  3770, y =  3500, z = -3940, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_COTMC,          "mc",        { x =  2033, y = 10225, z =  4960, a = -0x4000 }, 3.5,  1,  FLOOD_LAVA,  { x =  4478, y =  5324, z =  -313, a = -0x4000 })	
    flood_define_level(false, LEVEL_BBH,            "c5",        { x =  4376, y =  2632, z = -4542, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,          "vc",        { x =  6355, y =   874, z =   866, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x = -4766, y =    30, z =  -443, a =  0x4000 })	
    flood_define_level(false, LEVEL_PSS,            "pss",       { x = -3415, y =  4573, z =  2678, a = -0x6000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,          "b1",        { x =  3520, y =  5010, z = -4355, a = -0x4000 }, 3.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_BOWSER_1,       "bowser-1",  { x =  1780, y =   990, z =  4200, a = -0x4000 }, 2.5,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_HMC,            "c6",        { x =  2454, y =  4160, z = -5055, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, { x =  6337, y =  3374, z =  4337, a =  0x0000 })
    flood_define_level(false, LEVEL_LLL,            "c7",        { x =  4348, y =  4638, z =  3970, a = -0x4000 }, 5.0,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SA,             "sa",        { x =  3737, y =  3532, z =  2302, a = -0x4000 }, 4.0,  1,  FLOOD_SAND,  { x =  5670, y = -6025, z = -5365, a =  0x0000 })		
    flood_define_level(false, LEVEL_SSL,            "c8",        { x =   -33, y =  3609, z =  1779, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,            "c9",        { x =   670, y =  2232, z = -3373, a =  0x0000 }, 4.5,  1,  FLOOD_WATER, { x = -1360, y = -1947, z =  4452, a =  0x0000 })
    flood_define_level(false, LEVEL_SL,             "c10",       { x =  4543, y =  3709, z =  3311, a =  0x8000 }, 1.25, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,          "b2",        { x =  3282, y =   584, z =  4478, a = -0x4000 }, 1.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BOWSER_2,       "bowser-2",  { x =   -40, y =  1799, z =  1870, a =  0x8000 }, 4.5,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_WDW,            "c11",       { x =  4780, y =  5155, z =  4330, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,            "c12",       { x =  1033, y =  4813, z = -6320, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,          "wc",        { x = -4220, y =  7320, z =  -180, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_THI,            "c13",       { x =  1796, y =  2879, z =  5015, a =  0x8000 }, 1.5,  1,  FLOOD_LAVA,  nil) 
    flood_define_level(false, LEVEL_TTC,            "c14",       { x =  1405, y =  3425, z = -3545, a =  0x8000 }, 4.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_RR,             "c15",       { x =  5052, y = 11056, z =   413, a = -0x4000 }, 4.0,  1,  FLOOD_WATER, { x =  5140, y = -6375, z =  1290, a = -0x2000 })
    flood_define_level(false, LEVEL_BITS,           "b3",        { x =  1870, y =  4220, z =   220, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",        { x = -6705, y =  1830, z =  2615, a =  0x4000 }, 10.0, 1,  FLOOD_WATER, { x = -1644, y =  -614, z = -1524, a = -0x4000 })
    flood_define_level(false, LEVEL_CASTLE,         "c",         { x = -4500, y =   470, z =  3040, a =  0x6000 }, 2.25, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_ZERO_LIFE,      "zl",        { x =  2600, y = -2600, z =  2850, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",     { x =  4990, y =  3989, z =   720, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)	
end

-- Super Mario 64 The Green Stars ported to Flood by MarcoGamerOJ
local function flood_load_sm64_the_green_stars_levels()
    game = GAME_THE_GREEN_STARS
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Super Mario 64 The Green Stars"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_the_green_stars_logo")
	gLevelValues.metalCapDurationCotmc  = 900		

    flood_define_level(false, LEVEL_BOB,              "c1",        { x =  -4410, y =  1875, z = -2475, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",        { x =  -2640, y =  3590, z =  6365, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x = -3520, y = -775,  z = - 4390, a =  0x0000 })
    flood_define_level(false, LEVEL_JRB,              "c3",        { x =  -4500, y =  4935, z =  -785, a =  0x0000 }, 2.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",        { x =   4527, y =  5028, z = -1183, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",        { x =  -4642, y =  4777, z =   547, a =  0x4000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,            "b1",        { x =   -888, y =  5026, z =  -602, a = -0x8000 }, 3.5,  1,  FLOOD_MUD,  nil)
    flood_define_level(false, LEVEL_BBH,              "c5",        { x =  -2832, y =  1890, z =  3223, a =  0x4000 }, 1.5,  1,  FLOOD_LAVA,  { x =  3514, y = -2349, z =   -560, a =  0x0000 })
    flood_define_level(false, LEVEL_COTMC,            "mc",        { x =  -8100, y =  2730, z =  7580, a =  0x8000 }, 2.5,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_HMC,              "c6",        { x =   1800, y =  5095, z =  4165, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,              "c7",        { x =  -4840, y =  2005, z =  -265, a =  0x2000 }, 2.0,  1,  FLOOD_WATER, { x =  5105, y =   280, z =  -3991, a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,              "c8",        { x =   4830, y =  3180, z = -4520, a =  0x4000 }, 3.0,  1,  FLOOD_SAND,  { x = -4177, y =  1000, z =  -3729, a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,              "c8-2",      { x =  -2130, y = -2085, z =   400, a =  0x4000 }, 1.0,  1,  FLOOD_SAND,  { x = -5895, y = -4070, z =    400, a =  0x4000 })	
    flood_define_level(false, LEVEL_DDD,              "c9",        { x = -10695, y =  3175, z =  7180, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",       { x =   4650, y =  -720, z = -5475, a = -0x2000 }, 1.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",       { x =   -310, y =  -924, z =  1859, a = -0x2000 }, 2.0,  1,  FLOOD_WATER, { x =  812,  y = -4343, z =   3221, a = -0x0000 })	
    flood_define_level(false, LEVEL_BITFS,            "b2",        { x =    226, y =  3891, z =    77, a = -0x4000 }, 1.5,  1,  FLOOD_LAVA,  { x =  9718, y = -2973, z =     30, a = -0x4000 })
    flood_define_level(false, LEVEL_TTM,              "c12",       { x =  -4610, y =  5009, z =  4295, a =  0x6000 }, 2.5,  1,  FLOOD_SAND,  { x = -6250, y =   360, z = -11115, a =  0x0000 })
    flood_define_level(false, LEVEL_THI,              "c13",       { x =   4610, y =  2741, z =  2207, a =  0x7000 }, 2.5,  1,  FLOOD_SAND,  { x =  -785, y = -3999, z =   5970, a = -0x8000 })
    flood_define_level(false, LEVEL_THI,              "c13-2",     { x =   6050, y =  5655, z =  -255, a =  0x0000 }, 6.0,  1,  FLOOD_SAND,  { x =  6775, y = -3870, z =  -1700, a = -0x8000 })	
    flood_define_level(false, LEVEL_TTC,              "c14",       { x =   3330, y =  5730, z =  2640, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x = -5470, y =     0, z =  -2725, a =  0x4000 })
    flood_define_level(false, LEVEL_RR,               "c15",       { x =  -4557, y =  3489, z = -9292, a =  0x4000 }, 3.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITS,             "b3",        { x =  -7200, y =  7233, z =   610, a =  0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",        { x =    875, y =  1320, z =  3000, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",        { x =   3710, y =   310, z =  2815, a =  0x8000 }, 5.0,  1,  FLOOD_LAVA,  { x = -2320, y = -2060, z =  -2335, a =  0x8000 })
end

-- Luigi's Mansion 64 ported to Flood by MarcoGamerOJ
local function flood_load_luigis_mansion_64_levels()
    game = GAME_LUIGIS_MANSION_64
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
    romhackText = "Luigi's Mansion 64"	
	TEX_ROMHACK_LOGO = get_texture_info("luigis_mansion_64_logo")	
	gLevelValues.metalCapDurationCotmc  = 1	
	hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

    flood_define_level(false, LEVEL_BOB,            "c1",            { x =  3304, y =  4293, z = -4603, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",             { x = -2575, y =  5055, z = -265,  a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,            "c6",            { x = -4163, y =  2355, z = -2544, a =  0x0000 }, 4.5,  1,   FLOOD_WATER, { x = -3538, y = -3979, z =  3568, a =  0x8000 })	
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x =  4,    y =  369,  z = -6138, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CCM,            "c4",            { x = -478,  y =  3471, z = -964,  a =  0x0000 }, 5.0,  1,   FLOOD_WATER, { x =  3336, y = -3800, z =  0,    a = 0x0000 })	
    flood_define_level(false, LEVEL_CCM,            "c4-slide",      { x = -5620, y =  6656, z = -6145, a =  0x0000 }, 4.0,  2,  FLOOD_WATER, { x = -6498, y = -5836, z = -6937, a = 0x0000 })		
    flood_define_level(false, LEVEL_BBH,            "c5",            { x =  655,  y =  3277, z =  244,  a =  0x8000 }, 3.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_RR,             "c15",             { x =  3554, y =  4821, z = -2327, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x =  7060, y = -1243, z =  6571, a = -0x4000 })
    flood_define_level(false, LEVEL_PSS,            "pss",            { x =  3127, y =  7035, z = -5650, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x = -6387, y = -4000, z =  5723, a =  0x8000 })
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x =  6772, y =  2867, z =  0,    a = -0x4000 }, 4.0,  1,   FLOOD_WATER,  nil)	
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x =  4596, y = -1,    z = -4514, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x = -2093, y = -2500, z =  1338, a =  0x8000 })
    flood_define_level(false, LEVEL_LLL,            "c7",            { x =  9,    y =  768,  z = -6845, a = -0x8000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,            "c7-volcano",    { x =  2523, y =  3591, z = -898,  a = -0x8000 }, 3.5,  2,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_WDW,            "c11",            { x =  4730, y =  4110, z = 4390,   a = -0x4000 }, 4.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,            "c11-town",        { x =  1820,  y = -1107,  z = 1016, a = -0x4000 }, 3.0, 2,   FLOOD_WATER, { x = -3362, y = -2559, z = -1058, a = 0x0000 })	
    flood_define_level(false, LEVEL_DDD,            "c9",            { x =  4046, y = -511,  z = -8,    a = -0x4000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =  1224, y =  5478, z =  84,   a =  0x0000 }, 2.5,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_JRB,            "c3",            { x =  3583, y =  1536, z =  5017, a =  0x0000 }, 3.5,  1,   FLOOD_WATER, { x =  5138, y = -4912, z =  201,  a =  0x0000 })
    flood_define_level(false, LEVEL_JRB,            "c3-ship",       { x =  70, y =  1260, z = 2950, a =  0x0000 }, 3.5,  2,   FLOOD_WATER, { x = 675, y = -220, z = -2685,  a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,            "c8",            { x = -2038, y =  1103, z = -300,  a =  0x0000 }, 3.0,  1,   FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,            "c8-pyramid",    { x =  512,  y =  4815, z = -551,  a =  0x0000 }, 3.0,  2,   FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_TTM,            "c12",            { x =  1053, y =  2309, z =  305,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13",            { x = -12,    y = 3891,  z = -1556, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13-tiny",       { x = 30,    y = 1170,  z = -450, a =  0x0000 }, 5.0,  2,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13-cave",       { x = -1930, y = 1535,  z = -1090, a =  0x0000 }, 4.0,  3,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,            "c14",            { x =  2208, y =  7051, z =  2217, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,             "c10",             { x =  40,   y =  4864, z =  240,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SL,             "c10-igloo",      { x = -5,   y =  0, z = 2575,  a =  0x0000 }, 3.0,  2,   FLOOD_WATER, { x = -390, y = 145, z = -1740, a = 0x4000 })		
    flood_define_level(false, LEVEL_BITS,           "b3",           { x =  369,  y =  6552, z = -6000, a =  0x0000 }, 4.5,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg", { x =  0,    y =  7583, z = -4015, a =  0x0000 }, 7.0,  1,   FLOOD_WATER, nil)
end

local function flood_load_katze_stuck_in_the_toilet_levels()
    game = GAME_KATZE_STUCK_IN_THE_TOILET_64
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Katze Stuck In The Toilet 64"
    TEX_ROMHACK_LOGO = get_texture_info("katze_stuck_in_the_toilet_64_logo")		
	gLevelValues.metalCapDurationCotmc  = 1	
	hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

    flood_define_level(false, LEVEL_BOB,            "c1",            { x =  -1803, y = 4609,  z = 4623,  a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",             { x =  11611, y = -196,  z = -1523, a =  0x0000 }, 3.0,  2,   FLOOD_WATER, { x = 7832, y = 192, z = -1534, a =  0x4000 })
    flood_define_level(false, LEVEL_WF,             "c22",            { x =  912,   y = 3735,  z = -1566, a =  0x0000 }, 5.0,  3,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WF,             "c23",            { x = -5303,   y = 3237,  z = 4430, a =  0x0000 }, 1.5,  4,   FLOOD_WATER, { x = 4172, y = -1150, z = 3883, a =  0x6000 })	
    flood_define_level(false, LEVEL_WF,             "c24",            { x =  2180,   y = 2230,  z = 420, a =  0x0000 }, 4.0,  5,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,            "c3",            { x =  -3648, y = 5830,  z = 4987,  a =  0x0000 }, 5.5,  1,   FLOOD_WATER, { x = 5934, y = 185, z = -5,    a =  0x4000 })	
    flood_define_level(false, LEVEL_CCM,            "c4",            { x = -458,   y = 2215,  z = 531,   a =  0x0000 }, 5.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,            "c5",            { x =  1870,  y = 2867,  z = -2357, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,          "wc",          { x = -5,   y = 6255,  z = -5,  a =  0x8000 }, 20.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x = -2538,  y = 6044,  z = -5504, a =  0x0000 }, 4.5,  1,   FLOOD_WATER, { x = 3132, y = 5591, z = -9295, a = 0x8000 })	
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x =  1503,  y = 3241,  z = -6446, a = -0x4000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =  4556,  y = 2114,  z = -43,   a =  0x0000 }, 5.0,  1,   FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_CASTLE,         "c",         { x = -4165,  y = 4039,  z = 5469,  a =  0x0000 }, 5.5,  1,   FLOOD_WATER, nil)
end

local function flood_load_super_mario_and_the_marvel_adventure_levels()
    game = GAME_MARVEL_ADVENTURE
	LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Super Mario and the Marvel Adventure"
	TEX_ROMHACK_LOGO = get_texture_info("marvel_adventure_logo")	
	hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

    flood_define_level(false, LEVEL_BOB,            "c1",         { x =   6253, y =  1196, z =  -722, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",         { x =   7666, y =  1832, z =  -717, a = -0x4000 }, 3.0,  1,  FLOOD_SAND,  { x =  -5233, y = -1352, z =  -2902, a =  0x4000 })	
    flood_define_level(false, LEVEL_JRB,            "c3",         { x =  -4613, y =  3930, z = -2312, a =  0x8000 }, 4.0,  1,  FLOOD_LAVA, nil)
    flood_define_level(false, LEVEL_JRB,            "c3-2",       { x =  13310, y =  3370, z = 13820, a = -0x4000 }, 4.0,  1,  FLOOD_WATER, { x =   3990, y =   780, z =  -1025, a =  0x6000 })	
    flood_define_level(false, LEVEL_CCM,            "c4",         { x =  -2200, y =  2605, z =  7958, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =   -536, y = -1425, z =  -8182, a =  0x0000 })
    flood_define_level(false, LEVEL_BBH,            "c5",         { x =  -4121, y =  3325, z =  8071, a =  0x8000 }, 3.75, 1,  FLOOD_WATER, { x =   1140, y = -4155, z =   9565, a = -0x4000 })	
    flood_define_level(false, LEVEL_COTMC,          "mc",         { x =   4678, y =   769, z =   686, a =  0x8000 }, 3.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TOTWC,          "wc",         { x =  -3586, y =  3030, z =  2151, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x =   3610, y = -3190, z =   4305, a =  0x8000 })	
    flood_define_level(false, LEVEL_SA,             "sa",         { x =   3453, y =  1987, z = -4260, a = -0x2000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",      { x =  -5370, y = -1284, z = -4339, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, { x =  -5370, y = -1285, z =   4660, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITDW,          "b1",         { x =   8449, y =  1125, z = -9527, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =   9270, y = -2055, z = -11295, a =  0x8000 })
    flood_define_level(false, LEVEL_BITDW,          "b1-2",       { x =   7210, y =  -860, z =  7630, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =   9715, y = -3975, z =  11300, a =  0x4000 })	
    flood_define_level(false, LEVEL_BITDW,          "b1-3",       { x = -13060, y =  -410, z =  -965, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  -9890, y = -3700, z =    545, a =  0x4000 })	
    flood_define_level(false, LEVEL_BITFS,          "b2",         { x =   -922, y =  6860, z =    45, a =  0x8000 }, 1.75, 1,  FLOOD_LAVA,  { x = -11510, y = -3420, z =   1815, a =  0x4000 })	
    flood_define_level(false, LEVEL_BITS,           "b3",         { x =  13045, y = -4450, z =  1990, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,         "c",          { x =  11030, y =   440, z =  1960, a = -0x4000 }, 5.0,  1,  FLOOD_WATER, { x =  -4630, y = -1245, z =   1000, a =  0x6000 })
end

-- Moonshine ported to Flood by MarcoGamerOJ
local function flood_load_moonshine_levels()
    game = GAME_MOONSHINE
    LEVEL_LOBBY = LEVEL_CASTLE	
	romhackText = "Super Mario 64 Moonshine"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_moonshine_logo")	
	hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

    flood_define_level(false, LEVEL_BOB,            "c1",          { x =  6800, y =  1674, z = -3226, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =    52, y =   600, z =   -5, a =  0x4000 })
    flood_define_level(false, LEVEL_WF,             "c2",          { x =   -69, y =  5279, z = -6866, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =     0, y =   450, z = 7267, a = -0x8000 })
    flood_define_level(false, LEVEL_CCM,            "c4",          { x =  5770, y =  2855, z = -4320, a = -0x4000 }, 4.0,  1,  FLOOD_WATER, { x = -1187, y =   300, z = 3746, a =  0x8000 })
    flood_define_level(false, LEVEL_BBH,            "c5",          { x =  2294, y =     2, z = -7029, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,            "c5-2",        { x =  -250, y = -2160, z =  4260, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x =  6380, y = -3300, z = 5600, a = -0x4000 })	
    flood_define_level(false, LEVEL_HMC,            "c6",          { x = -2671, y = 10141, z =  1133, a = -0x4000 }, 4.5,  1,  FLOOD_WATER, { x =  6337, y =  3174, z = 4337, a =  0x0000 })			
    flood_define_level(false, LEVEL_PSS,            "pss",         { x =   832, y =  4940, z =  -706, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,            "c7",          { x =  4510, y =  5485, z = -4490, a = -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WDW,            "c11",         { x =  2997, y = -3576, z =  -207, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =  6914, y =  1750, z =  2599, a =  0x8000 }, 2.0,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_BITS,           "b3",          { x = -1492, y =  2442, z =  -572, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =  6707, y = -1049, z = 6853, a =  0x8000 })
end

local function flood_load_eureka_levels()
    game = GAME_EUREKA
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Eureka"
	TEX_ROMHACK_LOGO = get_texture_info("eureka_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",          { x = -2959, y = 2880, z =  -7550, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",          { x =  6217, y =  539, z = -10902, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil) -- a 
    flood_define_level(false, LEVEL_WF,               "c2-2",        { x = -1930, y =  790, z =   -810, a =  0x4000 }, 2.0,  2,  FLOOD_WATER, nil)   
    flood_define_level(false, LEVEL_WF,               "c2-3",        { x =   600, y = 1965, z =  -8300, a = -0x4000 }, 1.5,  3,  FLOOD_WATER, nil)    
    flood_define_level(false, LEVEL_JRB,              "c3",          { x = -1655, y = 3109, z =  -2200, a =  0x4000 }, 2.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "c3-2",        { x =    80, y = 2300, z =  -4030, a =  0x0000 }, 8.0,  2,  FLOOD_WATER, { x = 470, y = 2000, z =  2140, a =  0x8000 })  
    flood_define_level(false, LEVEL_CCM,              "c4",          { x = -6680, y = 6945, z = -14270, a = -0x6000 }, 2.5,  1,  FLOOD_SAND,  nil)  
    flood_define_level(false, LEVEL_CCM,              "c4-2",        { x =   490, y = -420, z = -17470, a = -0x4000 }, 0.5,  2,  FLOOD_SAND,  nil)   
    flood_define_level(false, LEVEL_BBH,              "c5",          { x = -6350, y = 2450, z =  -5200, a =  0x2000 }, 3.75, 1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",          { x =  1260, y = 1565, z = -19120, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, { x =  10, y =  385, z =  4310, a =  0x8000 })  
    flood_define_level(false, LEVEL_WDW,              "c11",         { x =    48, y = 9095, z =     21, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)  	
    flood_define_level(false, LEVEL_TTM,              "c12",         { x = -5367, y = 4613, z =  -9473, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	   	
    flood_define_level(false, LEVEL_BITDW,            "b1",          { x = -8870, y = 4300, z =   3744, a =  0x4000 }, 1.25, 1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",          { x =     0, y = 9635, z =  -3695, a =  0x0000 }, 4.5,  1,  FLOOD_WATER, nil) 	
    flood_define_level(false, LEVEL_HMC,              "c6",          { x = 10491, y = 2759, z =  -8326, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,              "c7",          { x = 11512, y = 5123, z =    311, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",          { x =  5935, y = 3245, z =  -8910, a = -0x4000 }, 2.75, 1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_DDD,              "c9",          { x =  1777, y = 2142, z =  -1436, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",          { x =  1454, y = 2577, z =  -2577, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	  
    flood_define_level(false, LEVEL_THI,              "c13",         { x = 11059, y = 1820, z =   -391, a =  0x0000 }, 4.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TTC,              "c14",         { x =   429, y = 3034, z =   -691, a =  0x6000 }, 2.5,  1,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_TTC,              "c14-2",       { x =     0, y = 1360, z =   5365, a =  0x8000 }, 5.0,  2,  FLOOD_WATER, { x =   0, y =  320, z = -2445, a =  0x0000 })	
    flood_define_level(false, LEVEL_BITFS,            "b2",          { x = -6450, y = -110, z = -28610, a =  0x0000 }, 0.75, 1,  FLOOD_SAND,  nil)      
    flood_define_level(false, LEVEL_SL,               "c10",         { x =  7618, y = 2917, z =  -6959, a =  0x2000 }, 2.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_RR,               "c15",         { x =  4746, y = 3244, z =  -2750, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITS,             "b3",          { x =  4690, y =  580, z = -25510, a = -0x4000 }, 1.0,  1,  FLOOD_LAVA,  nil)  
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",          { x =  -285, y = 1910, z =   8251, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, nil) 
end
  
  local function flood_load_scrooge_64_levels()
    game = GAME_SCROOGE_64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Scrooge 64"
	TEX_ROMHACK_LOGO = get_texture_info("scrooge_64_logo")	
	hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
	
    flood_define_level(false, LEVEL_BITDW,          "b1",       { x =  -800, y = 6770, z =  3780, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)     
    flood_define_level(false, LEVEL_BITS,           "b3",       { x =   370, y = 6650, z = -6000, a =  0x0000 }, 3.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BITFS,          "b2",       { x = 10700, y = 4880, z = -1965, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  { x = 5310, y = -5055, z =  2910, a = -0x4000 })
    flood_define_level(false, LEVEL_BOB,            "c1",       { x = -3550, y = -585, z =  4110, a =  0x8000 }, 6.0,  1,  FLOOD_WATER, { x =    0, y = -1350, z = -5400, a =  0x0000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",       { x =  -750, y =   80, z = -2880, a =  0x0000 }, 7.0,  1,  FLOOD_WATER, nil)
end  

local function flood_load_super_mario_parallel_stars_levels()
    game = GAME_SUPER_MARIO_PARALLEL_STARS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Super Mario Parallel Stars"
	TEX_ROMHACK_LOGO = get_texture_info("parallel_stars_logo")	
    hook_behavior(id_bhvExclamationBox, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
	gLevelValues.metalCapDurationCotmc  = 1
	gLevelValues.vanishCapDurationVcutm  = 750	

    flood_define_level(false, LEVEL_BOB,              "c1",        { x =   2127, y =  1947, z = -2439, a = -0x4000 }, 2.5,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",        { x =    900, y =  7912, z =   670, a =  0x4000 }, 3.0,  1, FLOOD_WATER, { x = -4220, y =   750, z =   5760, a =  0x6000 })
    flood_define_level(false, LEVEL_CCM,              "c4",        { x =   -535, y =  8200, z =   960, a =  0x0000 }, 4.0,  1, FLOOD_WATER, { x =  4390, y =    80, z =   9970, a =  0x9000 })
    flood_define_level(false, LEVEL_CCM,              "c4-2",      { x =    -43, y = 10000, z =    95, a = -0x2000 }, 4.0,  2, FLOOD_WATER, { x = -9390, y = -7274, z = -15670, a =  0x2000 })	
    flood_define_level(false, LEVEL_BBH,              "c5",        { x =  -3531, y =  2820, z = -1278, a = -0x4000 }, 3.0,  1, FLOOD_WATER, { x =  2200, y =   130, z =   2150, a =  0x2000 })	
    flood_define_level(false, LEVEL_TOTWC,            "wc",        { x =      0, y =  2477, z =    -6, a =  0x0000 }, 4.0,  1, FLOOD_WATER, { x =     0, y =   730, z =   9950, a =  0x8000 })			
    flood_define_level(false, LEVEL_BITDW,            "b1",        { x =    550, y =  5082, z = 20773, a =  0x8000 }, 1.25, 1, FLOOD_WATER, { x =  4150, y = -1200, z =   7875, a =  0x0000 })	
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",  { x =      0, y =   510, z = -5590, a =  0x0000 }, 4.0,  1, FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_VCUTM,            "vc",        { x =    -55, y = -1075, z =  -100, a =  0x0000 }, 3.0,  1, FLOOD_WATER, { x =  1095, y = -3059, z =     -3, a =  0x4000 })	
    flood_define_level(false, LEVEL_LLL,              "c7",        { x =      0, y =  2784, z =    36, a = -0x4000 }, 2.5,  1, FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",        { x =      0, y =  3890, z = -7735, a =  0x0000 }, 3.0,  1, FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_SSL,              "c8",        { x =   1448, y =  9728, z = -4743, a =  0x4000 }, 2.5,  1, FLOOD_SAND,  { x = -1525, y =  1730, z =  -2264, a =  0x8000 })	
    flood_define_level(false, LEVEL_DDD,              "c9",        { x =  -1275, y =  6553, z =  -110, a = -0x4000 }, 3.0,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",       { x =  -2237, y =  6621, z =  -743, a =  0x0000 }, 2.5,  1, FLOOD_WATER, { x = -8290, y =  1665, z =    415, a =  0x0000 })	
    flood_define_level(false, LEVEL_BITFS,            "b2",        { x =   2992, y =  6041, z = -9017, a =  0x6000 }, 1.5,  1, FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",  { x =      0, y =   310, z =  5115, a =  0x8000 }, 2.0,  1, FLOOD_WATER, { x =     0, y =   700, z =  -5115, a =  0x8000 })		
    flood_define_level(false, LEVEL_WDW,              "c11",       { x = -12125, y =  2560, z = -1534, a =  0x4000 }, 3.0,  1, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",       { x =    -10, y =  5395, z =     3, a =  0x0000 }, 2.5,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "sa",        { x =  -7480, y =  2200, z =     0, a =  0x4000 }, 6.0,  1, FLOOD_WATER, { x = -2250, y =   450, z =    -20, a = -0x4000 })	
    flood_define_level(false, LEVEL_SA,               "sa-2",      { x =      0, y =  1750, z =  6855, a =  0x8000 }, 1.5,  1, FLOOD_WATER, { x =     0, y =   450, z =   2270, a =  0x0000 })
    flood_define_level(false, LEVEL_SA,               "sa-3",      { x =   1135, y =  2355, z = -5685, a = -0x4000 }, 2.5,  1, FLOOD_WATER, { x =    20, y =   450, z =  -2270, a =  0x8000 })
    flood_define_level(false, LEVEL_SA,               "sa-4",      { x =   8665, y =  1895, z =    35, a = -0x4000 }, 1.0,  1, FLOOD_WATER, { x =  2270, y =   450, z =     20, a =  0x4000 })
    flood_define_level(false, LEVEL_SA,               "sa-5",      { x =   2045, y =  3430, z =  5425, a =  0x4000 }, 3.5,  2, FLOOD_LAVA,  { x =  3495, y =   450, z =   1910, a =  0x0000 })		
    flood_define_level(false, LEVEL_SA,               "sa-6",      { x =   6060, y =  6020, z = -4805, a =  0x0000 }, 1.5,  2, FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_THI,              "c13",       { x =   3790, y =  4920, z =  2300, a = -0x4000 }, 2.75, 1, FLOOD_WATER, { x =     0, y =  1265, z =  -2352, a =  0x8000 })	
    flood_define_level(false, LEVEL_TTC,              "c14",       { x =   3245, y =  4500, z = -6077, a = -0x4000 }, 3.5,  1, FLOOD_WATER, { x =     0, y =  1510, z =     -5, a =  0x8000 })	
    flood_define_level(false, LEVEL_TTC,              "c14-2",     { x =   1490, y =  5700, z =  -450, a =  0x8000 }, 1.0,  2, FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_TTC,              "c14-3",     { x =  -2230, y =  5950, z =  -810, a =  0x4000 }, 1.5,  3, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,              "c14-4",     { x =   3040, y =  6195, z =  6375, a =  0x8000 }, 1.5,  4, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,              "c14-5",     { x =  -5280, y =  3685, z = -6050, a =  0x4000 }, 1.5,  5, FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TTC,              "c14-6",     { x =      0, y =  1950, z =  4030, a =  0x8000 }, 4.0,  6, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_RR,               "c15",       { x = -11075, y =  2750, z = -3598, a =  0x4000 }, 3.0,  1, FLOOD_LAVA,  { x = -7270, y =   150, z =  -2360, a =  0x8000 })	
    flood_define_level(false, LEVEL_RR,               "c15-2",     { x =   9714, y =  3000, z = -3120, a = -0x4000 }, 2.5,  1, FLOOD_MUD,   { x =  7270, y =   150, z =  -2360, a =  0x4000 })
    flood_define_level(false, LEVEL_RR,               "c15-3",     { x =   5136, y =    25, z = 11475, a =  0x0000 }, 1.25, 1, FLOOD_WATER, { x =  4860, y =   150, z =   6675, a =  0x2000 })		
    flood_define_level(false, LEVEL_RR,               "c15-4",     { x =  -7602, y =  3395, z =  7035, a =  0x0000 }, 2.0,  1, FLOOD_WATER, { x = -4795, y =   150, z =   6590, a =  0x0000 })	
    flood_define_level(false, LEVEL_BITS,             "b3",        { x =    -10, y =  9730, z =    10, a =  0x8000 }, 1.5,  1, FLOOD_WATER, { x =   680, y =   120, z = -12780, a = -0x4000 })	
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",     { x =   6595, y =  8350, z = -5240, a = -0x4000 }, 3.0,  1, FLOOD_WATER, { x = -1405, y = -3210, z =   3790, a =  0x0000 })	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",        { x =  15150, y =  7680, z =     0, a = -0x4000 }, 4.0,  1, FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",        { x =      0, y =  4405, z = 12520, a =  0x8000 }, 1.5,  1, FLOOD_WATER, { x =     0, y =     0, z =  -8065, a =  0x0000 })
end


local function flood_load_mario_in_the_dreamscape_levels()
    game = GAME_DREAMSCAPE
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Mario in the Dreamscape"
    TEX_ROMHACK_LOGO = get_texture_info("dreamscape_logo")
	
    flood_define_level(false, LEVEL_BOB,              "c1",         { x =   6111, y =  4803, z =  -4164, a =  0x6000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOB,              "c1-2",       { x =  -7575, y =  2050, z =  -3060, a = -0x4000 }, 3.0,  2,  FLOOD_WATER, { x =  -3270, y =  -890, z =  3980, a = -0x4000 })
    flood_define_level(false, LEVEL_BOB,              "c1-3",       { x =    100, y =  2380, z =    920, a =  0x8000 }, 5.0,  3,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WF,               "c2",         { x =   6153, y =  3149, z =   4846, a =  0x0000 }, 4.0,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_WF,               "c2-2",       { x =   2705, y =  5915, z =   -695, a =  0x8000 }, 3.5,  2,  FLOOD_WATER, { x =   -430, y =  3800, z =  -925, a =  0x8000 })	
    flood_define_level(false, LEVEL_WF,               "c2-3",       { x =  -3005, y =  3240, z =   -835, a =  0x4000 }, 2.25, 3,  FLOOD_SAND,  { x =   5965, y =   100, z =  1430, a = -0x4000 })
    flood_define_level(false, LEVEL_WF,               "c2-4",       { x =  -7920, y =  3060, z =  -4645, a = -0x4000 }, 2.25, 4,  FLOOD_SAND,  { x =   9195, y =     0, z =  2340, a = -0x4000 })
    flood_define_level(false, LEVEL_JRB,              "c3",         { x = -15155, y =   910, z =   5775, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   1730, y =  -850, z = -3840, a =  0x0000 })	
    flood_define_level(false, LEVEL_JRB,              "c3-2",       { x =   -830, y =   500, z =  -4600, a = -0x4000 }, 3.0,  3,  FLOOD_WATER, { x =  -2850, y =  -530, z =  -780, a =  0x8000 })	
    flood_define_level(false, LEVEL_JRB,              "c3-3",       { x =   -950, y =  4730, z =   1520, a =  0x4000 }, 10.0, 3,  FLOOD_WATER, { x =  10100, y =   300, z =  9100, a = -0x4000 })		
    flood_define_level(false, LEVEL_JRB,              "c3-4",       { x =   -435, y =  3190, z =   2745, a =  0x6000 }, 3.0,  4,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_CCM,              "c4",         { x =  -1987, y =  1904, z =  -2656, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, { x =  -1425, y = -1401, z =  9543, a =  0x8000 })
    flood_define_level(false, LEVEL_CCM,              "c4-2",       { x =    105, y =  1180, z =   3015, a =  0x8000 }, 4.0,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CCM,              "c4-3",       { x = -14655, y =  5625, z =   3120, a =  0x0000 }, 4.0,  3,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_COTMC,            "mc",         { x =   2109, y =  1927, z =  -2699, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x =    810, y =   255, z =  2405, a =  0x6000 })	
    flood_define_level(false, LEVEL_BBH,              "c5",         { x =  -8201, y = -1587, z =   4032, a =  0x8000 }, 2.5,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_BBH,              "c5-2",       { x =   3985, y =   -20, z =  -2805, a =  0x0000 }, 2.5,  3,  FLOOD_MUD,   nil)		
    flood_define_level(false, LEVEL_BBH,              "c5-3",       { x =   1515, y = -1170, z =   4390, a =  0x4000 }, 2.5,  2,  FLOOD_MUD,   nil)		
    flood_define_level(false, LEVEL_HMC,              "c6",         { x =    520, y =  3810, z =  -3025, a = -0x2000 }, 3.0,  1,  FLOOD_WATER, { x =  -3345, y =  1130, z = -2895, a =  0x0000 })    
	flood_define_level(false, LEVEL_HMC,              "c6-2",       { x =   -980, y =  3582, z =   -480, a =  0x6000 }, 2.5,  2,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,              "c6-3",       { x =   2995, y =  2535, z =   4630, a =  0x8000 }, 3.5,  3,  FLOOD_WATER, { x =   6390, y = -1125, z =  3525, a =  0x8000 })  
    flood_define_level(false, LEVEL_VCUTM,            "vc",         { x =  -5655, y =  3626, z =  -9663, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_LLL,              "c7",         { x =   4977, y =  2585, z =  -6736, a =  0x2000 }, 3.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,              "c7-2",       { x =  -3460, y =  3440, z =   -590, a =  0x6000 }, 2.5,  2,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_SSL,              "c8",         { x =   4690, y =  8012, z =   5202, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8-2",       { x =   8755, y = -1880, z = -13730, a =  0x0000 }, 4.0,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TOTWC,            "wc",         { x =    -91, y =  -224, z = -14102, a =  0x4000 }, 1.5,  1,  FLOOD_WATER, { x =  -4335, y = -3335, z = -6860, a =  0x6000 })	
    flood_define_level(false, LEVEL_TOTWC,            "wc-2",       { x =    250, y =  5070, z =  17300, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =   3370, y =  1500, z =  9885, a =  0x0000 })	
    flood_define_level(false, LEVEL_BITDW,            "b1",         { x =  -4477, y =  1090, z =  -1408, a = -0x6000 }, 3.0,  1,  FLOOD_WATER, { x =    165, y =  -800, z =  2665, a =  0x8000 })
    flood_define_level(false, LEVEL_BITDW,            "b1-2",       { x =  -2600, y =  1770, z =    195, a =  0x4000 }, 3.0,  2,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_DDD,              "c9",         { x =  -5390, y =  1780, z =  11490, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,              "c9-2",       { x = -29050, y =  3810, z =   5350, a =  0x4000 }, 1.75, 1,  FLOOD_LAVA,  { x = -12325, y =   300, z =  4795, a = -0x4000 })
    flood_define_level(false, LEVEL_SA,               "sa",         { x =   8455, y =  2620, z =  -7420, a =  0x5000 }, 2.0,  1,  FLOOD_WATER, { x =  -8890, y =  -450, z =  2675, a =  0x8000 })
    flood_define_level(false, LEVEL_SL,               "c10",        { x =   7364, y =  3510, z =   1092, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10-2",      { x =   4520, y =  6275, z =   1760, a =  0x0000 }, 3.0,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",        { x =  -3302, y =   267, z =   5817, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WDW,              "c11-2",      { x =  -1935, y =  3000, z = -11440, a =  0x0000 }, 2.5,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",        { x =   8240, y =  6790, z =   9645, a = -0x4000 }, 2.5,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_BITFS,            "b2",         { x =   -643, y =  5509, z =  -2327, a = -0x4000 }, 1.0,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CCM,              "c4-4",       { x =  -6110, y =  7065, z = -10995, a =  0x8000 }, 2.75, 4,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_PSS,              "pss",        { x = -11226, y =   807, z =  -1141, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_THI,              "c13",        { x =   1727, y =  5201, z =   8937, a = -0x6000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,              "c14",        { x =      5, y =  5829, z =  -7745, a =  0x0000 }, 3.0,  2,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TTC,              "c14-2",      { x =   -205, y =  4220, z = -11190, a =  0x0000 }, 2.0,  3,  FLOOD_WATER, { x =   1630, y =  4345, z =     0, a =  0x8000 })	
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",      { x =   9610, y =  4280, z =   -600, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",         { x =   -500, y =  7755, z = -10595, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc-2",       { x =  -8420, y =   180, z =  -2115, a =  0x4000 }, 2.25, 2,  FLOOD_WATER, { x =   1985, y = -1655, z =  -470, a =  0x1000 })		
    flood_define_level(false, LEVEL_PSS,              "pss-2",      { x =   3310, y =  1510, z =   5750, a = -0x6000 }, 5.0,  2,  FLOOD_WATER, { x =  -3435, y = -1520, z =  1655, a =  0x4000 })		
    flood_define_level(false, LEVEL_RR,               "c15",        { x =   5860, y =  7080, z =   8340, a =  0x8000 }, 1.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_RR,               "c15-2",      { x =   2680, y =  3525, z =  -2775, a = -0x2000 }, 2.5,  2,  FLOOD_WATER, { x =     10, y =  2575, z =  2420, a =  0x8000 })	
    flood_define_level(false, LEVEL_PSS,              "pss-3",      { x =  -2570, y =  3690, z = -15210, a =  0x4000 }, 5.5,  3,  FLOOD_WATER, { x =   3500, y = -3595, z = -3630, a = -0x4000 })	
    flood_define_level(false, LEVEL_PSS,              "pss-4",      { x =  -9250, y = -3695, z =   6020, a =  0x8000 }, 5.0,  3,  FLOOD_WATER, { x =  -6050, y = -5410, z =  2780, a =  0x0000 })
    flood_define_level(false, LEVEL_PSS,              "pss-5",      { x =   7930, y = -1100, z =   5960, a =  0x4000 }, 6.0,  3,  FLOOD_WATER, { x =   7975, y = -3965, z =   770, a =  0x2000 })		
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",         { x = -11189, y =   807, z =  -1109, a =  0x2000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",         { x =   5210, y =  4100, z =  -3400, a = -0x4000 }, 5.0,  1,  FLOOD_WATER, { x =  -3530, y =  -990, z =  1680, a =  0x4000 })
    flood_define_level(false, LEVEL_CASTLE,           "c",          { x =    750, y =  1160, z =  -3685, a =  0x0000 }, 4.5,  1,  FLOOD_WATER, { x =    705, y =  -790, z =  5530, a =  0x8000 })

end

local function flood_load_mario_in_the_colorful_lands_levels()
    game = GAME_COLORFUL_LANDS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Mario in the Colorful Lands"
	TEX_ROMHACK_LOGO = get_texture_info("mario_in_the_colorful_lands_logo")	

    flood_define_level(false, LEVEL_BOB,            "c1",         { x = 15755, y =  4440, z =  -4995, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  7870, y =  340, z =  -1485, a =  0x8000 })
    flood_define_level(false, LEVEL_WF,             "c2",         { x =  9250, y =  7560, z =  -3195, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =  1975, y = 1775, z =  -2150, a = -0x6000 })
    flood_define_level(false, LEVEL_CCM,            "c4",         { x =  2280, y =  3955, z =  -5030, a =  0x4000 }, 1.5,  1,  FLOOD_SAND,  { x =  6510, y =  650, z =  -5220, a =  0x8000 })
    flood_define_level(false, LEVEL_BBH,            "c5",         { x = 13545, y =  7715, z =  -2285, a =  0x8000 }, 3.0,  1,  FLOOD_LAVA,  { x = 13525, y = 3870, z =  -5310, a =  0x8000 })
    flood_define_level(false, LEVEL_HMC,            "c6",         { x =  9270, y = 10035, z =  -8120, a = -0x4000 }, 2.75, 1,  FLOOD_WATER, { x =  2615, y = 1240, z =    445, a =  0x8000 })
    flood_define_level(false, LEVEL_LLL,            "c7",         { x =  2400, y =  6000, z =  -4365, a = -0x8000 }, 5.5,  1,  FLOOD_WATER, { x =  6245, y =  530, z =  -8720, a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,            "c8",         { x =  7420, y =  3355, z = -10060, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, { x =  1475, y =  480, z =  -6520, a =  0x3000 })
    flood_define_level(false, LEVEL_COTMC,          "mc",         { x =  1530, y =  3800, z =  -3460, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, { x =  2690, y = 1090, z =   -355, a =  0x8000 })
    flood_define_level(false, LEVEL_VCUTM,          "vc",         { x = 10350, y = 10620, z = -10425, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  6090, y = 6740, z = -10555, a =  0x8000 })
    flood_define_level(false, LEVEL_TOTWC,          "wc",         { x =  2470, y =  5135, z = -13355, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x =  -445, y = 1160, z =  -1385, a =  0x4000 })	
    flood_define_level(false, LEVEL_SA,             "sa",         { x =  2815, y =  2510, z = -10325, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =  2915, y = 1370, z =   -800, a =  0x8000 })
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",      { x = 18810, y =  1040, z =   1175, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITS,           "b3",         { x =  7020, y = 10445, z =  -9135, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",         { x =  3130, y =  6025, z =  -5490, a =  0x4000 }, 4.5,  1,  FLOOD_WATER, nil)	
end

-- SM74EEEEEE Renewed by SuperRodrigo0
local function flood_load_super_mario_74_EEEEEE_levels()
    game = GAME_SM74EEEEEE
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "SM74EEEEEE"
	TEX_ROMHACK_LOGO = get_texture_info("sm74eeeeee_logo")	
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

  flood_define_level(false, LEVEL_BOB,              "c1",              { x =  -4235, y = 3250,  z =  -3870, a =  0x4000 }, 1.0,  1,   FLOOD_LAVA, nil)
  flood_define_level(false, LEVEL_WF,               "c2",               { x =  6799,  y = 5192,  z = 905, a =  -0x4000 }, 7.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_JRB,              "c3",              { x =  2275, y = 2995, z = -3055,  a =  -0x4000 }, 2.0,  1,   FLOOD_LAVA, { x = -960, y = -4385, z = -800, a = 0x0000 })
  flood_define_level(false, LEVEL_COTMC,            "mc",            { x =  3310, y = 7520, z = -380,  a =  0x0000 }, 3.0,  1,   FLOOD_LAVA, nil)  
  flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -4405,  y = 5550,  z =  1720,    a = 0x4000 }, 5.0,  1,   FLOOD_WATER, { x = -3910, y = -705, z = -5155, a = 0x0000 })
  flood_define_level(false, LEVEL_CCM,              "c4",              { x =  4859, y = 1501,  z = 293, a = -0x8000 }, 3.0,  1,   FLOOD_WATER, { x = 2409, y = -39, z = -5916,  a = 0x0000 })
  flood_define_level(false, LEVEL_VCUTM,            "vc",            { x =  403,  y = 4193,  z = -2451,   a =  0x0000 }, 2.0,  1,   FLOOD_WATER, nil) 
  flood_define_level(false, LEVEL_PSS,              "pss",              { x = 2647, y = 5026,  z =  -3954, a =  -0x2000 }, 3.0,  1,   FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_HMC,              "c6",              { x = 5065, y = 2347, z = 4229, a =  0x8000 }, 1.5,  1,   FLOOD_LAVA,  { x = -5755, y = 675, z = 2165, a = 0x0000 })
  flood_define_level(false, LEVEL_LLL,              "c7",              { x = -1080, y = 11805,  z =  500, a = -0x0000 }, 5.0,  1,   FLOOD_WATER,  nil)
  flood_define_level(false, LEVEL_SSL,              "c8",              { x = 4260, y = 5165, z = 4800, a =  0x8000 }, 1.5,  1,   FLOOD_SAND,  { x = -2188, y = -565,  z = -5767, a = 0x0000 })
  flood_define_level(false, LEVEL_DDD,              "c9",              { x = 3718, y = 2256, z = -4753, a =  0x0000 }, 1.5,  1,   FLOOD_LAVA, { x = 2917, y = -3223, z = -5590, a = 0x0000 })
  flood_define_level(false, LEVEL_TOTWC,            "wc",            {  x =  -2985,  y = 4564,  z = -242, a =  0x0000 }, 1.8,  1,   FLOOD_LAVA, { x = 132, y = -2164, z = 814, a = 0x0000 })
  flood_define_level(false, LEVEL_BITFS,            "b2",            { x = -4878, y = 6639, z = -6502, a =  0x0000 }, 0.7,  1,   FLOOD_SAND, { x = 2087, y = 3390, z = -6139, a = 0x4000 })
  flood_define_level(false, LEVEL_SL,               "c10",               { x = -2261, y = 4320, z =  3279, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = 2239, y = -253, z = -3367, a = 0x8000 })  
  flood_define_level(false, LEVEL_WDW,              "c11",              { x =  -2335, y =  3277, z =  -1160,   a = 0x4000 }, 1.0,  1,   FLOOD_WATER, { x = 2211, y = -1240, z = 64, a = 0x0000 }) 
  flood_define_level(false, LEVEL_TTM,              "c12",              { x = 3200,  y = 4630, z = -4320,  a =  0x4000 }, 1.5,  1,   FLOOD_WATER, { x = -50,  y = -4485, z = 2200, a = 0x0000 })
  flood_define_level(false, LEVEL_THI,              "c13",              { x = 6374, y = 4826, z = -928, a =  0x0000 }, 1.0,  1,   FLOOD_LAVA, { x = -29,  y = -455, z = -47, a = 0x0000 })
  flood_define_level(false, LEVEL_TTC,              "c14",              { x = -230, y = 10925, z = 2530, a =  0x4000 }, 0.75,  1,   FLOOD_MUD, nil)
  flood_define_level(false, LEVEL_RR,               "c15",               { x = 90, y = 10815, z = -4320, a =  0x8000 }, 0.5,  1,   FLOOD_LAVA, { x = 2825,  y = -2890, z = 1080, a = -0x4000 })
  flood_define_level(false, LEVEL_SA,               "sa",               { x =  -2915,  y = 1077,  z = 4108, a =  0x8000 }, 1.0,  1,   FLOOD_WATER, { x = 7765,  y = -50, z = -5920, a = -0x4000 })
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",               { x = -143, y = 743,  z = -1668, a =  -0x4000 }, 1.5, 1,   FLOOD_LAVA, nil)
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",            { x = 5850,  y = 4325, z = 780, a =  -0x4000 }, 3.5,  1,   FLOOD_WATER, { x = -2780, y = -1040, z = -250, a = 0x4000 })
  flood_define_level(false, LEVEL_CASTLE,           "c",           { x = 39,    y = 2135, z =  3501, a = 0x4000 }, 5.0,  1,   FLOOD_LAVA, { x = -260,  y = -1315, z = -4345, a = 0x0000 })
  
  ----------------------------- Easy Mode by SuperRodrigo0 ----------------------------- START 25
  
    flood_define_level(true, LEVEL_BOB,            "easy",               { x = -199,    y = 3692,   z = 1275,   a =  0x0000 }, 1.5,  1,   FLOOD_LAVA,  nil) 
    flood_define_level(true, LEVEL_BOB,            "easy",          { x =  -4235, y = 3250,  z =  -3870, a =  0x4000 }, 4.5,  1,   FLOOD_LAVA,  { x =  -204, y = 2744,  z =  3878, a = -0x4000  })
    flood_define_level(true, LEVEL_WF,             "easy",    { x = 6643,  y = 3813,  z = 1346, a =  -0x6000 }, 11.0,  1,   FLOOD_LAVA,  nil) 
    flood_define_level(true, LEVEL_JRB,            "easy",           { x =  2203,   y = -903,   z = 2438,   a =  0x9000 }, 1.5,  1,   FLOOD_LAVA,  { x =  -960, y = -3737,  z = -797,  a =  0x0000 })
    flood_define_level(true, LEVEL_JRB,            "easy",               { x =  2275, y = 2995, z = -3055,  a =  -0x4000 }, 1.8,  1,   FLOOD_LAVA,  { x =  -221, y = 491, z = 3119 ,  a =  0x6000 })
    flood_define_level(true, LEVEL_COTMC,          "easy",               { x =  3310, y = 7520, z = -380,  a =  0x0000 }, 4.2,  1,   FLOOD_LAVA,  { x =  1907, y = 1517, z = 658 ,  a =  0x2000 })
    flood_define_level(true, LEVEL_BITDW,          "easy",             { x = -1829,   y = 1878,   z = 3829,   a =  0x0000 }, 2.0,  1,   FLOOD_LAVA,  { x = -3910, y = -705, z = -5155, a = 0x0000 })
    flood_define_level(true, LEVEL_BITDW,          "easy",           { x =  -4405,  y = 5550,  z =  1720,    a = 0x4000 }, 3.0,  1,   FLOOD_LAVA,  { x = -3484, y = 1959,  z = 1073,   a =  0x4000 })
    flood_define_level(true, LEVEL_CCM,            "easy",              { x =  4859, y = 1501,  z = 293, a = -0x6000 }, 3.0,  1,   FLOOD_WATER, { x = 2409, y = -39, z = -5916,  a = 0x0000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",               { x =  2380,  y = -1421,  z = -1226,   a =  0x4000 }, 2.0,  1,   FLOOD_LAVA,  nil) 
    flood_define_level(true, LEVEL_VCUTM,          "easy",               { x =  403,  y = 4193,  z = -2451,   a =  0x0000 }, 1.6,  1,   FLOOD_LAVA,  { x =  2380, y = -1421, z = -1226 ,  a =  -0x4000 })
    flood_define_level(true, LEVEL_PSS,            "easy",               { x =  2085,  y = 4672,  z = -3066,   a =  0x0000 }, 3.0,  1,   FLOOD_LAVA,  nil) 
    flood_define_level(true, LEVEL_PSS,            "easy",               { x = 3593, y = 4021,  z =  3641, a =  0x8000 }, 1.8,  1,   FLOOD_LAVA,  { x =  829, y = 2783, z = 4686 ,  a =  0x4000 })
    flood_define_level(true, LEVEL_HMC,            "easy",               { x =  -4096,  y = 2398,  z = 3406,   a =  -0x4000 }, 3.0,  1,   FLOOD_LAVA,  { x = -5755, y = 675, z = 2165, a = 0x0000 })
    flood_define_level(true, LEVEL_HMC,            "easy",               { x = 5065, y = 2347, z = 4229, a =  0x8000 }, 5.2,  1,   FLOOD_LAVA,  { x =  2073, y = 162, z = -6910 ,  a =  0x0000 })
    flood_define_level(true, LEVEL_LLL,            "easy",               { x =  564,   y = 206,   z = -1177,   a =  0x8000 }, 5,  1,   FLOOD_LAVA,  nil) 
    flood_define_level(true, LEVEL_LLL,            "easy",               { x = -1080, y = 11805,  z =  500, a = 0x0000 }, 3,  1,   FLOOD_LAVA,  { x =  1776, y = 1182, z = -340 ,  a =  0x0000 })
    flood_define_level(true, LEVEL_SSL,            "easy",              { x = 2812, y = 2436, z = 558, a =  0x8000 }, 1.3,  1,   FLOOD_SAND,  { x = -2188, y = -565,  z = -5767, a = 0x0000 })
    flood_define_level(true, LEVEL_SSL,            "easy",              { x = 4260, y = 5165, z = 4800, a =  0x0000 }, 1.3,  1,   FLOOD_SAND,  { x = 2826, y = 2175, z = -818, a = 0x0000 })
    flood_define_level(true, LEVEL_DDD,            "easy",               { x = 3904, y = -508,   z = 3866,   a =  0x8000 }, 3.5,  1,   FLOOD_LAVA,  { x = 2917, y = -3223, z = -5590, a = 0x0000 })
    flood_define_level(true, LEVEL_DDD,            "easy",               { x = 3718, y = 2256, z = -4753, a =  0x0000 }, 1.5,  1,   FLOOD_LAVA,  { x =  3739, y = -508,  z =  3864,  a =  0x8000 })
    flood_define_level(true, LEVEL_TOTWC,          "easy",               { x =  -3459,  y = -233,  z = 6511,   a =  0x8000 }, 2.1,  1,   FLOOD_LAVA,  { x = 132, y = -2164, z = 814, a = 0x0000 })
    flood_define_level(true, LEVEL_TOTWC,          "easy",               { x =  -2985,  y = 4564,  z = -242,   a =  0x0000 }, 2.1,  1,   FLOOD_LAVA,  { x =  -3459,  y = -233,  z = 6511, a = 0x6000 })
    flood_define_level(true, LEVEL_BITFS,          "easy",            { x = -4911, y = 6810, z = -2383, a =  0x0000 }, 0.7,  1,   FLOOD_SAND, { x = 2087, y = 3390, z = -6139, a = 0x4000 })
    flood_define_level(true, LEVEL_BITFS,          "easy",        { x =  -4880,  y = 6639,  z = -6474,   a =  0x0000 }, 3.0,  1,   FLOOD_LAVA,  { x =  -4903, y = 5180, z = -1300 ,  a =  0x6000 })
    flood_define_level(true, LEVEL_SL,             "easy",               { x = -2261, y = 4320, z =  3279, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, { x = 2239, y = -253, z = -3367, a = 0x8000 })  
    flood_define_level(true, LEVEL_WDW,            "easy",               { x =  4603,  y = 681,  z = 418,   a =  0x8000 }, 1.1,  1,   FLOOD_LAVA,  { x = 2211, y = -1240, z = 64, a = 0x0000 }) 
    flood_define_level(true, LEVEL_WDW,            "easy",               { x =  -2335, y =  3277, z =  -1160,   a = 0x4000 }, 1.5,  1,   FLOOD_LAVA,  { x = 4603,  y = 915,  z = 418, a = 0x0000 }) 
    flood_define_level(true, LEVEL_TTM,            "easy",               { x =  -26,  y = 604,  z = 1055,   a =  0x6000 }, 1.5,  1,   FLOOD_LAVA,  { x = -50,  y = -4485, z = 2200, a = 0x0000 })
    flood_define_level(true, LEVEL_TTM,            "easy",               { x =  4692,  y = 4630,  z = -3321,   a =  0x8000 }, 1.4,  1,   FLOOD_LAVA,  { x = -26,  y = 604,  z = 1055,  a =  -0x4000 })
    flood_define_level(true, LEVEL_THI,            "easy",               { x =  6380,  y = 1777,  z = -847,   a =  -0x4000 }, 1.0,  1,   FLOOD_LAVA, { x = -29,  y = -455, z = -47, a = 0x0000 })
    flood_define_level(true, LEVEL_THI,            "easy",               { x =  6319,  y = 4826,  z = -787,   a =  0x0000 }, 1.2,  1,   FLOOD_LAVA,  { x = 6380,  y = 2225,  z = -847,  a =  0x0000 })
    flood_define_level(true, LEVEL_TTC,            "easy",           { x =  2367,  y = 2778,  z = -3517,   a =  0x8000 }, 1.6,  1,   FLOOD_LAVA,  { x = 2135,  y = -3215,  z = 27,  a =  -0x6000 })
    flood_define_level(true, LEVEL_TTC,            "easy",      { x =  -656,  y = 5984,  z = 5782 ,   a =  0x8000 }, 3.0,  1,   FLOOD_LAVA,  { x =  2381,  y = 3541,  z = -3492 ,  a =  0x0000 })
    flood_define_level(true, LEVEL_TTC,            "easy",            { x = -230, y = 10925, z = 2530, a =  0x4000 }, 10.0,  1,   FLOOD_LAVA,  { x =  -1393,  y = 7474,  z = 5226 ,  a =  0x0000 })
    flood_define_level(true, LEVEL_RR,             "easy",          { x =  1526,  y = 906,  z = -6626,   a =  0x4000 }, 1.4,  1,   FLOOD_LAVA,  { x =  2378,  y = -2727,  z = 1094 ,  a = -0x6000 })
    flood_define_level(true, LEVEL_RR,             "easy",           { x =  -2314,  y = 3703,  z = 2930,   a =  0x8000 }, 3.9,  1,   FLOOD_LAVA,  { x =  180, y = 1545, z = -6671 ,  a = -0x4000 })
    flood_define_level(true, LEVEL_RR,             "easy",           { x =  903,  y = 6780,  z = 4750,   a =  0x0000 }, 2.6,  1,   FLOOD_LAVA,  { x = -2316,  y = 3885,  z = 1247,  a =  0x0000 })
    flood_define_level(true, LEVEL_RR,             "easy",               { x = 90, y = 10815, z = -4320, a =  0x8000 }, 1.4,  1,   FLOOD_LAVA,  { x = 829, y = 7100, z = 4743 ,  a =  0x4000 })
    flood_define_level(true, LEVEL_SA,             "easy",               { x =  -2915,  y = 1077,  z = 4108,   a =  0x8000 }, 1.0,  1,   FLOOD_LAVA, { x = 7765,  y = -50, z = -5920, a = -0x4000 })
    flood_define_level(true, LEVEL_CASTLE_COURTYARD, "easy",               { x = -143, y = 743,  z = -1668, a =  -0x4000 }, 1.5, 1,   FLOOD_LAVA, nil)
    flood_define_level(true, LEVEL_WMOTR,            "easy",            { x = 5850,  y = 4325, z = 780, a =  -0x4000 }, 3.5,  1,   FLOOD_WATER, { x = -2780, y = -1040, z = -250, a = 0x4000 })
    flood_define_level(true, LEVEL_CASTLE,           "easy",           { x = 39,    y = 2135, z =  3501, a = 0x4000 }, 5.0,  1,   FLOOD_LAVA, { x = -260,  y = -1315, z = -4345, a = 0x0000 })
end	

local function flood_load_super_mario_64_sapphire_levels()
    game = GAME_SUPER_MARIO_64_SAPPHIRE
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Super Mario 64 Sapphire"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_sapphire_logo")

    flood_define_level(false, LEVEL_BOB,            "c1",   { x =   6070, y = 3655, z =  -5880, a =  0x0000 }, 2.0,  1, FLOOD_WATER, { x =    -80, y =  1300, z =  -150, a =  0x8000 })
    flood_define_level(false, LEVEL_WF,             "c2",   { x = -12120, y = 3790, z =   9690, a =  0x6000 }, 2.0,  1, FLOOD_WATER, { x =  -5485, y =  2060, z =  8890, a =  0x8000 })
    flood_define_level(false, LEVEL_JRB,            "c3",   { x =  -4265, y = 2850, z =  -6280, a =  0x8000 }, 2.0,  1, FLOOD_SAND,  { x =      0, y =    80, z =  -270, a = -0x8000 })
    flood_define_level(false, LEVEL_CCM,            "c4",   { x =   7305, y = 2300, z = -13765, a =  0x3000 }, 1.75, 1, FLOOD_LAVA,  { x =  13625, y =   470, z =   -55, a = -0x8000 })	
    flood_define_level(false, LEVEL_PSS,            "pss",  { x =   -100, y = 5035, z =   -700, a =  0x8000 }, 6.5,  1, FLOOD_WATER, { x = -24425, y = -2500, z = -7690, a =  0x0000 })		
    flood_define_level(false, LEVEL_BITS,           "b3",   { x =   6350, y = 7300, z =  -4660, a =  0x8000 }, 2.75, 1, FLOOD_WATER, { x =      0, y =   800, z =  -200, a = -0x8000 })	
end

local function flood_load_the_mushroom_cup_levels()
    game = GAME_THE_MUSHROOM_CUP
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Super Mario 64: The Mushroom Cup"
	TEX_ROMHACK_LOGO = get_texture_info("the_mushroom_cup_logo")	
    hook_behavior(id_bhvDoorWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
	
    flood_define_level(false, LEVEL_BOB,              "c1",          { x =   -860, y =  1040, z =  11585, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",          { x =   8230, y =  5130, z =   7585, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x = 12840, y =  -700, z =  2970, a = -0x4000 })	
    flood_define_level(false, LEVEL_RR,               "c15",         { x =   1800, y =  3555, z =   -600, a = -0x4000 }, 3.0,  1,   FLOOD_WATER, { x = -6490, y =  1135, z =  2215, a = -0x8000 })	
    flood_define_level(false, LEVEL_JRB,              "c3",          { x =   2490, y =  6500, z =  -7055, a =  0x8000 }, 4.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3-2",        { x =   -990, y =  2245, z =  -7465, a =  0x4000 }, 3.5,  1,   FLOOD_WATER, { x = -2565, y = -4100, z = -8300, a =  0x4000 })
    flood_define_level(false, LEVEL_CCM,              "c4",          { x =   1195, y =  2900, z = -11000, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x =   152, y = -1065, z = -1944, a = -0x8000 })
    flood_define_level(false, LEVEL_PSS,              "pss",         { x =   2960, y =  1400, z =   4675, a =  0x4000 }, 1.25, 1,   FLOOD_WATER, { x =  8505, y = -1650, z = -1590, a =  0x0000 })		
    flood_define_level(false, LEVEL_COTMC,            "mc",          { x =    490, y = 12686, z =   -865, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x =   565, y =   500, z =   515, a = -0x8000 })	
    flood_define_level(false, LEVEL_VCUTM,            "vc",          { x =   1540, y = -4537, z =  -1070, a =  0x8000 }, 1.5,  1,   FLOOD_WATER, { x =  2870, y = -6450, z =   120, a = -0x4000 })		
    flood_define_level(false, LEVEL_BITDW,            "b1",          { x =   8410, y =  5290, z =  -7085, a = -0x4000 }, 2.0,  1,   FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_BBH,              "c5",          { x =  13370, y =  5745, z =     15, a =  0x8000 }, 1.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_HMC,              "c6",          { x =   3415, y =  6676, z =   9745, a =  0x6000 }, 3.0,  1,   FLOOD_LAVA,  { x =  4739, y = -1000, z = -4780, a = -0x8000 })
    flood_define_level(false, LEVEL_THI,              "c13",         { x =   2975, y =  6360, z =  -1305, a =  0x0000 }, 3.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SA,               "sa",          { x =   1470, y =  8470, z =  -5310, a =  0x4000 }, 5.0,  1,   FLOOD_LAVA,  { x = -2550, y = -3265, z = 10380, a =  0x8000 })
    flood_define_level(false, LEVEL_LLL,              "c7",          { x = -12920, y =  3485, z =  -1610, a =  0x4000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",          { x =    900, y =  3120, z =  -9510, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_SSL,              "c8",          { x =   3870, y =  3980, z =  -2800, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,              "c9",          { x =   -700, y =  5250, z =  -1680, a = -0x4000 }, 1.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,            "b2",          { x =   1595, y =  1755, z =   3820, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x =  1495, y =   380, z = -1725, a =  0x8000 })
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",    { x =   1030, y =  3070, z =  -8100, a =  0x2000 }, 3.75, 1,   FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_SL,               "c10",         { x =   3750, y = 10735, z =  12280, a =  0x0000 }, 2.25, 1,   FLOOD_WATER, { x = -1655, y = -1710, z =  7510, a = -0x4000 })
    flood_define_level(false, LEVEL_WDW,              "c11",         { x =  -3235, y = 12152, z =   4357, a = -0x4000 }, 2.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",         { x =  -4840, y =  5763, z =  -4470, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTC,              "c14",         { x =  -1369, y =  3670, z =   -465, a =  0x0000 }, 4.5,  1,   FLOOD_WATER, { x =  -820, y = -7090, z =   700, a = -0x4000 })
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",       { x =   -100, y =  4390, z =    -80, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITS,             "b3",          { x =   1990, y = 16830, z =  -3160, a =  0x0000 }, 2.5,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",          { x =    945, y =  1980, z =   6500, a =  0x0000 }, 3.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",          { x =   -335, y = 11345, z =      0, a =  0x4000 }, 14.0, 1,   FLOOD_WATER, nil)	
end

local function flood_load_the_galactic_journey_levels()
    game = GAME_THE_GALACTIC_JOURNEY
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Super Mario The Galactic Journey"
	TEX_ROMHACK_LOGO = get_texture_info("the_galactic_journey_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  1945, y =   830, z =-12870, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x =-13590, y = -2495, z =  3690,  a = 0x4000 })
    flood_define_level(false, LEVEL_WF,               "c2",             { x =-15020, y =  3780, z = -4270, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =-19670, y =  3300, z = -3575, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = 19810, y =  6940, z =  9610, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =  8055, y =  2205, z = 15070, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x = -3285, y = -3015, z =  8180, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =   -10, y =  4870, z =  -600, a =  0x4000 }, 3.0,  1,  FLOOD_LAVA,  nil) 	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =-16055, y =   385, z =-16245, a =  0x6000 }, 4.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x = -5750, y =  5990, z =  8080, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  8950, y =  4205, z =  5345, a =  0x8000 }, 2.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  8545, y =  4185, z =  7100, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x = -4950, y = -5590, z = -2150,  a = 0x4000 })
    flood_define_level(false, LEVEL_DDD,              "c9",             { x = 10440, y = -2145, z =  3495, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =-13215, y =   550, z = -3230, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",            { x =-15775, y =  3240, z = 14585, a =  0x0000 }, 4.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =-17000, y =  6805, z =  1560, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,              "c13",            { x = 24080, y =  1615, z =-11990, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,              "c14",            { x =  9970, y =  3265, z =  2595, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,               "c15",            { x =  5600, y =  -455, z =-20425, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITS,             "b3",             { x = 12390, y =  6295, z = -8165, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =  1465, y = -9155, z =17655,  a = -0x4000 })
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  4750, y =   920, z =  4335, a =  0x0000 }, 4.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =  1785, y =   -20, z = -4310, a =  0x0000 }, 1.75, 1,  FLOOD_WATER, nil)
end

local function flood_load_star_revenge_1_3_redone_levels()
    game = GAME_STAR_REVENGE_1_3_REDONE
 	LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
    romhackText = "Star Revenge 1.3 - Redone"	
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_1.3_redone_logo")	
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		
	
  flood_define_level(false, LEVEL_BOB,              "c1",        { x =   -960, y =  3985, z =   6040, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_WF,               "c2",        { x =   3105, y =  4770, z =   3920, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x =   -545, y = -2580, z =  4935, a =  0x8000 })
  flood_define_level(false, LEVEL_TOTWC,            "wc",        { x =  -2530, y =  7065, z =  -1700, a = -0x6000 }, 2.5,  1,   FLOOD_WATER, { x =    120, y = -3785, z =  4915, a =  0x8000 })  
  flood_define_level(false, LEVEL_JRB,              "c3",        { x = -21515, y =  1650, z = -22890, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)      
  flood_define_level(false, LEVEL_CCM,              "c4",        { x =  12095, y =  4310, z =   2575, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x =   1910, y =   -70, z = -3545, a =  0x8000 })  
  flood_define_level(false, LEVEL_BBH,              "c5",        { x =  -1350, y =  7484, z =   -735, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, nil)     
  flood_define_level(false, LEVEL_BITDW,            "b1",        { x =   4920, y =  6055, z =   -215, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = -11680, y = -4230, z =  6960, a =  0x8000 })  
  flood_define_level(false, LEVEL_HMC,              "c6",        { x =   5880, y =  5058, z =  -6485, a =  0x4000 }, 1.0,  1,   FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_COTMC,            "mc",        { x =  -7630, y =  5890, z =  -4090, a =  0x0000 }, 2.75, 1,   FLOOD_LAVA,  nil)   
  flood_define_level(false, LEVEL_PSS,              "pss",       { x =  -9165, y =  5910, z =  -6665, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x =   3915, y = -2060, z =  1090, a =  0x4000 })      
  flood_define_level(false, LEVEL_LLL,              "c7",        { x =   7635, y =  2143, z =   -700, a =  0x4000 }, 1.75, 1,   FLOOD_WATER, { x =  -1145, y =  -995, z =   932, a = -0x8000 })  
  flood_define_level(false, LEVEL_SSL,              "c8",        { x =   5030, y =  2025, z =  10545, a = -0x4000 }, 2.0,  1,   FLOOD_SAND,  { x =   8740, y =  -220, z = -3330, a = -0x2000 })  
  flood_define_level(false, LEVEL_SSL,              "c8-2",      { x =   6660, y = -2940, z =   8175, a =  0x0000 }, 1.0,  1,   FLOOD_SAND,  { x =  -2995, y = -5490, z =   925, a =  0x4000 }) 
  flood_define_level(false, LEVEL_VCUTM,            "vc",        { x =  -9470, y =  1770, z =   4380, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)   
  flood_define_level(false, LEVEL_DDD,              "c9",        { x =     30, y =  2800, z =    230, a =  0x6000 }, 2.25, 1,   FLOOD_LAVA,  nil)  
  flood_define_level(false, LEVEL_SL,               "c10",       { x =   6415, y =  5470, z =   3045, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",     { x =  -9350, y =  1890, z =   5640, a =  0x8000 }, 4.5,  1,   FLOOD_WATER, nil)     
  flood_define_level(false, LEVEL_BITFS,            "b2",        { x =  -5650, y =  3555, z =  -6530, a =  0x4000 }, 1.5,  1,   FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_WDW,              "c11",       { x =    330, y =  6500, z =  -5000, a = -0x4000 }, 3.0,  1,   FLOOD_WATER, { x =  -1475, y = -1680, z =  5130, a = -0x8000 }) 
  flood_define_level(false, LEVEL_TTM,              "c12",       { x =    730, y =  6320, z =   7290, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x =  -5870, y = -3920, z =   510, a =  0x4000 }) 
  flood_define_level(false, LEVEL_RR,               "c15",       { x =  -9480, y =  1422, z =   4710, a =  0x0000 }, 1.0,  1,   FLOOD_SAND,  { x =  -7280, y =  -460, z =  1605, a =  0x0000 })  
  flood_define_level(false, LEVEL_RR,               "c15-2",     { x =   4920, y =  4500, z =   4880, a =  0x0000 }, 1.5,  1,   FLOOD_LAVA,  { x =   7450, y =  -450, z =   625, a =  0x4000 })  
  flood_define_level(false, LEVEL_RR,               "c15-3",     { x =  10990, y =  4290, z = -13725, a =  0x4000 }, 1.5,  1,   FLOOD_MUD,   { x =   8820, y =  1990, z = -8690, a = -0x8000 })  
  flood_define_level(false, LEVEL_BITS,             "b3-2",      { x = -10480, y =  1895, z =   2015, a =  0x8000 }, 2.0,  1,   FLOOD_LAVA,  { x =  -8620, y =   100, z = -2150, a =  0x2000 })  
  flood_define_level(false, LEVEL_BITS,             "b3-4",      { x =   8210, y =   500, z =    690, a =  0x4000 }, 2.5,  1,   FLOOD_SAND,  { x =   4205, y =   450, z =  1090, a =  0x4000 }) 
  flood_define_level(false, LEVEL_BITS,             "b3-3",      { x =  -1355, y =  1325, z =  -5615, a =  0x8000 }, 2.75, 1,   FLOOD_WATER, { x =  -1840, y =  -180, z = -3455, a =  0x4000 })  
  flood_define_level(false, LEVEL_BITS,             "b3",        { x =    740, y =  1265, z =   7940, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x =  -1110, y =   300, z =  4690, a =  0x0000 })  
  flood_define_level(false, LEVEL_TTC,              "c14",       { x =  12465, y =  -735, z =    200, a = -0x4000 }, 0.75, 1,   FLOOD_WATER, nil)   
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",        { x =  -8275, y =  3465, z =   8940, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",        { x =   7950, y =  3240, z =   1305, a =  0x4000 }, 5.0,  1,   FLOOD_WATER, nil)
end

local function flood_load_star_revenge_1_levels()
    game = GAME_STAR_REVENGE_1
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Star Revenge 1: Star Takeover"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_1_logo")	

  flood_define_level(false, LEVEL_BOB,              "c1",            { x =  -1150, y =  8405, z =  5150, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_WF,               "c2",            { x =   2220, y =  4220, z =  3560, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -895, y = -1945, z =  4460, a = -0x8000 })  
  flood_define_level(false, LEVEL_TOTWC,            "wc",            { x =  -1950, y =  4905, z =  1505, a = -0x3000 }, 2.5,  1,  FLOOD_WATER, { x =   210, y = -3815, z = -3960, a =  0x0000 })    
  flood_define_level(false, LEVEL_JRB,              "c3",            { x = -23375, y =  3430, z = 16080, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_CCM,              "c4",            { x =  11705, y =  3640, z =  2515, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_BBH,              "c5",            { x =   -350, y =  4505, z =   100, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x = -4660, y = -5220, z = -2150, a =  0x0000 })    
  flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -5290, y =  2965, z = -5450, a =  0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)   
  flood_define_level(false, LEVEL_HMC,              "c6",            { x =   4075, y =  2670, z = -4790, a =  0x8000 }, 1.0,  1,  FLOOD_LAVA,  { x = -5920, y = -1070, z =  4450, a =  0x0000 })
  flood_define_level(false, LEVEL_COTMC,            "mc",            { x =  -4875, y =  4180, z = -7510, a =  0x4000 }, 2.5,  1,  FLOOD_MUD,   nil) 
  flood_define_level(false, LEVEL_PSS,              "pss",           { x =  11745, y =  7175, z =  5630, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x = -1380, y =   210, z = -2100, a = -0x8000 })   
  flood_define_level(false, LEVEL_LLL,              "c7",            { x =   9335, y =  2490, z =  -890, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -820, y = -1060, z =   900, a = -0x8000 }) 
  flood_define_level(false, LEVEL_SSL,              "c8",            { x =   3600, y =  1670, z =  7765, a = -0x4000 }, 1.75, 1,  FLOOD_SAND,  { x =  6485, y =   400, z = -3045, a = -0x2000 })   
  flood_define_level(false, LEVEL_SSL,              "c8-2",          { x =   4920, y = -2190, z =  5920, a =  0x8000 }, 1.0,  1,  FLOOD_SAND,  { x = -2555, y = -3310, z =   300, a = -0x8000 })   
  flood_define_level(false, LEVEL_DDD,              "c9",            { x =     30, y =  2555, z =   150, a =  0x6000 }, 2.0,  1,  FLOOD_LAVA,  nil)      
  flood_define_level(false, LEVEL_SL,               "c10",           { x =   5220, y =  4660, z =  2570, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =   290, y = -1180, z = -5640, a =  0x0000 })
  flood_define_level(false, LEVEL_BITFS,            "b2",            { x =   3470, y =  3165, z =  2355, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_WDW,              "c11",           { x =    330, y =  5100, z = -3820, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x = -1160, y = -1210, z =  3955, a = -0x8000 })  
  flood_define_level(false, LEVEL_TTM,              "c12",           { x =  -2030, y =  6200, z =  4055, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x = -5530, y = -2290, z =   440, a = -0x8000 })  
  flood_define_level(false, LEVEL_BITS,             "b3",            { x =    740, y =  1265, z =  7940, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, { x = -1720, y =   300, z =  5135, a =  0x0000 }) 
  flood_define_level(false, LEVEL_BITS,             "b3-2",          { x = -10480, y =  1895, z =  2015, a =  0x8000 }, 2.0,  1,  FLOOD_LAVA,  { x = -9495, y =   100, z = -2890, a =  0x2000 }) 
  flood_define_level(false, LEVEL_BITS,             "b3-3",          { x =  -1355, y =  1325, z = -5615, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, { x = -1840, y =  -180, z = -3455, a =  0x4000 }) 
  flood_define_level(false, LEVEL_BITS,             "b3-4",          { x =   8210, y =   500, z =   690, a =  0x4000 }, 2.5,  1,  FLOOD_SAND,  { x =  4055, y =   450, z =  1080, a =  0x4000 }) 
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",         { x =  10130, y =  -590, z =   165, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, nil)      
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",            { x =    860, y =  5465, z =  8455, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, { x =  8200, y = -1860, z = -9450, a =  0x0000 })  
  flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",            { x =  -6990, y =  3330, z =  -620, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x =  4040, y =  -540, z =  3820, a = -0x8000 })  
end

local function flood_load_star_revenge_3_levels()
    game = GAME_STAR_REVENGE_3
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
    romhackText = "Star Revenge 3: Mario on An Saoire"		
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_3_logo")	

  flood_define_level(false, LEVEL_BOB,              "c1",       { x =  -1830, y = 1650, z = -11035, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_WF,               "c2",       { x = -21980, y = -110, z =  11200, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, nil) 
  flood_define_level(false, LEVEL_JRB,              "c3",       { x =   7235, y = 4885, z =   3280, a =  0x4000 }, 2.75, 1,  FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_CCM,              "c4",       { x =  -2980, y = 1880, z =   6705, a =  0x4000 }, 5.0,  1,  FLOOD_WATER, nil)   
  flood_define_level(false, LEVEL_BBH,              "c5",       { x =   1250, y = 3664, z =    770, a = -0x2000 }, 1.0,  1,  FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_HMC,              "c6",       { x =  -4830, y = 1340, z =   4760, a =  0x2000 }, 1.0,  1,  FLOOD_MUD,   nil)
  flood_define_level(false, LEVEL_LLL,              "c7",       { x =  -5220, y =  -75, z =   4230, a =  0x8000 }, 2.5,  1,  FLOOD_SAND,  nil)
  flood_define_level(false, LEVEL_SSL,              "c8",       { x =   5050, y = 2925, z =   6965, a =  0x4000 }, 3.0,  1,  FLOOD_LAVA,  nil)  
  flood_define_level(false, LEVEL_BITFS,            "b2",       { x =  -1120, y = 5190, z =  -4390, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_PSS,              "pss",      { x = -11005, y = 6160, z =  -8540, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, { x = -9800, y = -5910, z = 2325, a = 0x0000 }) 
  flood_define_level(false, LEVEL_SA,               "sa",       { x =  -1650, y = 2770, z =  -5325, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)  
end

local function flood_load_star_revenge_6_levels()
    game = GAME_STAR_REVENGE_6
	LEVEL_LOBBY = LEVEL_PSS
    romhackText = "Star Revenge 6: Luigi's Adventure"		
	
    flood_define_level(false, LEVEL_BOB,            "c1",            { x = -8135, y =  3937, z =   9525, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",            { x = 11940, y =   850, z =   2140, a = -0x4000 }, 2.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_JRB,            "c3",            { x = -6145, y =  4265, z =  10055, a = -0x3000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,            "c4",            { x = -3090, y =  2265, z =   1480, a =  0x6000 }, 3.25, 1,  FLOOD_LAVA,  { x =   8390, y = -2600, z = -11105, a =  0x0000 }) 
    flood_define_level(false, LEVEL_SA,             "sa",            { x = 13460, y =  9450, z =   -455, a = -0x4000 }, 10.0, 1,  FLOOD_WATER, { x =  -8800, y = -6320, z =  -1325, a =  0x8000 })  	
    flood_define_level(false, LEVEL_BITDW,          "b1",            { x =   -40, y =  3500, z =   2950, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,            "c5",            { x =   385, y =  3525, z = -10595, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)  
    flood_define_level(false, LEVEL_HMC,            "c6",            { x = -8675, y =  2950, z =  -7015, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,            "c7",            { x =  5030, y =  5655, z = -16875, a =  0x0000 }, 8.5,  1,  FLOOD_WATER, { x = -12270, y = -5680, z =   6730, a =  0x4000 })  
    flood_define_level(false, LEVEL_SSL,            "c8",            { x =  3850, y =  2600, z =   1770, a =  0x8000 }, 2.0,  1,  FLOOD_SAND,  { x =   6370, y = -3490, z =  -4480, a =  0x0000 })  
    flood_define_level(false, LEVEL_BITFS,          "b2",            { x = -1985, y = -1110, z =  -5400, a =  0x4000 }, 1.5,  1,  FLOOD_WATER, nil) 	
    flood_define_level(false, LEVEL_DDD,            "c9",            { x = -7000, y =  8700, z =   1680, a =  0x8000 }, 2.0,  1,  FLOOD_LAVA,  { x =   8000, y = -1380, z =   2625, a =  0x0000 })  
    flood_define_level(false, LEVEL_SL,             "c10",           { x =  -725, y =  7700, z =   6900, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, { x =   8000, y =  5180, z =   2615, a =  0x0000 })   
    flood_define_level(false, LEVEL_WDW,            "c11",           { x = -3560, y =  -285, z =  -9825, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x =    110, y = -1995, z =  10400, a =  0x8000 })  
    flood_define_level(false, LEVEL_TTM,            "c12",           { x = -9815, y =  3680, z =   1630, a =  0x2000 }, 3.5,  1,  FLOOD_MUD,   { x =  -4665, y = -1455, z =   6125, a =  0x0000 })  
    flood_define_level(false, LEVEL_THI,            "c13",           { x =  7860, y =  1650, z = -15475, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTC,            "c14",           { x = -1980, y =  1259, z = -11780, a =  0x4000 }, 1.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_RR,             "c15",           { x = -4595, y =  7050, z =  -6165, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",         { x = 13485, y =   610, z =  12765, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)
end

local function flood_load_brutal_mario_64_levels()
    game = GAME_BRUTAL_MARIO_64
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Brutal Mario 64"
    TEX_ROMHACK_LOGO = get_texture_info("brutal_mario_64_logo")		
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)			
	
  flood_define_level(false, LEVEL_DDD,              "c1",            { x =  4045, y =  6710, z = -6060, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_TTM,              "c2",            { x = -1080, y =  8100, z =  -930, a =  0x0000 }, 2.0,  1,  FLOOD_MUD,   { x =  1837, y =  1215, z =  4330, a = 0x0000 })  
  flood_define_level(false, LEVEL_BOWSER_2,         "bowser",        { x = -2200, y =  1180, z =     0, a =  0x8000 }, 8.0,  1,  FLOOD_LAVA,  nil)   
  flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",            { x = -6330, y =  3320, z =  7645, a =  0x0000 }, 4.0,  1,  FLOOD_MUD,   nil)  
  
 ---- Easy Mode ---- /flood start 5

    flood_define_level(true, LEVEL_DDD,              "easy",         { x =  5980, y =  1567, z = -5443, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)  
    flood_define_level(true, LEVEL_DDD,              "easy",         { x =  4031, y =  6713, z = -6089, a =  0x0000 }, 0.8,  1,  FLOOD_WATER, { x =  6720, y =  2256, z = -8193, a = 0x0000  })
    flood_define_level(true, LEVEL_TTM,              "easy",         { x =   537, y =  5148, z = -1520, a =  0x0000 }, 1.0,  1,  FLOOD_MUD,   { x =  1837, y =  1215, z =  4330, a = 0x0000 })
    flood_define_level(true, LEVEL_TTM,              "easy",         { x = -1073, y =  8207, z =  -929, a =  0x0000 }, 2.0,  1,  FLOOD_MUD,   { x =   537, y =  5869, z = -1520, a = 0x0000  })
    flood_define_level(true, LEVEL_BOWSER_2,         "easy",         { x = -1067, y = -2027, z =    10, a =  0x0000 }, 9.0,  1,  FLOOD_LAVA,  nil) 
    flood_define_level(true, LEVEL_BOWSER_2,         "easy",         { x = -2194, y =  1180, z =    13, a =  0x0000 }, 4.0,  1,  FLOOD_LAVA,  { x = -3075, y = -3870, z =   -22, a = 0x8000  })
    flood_define_level(true, LEVEL_CASTLE_GROUNDS,   "easy",         { x = -6330, y =  3320, z =  7645, a =  0x0000 }, 4.0,  1,  FLOOD_MUD,   nil)   
end

local function flood_load_some_kind_of_a_crash_game_levels()
    game = GAME_SOME_KIND_OF_A_CRASH_GAME
	LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD	
	romhackText = "Some Kind of a Crash Game"	
	TEX_ROMHACK_LOGO = get_texture_info("some_kind_of_a_crash_game_logo")	
	
  flood_define_level(false, LEVEL_BOB,              "c1",            { x =  3945, y =  3715, z =  -4375, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x = -3465, y =   870, z =  -6700, a =  0x4000 })
  flood_define_level(false, LEVEL_BOB,              "c1-2",          { x = -1385, y =  2205, z =  11010, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   895, y =   300, z =   -545, a =  0x0000 })
  flood_define_level(false, LEVEL_BOB,              "c1-3",          { x =  -560, y =  5690, z = -17100, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x =  -810, y =  3410, z = -15045, a = -0x4000 })
  flood_define_level(false, LEVEL_WF,               "c2",            { x =  7640, y =  4120, z =  -4210, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x = -7600, y =  -300, z =   -670, a =  0x4000 })  
  flood_define_level(false, LEVEL_BBH,              "c5",            { x = -8560, y =  2315, z =   -300, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, { x = -7120, y =   300, z =   7695, a =  0x8000 })  
  flood_define_level(false, LEVEL_LLL,              "c7",            { x = -2955, y =  4250, z =  -1625, a =  0x5000 }, 0.75, 1,  FLOOD_MUD,   nil) 
  flood_define_level(false, LEVEL_SSL,              "c8",            { x =   -40, y = 11200, z =   6565, a =  0x6000 }, 2.5,  1,  FLOOD_WATER, { x =  5750, y =  4485, z =   1655, a =  0x0000 }) 
  flood_define_level(false, LEVEL_SL,               "c10",           { x =  5000, y =  3390, z =  -5740, a =  0x0000 }, 2.5,  1,  FLOOD_LAVA,  { x =  -860, y =  4095, z =   5515, a =  0x4000 }) 
  flood_define_level(false, LEVEL_SL,               "c10-2",         { x =  4930, y =   315, z =   -780, a =  0x0000 }, 2.5,  1,  FLOOD_SAND,  { x =  6880, y = -4220, z =   -470, a = -0x4000 })  
  flood_define_level(false, LEVEL_SL,               "c10-3",         { x =  6050, y = -2130, z =  -7930, a = -0x2000 }, 1.0,  1,  FLOOD_SAND,  { x =  2340, y = -2515, z =  -4490, a =  0x6000 })    
  flood_define_level(false, LEVEL_TTM,              "c12",           { x = -1090, y =  8180, z =   -920, a = -0x4000 }, 2.75, 1,  FLOOD_MUD,   { x =  2115, y =  1250, z =   4670, a =  0x0000 })  
  flood_define_level(false, LEVEL_TTM,              "c12-2",         { x = -4565, y = -1005, z =  -1460, a =  0x4000 }, 1.5,  1,  FLOOD_MUD,   { x = -1375, y = -3430, z =   -920, a =  0x0000 })  
  flood_define_level(false, LEVEL_PSS,              "pss",           { x = -4800, y = 10925, z =   -325, a =  0x0000 }, 8.0,  1,  FLOOD_SAND,  { x = -4790, y = -5590, z =   3780, a =  0x8000 }) 
  flood_define_level(false, LEVEL_SA,               "sa",            { x =  5900, y =  5770, z =  -9570, a =  0x2000 }, 1.0,  1,  FLOOD_SAND,  { x =  2550, y =  5160, z =  -1560, a = -0x8000 }) 
  flood_define_level(false, LEVEL_VCUTM,            "vc",            { x = -3040, y =  7225, z =  -5140, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, { x =  6450, y = -1085, z =   7385, a =  0x4000 })  
  flood_define_level(false, LEVEL_COTMC,            "mc",            { x =   -20, y =   -75, z =   4370, a =  0x8000 }, 4.0,  1,  FLOOD_LAVA,  nil)
  flood_define_level(false, LEVEL_TOTWC,            "wc",            { x =     0, y =  7540, z =      0, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)   
  flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",      { x = -2185, y =    35, z =      0, a =  0x4000 }, 2.5,  1,  FLOOD_LAVA,  { x =  5515, y =   480, z =      0, a =  0x4000 }) 
end

local function flood_load_beat_block_beatdown_levels()
    game = GAME_BEAT_BLOCK_BEATDOWN
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Beat Block Beatdown"
	TEX_ROMHACK_LOGO = get_texture_info("beat_block_beatdown_logo")	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)			
	
    flood_define_level(false, LEVEL_SA,      "sa",         { x =     0, y =  3830, z = -4860, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,      "sa-2",       { x =   530, y =  5200, z =  7655, a = -0x4000 }, 1.0,  2,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,      "sa-3",       { x =   -20, y = 10270, z =  8495, a =  0x0000 }, 2.5,  3,  FLOOD_WATER, nil)  
    flood_define_level(false, LEVEL_SA,      "sa-4",       { x = -4990, y =   595, z = -4840, a =  0x6000 }, 1.0,  4,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_SA,      "sa-5",       { x = -2490, y =  3570, z = -6890, a =  0x4000 }, 1.0,  5,  FLOOD_WATER, nil) 
end

local function flood_load_super_luigi_64_the_flower_cup_levels()
    game = GAME_SUPER_LUIGI_64_THE_FLOWER_CUP
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Luigi 64: The Flower Cup"
	TEX_ROMHACK_LOGO = get_texture_info("the_flower_cup_logo")	
    hook_behavior(id_bhvWingCap, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,            "c1",          { x =  -4270, y =  9335, z =  -3200, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x = -11155, y =     5, z =  12755, a =  0x0000 })
    flood_define_level(false, LEVEL_WF,             "c2",          { x =  -9245, y =  7635, z =   1645, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =   1260, y =   370, z =   -190, a = -0x4000 })
    flood_define_level(false, LEVEL_WF,             "c2-2",        { x =    -15, y =  3155, z =    245, a =  0x8000 }, 3.5,  3,  FLOOD_WATER, nil)	   
	flood_define_level(false, LEVEL_WF,             "c2-3",        { x =   1945, y =  5400, z =   1360, a =  0x4000 }, 1.5,  4,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,            "c3",          { x =  10115, y =  9590, z =  -7145, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x =   6910, y =  1035, z =  10565, a =  0x8000 })
    flood_define_level(false, LEVEL_PSS,            "pss",         { x =  -6780, y = 11640, z =  -3720, a =  0x6000 }, 4.0,  1,  FLOOD_WATER, { x =   4080, y =  7120, z =   3870, a =  0x4000 })
    flood_define_level(false, LEVEL_PSS,            "pss-2",       { x =  -1125, y =  5830, z = -10270, a =  0x0000 }, 2.0,  3,  FLOOD_WATER, { x =  -8900, y =  3770, z =   7220, a =  0x6000 })	
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x =   3795, y =  2150, z =  -1165, a =  0x4000 }, 2.5,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x =   9350, y = 12810, z =  12055, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,          "b1-2",        { x =     40, y =  3145, z = -16650, a =  0x4000 }, 1.25, 2,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BOWSER_1,       "bowser-1",    { x =      5, y =  3295, z =     40, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CCM,            "c4",          { x =   1365, y =  2030, z = -13265, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,            "c5",          { x =  -4195, y =  9010, z =   3100, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x =  -4395, y =  8570, z =    720, a =  0x4000 }, 3.0,  1,  FLOOD_MUD,   nil)		
    flood_define_level(false, LEVEL_HMC,            "c6",          { x =   4185, y =  8490, z =  -8855, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x =  -1055, y =   375, z =  -8655, a =  0x4000 })
    flood_define_level(false, LEVEL_HMC,            "c6-2",        { x =  -2695, y =  3240, z =    170, a =  0x4000 }, 4.5,  2,  FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_SA,             "sa",          { x =   3815, y = 11340, z =    655, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -4020, y =  8370, z =   5730, a =  0x8000 })
    flood_define_level(false, LEVEL_SA,             "sa-2",        { x =   2655, y = 10210, z =    150, a = -0x4000 }, 5.0,  2,  FLOOD_WATER, { x =      0, y = -1920, z =     50, a = -0x4000 })	
    flood_define_level(false, LEVEL_LLL,            "c7",          { x =    315, y =  2955, z =   3225, a =  0x2000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,          "wc",          { x =   7220, y =  2865, z =  -5195, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =   -555, y =  5830, z =  -5585, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x =   1150, y =  2025, z =  -3415, a =  0x0000 })
    flood_define_level(false, LEVEL_BITFS,          "b2-2",        { x =    635, y =  4530, z =      0, a = -0x4000 }, 2.5,  3,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BOWSER_2,       "bowser-2",    { x =  21770, y =  -355, z =  -7095, a = -0x4000 }, 1.0,  2,  FLOOD_WATER, { x = -16985, y =   -50, z =  -7430, a =  0x4000 })	
    flood_define_level(false, LEVEL_BOWSER_2,       "bowser-2-2",  { x =  14880, y =    50, z =  11345, a = -0x4000 }, 0.75, 1,  FLOOD_SAND,  { x = -21345, y =   380, z =  11490, a =  0x4000 })	
    flood_define_level(false, LEVEL_SSL,            "c8",          { x =   5325, y = 17710, z =    840, a = -0x6000 }, 3.5,  1,  FLOOD_WATER, { x =      0, y =  1770, z =   1065, a =  0x0000 })
    flood_define_level(false, LEVEL_DDD,            "c9",          { x =   2145, y =  5365, z =  -7065, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,            "c9-2",        { x =      0, y =  4445, z =      0, a =  0x0000 }, 3.0,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_DDD,            "c9-3",        { x =   7785, y =  4585, z =   3150, a =  0x0000 }, 3.0,  3,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITS,           "b3",          { x =    735, y = 14145, z =   -735, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SL,             "c10",         { x =  -8855, y =  6705, z =   3035, a =  0x0000 }, 2.5,  1,  FLOOD_LAVA,  { x = -10970, y =  2400, z =  -1520, a =  0x2000 })
    flood_define_level(false, LEVEL_WDW,            "c11",         { x =   4955, y =  4935, z =   6085, a = -0x5000 }, 3.5,  1,  FLOOD_WATER, { x =   5330, y = -2940, z =   7405, a =  0x4000 })	
    flood_define_level(false, LEVEL_WDW,            "c11-2",       { x =  -6205, y =  6485, z =   -370, a = -0x6000 }, 5.5,  2,  FLOOD_LAVA,  { x =   7080, y = -1815, z =    210, a = -0x4000 })		
    flood_define_level(false, LEVEL_TTM,            "c12",         { x =     15, y =  9135, z =  13150, a =  0x3000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTM,            "c12-2",       { x =    965, y =  8695, z =   -165, a = -0x4000 }, 1.75, 2,  FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_TTM,            "c12-3",       { x =   2200, y =  2500, z =      0, a = -0x4000 }, 3.0,  3,  FLOOD_SAND,  { x =  -4710, y =  -110, z =   -360, a =  0x4000 })		
    flood_define_level(false, LEVEL_THI,            "c13",         { x =   3215, y =  3524, z =  11515, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil) 
    flood_define_level(false, LEVEL_THI,            "c13-2",       { x =  -3070, y =  1830, z =  -1580, a =  0x4000 }, 1.25, 2,  FLOOD_LAVA,  nil) 	
    flood_define_level(false, LEVEL_TTC,            "c14",         { x =   5290, y =  5290, z =   3565, a =  0x2000 }, 3.0,  1,  FLOOD_WATER, { x =   4015, y =  1285, z =   -110, a = -0x6000 })
    flood_define_level(false, LEVEL_RR,             "c15",         { x =  -5710, y =  4025, z =  -1585, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  -1140, y =   425, z =    325, a = -0x4000 })
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",       { x =    -90, y =  3560, z =    -20, a =  0x8000 }, 3.0,  1,  FLOOD_SAND,  { x =    -90, y =   665, z =    -20, a =  0x0000 })	
    flood_define_level(false, LEVEL_ENDING,           "ending",    { x =   2525, y =  8430, z =  -9625, a =  0x0000 }, 4.0,  3,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",        { x =   2325, y =  3580, z =  -7145, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",        { x =  -7705, y =  1995, z =  -8460, a =  0x2000 }, 3.0,  1,  FLOOD_WATER, nil)		
end

local function flood_load_lugs_delightful_dioramas_levels()
    game = GAME_LUGS_DELIGHTFUL_DIORAMAS
	LEVEL_LOBBY = LEVEL_CASTLE
    romhackText = "Lug's Delightful Dioramas"
	TEX_ROMHACK_LOGO = get_texture_info("lugs_delightful_dioramas_logo")	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)			

    flood_define_level(false, LEVEL_BOB,              "c1",            { x = -870,  y = 3845, z = 1050,  a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x = -80,  y = 5480,  z =  2380,  a =  -0x4000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",            { x = -1800,  y = 3625,  z = 450, a =  -0x4000 }, 2.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x = 530,  y = 5100, z = 0,  a =  0x6000 }, 3.0,  1,   FLOOD_SAND, { x = -1980, y = -2000,  z = 160, a = -0x4000 })
    flood_define_level(false, LEVEL_TOTWC,            "wc",          { x =  -885,  y = 5375,  z = 1010,  a =  0x0000 }, 1.5,  1,   FLOOD_WATER, { x = 0, y = 2415,  z = 35, a = -0x4000 })
    flood_define_level(false, LEVEL_COTMC,            "mc",          { x = -450,  y = 4405,  z = -670,  a =  0x4000 }, 2.5,  1,   FLOOD_WATER, { x = -2565, y = -490,  z = -1060, a = -0x4000 })
    flood_define_level(false, LEVEL_VCUTM,            "vc",          { x = -40,  y = 2550,  z = -5,  a =  0x4000 }, 2.5,  1,   FLOOD_WATER, { x = -4150, y = -815,  z = -790, a = -0x4000 })
    flood_define_level(false, LEVEL_BBH,              "c5",            { x =  1045,  y = 2705,  z = -165,   a =  0x8000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,              "c6",            { x =  3525,  y = 1670,  z = 3625,  a =  0x0000 }, 2.5,  1,   FLOOD_LAVA, { x = -155, y = 300,  z = -2500, a = 0x0000 })
    flood_define_level(false, LEVEL_BITFS,            "b2",          { x =  -3380,  y = 5530, z = -3345, a =  0x4000 }, 4.5,  1,   FLOOD_WATER,  nil)	
    flood_define_level(false, LEVEL_LLL,              "c7",            { x = -4940,   y = 17025,  z = 400,  a =  0x0000 }, 3.5,  1,   FLOOD_WATER, { x = -1595, y = 6505,  z = -1285, a = 0x0000 })
    flood_define_level(false, LEVEL_SA,               "sa",             { x = -845,  y = 4720, z = 180,    a =  0x0000 }, 2.0,  1,   FLOOD_SAND, { x = 155, y = 2550,  z = 1128, a = 0x0000 })
    flood_define_level(false, LEVEL_CASTLE,           "c",         { x = -1290,  y = 1270, z = 870,    a =  0x0000 }, 9.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc", { x = 1500,  y = 2640, z = 2295,  a =  -0x4000 }, 4.5,  1,   FLOOD_WATER, nil)	
end

local function flood_load_project_reimagined_demo_levels()
    game = GAME_PROJECT_REIMAGINED
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Project Reimagined"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")	
	gLevelValues.metalCapDurationCotmc = 1	
	gLevelValues.vanishCapDurationVcutm = 1		
	gLevelValues.wingCapDurationTotwc = 0

    flood_define_level(false, LEVEL_BOB,            "c1",          { x =  10540, y =  3980, z = -10820, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, { x =   2430, y =   700, z =  -1970, a =  0x4000 })
	flood_define_level(false, LEVEL_BOB,            "c1-2",        { x =   8415, y =  7015, z = -12130, a =  0x0000 }, 3.0,  2,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",          { x =  -9195, y =  5305, z =  -4040, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x = -10995, y =  2470, z =   -920, a =  0x0000 })
    flood_define_level(false, LEVEL_WF,             "c2-2",        { x =    850, y =  4515, z =   -850, a =  0x4000 }, 3.0,  2,  FLOOD_WATER, { x =   1160, y =    80, z =  -2770, a =  0x4000 })
    flood_define_level(false, LEVEL_PSS,            "pss",         { x =    400, y =  1495, z =    400, a = -0x6000 }, 3.5,  1,  FLOOD_WATER, { x =   2670, y =   560, z =   2650, a = -0x6000 })	
    flood_define_level(false, LEVEL_SA,             "sa",          { x =   5930, y = 11210, z =  -8170, a = -0x4000 }, 2.5,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_JRB,            "c3",          { x =   3400, y =  1790, z =  -3140, a = -0x2000 }, 5.0,  1,  FLOOD_WATER, { x =   5700, y = -8230, z =  -2320, a =  0x0000 })
    flood_define_level(false, LEVEL_JRB,            "c3-2",        { x =   7555, y =  -990, z =   1585, a =  0x8000 }, 2.25, 2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CCM,            "c4",          { x =   1530, y =  5460, z =   -835, a = -0x4000 }, 4.0,  1,  FLOOD_WATER, { x =  -1200, y = -1020, z =  -6370, a =  0x0000 })
    flood_define_level(false, LEVEL_CCM,            "c4-2",        { x =  -5870, y =  4620, z =  -2335, a =  0x0000 }, 5.0,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_PSS,            "pss-2",       { x =  -4445, y = -2000, z =   9330, a =  0x8000 }, 1.75, 2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TOTWC,          "wc",          { x =  -2110, y =  7860, z =  -8585, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,            "c5",          { x =  -2280, y =  1640, z =    590, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, { x =     20, y = -2855, z =   8460, a =  0x8000 })
    flood_define_level(false, LEVEL_BBH,            "c5-2",        { x =      0, y = 12130, z =      0, a =  0x0000 }, 3.0,  2,  FLOOD_WATER, { x =  18670, y =  3900, z = -11265, a =  0x0000 })	
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x =   6550, y = 10860, z =      0, a = -0x4000 }, 3.5,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_HMC,            "c6",          { x =  -4355, y =  2355, z =  -2380, a =  0x2000 }, 2.5,  1,  FLOOD_WATER, { x =  -3440, y =   373, z =   1230, a =  0x4000 })
    flood_define_level(false, LEVEL_HMC,            "c6-2",        { x =   1230, y =   355, z =  -3895, a =  0x0000 }, 2.75, 3,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x = -15740, y =   840, z =  15195, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_COTMC,          "mc-2",        { x =    765, y =    70, z =   4660, a =  0x8000 }, 0.75, 4,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x =    775, y =  4205, z =  -2410, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x =    315, y =   580, z =  -2470, a =  0x4000 })	
    flood_define_level(false, LEVEL_LLL,            "c7",          { x =  -5450, y =  6240, z =  -9810, a =  0x4000 }, 2.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_SSL,            "c8",          { x =   4870, y = -3455, z =   -560, a = -0x4000 }, 2.0,  1,  FLOOD_SAND,  { x =   6210, y = -7730, z =   4730, a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,            "c8-2",        { x =  15670, y =  2935, z =   -680, a = -0x4000 }, 2.0,  2,  FLOOD_SAND,  { x =   1230, y =   350, z =  -8340, a =  0x0000 })
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",       { x =      0, y =  1630, z =  -7175, a =  0x0000 }, 2.75, 2,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =     30, y = 17455, z =     20, a =  0x0000 }, 3.5,  1,  FLOOD_LAVA,  { x =   1390, y =   170, z =  -6055, a =  0x0000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",          { x =   2354, y =  2160, z =   4690, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, { x =  -4415, y =   100, z =   5400, a = -0x4000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg-2",        { x =  -6800, y =  2375, z =   2990, a =  0x8000 }, 2.5,  2,  FLOOD_WATER, { x =  -3655, y = -1405, z =   4645, a =  0x8000 })	
end

local function flood_load_kaizo_mario_64_levels()
    game = GAME_KAIZO_MARIO_64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Kaizo Mario 64"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")
	gLevelValues.metalCapDurationCotmc  = 1
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvWingCap, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		
    hook_behavior(id_bhvMetalCap, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,            "c1",            { x =  3304, y =  4293, z = -4603, a =  0x0000 }, 3.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",             { x = -5485,  y = 8130, z = -1260,   a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,            "c3",            { x =  4867, y =  1913, z =  853,  a =  0x4000 }, 3.5,  1,   FLOOD_WATER, { x =  5138, y = -4912, z =  201,  a = 0x0000 })
    flood_define_level(false, LEVEL_JRB,            "c3-ship",       { x =  20, y =  1260, z =  2910,  a =  0x4000 }, 6.5,  2,   FLOOD_WATER, { x = 675, y = -220, z = -2685,  a =  0x0000 })
    flood_define_level(false, LEVEL_CCM,            "c4",            { x = -50,  y = 5580, z = -150,  a =  0x0000 }, 5.0,  1,   FLOOD_WATER, { x =  3336, y = -3800, z =  0,    a = 0x0000 })
    flood_define_level(false, LEVEL_CCM,            "c4-c10ide",      { x = -5620, y =  6656, z = -6145, a =  0x0000 }, 5.5,  2,  FLOOD_WATER, { x = -6498, y = -5836, z = -6937, a = 0x0000 })	
    flood_define_level(false, LEVEL_BBH,            "c5",            { x =   655, y =  3280, z =   245,  a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = 2860, y = -2845, z = 2050, a = 0x8000 })	
    flood_define_level(false, LEVEL_TOTWC,          "wc",          { x =  0, y = 3105, z = 0, a =  0x8000 }, 30.0,  1,   FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_PSS,            "pss",            { x =  3127, y =  7035, z = -5650, a =  0x0000 }, 5.0,  1,   FLOOD_WATER, { x = -6387, y = -4000, z =  5723, a = 0x8000 })
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x =  1440, y =  4600, z = -2380,    a = -0x4000 }, 3.5,  1,   FLOOD_WATER,  nil) 
    flood_define_level(false, LEVEL_HMC,            "c6",            { x = -7357, y =  2161, z =  7362, a =  0x6000 }, 4.5,  1,   FLOOD_WATER, { x = -3538, y = -3979, z =  3568, a = 0x8000 })
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x =  4,    y =  360,  z = -6138, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x =  4315, y = -4190, z = 3995, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x = -6410, y = -3200, z = 1240, a = 0x4000 })	
    flood_define_level(false, LEVEL_LLL,            "c7",            { x =  0, y =  770, z = -6700,  a = -0x8000 }, 1.0,  1,   FLOOD_LAVA, nil)	
    flood_define_level(false, LEVEL_LLL,            "c7-volcano",    { x =  1790, y =  3230, z = 1460,  a = -0x8000 }, 3.5,  2,   FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_SSL,            "c8",            { x = -2040,  y =  1590, z = -1025,  a =  0x0000 }, 3.0,  1,   FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,            "c8-pyramid",    { x =  512,  y =  4815, z = -551,  a =  0x0000 }, 3.0,  2,   FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_DDD,            "c9",            { x =  4046, y = -511,  z = -8,    a = -0x4000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =  1224, y =  5478, z =  84,   a =  0x0000 }, 3.0,  1,   FLOOD_LAVA, nil)	
    flood_define_level(false, LEVEL_SL,             "c10",             { x =  40,   y =  4864, z =  240,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,             "c10-igloo",      { x = -5,   y =  0, z = 2575,  a =  0x0000 }, 3.0,  2,   FLOOD_WATER, { x = -390, y = 145, z = -1740, a = 0x4000 })		
    flood_define_level(false, LEVEL_WDW,            "c11",            { x =  1467, y =  4096, z =  93,   a = -0x4000 }, 3.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,            "c12",            { x =  0, y =  3555, z = 0,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13",            { x = -12,    y = 3891,  z = -1556, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13-tiny",       { x = 100,    y = 1170,  z = -400, a =  0x0000 }, 5.0,  2,   FLOOD_WATER, { x = -45, y = 2210, z = -7155, a = 0x0000 })	
    flood_define_level(false, LEVEL_THI,            "c13-cave",       { x = -1955,    y = 1535,  z = -1090, a =  0x0000 }, 6.0,  3,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,            "c14",            { x =  2208, y =  7051, z =  2217, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,             "c15",             { x =  3555,    y =  4770, z = -2330, a =  0x0000 }, 5.0,  1,   FLOOD_WATER, { x = 2560, y = 9630, z = 2070, a = 0x4000 })
    flood_define_level(false, LEVEL_BITS,           "b3",           { x =  369,  y =  6552, z = -6000, a =  0x0000 }, 4.0,  1,   FLOOD_LAVA,  { x = -7039, y = 7000, z = 4, a = 0x4000 })	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg", { x =  0,    y =  7583, z = -4015, a =  0x0000 }, 12.5,  1,   FLOOD_WATER, nil)	
end

local function flood_load_star_revenge_6_9_levels()
    game = GAME_STAR_REVENGE_6_9
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Star Revenge 6.9: Luigi Lost In Time"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_6.9_logo")	

    flood_define_level(false, LEVEL_BOB,               "c1",   { x =  -285, y = 5720, z = -11265, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WF,                "c2",   { x =   290, y = 3490, z =  -1565, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,               "c3",   { x = -3965, y = 1000, z =   4420, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_PSS,               "pss",  { x = 14925, y =  630, z =  -2990, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x = -11170, y = -1260, z =  4000, a =  0x4000 })
    flood_define_level(false, LEVEL_SA,                "sa",   { x =  4540, y =  270, z =  -5825, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,    "cg",   { x =  2290, y =  450, z =  -3760, a =  0x0000 }, 5.5,  1,  FLOOD_WATER, { x =  -1820, y = -2510, z =  4080, a = -0x4000 })	
    flood_define_level(false, LEVEL_CASTLE,            "c",    { x = -1000, y = 1285, z =  -5300, a =  0x0000 }, 4.5,  1,  FLOOD_WATER, nil)	
end

local function flood_load_super_mario_64_shining_stars_levels()
    game = GAME_SUPER_MARIO_64_SHINING_STARS
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Super Mario 64 Shining Stars"
	TEX_ROMHACK_LOGO = get_texture_info("shining_stars_logo")
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

  flood_define_level(false, LEVEL_BOB,              "c1",          { x =  -445, y =  8020, z =  -2180, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x = -4885, y =   100, z =  -1420, a = 0x6000})	
  flood_define_level(false, LEVEL_WF,               "c2",          { x = -2955, y =  2480, z =   7615, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x =  -830, y = -3000, z =  -5310, a = 0x4000})	
  flood_define_level(false, LEVEL_JRB,              "c3",          { x =  4430, y =  3045, z =  -2105, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_VCUTM,            "vc",          { x =  2010, y =  4290, z =   -315, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = -4155, y = -2800, z =   3540, a = 0x4000})  
  flood_define_level(false, LEVEL_CCM,              "c4",          { x =  7670, y =  4440, z = -10330, a =  0x0000 }, 1.75, 1,   FLOOD_LAVA,  { x = -6385, y = -3180, z =  -1970, a = 0x4000})
  flood_define_level(false, LEVEL_COTMC,            "mc",          { x =   170, y =  6465, z =  -1680, a =  0x0000 }, 4.5,  1,   FLOOD_LAVA,  { x = -4280, y =  1940, z =   1910, a = 0x4000})
  flood_define_level(false, LEVEL_BITDW,            "b1",          { x =  -490, y =  4320, z =   1660, a =  0x4000 }, 2.0,  1,   FLOOD_LAVA,  nil)  
  flood_define_level(false, LEVEL_HMC,              "c6",          { x =  1615, y =  4855, z =   -670, a =  0x4000 }, 2.5,  1,   FLOOD_SAND,  nil)  
  flood_define_level(false, LEVEL_LLL,              "c7",          { x =  2055, y =  6910, z = -13365, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x =  5460, y =  5220, z = -12480, a = 0x4000})
  flood_define_level(false, LEVEL_SSL,              "c8",          { x =   975, y = -1550, z =  13770, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_DDD,              "c9",          { x = -6980, y =  1760, z =  11920, a =  0x8000 }, 2.5,  1,   FLOOD_LAVA,  { x =  4360, y = -2830, z =   2520, a = 0x0000})
  flood_define_level(false, LEVEL_TOTWC,            "wc",          { x =  4110, y =  6810, z =  -2825, a = -0x4000 }, 4.5,  1,   FLOOD_WATER, nil)    
  flood_define_level(false, LEVEL_SL,               "c10",         { x =  5935, y =  1870, z =   2060, a =  0x8000 }, 4.5,  1,   FLOOD_WATER, { x =   -30, y = -1190, z =    630, a = 0x8000})
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",       { x =  3065, y =  2640, z =   8380, a =  0x8000 }, 2.25, 1,   FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_PSS,              "pss",         { x =  -110, y =  2680, z =    530, a =  0x4000 }, 3.5,  1,   FLOOD_LAVA,  { x = -6665, y = -5960, z =   -670, a = 0x8000}) 
  flood_define_level(false, LEVEL_BITFS,            "b2",          { x =   100, y =  2060, z =  -5960, a = -0x6000 }, 2.0,  1,   FLOOD_LAVA,  { x =  3535, y = -1900, z =   4910, a = 0x4000})  
  flood_define_level(false, LEVEL_WDW,              "c11",         { x =  7100, y =  3450, z =   -740, a =  0x4000 }, 1.5,  1,   FLOOD_WATER, { x = -3120, y =   -10, z =   1560, a = 0x4000})  
  flood_define_level(false, LEVEL_TTM,              "c12",         { x =  7150, y =  9750, z =  -2490, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_THI,              "c13",         { x =  2060, y =  3150, z =  -1460, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x =  -845, y = -4440, z =  -1555, a = 0x4000})
  flood_define_level(false, LEVEL_TTC,              "c14",         { x =  9925, y =  2510, z =   4270, a = -0x4000 }, 4.5,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_RR,               "c15",         { x =   495, y =  8430, z =   1200, a = -0x4000 }, 2.5,  1,   FLOOD_LAVA,  { x = -3980, y = -4455, z =   -310, a = 0x4000})
  flood_define_level(false, LEVEL_SA,               "sa",          { x =  5335, y =  2870, z =    -45, a = -0x4000 }, 2.0,  1,   FLOOD_WATER, { x = -6455, y = -3480, z =   -630, a = 0x4000})  
  flood_define_level(false, LEVEL_BITS,             "b3",          { x =  6440, y =  3495, z =   8425, a =  0x4000 }, 1.0,  1,   FLOOD_LAVA,  { x = -3145, y =   -55, z =   2375, a = 0x4000}) 
  flood_define_level(false, LEVEL_CASTLE,           "c",           { x =  5380, y =  -380, z =   5065, a =  0x8000 }, 5.0,  1,   FLOOD_WATER, { x = -3540, y = -5400, z =   2850, a = 0x4000})
end
  
-- B3313 ported to Flood by SuperMarty
local function flood_load_b3313_levels()
    game = GAME_BUILD_3313
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "B3313"
	TEX_ROMHACK_LOGO = get_texture_info("b3313_logo")
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		
    hook_behavior(id_bhvMetalCap, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvWingCap, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		
	
	-- GRASS
    flood_define_level(false, LEVEL_BITS,             "1",         { x =   4157, y =   4293, z =  -6967, a =  0x0000 }, 3.0,  4, FLOOD_WATER, nil)		
	flood_define_level(false, LEVEL_BITS,             "2",         { x =   1644, y =   2903, z =   -537, a =  0x0000 }, 4.0,  3, FLOOD_WATER, { x =  -7920, y =   -1260, z =  11135, a =  0x6000 })
    flood_define_level(false, LEVEL_PSS,              "3",         { x =  11350, y =   7213, z = -11435, a =  0x0000 }, 3.5,  5, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "4",         { x =  10520, y =   3980, z = -10790, a =  0x0000 }, 3.0,  1, FLOOD_WATER, { x =   2380, y =      77, z =  -2011, a =  0x4000 })	
    flood_define_level(false, LEVEL_JRB,              "5",         { x =   6737, y =   7024, z = -13412, a =  0x4000 }, 3.0,  2, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "6",         { x =   8801, y =   7682, z =  21907, a =  0x8000 }, 3.0,  3, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,            "7",         { x =   6655, y =   3015, z =  -5715, a =  0x0000 }, 3.5,  5, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "8",         { x =  10780, y =   1120, z =   -475, a = -0x4000 }, 5.0,  2, FLOOD_WATER, { x =  -6540, y =   -2130, z =   6955, a =  0x0000 })	
    flood_define_level(false, LEVEL_BOB,              "9",         { x =  -3961, y =   3150, z = -17236, a =  0x0000 }, 2.0,  7, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_THI,              "10",        { x =  -1930, y =   7497, z =  -8806, a =  0x0000 }, 4.0,  4, FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_SA,               "11",        { x =   3740, y =   8130, z =  -4415, a =  0x0000 }, 3.5,  3, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_THI,              "12",        { x =   -731, y =   5805, z =   1676, a =  0x8000 }, 4.0,  2, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,               "13",        { x =  14028, y =     89, z =   -321, a = -0x4000 }, 4.0,  2, FLOOD_WATER, { x =  -8196, y =   -4503, z =   7105, a =  0x8000 })
    flood_define_level(false, LEVEL_HMC,              "14",        { x =  13220, y =    710, z =   -580, a = -0x4000 }, 3.0,  5, FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_PSS,              "15",        { x =    156, y =   4164, z = -13591, a =  0x0000 }, 4.5,  3, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_HMC,              "16",        { x =  -2088, y =   4628, z =  11013, a =  0x4000 }, 2.5,  3, FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_WF,               "17",        { x =  -6343, y =  11101, z = -11152, a =  0x6000 }, 4.0,  6, FLOOD_WATER, { x =  -5931, y =     315, z =  -6061, a = -0x4000 })
    flood_define_level(false, LEVEL_WF,               "18",        { x =  -6343, y =  11101, z = -11152, a =  0x0000 }, 4.0,  7, FLOOD_LAVA,  { x =  -5931, y =     315, z =  -6061, a = -0x4000 })	
    flood_define_level(false, LEVEL_COTMC,            "19",        { x =  -2185, y =   7781, z = -10079, a =  0x0000 }, 5.0,  6, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,            "20",        { x =   3279, y =   3450, z =  -2858, a =  0x0000 }, 6.0,  1, FLOOD_WATER, nil)	

    -- FORTRESS
    flood_define_level(false, LEVEL_COTMC,            "21",        { x =    -20, y =   2875, z =     60, a =  0x0000 }, 4.0,  4, FLOOD_WATER, { x =  -3150, y =   -2100, z =  -4840, a = -0x4000 })	
    flood_define_level(false, LEVEL_COTMC,            "22",        { x =    325, y =   5365, z =    -25, a =  0x0000 }, 4.0,  1, FLOOD_WATER, { x =   2675, y =     885, z =   5120, a =  0x4000 })	
    flood_define_level(false, LEVEL_COTMC,            "23",        { x =   6620, y =   9710, z =  -7280, a =  0x8000 }, 5.0,  5, FLOOD_WATER, { x =    590, y =    1900, z =  -4620, a =  0x0000 })	
    flood_define_level(false, LEVEL_BBH,              "24",        { x =  -2170, y =   4521, z =  -1105, a =  0x0000 }, 4.0,  3, FLOOD_WATER, { x =     46, y =   -1024, z =   3621, a =  0x8000 })
    flood_define_level(false, LEVEL_BBH,              "25",        { x =  -5047, y =   5368, z =    759, a =  0x8000 }, 4.0,  1, FLOOD_WATER, { x = -10916, y =    2344, z =  -1041, a =  0x0000 })	
    flood_define_level(false, LEVEL_BBH,              "26",        { x =    800, y =   4515, z =   -800, a =  0x4000 }, 2.0,  2, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,              "27",        { x =  10723, y =   6294, z = -19440, a = -0x4000 }, 2.5,  5, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_COTMC,            "28",        { x =   6734, y =   8740, z =  -7758, a = -0x4000 }, 2.0,  2, FLOOD_WATER, { x =  -2563, y =    5008, z =   5205, a =  0x8000 })	
    flood_define_level(false, LEVEL_VCUTM,            "29",        { x =   1040, y =   1300, z =   1020, a = -0x6000 }, 4.0,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,              "30",        { x =   4577, y =   2780, z =    886, a =  0x0000 }, 4.0,  5, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BOB,              "31",        { x =  -1280, y =   4955, z =  -2808, a =  0x6000 }, 3.0,  3, FLOOD_WATER, { x =  10485, y =    1310, z =  -3055, a = -0x4000 })	
    flood_define_level(false, LEVEL_CCM,              "32",        { x = -10882, y =  11483, z = -12477, a = -0x2000 }, 3.75, 3, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WMOTR,            "33",        { x =   3970, y =   5390, z =  -6720, a =  0x0000 }, 4.5,  3, FLOOD_WATER, { x =  -3205, y =   -2690, z =  10070, a =  0x4000 })
    flood_define_level(false, LEVEL_WMOTR,            "34",        { x =   3790, y =   4076, z =  -6737, a =  0x0000 }, 3.0,  2, FLOOD_WATER, { x =   1139, y =   -2636, z =   2157, a =  0x8000 })
    flood_define_level(false, LEVEL_PSS,              "35",        { x =  -2129, y =   7917, z = -14651, a =  0x0000 }, 3.5,  2, FLOOD_WATER, nil)	
	
	-- WATER
	-- [JRB] --
    flood_define_level(false, LEVEL_RR,               "36",        { x =   3400, y =   1790, z =  -3140, a =  0x0000 }, 5.0,  1, FLOOD_WATER, { x =   5700, y =   -8230, z =  -2320, a =  0x0000 })
    flood_define_level(false, LEVEL_BITDW,            "37",        { x =    200, y =   2710, z =  -6450, a =  0x0000 }, 5.0,  3, FLOOD_WATER, { x =  -2170, y =   -4080, z = -13090, a =  0x0000 })
    flood_define_level(false, LEVEL_WMOTR,            "38",        { x =    560, y =    670, z =   4650, a =  0x8000 }, 6.0,  4, FLOOD_WATER, { x =  -2515, y =   -3650, z =  -3475, a =  0x0000 })
    flood_define_level(false, LEVEL_CCM,              "39",        { x = -15950, y =   1190, z =  -6605, a = -0x7000 }, 1.0,  1, FLOOD_WATER, { x =  -2215, y =    1100, z = -12930, a = -0x4000 })	
	-- [DDD] --
    flood_define_level(false, LEVEL_WMOTR,            "40",        { x =   3520, y =  -1295, z =  11485, a =  0x8000 }, 4.75, 1, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_LLL,              "41",        { x =    700, y =   1310, z =   3215, a = -0x4000 }, 4.0,  2, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "42",        { x =  -1549, y =   4263, z =   9063, a =  0x5000 }, 4.0,  3, FLOOD_WATER, nil)
	-- [SA] --
    flood_define_level(false, LEVEL_BITFS,            "43",        { x =   -520, y =   2975, z = -10905, a =  0x0000 }, 1.0,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,            "44",        { x =   7640, y =  -1000, z =   1570, a =  0x8000 }, 3.5,  4, FLOOD_WATER, { x =   -155, y =    -800, z =  -4430, a = -0x4000 })
	
	-- ICE
	-- [CCM] --
    flood_define_level(false, LEVEL_WDW,              "45",        { x =  -3180, y =   7120, z =  -1160, a = -0x4000 }, 2.5,  3, FLOOD_WATER, { x =  -1094, y =   -1123, z =  -6629, a = -0x2000 })
    flood_define_level(false, LEVEL_WDW,              "46",        { x =  -5858, y =   4623, z =  -2360, a =  0x0000 }, 4.0,  6, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WDW,              "47",        { x =   3110, y =  12080, z =    -45, a = -0x4000 }, 3.0,  1, FLOOD_WATER, { x =   3441, y =    2705, z = -10607, a =  0x0000 })
    flood_define_level(false, LEVEL_WDW,              "48",        { x =  -8076, y =  11202, z =   7125, a =  0x8000 }, 4.0,  7, FLOOD_WATER, { x =   1336, y =   -1358, z =   4221, a =  0x8000 })	
    flood_define_level(false, LEVEL_WDW,              "49",        { x =  -6400, y =  11100, z = -11040, a =  0x8000 }, 4.5,  4, FLOOD_WATER, { x = -12805, y =     700, z = -14450, a = -0x4000 })	
	-- [SL]
    flood_define_level(false, LEVEL_DDD,              "50",        { x =   3262, y =   4863, z =   4790, a =  0x0000 }, 2.5,  6, FLOOD_WATER, { x =   1435, y =    1470, z =  24850, a =  0x8000 })	
    flood_define_level(false, LEVEL_WDW,              "51",        { x =  -3279, y =   3185, z =    151, a =  0x0000 }, 4.5,  2, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,              "52",        { x =    570, y =   6480, z =   7490, a =  0x8000 }, 5.5,  5, FLOOD_WATER, { x =      0, y =    5835, z =  -2265, a =  0x0000 })	
    flood_define_level(false, LEVEL_PSS,              "53",        { x =  13085, y =   3430, z =  17080, a =  0x8000 }, 1.4,  6, FLOOD_WATER, { x = -11010, y =    1365, z =  -6445, a =  0x4000 })	
	
	-- HAUNTED
    flood_define_level(false, LEVEL_TTC,              "54",        { x =  -6670, y =   6635, z = -13125, a =  0x0000 }, 4.0,  1, FLOOD_WATER, { x =  -6941, y =   -4484, z =   5295, a =  0x8000 })
    flood_define_level(false, LEVEL_TTC,              "55",        { x =   3655, y =   1315, z =   -780, a =  0x8000 }, 1.0,  5, FLOOD_WATER, { x =  12465, y =     230, z =  -2265, a =  0x8000 })	
	
    -- CAVE	
    flood_define_level(false, LEVEL_HMC,              "56",        { x =  -2379, y =   2810, z =  -6216, a =  0x0000 }, 1.0,  1, FLOOD_WATER, { x =  -4316, y =    2161, z =   8956, a =  0x8000 })	
    flood_define_level(false, LEVEL_HMC,              "57",        { x =   8916, y =   2268, z = -13699, a =  0x0000 }, 1.0,  6, FLOOD_WATER, nil)	

    -- LAVA
    flood_define_level(false, LEVEL_LLL,              "58",        { x =  -5631, y =   6239, z =  -9797, a =  0x4000 }, 2.5,  1, FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,              "59",        { x =   2452, y =   1435, z =  -1870, a =  0x0000 }, 7.0,  5, FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,              "60",        { x =   6963, y =   6195, z =   4680, a =  0x0000 }, 1.5,  3, FLOOD_LAVA,  { x = -11211, y =     436, z =  12663, a =  0x8000 })	
    flood_define_level(false, LEVEL_HMC,              "61",        { x =  31162, y =   2125, z =  -2942, a = -0x4000 }, 2.0,  4, FLOOD_LAVA,  nil)	
	
    -- SAND
    flood_define_level(false, LEVEL_SSL,              "62",        { x =   1725, y =   2829, z = -16152, a =  0x0000 }, 3.5,  1, FLOOD_SAND,  { x =  -5033, y =    -485, z =  -8143, a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,              "63",        { x =  -6096, y =   5021, z = -20608, a =  0x0000 }, 3.0,  2, FLOOD_SAND,  nil) 
    flood_define_level(false, LEVEL_SSL,              "64",        { x =   1280, y =   2435, z = -10145, a =  0x0000 }, 2.0,  4, FLOOD_SAND,  { x =   7520, y =     865, z =   -740, a = -0x4000 })
    flood_define_level(false, LEVEL_SSL,              "65",        { x =  16640, y =   3720, z =   7275, a = -0x4000 }, 4.0,  5, FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,              "66",        { x = -21500, y =    210, z =  -2795, a =  0x4000 }, 2.75, 5, FLOOD_SAND,  { x =  -2880, y =   -1500, z =     80, a = -0x6000 })	
	
    -- WDW
    flood_define_level(false, LEVEL_ENDING,           "67",        { x =  -1080, y =   4095, z =   -355, a =  0x4000 }, 2.75, 6, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "68",        { x =   2945, y =   6199, z =   2282, a = -0x6000 }, 4.0,  6, FLOOD_WATER, { x =   5355, y =    3215, z =   4875, a = -0x6000 })
    flood_define_level(false, LEVEL_PSS,              "69",        { x =   -290, y =  -2270, z =  -1580, a =  0x0000 }, 3.0,  1, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SA,               "70",        { x =   1560, y =   2000, z =  -3300, a =  0x0000 }, 1.5,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_ENDING,           "71",        { x =    -10, y =   3040, z = -11230, a =  0x0000 }, 2.0,  1, FLOOD_WATER, { x =   3670, y =    315, z =   11110, a =  0x8000 })	
	
    -- TTC
    flood_define_level(false, LEVEL_HMC,              "72",        { x =    972, y =   5694, z =  -1734, a =  0x0000 }, 5.0,  7, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_COTMC,            "73",        { x =  -1841, y =   6530, z =  -1815, a =  0x2000 }, 3.0,  3, FLOOD_WATER, { x =   -811, y =   -4452, z =    -49, a = -0x2000 })	

    -- SKY
    flood_define_level(false, LEVEL_SL,               "74",        { x =   1280, y =  10290, z =   4855, a =  0x8000 }, 4.0,  3, FLOOD_WATER, { x =    750, y =    2570, z = -12240, a =  0x0000 })
    flood_define_level(false, LEVEL_SL,               "75",        { x =  -1580, y =   2430, z =  -9590, a =  0x0000 }, 2.5,  5, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "76",        { x =    -80, y =   6500, z =  -5700, a =  0x0000 }, 2.5,  4, FLOOD_WATER, { x =      0, y =   -1900, z = -12700, a =  0x0000 })	

    -- FINAL
    flood_define_level(false, LEVEL_HMC,              "77",        { x =  28853, y =   2632, z =   -495, a = -0x4000 }, 2.5,  2, FLOOD_WATER, { x = -21870, y =   -1306, z =    114, a =  0x4000 })	
    flood_define_level(false, LEVEL_LLL,              "78",        { x =   1701, y =  17455, z =   1283, a = -0x6000 }, 4.5,  4, FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_VCUTM,            "79",        { x = -12045, y =   2300, z =  -1950, a =  0x8000 }, 2.0,  3, FLOOD_WATER, { x =   4200, y =     400, z =  20400, a = -0x4000 })
    flood_define_level(false, LEVEL_BOWSER_3,         "80",        { x =     90, y =  -3735, z =  29800, a =  0x8000 }, 1.0,  1, FLOOD_LAVA,  { x =    -60, y =   -4290, z =  -7730, a =  0x0000 })
	
	-- CASTLE
	-- [OUTSIDE] --
    flood_define_level(false, LEVEL_THI,              "81",        { x =   -399, y =   -224, z =    344, a =  0x0000 }, 2.5,  1, FLOOD_WATER, { x =   -377, y =    -964, z = -12966, a =  0x0000 })	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "82",        { x =  -4110, y =   1285, z = -19845, a =  0x0000 }, 5.5,  7, FLOOD_WATER, { x =  -4180, y =    -825, z =  -1495, a =  0x8000 })	
	flood_define_level(false, LEVEL_RR,               "83",        { x =   4108, y =    351, z =   -755, a = -0x4000 }, 3.0,  5, FLOOD_WATER, { x =    774, y =       0, z =   -666, a =  0x4000 })	
    flood_define_level(false, LEVEL_WMOTR,            "84",        { x =  15395, y =  -1315, z = -22560, a =  0x0000 }, 2.25, 5, FLOOD_WATER, { x =  15400, y =   -1075, z =  -2635, a =  0x8000 })	
	-- [INSIDE] --
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "85",        { x =     71, y =   -287, z = -19725, a =  0x0000 }, 0.5,  5, FLOOD_WATER, { x = -10502, y =    -990, z =  17836, a =  0x8000 })
    flood_define_level(false, LEVEL_BITFS,            "86",        { x =     60, y =   -165, z =  -1710, a =  0x0000 }, 2.0,  5, FLOOD_WATER, { x =  -6655, y =     80, z =   -7955, a =  0x0000 })	
    flood_define_level(false, LEVEL_TTC,              "87",        { x =   6847, y =    629, z = -12573, a =  0x8000 }, 1.25, 7, FLOOD_WATER, { x =   -332, y =   -1571, z =  16141, a =  0x8000 })
    flood_define_level(false, LEVEL_VCUTM,            "88",        { x = -12110, y =   1690, z =   3195, a =  0x8000 }, 2.0,  2, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,            "89",        { x =   -350, y =    215, z = -24185, a =  0x0000 }, 2.5,  2, FLOOD_WATER, { x =  16675, y =   -555, z =  -12040, a = -0x4000 })
    flood_define_level(false, LEVEL_ENDING,           "90",        { x =   -840, y =  -1070, z =  13785, a =  0x8000 }, 2.5,  2, FLOOD_WATER, { x =   -735, y =  -1890, z =  -11195, a =  0x0000 })	
    flood_define_level(false, LEVEL_SL,               "91",        { x = -30595, y =   1075, z =  -7330, a =  0x0000 }, 2.5,  6, FLOOD_WATER, { x = -18630, y =   -3470, z =  -5875, a = -0x4000 })
    flood_define_level(false, LEVEL_TOTWC,            "92",        { x =  -4280, y =   4600, z =   2810, a =  0x4000 }, 5.5,  4, FLOOD_WATER, { x =      0, y =     300, z =      0, a =  0x8000 })
    flood_define_level(false, LEVEL_WF,               "93",        { x =  -1067, y =    216, z = -28448, a =  0x0000 }, 3.0,  1, FLOOD_WATER, { x =  15978, y =    -684, z = -11889, a = -0x4000 })
    flood_define_level(false, LEVEL_TTC,              "94",        { x = -27077, y =    288, z =   4884, a =  0x4000 }, 1.25, 3, FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_CCM,              "95",        { x =   1849, y =    756, z =  -8186, a =  0x0000 }, 3.0,  5, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,            "96",        { x =   1455, y =    249, z = -28049, a =  0x0000 }, 2.5,  2, FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_THI,              "97",        { x =   2342, y =      0, z = -17514, a =  0x0000 }, 3.0,  6, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,              "98",        { x =   2320, y =      0, z = -22680, a =  0x0000 }, 3.0,  7, FLOOD_WATER, { x =   2310, y =     150, z = -13360, a =  0x8000 })	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "99",       { x =    805, y =   1920, z =  -6930, a =  0x0000 }, 5.5,  4, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SL,               "100",       { x =   -399, y =   -224, z =    344, a =  0x0000 }, 2.5,  2, FLOOD_LAVA,  { x =   -377, y =    -964, z = -12966, a =  0x0000 })	
end 

local function flood_load_star_revenge_5_levels()
    game = GAME_STAR_REVENGE_5
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Star Revenge 5: Neo Blue Realm"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_5_logo")	

  flood_define_level(false, LEVEL_BOB,              "c1",            { x =    520, y =  3245, z =  -6920, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   -30, y =   250, z =      0, a =  0x4000 })  
  flood_define_level(false, LEVEL_WF,               "c2",            { x =   4660, y =  6020, z =   3180, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_TOTWC,            "wc",            { x =    220, y =  3520, z =   8500, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x = -1005, y = -2725, z =  -7785, a =  0x0000 }) 
  flood_define_level(false, LEVEL_JRB,              "c3",            { x = -12420, y =  6040, z = -15875, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil) 
  flood_define_level(false, LEVEL_JRB,              "c3-2",          { x =  11525, y =     0, z =  -5635, a =  0x0000 }, 1.0,  2,  FLOOD_WATER, { x =  -100, y =   175, z =   -170, a =  0x4000 })
  flood_define_level(false, LEVEL_JRB,              "c3-3",          { x =    390, y = 11515, z =    900, a =  0x8000 }, 4.0,  3,  FLOOD_WATER, { x = -7515, y =   200, z = -20255, a =  0x4000 })        
  flood_define_level(false, LEVEL_CCM,              "c4",            { x =  -9545, y =  3450, z =  -6750, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, { x =    40, y =   145, z =    105, a =  0x8000 }) 
  flood_define_level(false, LEVEL_COTMC,            "mc",            { x =   -175, y =   -60, z =   2080, a =  0x4000 }, 1.75, 1,  FLOOD_LAVA,  { x = -7400, y = -2400, z =  -1530, a =  0x4000 })   
  flood_define_level(false, LEVEL_BBH,              "c5",            { x =   3490, y =  5250, z =  -5550, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =  1405, y =   130, z =      0, a = -0x4000 }) 
  flood_define_level(false, LEVEL_BBH,              "c5-2",          { x =  20205, y =  5640, z =  -2710, a =  0x0000 }, 4.0,  2,  FLOOD_WATER, { x = 21790, y =  1000, z =  -1835, a = -0x4000 })     
  flood_define_level(false, LEVEL_BITDW,            "b1",            { x = -10480, y =  1000, z =   -205, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_BITDW,            "b1-2",          { x =  14840, y =  1600, z =   4200, a =  0x8000 }, 2.0,  1,  FLOOD_MUD,   { x =  4210, y =   240, z =   5240, a =  0x8000 })     
  flood_define_level(false, LEVEL_HMC,              "c6",            { x =   7465, y =  3780, z =   8330, a = -0x4000 }, 1.0,  1,  FLOOD_SAND,  { x =   -35, y =   775, z =   -125, a =  0x4000 }) 
  flood_define_level(false, LEVEL_LLL,              "c7",            { x =   1580, y =  5420, z =   6880, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, { x =  -760, y = -1810, z =   2670, a =  0x8000 }) 
  flood_define_level(false, LEVEL_SSL,              "c8",            { x =  -3450, y =  1485, z =   4465, a =  0x4000 }, 1.5,  1,  FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_VCUTM,            "vc",            { x =  10030, y =  2250, z =   -290, a = -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_DDD,              "c9",            { x =   8005, y =  3750, z =  -5060, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, { x =     0, y =  1670, z =    -30, a =  0x8000 })    
  flood_define_level(false, LEVEL_BITFS,            "b2",            { x =   -510, y =  9560, z =   5670, a =  0x8000 }, 1.0,  1,  FLOOD_WATER, { x =   155, y =   300, z =   -315, a =  0x8000 }) 
  flood_define_level(false, LEVEL_BITS,             "b3",            { x =  -8905, y =  -100, z =   9055, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
end
  
 local function flood_load_star_revenge_7_levels()
    game = GAME_STAR_REVENGE_7
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Star Revenge 7: Park Of Time"
    TEX_ROMHACK_LOGO = get_texture_info("star_revenge_7_logo")	

    flood_define_level(false, LEVEL_BOB,            "c1",            { x =  3370, y =  1170, z =  3980, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x = 3180, y = -970, z = 2830, a = 0x4000 }) 
    flood_define_level(false, LEVEL_WF,             "c2",             { x = -4155, y =  1765, z = 3230,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x = -6720, y = -1480, z = -210, a = 0x4000 }) 
    flood_define_level(false, LEVEL_JRB,            "c3",            { x =  9505, y =  2535, z = 1790,  a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x = -7820, y = -1015, z = 11955, a = 0x4000 }) 
    flood_define_level(false, LEVEL_CCM,            "c4",            { x = -795,  y =  1990, z = -3850, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,            "pss",            { x = -12845, y = 6625, z = 15360, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x = 8415, y = -3090, z = -10705, a = 0x4000 }) 
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x =  5430, y =  4005, z = -3380, a = -0x4000 }, 4.0,  1,   FLOOD_WATER, { x = -5300, y = -2110, z = 2715, a = 0x8000 }) 
    flood_define_level(false, LEVEL_BBH,            "c5",            { x = 5970,  y = -1115, z = -1180, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_HMC,            "c6",            { x =  1845, y =  1950, z =  8220, a =  0x6000 }, 1.5,  1,   FLOOD_MUD, { x = -2190, y = -2020, z = 6530, a = 0x4000 }) 
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x =  -500, y = 2005,  z = -1840, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x = -5520, y = -2045, z = 2505, a = 0x4000 }) 
    flood_define_level(false, LEVEL_LLL,            "c7",            { x =  8460, y =   600, z = -3020, a = -0x8000 }, 3.5,  1,   FLOOD_WATER, { x = 13910, y = -1665, z = -5490, a = 0x4000 }) 
    flood_define_level(false, LEVEL_SSL,            "c8",            { x = -7315, y = 2850, z = 230, a =  0x0000 }, 2.5,  1,   FLOOD_MUD,  nil)
    flood_define_level(false, LEVEL_DDD,            "c9",            { x =  3310, y = 2595,  z = -5380, a =  0x6000 }, 3.5,  1,   FLOOD_SAND, { x = 11590, y = -2540, z = -2915, a = 0x4000 }) 
    flood_define_level(false, LEVEL_DDD,            "c9-2",          { x = -13280, y =  885,  z = -4850, a =  0x6000 }, 0.5,  1,   FLOOD_SAND, { x = -2820, y = 1655, z = -575, a = 0x4000 }) 	
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x = -4060, y =  4100, z = 3235,  a =  0x0000 }, 1.0,  1,   FLOOD_MUD,  nil)
    flood_define_level(false, LEVEL_SL,             "c10",             { x = -9610,   y = 1845, z = 2745,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x = -325, y = -3025, z = 7410, a = 0x4000 }) 	
    flood_define_level(false, LEVEL_WDW,            "c11",            { x =  7070, y = -2390, z = -6300, a = -0x4000 }, 1.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,            "c12",            { x = -7260, y =  1915, z = -7085,  a =  0x0000 }, 5.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13",            { x =  9590, y =  3390, z = -1830, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,             "c14",             { x = 3910,  y =  4315, z =  7045, a =  0x0000 }, 3.5,  1,   FLOOD_WATER, { x = -870, y = -2280, z = -2840, a = 0x0000 }) 
    flood_define_level(false, LEVEL_SA,             "sa",             { x = -215,  y = 4795,  z = -885,  a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x = -205, y = -3480, z = -3470, a = 0x4000 }) 	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg", { x = -6810, y = 610,   z = 2425,  a =  0x0000 }, 3.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,         "c",         { x = 1670, y = 2100,   z = -3930,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)	
end 

-- Super Mario 64 Extra ported to Flood by SuperRodrigo0
local function flood_load_super_mario_64_extra_levels()
    game = GAME_SUPER_MARIO_64_EXTRA
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
    romhackText = "Super Mario 64 Extra"	
	TEX_ROMHACK_LOGO = get_texture_info("sm64_extra_logo")	

    flood_define_level(false, LEVEL_BOB,             "c1",              { x = 12932, y = 11637, z = -4408, a =  0x8000 }, 5.2,  1,   FLOOD_WATER, { x = 10972, y = 296, z = 4620,  a = 0x8000 })
    flood_define_level(false, LEVEL_WF,              "c2",              { x = 4644, y = 922, z = 922, a =  0x4000 }, 2.5,  1,   FLOOD_LAVA, { x = 2692, y = -3512, z = -197,  a = 0x0000 })
    flood_define_level(false, LEVEL_WF,              "c2",              { x = 5572, y = 1505, z = -5696, a =  0x8000 }, 2.8,  1,   FLOOD_LAVA, { x = 5859, y = -479, z = -4897,  a = 0x6000 })
    flood_define_level(false, LEVEL_WF,              "c2",              { x = -8571, y = 3629, z = -7940, a =  0x4000 }, 1.3,  1,   FLOOD_LAVA, { x = -9535, y = -1060, z = -377,  a = -0x6000 })
    flood_define_level(false, LEVEL_JRB,             "c3",              { x = 14408, y = 4026, z = -3988, a =  0x8000 }, 1.4,  1,   FLOOD_WATER, { x = 1408, y = -919, z = -16688,  a = 0x2000 }) 
    flood_define_level(false, LEVEL_JRB,             "c3",              { x = 2046, y = 3563, z = -12072, a =  0x4000 }, 1.6,  1,   FLOOD_WATER, { x = 5997, y = -857, z = -14151,  a = -0x2000 }) 
    flood_define_level(false, LEVEL_JRB,             "c3",              { x = 3470, y = 4815, z = 10625, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = 6686, y = 1015, z = 18477,  a = -0x4000 }) 
    flood_define_level(false, LEVEL_JRB,             "c3",              { x = -20341, y = -171, z = 20304, a =  0x4000 }, 3.2,  1,   FLOOD_WATER, { x = -15896, y = -4815, z = 19154,  a = -0x4000 })	
    flood_define_level(false, LEVEL_CCM,             "c4",              { x = 5460, y = 17693, z = 4602, a =  0x4000 }, 4.3,  1,   FLOOD_WATER, { x = -7836, y = -2185, z = -18739,  a = 0x0000 })
    flood_define_level(false, LEVEL_CCM,             "c4",              { x = -13000, y = 5524, z = 11738, a =  0x4000 }, 1.6,  1,   FLOOD_WATER, { x = -3692, y = 3450, z = 16032,  a = 0x8000 })
    flood_define_level(false, LEVEL_PSS,             "pss",             { x = 2470, y = 2672, z = 11378, a =  0x4000 }, 1.2,  1,   FLOOD_MUD, { x = -52, y = -0, z = 1386,  a = 0x0000 })
    flood_define_level(false, LEVEL_PSS,             "pss",             { x = -9364, y = 5328, z = 89, a =  0x4000 }, 1.6,  1,   FLOOD_MUD, { x = -3036, y = 1371, z = 17,  a = -0x4000 })
    flood_define_level(false, LEVEL_PSS,             "pss",             { x = 1110, y = 6303, z = -9437, a =  0x4000 }, 1.7,  1,   FLOOD_MUD, { x = -40, y = 2304, z = -3920,  a = 0x8000 })
    flood_define_level(false, LEVEL_WMOTR,           "wmotr",           { x = -1965, y = -616, z = 11542, a =  0x4000 }, 2.8,  1,   FLOOD_MUD, nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,  "cg",              { x = 151, y = -0, z = -5685, a =  0x4000 }, 1.8,  1,   FLOOD_WATER, { x = -11576, y = 689, z = 10706,  a = 0x8000 })
end

-- Super Mario 64 Odyssey ported to Flood by SuperRodrigo0
local function flood_load_super_mario_64_odyssey_levels()
    game = GAME_SUPER_MARIO_64_ODYSSEY
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Super Mario 64 Odyssey"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_odyssey_logo")	

    flood_define_level(false, LEVEL_BOB,             "c1",              { x = -6184, y = 1311, z = -6919, a =  0x0000 }, 7.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOB,             "c1",              { x = -6759, y = 3889, z = -1024, a =  0x0000 }, 1.5,  1,   FLOOD_WATER, { x = 6155, y = 775, z = -7950,  a = 0x0000 })
    flood_define_level(false, LEVEL_WF,              "c2",              { x = 2513, y = 8503, z = 4980, a =  0x8000 }, 6.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,             "c3",              { x = -16190, y = -1749, z = -15969, a =  0x0000 }, 3.0,  1,   FLOOD_SAND, nil)	
    flood_define_level(false, LEVEL_CCM,             "c4",              { x = 4735, y = 7000, z = 1767, a =  0x8000 }, 6.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,             "c5",              { x = -51, y = 7791, z = 15361, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_HMC,             "c6",              { x = -28022, y = 693, z = 33, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 29698, y = -7892, z = 1291,  a = -0x4000 })
    flood_define_level(false, LEVEL_RR,              "c15",             { x = 12462, y = 969, z = -9, a = -0x4000 }, 6.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,           "b2",              { x = 7503, y = 6000, z = -1001, a =  0x8000 }, 1.5,  1,   FLOOD_LAVA, { x = -5468, y = 3000, z = 3750,  a = 0x4000 })
    flood_define_level(false, LEVEL_PSS,             "pss",             { x = 3, y = -305, z = -4966, a =  0x0000 }, 5.7,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,  "cg",              { x = -6542, y = 2168, z = 2950, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, nil)
end

 local function flood_load_star_revenge_4_5_levels()
    game = GAME_STAR_REVENGE_4_5
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Star Revenge 4.5: The Kedama Takeover Redone"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_4.5_logo")	
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,            "c1",             { x = -7295, y =  2780, z =  2055, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x =  3900, y = -1860, z = 11440,  a =  0x8000 })
    flood_define_level(false, LEVEL_WF,             "c2",             { x = -2170, y =  1475, z = -9845, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,            "c3",             { x =  9790, y =  1720, z =  3235, a =  0x0000 }, 3.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,            "c4",             { x =  3250, y =  2720, z =   655, a =  0x0000 }, 1.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,            "c5",             { x =  5090, y =  2260, z =  4445, a =  0x8000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BITDW,          "b1",             { x =  6830, y =  3600, z =  5970, a =  0x4000 }, 2.5,  1,   FLOOD_WATER, nil) 	
    flood_define_level(false, LEVEL_VCUTM,          "vc",             { x =  3330, y =   520, z = -2370, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,            "c6",             { x =  4430, y =  -785, z =  1080, a =  0x4000 }, 2.5,  1,   FLOOD_MUD,   { x = -3440, y = -3960, z =  1120,  a =  0x4000 })
    flood_define_level(false, LEVEL_BITFS,          "b2",             { x =  3490, y =  1640, z = -7520, a =  0x4000 }, 3.5,  1,   FLOOD_MUD,   { x =  3800, y = -2860, z = -3330,  a =  0x4000 })	
    flood_define_level(false, LEVEL_LLL,            "c7",             { x =  2705, y =  3135, z =  8230, a =  0x4000 }, 2.0,  1,   FLOOD_MUD,   { x =   900, y = -1475, z = -9350,  a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,            "c8",             { x =  -100, y =  2250, z = -1745, a =  0x6000 }, 3.0,  1,   FLOOD_WATER, { x =   465, y =   340, z = 11010,  a =  0x8000 })
    flood_define_level(false, LEVEL_DDD,            "c9",             { x =   420, y =  1485, z = -1285, a =  0x0000 }, 2.0,  1,   FLOOD_LAVA,  { x =  2975, y = -1070, z =  6835,  a =  0x8000 })
    flood_define_level(false, LEVEL_SL,             "c10",            { x = -5060, y =  2560, z = -3880, a =  0x0000 }, 3.0,  1,   FLOOD_SAND, nil)	
    flood_define_level(false, LEVEL_WDW,            "c11",            { x = -4150, y =   935, z =   845, a =  0x4000 }, 1.5,  1,   FLOOD_LAVA,  { x = -7540, y = -1510, z = -6535,  a =  0x0000 })
    flood_define_level(false, LEVEL_TTM,            "c12",            { x = -3880, y =  3290, z = 12870, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x = -8485, y = -3725, z =   270,  a =  0x4000 })
    flood_define_level(false, LEVEL_TTM,            "c12-2",          { x = -4050, y =  1890, z =     0, a =  0x0000 }, 3.0,  2,   FLOOD_WATER, { x = -2520, y = -2445, z =    -5,  a = -0x4000 })
    flood_define_level(false, LEVEL_TTM,            "c12-3",          { x =  4050, y =  1560, z =    10, a =  0x0000 }, 3.0,  2,   FLOOD_WATER, { x =  4050, y = -2700, z =    10,  a =  0x8000 })	
    flood_define_level(false, LEVEL_THI,            "c13",            { x =  8330, y =  6225, z =  -145, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x =  -560, y = -2030, z =  3780,  a =  0x8000 })
    flood_define_level(false, LEVEL_TTC,            "c14",            { x =  6035, y =  4320, z =-15335, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x =     0, y =   420, z =     0,  a =  0x8000 })
    flood_define_level(false, LEVEL_TTC,            "c14-2",          { x =  4470, y =  1640, z =    70, a =  0x4000 }, 2.5,  2,   FLOOD_WATER, { x = -4075, y = -1880, z =  3525,  a =  0x8000 })
    flood_define_level(false, LEVEL_TTC,            "c14-3",          { x = -4420, y =  4920, z =  9600, a =  0x0000 }, 3.0,  3,   FLOOD_WATER, { x = -4445, y = -5175, z =  1180,  a =  0x8000 })	
    flood_define_level(false, LEVEL_RR,             "c15",            { x =  6200, y =  4380, z =  -320, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x = -4210, y = -5075, z =  6550,  a =  0x6000 })
    flood_define_level(false, LEVEL_RR,             "c15-2",          { x = -4760, y =  5815, z = -1335, a =  0x0000 }, 3.5,  2,   FLOOD_WATER, { x = -3455, y = -4290, z =  5800,  a =  0x8000 })	
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",          { x =     0, y =  5850, z =-11160, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_ENDING,         "ending",         { x =   125, y =  4245, z =  1970, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x =  -175, y =   235, z =  1920,  a =  0x8000 })	
    flood_define_level(false, LEVEL_SA,             "sa",             { x = 11265, y = -1950, z = 13235, a =  0x4000 }, 0.75, 1,   FLOOD_WATER, { x =-10930, y = -2765, z = -5610,  a =  0x8000 })	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",             { x =  7920, y =  2830, z = -9535, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x =  3450, y =  3330, z = -7330,  a =  0x4000 })		
end 

local function flood_load_star_revenge_0_5_levels()
    game = GAME_STAR_REVENGE_0_5
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Star Revenge 0.5: Unused Levels"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_0.5_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  8080, y =  1550, z = -9655, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x = -3570, y =  1890, z = -4685, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x = -5235, y =  3475, z =  6150, a =  0x4000 }, 4.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  8640, y =  6325, z =  -330, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = -5390, y =  6640, z =  3050, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =  3590, y =  3380, z = -5260,  a = 0x0000 }) 
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =  7040, y =  5510, z =  4570, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BBH,              "c5",             { x = -8090, y =  2425, z =-12450, a =  0x2000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =  3220, y = -3200, z =-17260, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, { x =  1625, y = -7105, z = -1835,  a = 0x6000 }) 	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =-12335, y =  1535, z =-11510, a =  0x1000 }, 1.0,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x = 10050, y =  8810, z =  4510, a =  0x2000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  -500, y =  7870, z =  6870, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, { x =  2170, y = -5500, z =   825,  a = 0x2000 }) 	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x = -4055, y =   600, z = -4535, a =  0x0000 }, 2.5,  1,  FLOOD_LAVA,  nil) 
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =-14050, y =  1710, z =  7815, a =  0x0000 }, 4.5,  1,  FLOOD_WATER, { x = -7780, y = -2275, z = -3490,  a = 0x4000 }) 	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =  1920, y =  4560, z =  2770, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =   190, y =   975, z =  2805, a =  0x8000 }, 5.0,  1,  FLOOD_WATER, { x =   150, y = -2450, z =    80,  a = 0x8000 })
end

local function flood_load_luigis_mansion_64_super_player_mode_levels()
    game = GAME_LUIGIS_MANSION_64_5_SUPER_MODE
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Luigi's Mansion 64.5 [Super Player Mode]"
	TEX_ROMHACK_LOGO = get_texture_info("luigis_mansion_64_5_logo")	
	gLevelValues.metalCapDurationCotmc  = 1	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,            "c1",            { x =  3304, y =  4293, z = -4603, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",             { x = 1775, y =  3585, z = -3180,  a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,            "c6",            { x = -7420, y =  2160, z = 7410, a =  0x0000 }, 1.5,  1,   FLOOD_WATER, { x = -2720, y = 2040, z = -6415, a =  0x8000 })	
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x =  4,    y =  369,  z = -6138, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CCM,            "c4",            { x = -478,  y =  3471, z = -964,  a =  0x0000 }, 5.0,  1,   FLOOD_WATER, { x =  3336, y = -3800, z =  0,    a = 0x0000 })	
    flood_define_level(false, LEVEL_CCM,            "c4-slide",      { x = -5620, y =  6656, z = -6145, a =  0x0000 }, 4.0,  2,  FLOOD_WATER, { x = -6498, y = -5836, z = -6937, a = 0x0000 })		
    flood_define_level(false, LEVEL_BBH,            "c5",            { x = -3100,  y = 1125, z = 5535,  a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x = 2860, y = -2845, z = 2050, a = 0x8000 })
    flood_define_level(false, LEVEL_PSS,            "pss",            { x =  3127, y =  7035, z = -5650, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x = -6387, y = -4000, z =  5723, a =  0x8000 })
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x = -2010, y = 6220, z =  1955,    a = -0x4000 }, 3.5,  1,   FLOOD_WATER,  nil)	
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x =  4596, y = -1,    z = -4514, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x = -2093, y = -2500, z =  1338, a =  0x8000 })
    flood_define_level(false, LEVEL_LLL,            "c7",            { x =  9,    y =  768,  z = -6845, a = -0x8000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,            "c7-volcano",    { x =  2523, y =  3591, z = -898,  a = -0x8000 }, 3.5,  2,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_WDW,            "c11",            { x =  4265, y =  4495, z = 4390,   a = -0x4000 }, 4.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_DDD,            "c9",            { x =  4046, y = -511,  z = -8,    a = -0x4000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =  1224, y =  5478, z =  84,   a =  0x0000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_JRB,            "c3",            { x =  4885, y =  2000, z =  900, a =  0x0000 }, 3.5,  1,   FLOOD_WATER, { x =  5138, y = -4912, z =  201,  a =  0x0000 })
    flood_define_level(false, LEVEL_JRB,            "c3-ship",       { x =  70, y =  1260, z = 2950, a =  0x0000 }, 3.5,  2,   FLOOD_WATER, { x = 675, y = -220, z = -2685,  a =  0x0000 })
    flood_define_level(false, LEVEL_SSL,            "c8",            { x = -2038, y =  1103, z = -300,  a =  0x0000 }, 3.0,  1,   FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,            "c8-pyramid",    { x =  512,  y =  4815, z = -551,  a =  0x0000 }, 3.0,  2,   FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_TTM,            "c12",            { x =  1053, y =  2309, z =  305,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13",            { x = -12,    y = 3891,  z = -1556, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13-tiny",       { x = 30,    y = 1170,  z = -450, a =  0x0000 }, 5.0,  2,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13-cave",       { x = -1930, y = 1535,  z = -1090, a =  0x0000 }, 4.0,  3,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,            "c14",            { x =  2208, y =  7051, z =  2217, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,             "c10",             { x =  40,   y =  4864, z =  240,  a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SL,             "c10-igloo",      { x = -5,   y =  0, z = 2575,  a =  0x0000 }, 3.0,  2,   FLOOD_WATER, { x = -390, y = 145, z = -1740, a = 0x4000 })		
    flood_define_level(false, LEVEL_BITS,           "b3",           { x =  369,  y =  6552, z = -6000, a =  0x0000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg", { x =  0,    y =  7583, z = -4015, a =  0x0000 }, 7.0,  1,   FLOOD_WATER, nil)
end

local function flood_load_blossoming_bluds_levels()
    game = GAME_BLOSSOMING_BLUDS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Blossoming Buds"
	TEX_ROMHACK_LOGO = get_texture_info("blossoming_bluds_logo")		

    flood_define_level(false, LEVEL_BOB,              "c1",             { x = -6135, y =  3215, z = -6100, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =  2545, y =  4860, z =  5000, a = -0x6000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   820, y =  1640, z = -7885, a = -0x2000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =  4515, y =  1490, z =  7040, a = -0x4000 }, 2.75, 1,  FLOOD_WATER, nil) 	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x = -7430, y =  2260, z = -2545, a =  0x0000 }, 2.5,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_BITS,             "b3",             { x = -2325, y =  5790, z = -2620, a =  0x8000 }, 1.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  3160, y =  2005, z = -1050, a =  0x4000 }, 4.5,  1,  FLOOD_WATER, { x = 2445, y = 1340, z = -2180, a = -0x5000 })
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =  3650, y =   855, z =  -910, a =  0x2000 }, 10.0, 1,  FLOOD_WATER, nil)	
end

-- Waifu Cauldron Renewed by SuperRodrigo0
local function flood_load_waifu_cauldron_levels()
    game = GAME_WAIFU_CAULDRON
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Waifu Cauldron"
	TEX_ROMHACK_LOGO = get_texture_info("waifu_cauldron_logo")
	
    flood_define_level(false, LEVEL_BOB,              "c1",             { x = -5690, y = 6535, z = -2865, a =  -0x6000 }, 2.5,  1,  FLOOD_WATER, { x = -300, y = 1565, z = 10, a = -0x2000 })
    flood_define_level(false, LEVEL_WF,               "c2",             { x = -8210, y = 6380, z = -2885, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "c3",             { x = 1698, y = 7211, z = -2040, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = -218, y = 4575, z = -8897, a =  -0x4000 }, 2.2,  1,  FLOOD_WATER, { x = 375, y = -2419, z = 1835, a = 0x8000 })
    flood_define_level(false, LEVEL_BBH,              "c5",             { x = -3641, y = 1868, z = -4509, a =  -0x4000 }, 2.0,  1,  FLOOD_WATER, { x = -60, y = -1940, z = -5675, a = -0x4000 })
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x = 1232, y = 8928, z = -13172, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x = 1279, y = 1147, z = -8325, a = 0x8000 })	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x = -8330, y = 10100, z = -2620, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,              "c7",             { x = -2915, y =  6690, z =  2645, a =  -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x = -2809, y = 2801, z = -9310, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, { x =  8725, y =  -465, z =  4085, a = 0x8000 })
    flood_define_level(false, LEVEL_DDD,              "c9",             { x = -3781, y = 12432, z = -16571, a =  0x8000 }, 1.2,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =  2230, y =  4975, z = -2865, a =  0x4000 }, 1.3,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",            { x = -1660, y =  3400, z =-17610, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x = -9385, y =  6755, z = -7140, a =  0x6000 }, 2.3,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =   -30, y =  9160, z =-13500, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,              "c13",            { x = 10360, y = 11456, z =  8282, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,              "c14",            { x = 26427, y = 17229, z = -7622, a =  -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,               "c15",            { x =  23187, y = 15828, z = 15662, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "c16",            { x =  -3218, y = 3503, z = 546, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "c17",            { x =  282, y = -1684, z = -9839, a =  0x0000 }, 10.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,    "c18",            { x =  -4222, y = 3499, z = -698, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)

--- Easy Mode --- /flood start 21 ---

    flood_define_level(true, LEVEL_BOB,              "easy",             { x = -5690, y = 6535, z = -2865, a =  -0x6000 }, 2.5,  1,  FLOOD_WATER, { x = -300, y = 1565, z = 10, a = -0x2000 })
    flood_define_level(true, LEVEL_WF,               "easy",             { x = -9416, y = 806, z = -9412, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_WF,               "easy",             { x = -8210, y = 6380, z = -2885, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x = -9377, y = 1677, z = -9374, a = -0x4000 })
    flood_define_level(true, LEVEL_JRB,              "easy",             { x = 685, y = 4736, z = -535, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_JRB,              "easy",             { x = 1698, y = 7211, z = -2040, a =  0x8000 }, 1.1,  1,  FLOOD_WATER, { x = 685, y = 5460, z = -535, a = 0x8000 })
    flood_define_level(true, LEVEL_CCM,              "easy",             { x = -1696, y = 1570, z = -6026, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x = 375, y = -2419, z = 1835, a = 0x8000 })
    flood_define_level(true, LEVEL_CCM,              "easy",             { x = -218, y = 4575, z = -8897, a =  -0x4000 }, 1.0,  1,  FLOOD_WATER, { x = -1686, y = 2082, z = -5919, a = 0x8000 })
    flood_define_level(true, LEVEL_BBH,              "easy",             { x = -4425, y = 821, z = 929, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x = -60, y = -1940, z = -5675, a = -0x4000 })
    flood_define_level(true, LEVEL_BBH,              "easy",             { x = -3641, y = 1868, z = -4509, a =  -0x4000 }, 1.0,  1,  FLOOD_WATER, { x = -4425, y = 1461, z = 929, a = -0x6000 })
    flood_define_level(true, LEVEL_BITDW,            "easy",             { x = 1237, y = 6191, z = -8221, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x = 1279, y = 1147, z = -8325, a = 0x8000 })	
    flood_define_level(true, LEVEL_BITDW,            "easy",             { x = 1232, y = 8928, z = -13172, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, { x = 1237, y = 6575, z = -8221, a = 0x8000 })	
    flood_define_level(true, LEVEL_HMC,              "easy",             { x = -9600, y = 6609, z = -25, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_HMC,              "easy",             { x = -8330, y = 10100, z = -2620, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, { x = -9060, y = 5563, z = 1759, a = 0x8000 })
    flood_define_level(true, LEVEL_LLL,              "easy",             { x = -9438, y = 1390, z = 1094, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_LLL,              "easy",             { x = -2915, y =  6690, z =  2645, a =  -0x4000 }, 1.0,  1,  FLOOD_WATER, { x = -6654, y = 327, z = 1082, a = -0x4000 })
    flood_define_level(true, LEVEL_SSL,              "easy",             { x = -5938, y =  1611, z = -5568, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, { x =  8725, y =  -465, z =  4085, a = 0x8000 })
    flood_define_level(true, LEVEL_SSL,              "easy",             { x = -2809, y = 2801, z = -9310, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, { x = -4706, y = 1753, z = -6491, a = -0x2000 })
    flood_define_level(true, LEVEL_DDD,              "easy",             { x = -5214, y = 10117, z = -13442, a =  0x0000 }, 1.2,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_DDD,              "easy",             { x = -3781, y = 12432, z = -16571, a =  0x8000 }, 1.2,  1,  FLOOD_WATER, { x = -5214, y = 10562, z = -13446, a = 0x4000 })
    flood_define_level(true, LEVEL_BITFS,            "easy",             { x =  2320, y =  -1297, z = -1836, a =  0x4000 }, 1.3,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_BITFS,            "easy",             { x =  2230, y =  4975, z = -2865, a =  0x4000 }, 1.3,  1,  FLOOD_WATER, { x = 2320, y = -705, z = -1836, a = 0x4000 })
    flood_define_level(true, LEVEL_SL,               "easy",            { x = -480, y = 85, z = -8309, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(true, LEVEL_SL,               "easy",            { x = -1660, y =  3400, z =-17610, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, { x = -459, y = 553, z = -8233, a = 0x8000 })	
    flood_define_level(true, LEVEL_WDW,              "easy",            { x = -4773, y = 1219, z = -2499, a =  0x0000 }, 2.3,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_WDW,              "easy",            { x = -9385, y =  6755, z = -7140, a =  0x6000 }, 2.3,  1,  FLOOD_WATER, { x = -4820, y = 1619, z = -641, a = 0x8000 })	
    flood_define_level(true, LEVEL_TTM,              "easy",            { x =   -10, y = 1682, z = -13528, a =  -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_TTM,              "easy",            { x =   -30, y =  9160, z =-13500, a =  0x4000 }, 0.5,  1,  FLOOD_WATER, { x = 20, y = 2194, z = -13522, a = 0x4000 })
    flood_define_level(true, LEVEL_THI,              "easy",            { x = 9323, y = 8576, z = 6538, a =  -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_THI,              "easy",            { x = 10360, y = 11456, z =  8282, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, { x = 7646, y = 9044, z = 8120, a = 0x6000 })
    flood_define_level(true, LEVEL_TTC,              "easy",            { x = -2819, y = -884, z = -5029, a =  -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_TTC,              "easy",            { x = 13912, y = 4410, z = -12788, a =  0x0000 }, 0.8,  1,  FLOOD_WATER, { x = -2819, y = -116, z = -5029, a = 0x2000 })
    flood_define_level(true, LEVEL_TTC,              "easy",            { x = 26427, y = 17229, z = -7622, a =  -0x4000 }, 1.1,  1,  FLOOD_WATER, { x = 13518, y = 4108, z = -11095, a = 0x8000 })
    flood_define_level(true, LEVEL_RR,               "easy",            { x =  24748, y = -3920, z = -7527, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_RR,               "easy",            { x =  24309, y = 1334, z = 4161, a =  -0x4000 }, 1.5,  1,  FLOOD_WATER, { x = 24745, y = -3282, z = -7542, a = 0x0000 })
    flood_define_level(true, LEVEL_RR,               "easy",            { x =  25618, y = 8646, z = 6285, a =  0x8000 }, 0.8,  1,  FLOOD_WATER, { x = 24293, y = 2004, z = 4250, a = -0x4000 })
    flood_define_level(true, LEVEL_RR,               "easy",            { x =  23187, y = 15828, z = 15662, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, { x = 25618, y = 9222, z = 6285, a = -0x4000 })
    flood_define_level(true, LEVEL_CASTLE_GROUNDS,   "easy",            { x =  -3218, y = 3503, z = 546, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_CASTLE_COURTYARD, "easy",            { x =  282, y = -1684, z = -9839, a =  0x0000 }, 10.5,  1,  FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_CASTLE,           "easy",            { x =  -4222, y = 3499, z = -698, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)
end


-- Luigi and the Forest Ruins ported to Flood by SuperRodrigo0
local function flood_load_luigi_and_the_forest_ruins_levels()
    game = GAME_LUIGI_AND_THE_FOREST_RUINS 
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Luigi and the Forest Ruins"
	TEX_ROMHACK_LOGO = get_texture_info("luigi_and_the_forest_ruins_logo")	

    flood_define_level(false, LEVEL_BOB,          "c1",          { x = -6646, y = 2769, z = -2526,  a = 0x6000 }, 3.0,  1,   FLOOD_WATER, { x = -5934, y = -3708, z = 1651,  a = 0x4000 })
    flood_define_level(false, LEVEL_WF,           "c2",          { x = -4974, y = 13645, z = -4997,  a = -0x2000 }, 1.2,  1,   FLOOD_WATER, { x = -3545, y = 11039, z = -12909,  a = 0x0000 })	
    flood_define_level(false, LEVEL_JRB,          "c3",          { x = -6113, y = 2718, z = -8059,  a = -0x0000 }, 3.3,  1,   FLOOD_WATER, { x = 7423, y = 240, z = -120,  a = -0x4000 })
    flood_define_level(false, LEVEL_JRB,          "c3",          { x = -5629, y = -521, z = -12373,  a = 0x6000 }, 2.5,  1,   FLOOD_WATER, { x = -6174, y = -1065, z = -7701,  a = 0x8000 })
    flood_define_level(false, LEVEL_CCM,          "c4",          { x = -13361, y = 621, z = -2437,  a = 0x8000 }, 2.0,  1,   FLOOD_WATER, { x = -16440, y = -1985, z = 5201,  a = 0x8000 }) 
    flood_define_level(false, LEVEL_CCM,          "c4",          { x = -20862, y = 2277, z = -6380,  a = 0x8000 }, 5.0,  1,   FLOOD_WATER, { x = -22743, y = -379, z = -4724,  a = -0x0500 }) 
    flood_define_level(false, LEVEL_BBH,          "c5",            { x = 2304, y = 725, z = -1871, a =  0x2000 }, 5.0,  1,   FLOOD_LAVA, nil)	
    flood_define_level(false, LEVEL_BBH,          "c5",            { x = -1095, y = 2619, z = -9347, a = -0x4000 }, 3.2,  1,   FLOOD_LAVA, { x = 3691, y = -1044, z = 5197,  a = -0x4000 })
    flood_define_level(false, LEVEL_HMC,          "c6",          { x = -3153, y = 7743, z = 4489,  a = -0x4000 }, 2.3,  1,   FLOOD_WATER, { x = 496, y = 2044, z = -3690,  a = 0x9999 })  	
    flood_define_level(false, LEVEL_WMOTR,        "wmotr",          { x = 3699, y = 3656, z = -4303,  a = 0x6000 }, 2.5,  1,   FLOOD_WATER, { x = -524, y = 744, z = -2077,  a = 0x5000 }) 
    flood_define_level(false, LEVEL_BITDW,        "b1",             { x = -9395, y = 3430, z = -5685, a = 0x0000 }, 5.75,  1,   FLOOD_SAND, nil)
    flood_define_level(false, LEVEL_BOWSER_1,     "bowser-1",            { x = 5727, y = -777, z = 44, a = -0x5000 }, 2.0, 1,   FLOOD_LAVA, nil)
    flood_define_level(false, LEVEL_BITFS,        "b2",          { x = -9620, y = 298, z = 5248,  a = 0x8000 }, 4.1,  1,   FLOOD_LAVA, nil)	
    flood_define_level(false, LEVEL_BOWSER_2,     "bowser-2",            { x = 2910, y = -192, z = 156, a = -0x4000 }, 4.0, 1,   FLOOD_LAVA, { x = -1643, y = 0, z = -13,  a = 0x8000 })
    flood_define_level(false, LEVEL_SA,           "sa",          { x = -380, y = -2850, z = 2707,  a = 0x8000 }, 3.0,  1,   FLOOD_WATER, { x = -25, y = -2852, z = -2403,  a = 0x0000 })
    flood_define_level(false, LEVEL_PSS,          "pss",          { x = 6644, y = 2659, z = -447,  a = -0x2000 }, 3.0,  1,   FLOOD_WATER, { x = -3872, y = -385, z = 6028,  a = 0x7000 })  
    flood_define_level(false, LEVEL_BITS,         "b3",          { x = -2695, y = 8001, z = -3033,  a = 0x8000 }, 4.5,  1,   FLOOD_WATER, { x = -10793, y = 1966, z = 308,  a = 0x4000 })
    flood_define_level(false, LEVEL_BITS,         "b3",          { x = 22557, y = 3777, z = -18617,  a = -0x4000 }, 1.7,  1,   FLOOD_WATER, { x = 4406, y = 2966, z = -10913,  a = 0x6000 })	
    flood_define_level(false, LEVEL_BOWSER_3,     "bowser-3",            { x = -5377, y = -470, z = -117, a =  0x5000 }, 12.0, 1,   FLOOD_LAVA, nil)	 
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",          { x = 432, y = 2834, z = -3771,  a = 0x6000 }, 2.0,  1,   FLOOD_WATER, { x = -4565, y = 740, z = 6996,  a = 0x8000 })	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",          { x = 1756, y = 2799, z = 1392,  a = 0x0000 }, 1.5,  1,   FLOOD_WATER, nil) 
end

-- Thousand Year Door in Mario 64 ported to Flood by SuperRodrigo0
local function flood_load_tyd64_levels()
    game = GAME_TYD64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Thousand-Year Door 64"
	TEX_ROMHACK_LOGO = get_texture_info("thousand_year_door_64_logo")	

  flood_define_level(false, LEVEL_BOB,              "c1",            { x = 387, y = -248, z = -1704, a =  -0x4000 }, 2.5,  1,   FLOOD_WATER, { x = 281, y = -1152, z = 4094,  a = 0x8000 })
  flood_define_level(false, LEVEL_WF,               "c2",               { x = 10264, y = 208, z =  5901, a =  -0x4000 }, 1.4,  1,   FLOOD_WATER, { x = -16335, y = 331, z = 6605,  a = 0x4000 })
  flood_define_level(false, LEVEL_JRB,              "c3",              { x = -157, y = -5518, z =  591, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x = -172, y = -8514, z = 1922,  a = 0x0000 })
  flood_define_level(false, LEVEL_CCM,              "c4",              { x = 16195, y = 2155,  z = -5768, a =  -0x4000 }, 1.0,  1,   FLOOD_WATER, { x = -7743, y = 1253, z = 11380,  a = 0x8000 }) 
  flood_define_level(false, LEVEL_BBH,              "c5",              { x =  1188,   y = -3926, z =  8902,  a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x = 1201, y = -5535, z = 11306,  a = 0x8000 }) 
  flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -4561, y = 5634, z =  682, a = -0x4000 }, 3.8,  1,   FLOOD_LAVA,  { x = -9362, y = -4238, z = 472,  a = 0x4000 })
  flood_define_level(false, LEVEL_TOTWC,            "wc",               { x =  -6768,  y = 5070, z = -3028, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 6679, y = 1361, z = 6557,  a = 0x4000 })  
  flood_define_level(false, LEVEL_COTMC,            "mc",               { x =  -3000,  y = 5220, z = -6005, a =  0x0000 }, 4.5,  1,   FLOOD_WATER, { x = -473, y = 588, z = -6020,  a = -0x4000 }) 
  flood_define_level(false, LEVEL_HMC,              "c6-2",              { x = -4237, y = 0, z =  2497, a =  0x8000 }, 1.5,  1,   FLOOD_WATER,  { x = 5308, y = -1442, z = 132,  a = -0x4000 })  
  flood_define_level(false, LEVEL_LLL,              "c7",              { x =  -9265,  y = 2328, z = -8152, a =  0x6000 }, 1.5,  1,   FLOOD_WATER, { x = 9134, y = -148, z = -7365,  a = 0x8000 })
  flood_define_level(false, LEVEL_LLL,              "c7-2",              { x =  6002,  y = 10740, z = -5999, a =  0x4000 }, 1.5,  2,   FLOOD_WATER, { x = 9564, y = 1695, z = 112,  a = 0x8000 })
  flood_define_level(false, LEVEL_SSL,              "c8",              { x = -12153, y = 720, z =  -5384, a =  0x0000 }, 1.5,  1,   FLOOD_WATER,  { x = -10747, y = 704, z = 9128,  a = 0x8000 })
  flood_define_level(false, LEVEL_SSL,              "c8-2",              { x = 150, y = 5100, z =  -1042, a =  -0x4000 }, 1.5,  2,   FLOOD_WATER,  { x = 869, y = 498, z = -3066,  a = 0x8000 }) 
  flood_define_level(false, LEVEL_VCUTM,            "vc",            { x = -6129, y = -956, z = 4971, a =  0x8000 }, 1.3,  1,   FLOOD_WATER, { x = 6700, y = -862, z = 1019,  a = -0x4000 })
  flood_define_level(false, LEVEL_SA,               "sa",               { x =  -129,  y = 2023, z = -131, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 5121, y = -5043, z = 5726,  a = -0x4000 })
  flood_define_level(false, LEVEL_DDD,              "c9",              { x = 7748, y = 330, z = -5283, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x = 11130, y = -4824, z = 5456,  a = 0x8000 })  
  flood_define_level(false, LEVEL_DDD,              "c9",              { x = 1496, y = 4650, z = 8287, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x = 2326, y = -2470, z = 23759,  a = 0x8000 })  
  flood_define_level(false, LEVEL_SL,               "c10",               { x =  -3325, y = -396, z =  75, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, { x = -767, y = -1473, z = 3014,  a = 0x8000 })
  flood_define_level(false, LEVEL_WDW,              "c11",              { x = 1565, y = 0, z =  -240, a =  0x8000 }, 1.5,  1,   FLOOD_WATER,  { x = 3640, y = 65, z = -1600,  a = 0x8000 })   
  flood_define_level(false, LEVEL_PSS,              "pss",              { x = -3508, y = 3540, z = -13114, a =  0x4000 }, 2.3,  1,   FLOOD_WATER, { x = -2615, y = 148, z = -11145,  a = 0x0000 })
end

-- Nice Mario 75 ported to Flood by SuperRodrigo0
local function flood_load_nice_mario_75_levels()
    game = GAME_NICE_MARIO_75
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Nice Mario 75"
	TEX_ROMHACK_LOGO = get_texture_info("nice_mario_75_logo")	

  flood_define_level(false, LEVEL_BOB,              "c1",            { x = 6475, y = 13141, z = -10189, a =  0x0000 }, 2.6,  1,   FLOOD_WATER, { x = 2207, y = 8818, z = -11455,  a = 0x4000 })
  flood_define_level(false, LEVEL_WF,               "c2",               { x = -7368, y = 1478, z =  -3408, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, { x = -1487, y = -369, z = 4468,  a = 0x8000 })  
  flood_define_level(false, LEVEL_JRB,              "c3",              { x = -2884, y = 1834, z =  1296, a =  0x4000 }, 3.5,  1,   FLOOD_WATER, { x = 2985, y = -728, z = 847,  a = 0x8000 })  
  flood_define_level(false, LEVEL_CCM,              "c4",              { x = -1890, y = 1516,  z = 5195, a =  0x0000 }, 2.7,  1,   FLOOD_WATER, { x = 1496, y = -571, z = -1419,  a = -0x2000 })
  flood_define_level(false, LEVEL_BBH,              "c5",              { x =  3218,   y = -187, z =  4789,  a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x = 265, y = -187, z = -1492,  a = 0x0000 })
  flood_define_level(false, LEVEL_TOTWC,            "wc",              { x = 3935, y = 686, z = 2075, a =  0x0000 }, 1.0,  1,   FLOOD_WATER, { x = -1298, y = 420, z = -3062,  a = 0x0000 }) 
  flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -2925, y = 1742, z =  256, a = -0x4000 }, 3.0,  1,   FLOOD_LAVA,  { x = -385, y = -1722, z = -1329,  a = 0x4000 })
  flood_define_level(false, LEVEL_PSS,              "pss",              { x = 2156, y = 7443, z = -3740, a =  0x0000 }, 6.0,  1,   FLOOD_WATER, { x = -3548, y = -4909, z = 1675,  a = 0x8000})
  flood_define_level(false, LEVEL_HMC,              "c6",              { x = -1917, y = 2576, z =  2548, a =  0x8000 }, 3.0,  1,   FLOOD_WATER,  { x = 5173, y = -1475, z = -5738,  a = 0x0000 })  
  flood_define_level(false, LEVEL_LLL,              "c7",              { x =  5005,  y = 2710, z = 2935, a =  0x8000 }, 4.0,  1,   FLOOD_WATER, { x = -6611, y = -2368, z = 3147,  a = 0x8000 })
  flood_define_level(false, LEVEL_SSL,              "c8",              { x = 3774, y = 836, z =  3268, a =  0x8000 }, 2.0,  1,   FLOOD_LAVA,  { x = -1060, y = -218, z = 2729,  a = 0x6000 })
  flood_define_level(false, LEVEL_BITFS,            "b2",            { x = -394, y = 1999, z =  1704, a =  0x4000 }, 2.3,  1,   FLOOD_LAVA, { x = 3155, y = -664, z = -1497,  a = -0x4000 })
  flood_define_level(false, LEVEL_SL,               "c10",               { x =  -1519, y = 322, z =  1504, a =  0x8000 }, 3.0,  1,   FLOOD_LAVA, { x = 230, y = -1055, z = -2435,  a = -0x2000 })
  flood_define_level(false, LEVEL_WDW,              "c11",              { x = -7205,  y = 1554, z = -5637, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x = 334, y = -4326, z = 6311,  a = 0x8000 })
  flood_define_level(false, LEVEL_TTM,              "c12",              { x =  -4831,  y = 2181, z = 2515,  a =  0x8000 }, 1.8,  1,   FLOOD_SAND, { x = -4723, y = -204, z = 9620,  a = 0x4000 })
  flood_define_level(false, LEVEL_RR,               "c15",               { x =  63, y = 1895, z = 6396, a =  -0x4000 }, 1.5,  1,   FLOOD_MUD, { x = -6082, y = -1491, z = -9244,  a = 0x0000 })
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",        { x = -281, y = 240, z =  1571, a =  0x8000 }, 6.0,  1,   FLOOD_WATER, { x = -836, y = -561, z = -2593,  a = 0x0000 })
  flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",           { x = 705, y = 1440, z = 1910, a =  0x8000 }, 4.3,  1,   FLOOD_WATER, nil)
end

local function flood_load_luigi_the_violet_stars_levels()
    game = GAME_LUIGI_AND_THE_VIOLET_STARS
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Luigi and the Violet Stars"
	TEX_ROMHACK_LOGO = get_texture_info("luigi_and_the_violet_stars_logo")	

    flood_define_level(false, LEVEL_BOB,            "bob",            { x = 1318, y = 5982, z = -8447, a =  0x0000 }, 4.3,  1,  FLOOD_WATER, { x = -9167, y = -4689, z = 7907,  a = 0x8000 })
    flood_define_level(false, LEVEL_WF,          "wf",          { x = 3650, y = 2424, z = -9571, a =  0x4000 }, 2.5,  1,   FLOOD_MUD, { x = 659, y = -1298, z = -2274,  a = 0x4000 })
    flood_define_level(false, LEVEL_JRB,          "jrb",          { x = 3502, y = 8021, z = 16229, a =  0x4000 }, 4.5,  1,   FLOOD_MUD, { x = -2983, y = -1205, z = 1415,  a = 0x0000 })
    flood_define_level(false, LEVEL_CCM,          "ccm",          { x = -11537, y = 3143, z = 2185, a =  0x4000 }, 4.8,  1,   FLOOD_WATER, { x = 2198, y = -3009, z = 9459,  a = -0x4000 })
    flood_define_level(false, LEVEL_BITFS,          "bitfs",          { x = 2646, y = -378, z = 857, a = 0x8000 }, 1.6,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,          "bbh",          { x = -9099, y = 8326, z = 6691, a =  0x4000 }, 4.3,  1,   FLOOD_MUD, { x = -7382, y = -494, z = 210,  a = 0x0000 })
    flood_define_level(false, LEVEL_PSS,            "pss",            { x = -1092, y = 1380, z = -8974, a =  0x4000 }, 2.4,  1,   FLOOD_LAVA, { x = -10673, y = -1960, z = 11814,  a = 0x6000 })
    flood_define_level(false, LEVEL_LLL,            "lll",            { x = 1607, y = -973, z = 3462, a =  0x4000 }, 1.1,  1,   FLOOD_LAVA, { x = -9730, y = -4415, z = 720,  a = 0x4000 })
    flood_define_level(false, LEVEL_VCUTM,          "vcutm",          { x = -119, y = 1397, z = 2827, a = 0x8000 }, 1.6,  1,   FLOOD_WATER, { x = -597, y = 1120, z = -1825,  a = 0x0000 })
    flood_define_level(false, LEVEL_HMC,            "hmc",            { x = -1539, y = 6909, z = -5032, a =  0x1000 }, 2.1,  1,   FLOOD_WATER, { x = 3059, y = 2004, z = -180,  a = 0x3000 })
    flood_define_level(false, LEVEL_SSL,            "ssl",            { x = -11203, y = 1899, z = 3024, a =  0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 4315, y = -1578, z = 2769,  a = -0x2000 })
    flood_define_level(false, LEVEL_SA,          "sa",          { x = 8179, y = 3117, z = 1508, a =  0x4000 }, 7.2,  1,   FLOOD_WATER, { x = -3695, y = -917, z = 3271,  a = 0x8000 })
    flood_define_level(false, LEVEL_TOTWC,          "totwc",          { x = 14319, y = -2577, z = -1510, a =  0x4000 }, 1.5,  1,   FLOOD_SAND, { x = 2544, y = -4962, z = 4263,  a = 0x5000 })
    flood_define_level(false, LEVEL_DDD,            "ddd",            { x = -2074, y = 2292, z = 3353, a =  0x4000 }, 3.1,  1,   FLOOD_WATER, { x = -1539, y = -1104, z = 6242,  a = 0x8000 })
    flood_define_level(false, LEVEL_TTM,            "ttm",            { x = 6536, y = 1254, z = -4818, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x = 2016, y = -2528, z = -7471,  a = 0x3000 })
    flood_define_level(false, LEVEL_SL,             "sl",             { x = 4600, y = 2151, z = -7649, a =  0x4000 }, 2.2,  1,  FLOOD_WATER, { x = 11057, y = -2450, z = -6553,  a = -0x4000 })
    flood_define_level(false, LEVEL_COTMC,          "cotmc",          { x = -2285, y = 1, z = 6716, a =  0x4000 }, 2.5,  1,   FLOOD_LAVA, { x = 4874, y = -3596, z = -6258,  a = 0x8000 })
    flood_define_level(false, LEVEL_WDW,            "wdw",            { x = 3695, y = 2378, z = 2468, a =  0x8000 }, 3.1,  1,  FLOOD_SAND, { x = 2152, y = -5750, z = -3500,  a = 0x8000 })
    flood_define_level(false, LEVEL_THI,            "thi",            { x = -3212, y = 1023, z = 1049, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x = -3982, y = -1499, z = 3612,  a = 0x6000 })
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",          { x = 79, y = 1737, z = 50, a =  0x4000 }, 2.4,  1,   FLOOD_WATER, { x = -229, y = -2850, z = 5831,  a = 0x8000 })
    flood_define_level(false, LEVEL_TTC,            "ttc",            { x = -3582, y = 5563, z = 11391, a =  0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 830, y = -1840, z = 12544,  a = 0x8000 })
    flood_define_level(false, LEVEL_RR,             "rr",             { x = 2753, y = 1855, z = -3195, a =  0x4000 }, 1.3,  1,   FLOOD_LAVA, { x = -9110, y = -2526, z = 12390,  a = 0x6000 })
    flood_define_level(false, LEVEL_RR,             "rr",             { x = 9591, y = 336, z = 5055, a =  0x4000 }, 1.7,  1,   FLOOD_LAVA, { x = 9494, y = -2803, z = 3268,  a = -0x4000 })
    flood_define_level(false, LEVEL_BITS,          "bits",          { x = -9891, y = 978, z = 5513, a =  0x4000 }, 1.1,  1,   FLOOD_LAVA, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD,     "cc",          { x = 4834, y = 946, z = 6993, a =  0x4000 }, 1.5,  1,   FLOOD_MUD, { x = -361, y = -1308, z = 4712,  a = 0x8000 })
end

local function flood_load_ztar_attack_2_levels()
    game = GAME_ZTAR_ATTACK_2
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Ztar Attack 2 - A Blast to the Past"
    TEX_ROMHACK_LOGO = get_texture_info("ztar_attack_2_logo")			

    flood_define_level(false, LEVEL_BOB,              "c1",       { x = -15830, y =  1840, z = -23790, a = -0x2000 }, 3.0,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",       { x =  11615, y =  3935, z =  -2960, a = -0x4000 }, 2.0,  1, FLOOD_WATER, { x =  -2620, y = -3320, z =   5660, a =  0x6000 })
    flood_define_level(false, LEVEL_JRB,              "c3",       { x =  -5430, y =   430, z =   9215, a =  0x0000 }, 3.0,  1, FLOOD_WATER, { x =  11595, y = -1905, z =  -1140, a =  0x4000 })
    flood_define_level(false, LEVEL_BITDW,            "b1",       { x =   1890, y =  6740, z =  11790, a =  0x8000 }, 1.5,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",       { x =  22240, y =  -600, z = -19895, a = -0x2000 }, 1.75, 1, FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_BBH,              "c5",       { x =  27610, y =  -670, z = -13420, a =  0x8000 }, 1.75, 1, FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_HMC,              "c6",       { x =   7330, y = 10845, z =   4640, a =  0x0000 }, 1.5,  1, FLOOD_SAND,  { x = -11810, y = -7425, z =  12345, a =  0x8000 })
    flood_define_level(false, LEVEL_BITFS,            "b2",       { x =   8915, y =   130, z =  -7050, a =  0x0000 }, 1.75, 1, FLOOD_SAND,  { x = -14515, y = -4545, z =   9020, a =  0x4000 })
    flood_define_level(false, LEVEL_LLL,              "c7",       { x =  16895, y =   685, z =   7270, a =  0x4000 }, 1.5,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",       { x =   9330, y =  1310, z =  -5660, a = -0x4000 }, 1.0,  1, FLOOD_WATER, { x =  -6960, y =  6705, z =  10375, a =  0x8000 })
    flood_define_level(false, LEVEL_DDD,              "c9",       { x = -16195, y =  1035, z =  -5050, a =  0x4000 }, 3.25, 1, FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",       { x = -21270, y =  6310, z = -11970, a = -0x4000 }, 2.5,  1, FLOOD_MUD,   { x =  22298, y = -8174, z =   2135, a = -0x4000 })
    flood_define_level(false, LEVEL_SL,               "c10",      { x =   5897, y =  1332, z =   9064, a = -0x4000 }, 1.5,  1, FLOOD_WATER, { x =  17401, y = -1386, z =  -4598, a =  0x8000 })
    flood_define_level(false, LEVEL_TTM,              "c12",      { x =   9841, y =  5141, z =  -7024, a =  0x0000 }, 2.5,  1, FLOOD_WATER, { x = -11066, y = -3956, z =  20912, a =  0x8000 })
    flood_define_level(false, LEVEL_VCUTM,            "vc-2",     { x = -18605, y =  9785, z =   3100, a =  0x4000 }, 3.0,  1, FLOOD_WATER, { x =  13420, y =  1930, z =   1445, a =  0x8000 })	
    flood_define_level(false, LEVEL_THI,              "c13",      { x = -15729, y =  2200, z =   1098, a =  0x4000 }, 1.25, 1, FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TTC,              "c14",      { x = -15559, y =  1649, z =   4903, a =  0x8000 }, 1.5,  1, FLOOD_LAVA, { x =    6593, y = -2614, z =  12598, a =  0x8000 })
    flood_define_level(false, LEVEL_RR,               "c15",      { x =   1240, y =   705, z =  19870, a =  0x4000 }, 1.5,  1, FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_BITS,             "b3",       { x = -16605, y =  5030, z =  22805, a =  0x8000 }, 2.0,  1, FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_BITS,             "b3-2",     { x =  12380, y =   -55, z = -15720, a =  0x4000 }, 2.5,  1, FLOOD_LAVA,  { x =  13005, y =   510, z =  12270, a =  0x4000 })		
    flood_define_level(false, LEVEL_BITS,             "b3-3",     { x =  12200, y =  2610, z =  -9325, a =  0x8000 }, 2.0,  1, FLOOD_LAVA,  { x =  11325, y = -5090, z =  -1565, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITS,             "b3-4",     { x = -23880, y = -1640, z = -14830, a =  0x0000 }, 17.5, 1, FLOOD_LAVA,  { x =  -6885, y =  -685, z = -14680, a = -0x4000 })		
    flood_define_level(false, LEVEL_TOTWC,            "wc",       { x =    515, y = 12170, z =  -7610, a =  0x6000 }, 10.0, 1, FLOOD_LAVA,  { x =   -654, y =   958, z =  15222, a =  0x6000 })
    flood_define_level(false, LEVEL_SA,               "sa",       { x =  24190, y = 13790, z =   9010, a = -0x2000 }, 2.0,  1, FLOOD_WATER, { x =  -3861, y = -4979, z =  13371, a =  0x7000 })
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",    { x = -15830, y =  1840, z = -23790, a = -0x2000 }, 2.5,  1, FLOOD_WATER, { x =  15270, y = -2900, z =  20250, a =  0x8000 })		
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",       { x =  11020, y =  -265, z =  -2760, a =  0x4000 }, 3.0,  1, FLOOD_WATER, { x =  -3925, y = -1775, z =   9625, a =  0x8000 })		
end

-- Dream64 ported to flood by SuperRodrigo0
local function flood_load_dream64_levels()
    game = GAME_DREAM64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Dream 64"
	TEX_ROMHACK_LOGO = get_texture_info("dream_64_logo")	
 
    flood_define_level(false, LEVEL_BOB,              "c1",            { x = -5543, y =  5279, z =  4661, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x =    740, y =   667, z =  3159,  a =  0x8000 })
    flood_define_level(false, LEVEL_WF,               "c2",            { x =     0, y =     0, z = -2448, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x =      0, y = -2249, z = 12126,  a =  0x8000 })
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",         { x = -5942, y =  6828, z = -5250, a =  0x2000 }, 3.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "sa",            { x =     5, y =  1769, z =   996, a =  0x0000 }, 2.7,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "c3",            { x = -5746, y =   924, z = -2496, a =  0x4000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_JRB,              "c3-2",          { x = -5746, y =   924, z = -2496, a =  0x4000 }, 2.0,  2,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",            { x = -1357, y =  1640, z =   647, a = -0x4000 }, 2.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -142, y =  1653, z = -4448, a =  0x0000 }, 5.0,  1,   FLOOD_WATER, { x = -14304, y = -3589, z = -3444,  a =  0x8000 })
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",      { x =   -94, y =  1791, z =  2646, a =  0x8000 }, 3.5,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "c",             { x =     3, y =   678, z = -9414, a =  0x8000 }, 4.0,  1,   FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_PSS,              "pss",           { x =  -987, y =   -98, z = -4534, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",            { x =   -25, y =  2013, z = -1753, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x =    941, y =  -713, z = -2195,  a =  0x8000 })
end

-- SM64 Twisted Adventures ported to Flood by SuperRodrigo0
local function flood_load_sm64_twisted_adventures_levels()
    game = GAME_SM64_TWISTED_ADVENTURES 
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Super Mario 64 - Twisted Adventures"
	TEX_ROMHACK_LOGO = get_texture_info("twisted_adventures_logo")
	
    flood_define_level(false, LEVEL_BOB,              "c1",         { x = 5165, y = 1991, z = 1622, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = -1042, y = -1011, z = -3067,  a = 0x4000 })
    flood_define_level(false, LEVEL_CCM,              "c4",         { x = -1067, y = 3027, z = 5266, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 3005, y = 618, z = -3273,  a = 0x0000 })	
    flood_define_level(false, LEVEL_BBH,              "c5",         { x = 1621, y = 1854, z = 1872, a =  0x0000 }, 0.62,  1,   FLOOD_WATER, { x = -4840, y = 93, z = 4813,  a = 0x5000 })
    flood_define_level(false, LEVEL_COTMC,            "mc",       { x = -5128, y = 4305, z = 3054, a =  0x4000 }, 1.8,  1,   FLOOD_WATER, { x = 1768, y = -254, z = -2009,  a = 0x4000 })		
    flood_define_level(false, LEVEL_BITDW,            "b1",       { x = -2051, y = 2747, z = -1085, a =  0x8000 }, 0.5,  1,   FLOOD_LAVA, { x = -3137, y = -2524, z = -5071,  a = 0x0000 })	
    flood_define_level(false, LEVEL_HMC,              "c6",         { x = 4690, y = 4314, z = -5577, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = -6112, y = -4266, z = 5985,  a = 0x4000 })
    flood_define_level(false, LEVEL_LLL,              "c7",         { x = -1111, y = 4313, z = -2819, a =  0x8000 }, 1.6,  1,   FLOOD_LAVA, { x = 2796, y = -465, z = 337,  a = -0x6000 })		
    flood_define_level(false, LEVEL_SSL,              "c8",          { x = 2265, y = 2430, z = -187, a =  -0x4000 }, 3.0,  1,   FLOOD_SAND, { x = 5361, y = -3464, z = 5510,  a = 0x8000 })	
    flood_define_level(false, LEVEL_SSL,              "c8",          { x = 5596, y = 346, z = -4257, a = 0x8000 }, 1.0,  1,   FLOOD_SAND, { x = 4200, y = -646, z = -1385,  a = 0x8000 })	
    flood_define_level(false, LEVEL_DDD,              "c9",         { x = -1703, y = 1072, z = -1414, a =  0x6000 }, 1.4,  1,   FLOOD_WATER, { x = 2925, y = -559, z = 5064,  a = 0x8000 })	
    flood_define_level(false, LEVEL_PSS,              "pss",         { x = 4294, y = 2150, z = 4555, a =  0x0000 }, 2.1,  1,   FLOOD_WATER, { x = -6048, y = -1770, z = -5600,  a = 0x4000 })
    flood_define_level(false, LEVEL_BITFS,            "b2",       { x = 531, y = 1332, z = 1881, a =  0x4000 }, 1.0,  1,   FLOOD_MUD, { x = -4688, y = -929, z = 5644,  a = 0x6000 })	
    flood_define_level(false, LEVEL_SL,               "c10",          { x = 4549, y = 6643, z = -5793, a =  0x0000 }, 2.5,  1,   FLOOD_SAND, { x = -679, y = -1079, z = -2916,  a = -0x2000 })
    flood_define_level(false, LEVEL_WDW,              "c11",         { x = 4714, y = 704, z = 6992, a =  -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 5469, y = -2923, z = -5293,  a = -0x4000 })	
    flood_define_level(false, LEVEL_TTM,              "c12",         { x = -834, y = -535, z = 2520, a =  0x2000 }, 2.5,  1,   FLOOD_WATER, { x = -2206, y = -2066, z = -3939,  a = 0x0000 })
    flood_define_level(false, LEVEL_THI,              "c13",         { x = -4583, y = -587, z = 4529, a =  0x4000 }, 1.0,  1,   FLOOD_WATER, { x = 2228, y = -6830, z = -4446,  a = 0x2000 })
    flood_define_level(false, LEVEL_TOTWC,            "wc",       { x = 4338, y = 3586, z = -5976, a =  0x0000 }, 0.7,  1,   FLOOD_LAVA, { x = 5233, y = -1459, z = 4829,  a = -0x6000 })
    flood_define_level(false, LEVEL_TTC,              "c14",         { x = 3468, y = 397, z = 5232, a =  0x8000 }, 0.6,  1,   FLOOD_LAVA, { x = 6776, y = -2743, z = -5145,  a = -0x4000 })
    flood_define_level(false, LEVEL_RR,               "c15",          { x = 5685, y = 713, z = 1789, a =  0x0000 }, 1.6,  1,   FLOOD_MUD, nil)	
    flood_define_level(false, LEVEL_VCUTM,            "vc",       { x = 938, y = 1829, z = -5000, a = -0x4000 }, 1.8,  1,   FLOOD_WATER, { x = -2081, y = -777, z = 2494,  a = 0x4000 })
    flood_define_level(false, LEVEL_BITS,             "b3",        { x = 6810, y = -1171, z = -5163, a =  0x0000 }, 1.0,  1,   FLOOD_LAVA, { x = -6136, y = -1007, z = 7435,  a = 0x4000 })	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",   { x = 206, y = 587, z = -2592, a =  -0x2000 }, 1.8,  1,   FLOOD_LAVA, nil)
end

-- Super Mario Bros 64 ported to Flood by SuperRodrigo0
local function flood_load_super_mario_bros_64_levels()
    game = GAME_SUPER_MARIO_BROS_64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario Bros 64"
	TEX_ROMHACK_LOGO = get_texture_info("super_mario_bros_64_logo")	

    flood_define_level(false, LEVEL_BOB,            "c1",            { x = 233, y = -171, z = 7516, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, { x = 150, y = 405, z = -12091,  a = 0x0000 })
    flood_define_level(false, LEVEL_WF,             "c2",             { x = 0, y = -809, z = 9671, a =  0x8000 }, 1.5,  1,   FLOOD_WATER, { x = 101, y = -724, z = -6056,  a = 0x0000 })
    flood_define_level(false, LEVEL_JRB,            "c3",            { x = 6665, y = -398, z = -272, a = -0x4000 }, 2.0,  1,   FLOOD_WATER, { x = -9271, y = -78, z = -150,  a = 0x4000 })
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x = -10, y = -555, z = 7628, a =  0x8000 }, 1.0,  1,   FLOOD_LAVA, { x = -42, y = 46, z = -6275,  a = 0x0000 })
    flood_define_level(false, LEVEL_HMC,            "c6",            { x = 1526, y = -365, z = -1010, a =  0x0000 }, 1.0,  1,   FLOOD_WATER, { x = -1536, y = 73, z = -2600, a = 0x0000 })
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x = -0, y = -340, z = 6563, a =  0x8000 }, 1.0,  1,   FLOOD_LAVA, { x = -23, y = 250, z = -9651, a = 0x0000 })
end

local function flood_load_winterbottom_pie_trials()
    game = GAME_WINTERBOTTOM_PIE_TRIALS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Winterbottom's Pie Trials"	

    flood_define_level(false, LEVEL_PSS,            "pss", { x =     0, y = 10550, z =  9015, a =  0x8000 }, 4.0,  1, FLOOD_WATER, { x = -9655, y = -6330, z = 4325, a = 0x4000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",  { x = -5350, y =  6095, z = -2820, a =  0x4000 }, 1.75, 1, FLOOD_WATER, nil)
end	

local function flood_load_sm64_into_bowsers_castle_levels()
    game = GAME_SM64_INTO_BOWSERS_CASTLE
    LEVEL_LOBBY = LEVEL_CASTLE
    romhackText = "Super Mario 64: Into Bowser's Castle"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_into_bowsers_castle_logo")	
    hook_behavior(id_bhvDoorWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	

    flood_define_level(false, LEVEL_BOB,              "c1",        { x =  -4203, y =   715, z =   3083, a =   0x4000 }, 5.0,  1,  FLOOD_WATER, { x =   -566, y = -4942, z =  -781, a = -0x4000 }) 
    flood_define_level(false, LEVEL_WF,               "c2",        { x =  -1576, y =  2048, z =  -3218, a =   0x8000 }, 2.4,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",        { x = -14806, y =  3599, z =   2203, a =   0x4000 }, 2.7,  1,  FLOOD_WATER, { x =  12341, y = -1111, z =  2188, a = -0x4000 })	
    flood_define_level(false, LEVEL_CCM,              "c4",        { x =  -6155, y = -2250, z = -13934, a =   0x0000 }, 2.2,  1,  FLOOD_WATER, { x =  -6262, y = -2250, z = 14449, a =  0x8000 })
    flood_define_level(false, LEVEL_BBH,              "c5",        { x =   2467, y =  -216, z =  -3989, a =   0x8000 }, 3.3,  1,  FLOOD_WATER, { x =  -4143, y = -1766, z = -1430, a =  0x8000 })	
    flood_define_level(false, LEVEL_PSS,              "pss",       { x =  -3756, y =  4000, z =  -6244, a =   0x0000 }, 4.0,  1,  FLOOD_WATER, { x =  -6442, y =   820, z = -3666, a =  0x7500 })
    flood_define_level(false, LEVEL_BITDW,            "b1",        { x =    146, y = 11124, z =   3374, a =  -0x8000 }, 3.5,  1,  FLOOD_WATER, { x =    406, y =  1000, z =  8914, a =  0x8000 }) 
    flood_define_level(false, LEVEL_HMC,              "c6",        { x =    932, y =  4400, z = -10044, a = -0x10000 }, 4.5,  1,  FLOOD_WATER, { x =   -315, y = -3244, z =   662, a =  0x4000 })
    flood_define_level(false, LEVEL_TOTWC,            "wc",        { x =     50, y = -2362, z = -21732, a =   0x0000 }, 5.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_LLL,              "c7",        { x =   1906, y =  2780, z =  -4379, a =   0x0000 }, 6.1,  1,  FLOOD_LAVA,  { x =  -3422, y = -2650, z = 12970, a =  0x7000 })
    flood_define_level(false, LEVEL_SA,               "sa",        { x =    367, y =   872, z =   7471, a =   0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",       { x =   2682, y =  6239, z =   8317, a =   0x8000 }, 4.6,  1,  FLOOD_WATER, { x = -10487, y = -1979, z =  9737, a =  0x4000 })
    flood_define_level(false, LEVEL_BITFS,            "b2",        { x =    200, y =  5725, z =   8936, a =   0x4000 }, 1.45, 1,  FLOOD_WATER, { x =    381, y =   250, z =   337, a =  0x0000 })
    flood_define_level(false, LEVEL_TTM,              "c12",       { x =   6885, y =  2000, z = -14967, a =   0x0000 }, 4.0,  1,  FLOOD_MUD,   { x =   1898, y =   640, z = -2477, a =  0x8000 })
    flood_define_level(false, LEVEL_THI,              "c13",       { x =  21998, y =   500, z =  -3433, a =  -0x4000 }, 1.6,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTC,              "c14",       { x =   9735, y =  4000, z =   5996, a =  -0x4000 }, 2.8,  1,  FLOOD_MUD,   { x =   9755, y =   175, z =  6000, a = -0x4000 })
    flood_define_level(false, LEVEL_TTC,              "c14-2",     { x =    347, y =  4450, z =   4126, a =  -0x4000 }, 4.0,  1,  FLOOD_WATER, { x =   2200, y =   355, z =  4000, a =  0x0000 })
    flood_define_level(false, LEVEL_TTC,              "c14-3",     { x =   5611, y =  4415, z =   5631, a =  -0x4000 }, 2.8,  1,  FLOOD_LAVA,  { x =   5940, y =   355, z =  5100, a =  0x0000 })
    flood_define_level(false, LEVEL_TTC,              "c14-4",     { x =   1395, y =  4500, z =    331, a =  -0x4000 }, 2.8,  1,  FLOOD_MUD,   { x =   2132, y =   355, z =   251, a = -0x4000 })
    flood_define_level(false, LEVEL_TTC,              "c14-5",     { x =   9744, y =  4500, z =    208, a =  -0x4000 }, 2.8,  1,  FLOOD_MUD,   { x =   9748, y =   175, z =  2246, a =  0x8000 })
    flood_define_level(false, LEVEL_RR,               "c15",       { x =   8194, y =  2287, z =   5047, a =   0x0000 }, 3.0,  1,  FLOOD_LAVA,  { x =   6838, y =  -254, z = 10843, a =  0x8000 })
    flood_define_level(false, LEVEL_BITS,             "b3",        { x =   6750, y = 10750, z =   1860, a =   0x2000 }, 2.0,  1,  FLOOD_LAVA,  { x =    477, y =   701, z =  1402, a =  0x0000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",        { x =    -50, y =  4450, z =  10220, a =  -0x4000 }, 1.5,  1,  FLOOD_LAVA,  { x =    -70, y =  2200, z = 11550, a =  0x0000 })	
    flood_define_level(false, LEVEL_CASTLE,           "c",         { x =  -1000, y =  4600, z =   2805, a =   0x8000 }, 4.0,  1,  FLOOD_WATER, { x =      0, y = -2770, z =     0, a =  0x8000 })		
end

-- Servus 64 Renewed by SuperRodrigo0
local function flood_load_servus_64_levels()
    game = GAME_SERVUS_64
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Servus 64"
	TEX_ROMHACK_LOGO = get_texture_info("servus_64_logo")	
	
    flood_define_level(false, LEVEL_BOB,              "c1",          { x =   7783, y =  2838, z =  -4916, a =  0x0000 }, 1.7,  1,  FLOOD_WATER, { x =   -935, y =   695, z =   618, a =  0x4000 })	
    flood_define_level(false, LEVEL_WF,               "c2",          { x =  -2912, y =  2692, z =  -7283, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =    406, y =   992, z = -1528, a =  0x4000 })
    flood_define_level(false, LEVEL_JRB,              "c3",          { x =  -6680, y =   801, z =   1441, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x =   9941, y = -1889, z =  1669, a = -0x4000 })
    flood_define_level(false, LEVEL_TOTWC,            "wc",          { x =    778, y =  3146, z =  20658, a = -0x4000 }, 15.0, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",         { x =  12707, y = 14048, z =   8011, a =  0x8000 }, 3.4,  1,  FLOOD_LAVA,  { x =  -3857, y =  5798, z =  3548, a =  0x4000 })	
    flood_define_level(false, LEVEL_CCM,              "c4",          { x =  -3967, y =  6063, z =  -4473, a =  0x0000 }, 2.8,  1,  FLOOD_WATER, { x =    473, y =  2047, z =  5123, a = -0x4000 })	
    flood_define_level(false, LEVEL_BBH,              "c5",          { x =  11292, y =  2672, z = -17666, a =  0x0000 }, 0.45, 1,  FLOOD_LAVA,  { x =    -25, y =  2672, z = -1391, a =  0x8000 })
    flood_define_level(false, LEVEL_BITDW,            "b1",          { x =    506, y =  9337, z =  -1686, a =  0x4000 }, 2.5,  1,  FLOOD_MUD,   { x =  -6338, y =  3833, z = -1976, a =  0x4000 })	
    flood_define_level(false, LEVEL_COTMC,            "mc",          { x =     68, y =  4152, z = -12311, a =  0x0000 }, 0.4,  1,  FLOOD_LAVA,  { x =   9915, y =  3324, z =  1550, a = -0x4000 })	
    flood_define_level(false, LEVEL_COTMC,            "mc-2",        { x =  12737, y =  3086, z = -21147, a =  0x4000 }, 0.7,  1,  FLOOD_LAVA,  { x =  11895, y =   392, z = -8998, a =  0x4000 })
    flood_define_level(false, LEVEL_HMC,              "c6",          { x =   1355, y =  8171, z =  -1479, a =  0x0000 }, 1.2,  1,  FLOOD_WATER, { x =   1259, y =  1170, z =  -672, a =  0x8000 })
    flood_define_level(false, LEVEL_HMC,              "c6-2",        { x = -14081, y = 13982, z =   6533, a = -0x4000 }, 2.4,  1,  FLOOD_SAND,  { x = -14809, y = 11983, z =  5667, a = -0x4000 })
    flood_define_level(false, LEVEL_LLL,              "c7",          { x =  -1678, y =  4171, z = -10116, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =    133, y =   466, z =   739, a =  0x4000 })		
    flood_define_level(false, LEVEL_SSL,              "c8",          { x =   6159, y =  7405, z =   3010, a =  0x4000 }, 1.3,  1,  FLOOD_LAVA,  { x =   -526, y =   471, z = -4991, a =  0x0000 })
    flood_define_level(false, LEVEL_DDD,              "c9",          { x =  14493, y =  4475, z =   3468, a =  0x8000 }, 0.4,  1,  FLOOD_LAVA,  { x =  -7731, y =  4582, z =  3546, a = -0x8000 })	
    flood_define_level(false, LEVEL_SL,               "c10",         { x =  -7168, y =  6567, z =   1419, a =  0x4000 }, 1.5,  1,  FLOOD_SAND,  { x =  -9770, y =   498, z =  5829, a =  0x8000 })
    flood_define_level(false, LEVEL_WDW,              "c11",         { x = -12896, y =  5485, z =  10515, a =  0x4000 }, 0.7,  1,  FLOOD_LAVA,  { x =  12765, y =  3122, z =   705, a = -0x4000 })
    flood_define_level(false, LEVEL_BITFS,            "b2",          { x =   3980, y = 16591, z =    333, a =  0x8000 }, 2.3,  1,  FLOOD_LAVA,  { x =  -3996, y =  5428, z =  8381, a =  0x8000 })
    flood_define_level(false, LEVEL_VCUTM,            "vc",          { x =    721, y =  7169, z =   7277, a =  0x8000 }, 1.0,  1,  FLOOD_WATER, { x =    664, y =  2159, z =  -322, a =  0x8000 })
    flood_define_level(false, LEVEL_THI,              "c13",         { x =  13694, y =  7747, z =  -2469, a =  0x4000 }, 0.7,  1,  FLOOD_SAND,  { x =   4557, y =  2938, z =  1607, a =  0x0000 })
    flood_define_level(false, LEVEL_TTC,              "c14",         { x =  -2160, y =  2958, z =  -6415, a = -0x4000 }, 1.0,  1,  FLOOD_MUD,   { x =   4178, y =   411, z =  4338, a = -0x4000 })	
    flood_define_level(false, LEVEL_RR,               "c15",         { x = -10311, y =  9952, z = -14529, a =  0x0000 }, 2.4,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BITS,             "b3",          { x =   9811, y = 16131, z =    847, a =  0x8000 }, 1.1,  1,  FLOOD_SAND,  { x =   7742, y =  2383, z =  4686, a =  0x8000 })
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",       { x =     -7, y = 14477, z =   1965, a =  0x4000 }, 1.5,  1,  FLOOD_WATER, { x =     -9, y = 12625, z =  4889, a =  0x8000 })
    flood_define_level(false, LEVEL_SA,               "sa",          { x =     25, y =  7467, z = -10961, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, { x =      0, y =  7538, z =   727, a = -0x8000 })
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",          { x =   2318, y =  1949, z = -18991, a =  0x4000 }, 1.0,  1,  FLOOD_LAVA,  { x =    464, y =  -593, z = 17089, a =  0x8000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",          { x =   4940, y =   938, z =   8416, a =  0x8000 }, 2.57, 1,  FLOOD_LAVA,  nil)
end

local function flood_load_super_mario_and_the_cursed_castle_levels()
    game = GAME_CURSED_CASTLES
    LEVEL_LOBBY = LEVEL_JRB
	romhackText = "Super Mario and the Cursed Castles"
	TEX_ROMHACK_LOGO = get_texture_info("cursed_castles_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =   -920, y =   5430, z =  -4675, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x = 12225, y =    250, z = -14600, a = -0x4000})
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   3620, y =   5540, z =  10460, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   5085, y =   5135, z =   -170, a = -0x4000 }, 1.75, 1,  FLOOD_WATER, { x = -5230, y =    510, z = -11100, a =  0x8000})
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =  -4670, y =   5850, z =  -1930, a =  0x8000 }, 3.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =  -7945, y =   2955, z =  -8705, a =  0x8000 }, 2.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =   4880, y =   4495, z = -21395, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x = 11470, y =    560, z =  -3175, a =  0x0000})	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =   5110, y =   7380, z =  -3660, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, { x = 10865, y =    195, z =  -4270, a =  0x0000})
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  19965, y =   7875, z = -19820, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =    235, y =   7675, z =     50, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =   8495, y =   4320, z =   9745, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",            { x =   -270, y =   9530, z =   4670, a =  0x4000 }, 3.0,  1,  FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =  26265, y =   3770, z = -15150, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =  13365, y =  11510, z = -14120, a =  0x0000 }, 2.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_THI,              "c13",            { x =  -8910, y =   7410, z = -10160, a =  0x0000 }, 2.5,  1,  FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_TTC,              "c14",            { x =   3360, y =   3895, z =   4370, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",             { x = -14805, y =   5005, z = -10365, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  11055, y =   1625, z =  -5490, a = -0x4000 }, 7.75, 1,  FLOOD_WATER, { x = 10360, y =      0, z =  -1940, a = -0x4000})	
end

local function flood_load_marios_nightmare_64_levels()
    game = GAME_MARIOS_NIGHTMARE_64
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Mario's Nightmare 64"
	TEX_ROMHACK_LOGO = get_texture_info("marios_nightare_64_logo")	

    flood_define_level(false, LEVEL_BOB,            "c1",            { x =  -3750, y =  4710, z = -5485, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =  5050, y = -3540, z = -2615, a = -0x4000 })
    flood_define_level(false, LEVEL_BITDW,          "b1",            { x =  -2110, y =   960, z =  1170, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_COTMC,          "mc",            { x =  -2735, y =  1870, z =  1780, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -670, y = -1000, z =    30, a =  0x4000 })	
    flood_define_level(false, LEVEL_JRB,            "c3",            { x =  -1770, y = -2090, z = -2350, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,            "c4",            { x =  -3320, y =  4730, z =   835, a =  0x9000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,            "c5",            { x =    255, y =  1960, z =     0, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x = -2405, y = -1480, z =   755, a =  0x4000 })
    flood_define_level(false, LEVEL_HMC,            "c6",            { x =   5975, y =  4670, z = -5220, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_DDD,            "c9",            { x =   1680, y =  5705, z = -2565, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =   150, y = -3920, z = -2355, a =  0x0000 })		
    flood_define_level(false, LEVEL_SL,             "c10",           { x =  -1605, y =   120, z =  3143, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,          "b2",            { x =   6760, y =   420, z =     0, a = -0x4000 }, 1.0,  1,  FLOOD_WATER, { x = -4485, y =   495, z =   -55, a =  0x4000 })	
    flood_define_level(false, LEVEL_BITFS,          "b2-2",          { x =   5000, y =  6420, z = -5390, a = -0x4000 }, 0.6,  1,  FLOOD_LAVA,  { x = -6660, y =  5400, z =  6050, a =  0x4000 })
    flood_define_level(false, LEVEL_PSS,            "pss",           { x =  -4675, y =  6780, z =  4380, a =  0x8000 }, 14.0, 1,  FLOOD_WATER, { x = -1300, y = -4780, z =  -545, a = -0x4000 })	
    flood_define_level(false, LEVEL_PSS,            "pss-2",         { x =  -3990, y = -1035, z =  1975, a = -0x4000 }, 2.5,  1,  FLOOD_LAVA,  { x = -6160, y = -4000, z =  1700, a =  0x4000 })		
    flood_define_level(false, LEVEL_WDW,            "c11",           { x =   -170, y =  5695, z = -1365, a =  0x0000 }, 2.9,  1,  FLOOD_WATER, { x = -6459, y = -3481, z =  6845, a =  0x2000 })	
    flood_define_level(false, LEVEL_WDW,            "c11-2",         { x =   6312, y =  1027, z =  3143, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  { x =  6158, y = -5580, z =  1910, a = -0x4000 })
    flood_define_level(false, LEVEL_WDW,            "c11-3",         { x =  -2039, y =  1616, z = -3378, a =  0x4000 }, 1.2,  1,  FLOOD_SAND,  { x = -4613, y = -6464, z = -1552, a =  0x0000 })
    flood_define_level(false, LEVEL_WDW,            "c11-2",         { x =   3926, y =  1196, z = -7153, a =  0x0000 }, 1.7,  1,  FLOOD_LAVA,  { x =   -41, y = -5076, z = -4797, a =  0x4000 })
    flood_define_level(false, LEVEL_TTM,            "c12",           { x =   4145, y =  3985, z =  2820, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  2505, y = -1969, z =  -776, a = -0x1000 })
    flood_define_level(false, LEVEL_THI,            "c13",           { x =  -1395, y =  4880, z =  2320, a =  0x4000 }, 2.0,  1,  FLOOD_MUD,   { x =   140, y = -3135, z = -1995, a =  0x2000 })
    flood_define_level(false, LEVEL_TTC,            "c14",           { x =   4170, y =  7340, z = -4440, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,             "c15",           { x =   2657, y =  6601, z = -6950, a =  0x0000 }, 2.4,  1,  FLOOD_WATER, { x =  6852, y = -1677, z = -6844, a = -0x2000 })
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",         { x =  -2391, y =  3179, z =  1870, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x = -1100, y = -4353, z =   603, a = -0x1800 })	
    flood_define_level(false, LEVEL_BITS,           "b3",            { x =   3470, y =  4790, z = -4800, a =  0x8000 }, 2.0,  1,  FLOOD_LAVA,  { x =  7065, y = -3300, z =   970, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITS,           "b3-2",          { x =  -4123, y =  3823, z =   694, a =  0x8000 }, 1.40, 1,  FLOOD_LAVA,  { x = -3848, y = -6568, z = -2568, a =  0x8000 })
end

local function flood_load_marios_treasure_dome_levels()
    game = GAME_MARIOS_TREASURE_DOME
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Mario's Treasure Dome"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")		
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	

    flood_define_level(false, LEVEL_BOB,            "c1",         { x = -2440, y =  2670, z = -4090, a =  0x2000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WF,             "c2",         { x = -1260, y =  -920, z = -3205, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_JRB,            "c3",         { x =   425, y =  -320, z =  -210, a = -0x4000 }, 1.75, 1,  FLOOD_MUD,   nil)		
    flood_define_level(false, LEVEL_PSS,            "pss",        { x =  1590, y =   135, z = -3220, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x = -1910, y = -1625, z = -3505, a = -0x4000 })
    flood_define_level(false, LEVEL_PSS,            "pss-2",      { x =  2225, y =   675, z =  6310, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  -160, y = -2020, z =  1740, a =  0x4000 })	
    flood_define_level(false, LEVEL_SA,             "sa",         { x =  6370, y = -3560, z =   475, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, { x =  1810, y = -3770, z =   385, a =  0x4000 })
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",      { x =  1700, y =  -745, z =   765, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_COTMC,          "mc",         { x =  1745, y =   325, z =   -75, a = -0x4000 }, 3.5,  1,  FLOOD_LAVA,  nil) 
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",         { x =   300, y =  -370, z =  -610, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)			
end

local function flood_load_rainbow_road_levels()
    game = GAME_SUPER_MARIO_RAINBOW_ROAD
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario Rainbow Road"
	TEX_ROMHACK_LOGO = get_texture_info("rainbow_road_logo")	

    flood_define_level(false, LEVEL_BOB,            "c1",           { x = 4270, y = -340, z = -90, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x = -1240, y = -3300, z = -1910, a = 0x2000})
    flood_define_level(false, LEVEL_WF,             "c2",           { x = -5530, y = 5670, z = -3555, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = 3120, y = -1450, z = -4760, a = 0x0000})
    flood_define_level(false, LEVEL_JRB,            "c3",           { x = 4585, y = 1465, z = 1600, a = 0x4000 }, 2.0,  1,   FLOOD_WATER, { x = -3985, y = -1415, z = -800, a = 0x4000})		
    flood_define_level(false, LEVEL_CCM,            "c4",           { x = -5235, y = 2255, z = -5925, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,            "c5",           { x = -3890, y = 460, z = -5940, a = 0x4000 }, 1.75, 1, FLOOD_MUD, { x = 4020, y = -940, z = -2890, a = 0x0000})	
    flood_define_level(false, LEVEL_TOTWC,          "wc",           { x = 5015, y = 7480, z = 1620, a = -0x4000 }, 2.5,  1,   FLOOD_WATER, { x = -3160, y = -2045, z = -3460, a = 0x3000})
    flood_define_level(false, LEVEL_COTMC,          "mc",           { x = 620, y = 710, z = 5150, a = 0x8000 }, 3.5,  1,   FLOOD_LAVA, { x = -2010, y = -700, z = -2940, a = 0x2000})	
    flood_define_level(false, LEVEL_HMC,            "c6",           { x = 6050, y = 3210, z = -4520, a =  -0x4000 }, 1.5,  1,   FLOOD_WATER, { x = -3430, y = -240, z = 2480, a = 0x8000})
    flood_define_level(false, LEVEL_LLL,            "c7",           { x = -5255, y = 4015, z = 2495, a = 0x8000 }, 2.75,  1,   FLOOD_WATER, { x = -6360, y = -1105, z = -6645, a = 0x4000})	
    flood_define_level(false, LEVEL_BITDW,          "b1",           { x = -2240, y = 4030, z = -225, a = -0x4000}, 2.25, 1,   FLOOD_LAVA, { x = 6400, y = -3810, z = 5490, a = 0x4000}) 
    flood_define_level(false, LEVEL_BITS,           "b3",           { x = 3250, y = 3905,  z = -895,  a = -0x4000 }, 2.0,  1,   FLOOD_LAVA, { x = 2535, y = -2595, z = -3390, a = 0x0000})
    flood_define_level(false, LEVEL_PSS,            "pss",          { x = 600, y = 1290,  z = -1445,  a = 0x0000 }, 2.75,  1,   FLOOD_LAVA, { x = 65, y = -295, z = -2435, a = 0x0000})
    flood_define_level(false, LEVEL_SA,             "sa",           { x =    5, y = 650,  z = -4175,  a = 0x0000 }, 7.0,  1,   FLOOD_WATER, { x = 25, y = -250, z = 4515, a = 0x8000})		
end

-- Star Revenge 2 Night Of Doom, ported to Flood by SuperRodrigo0
local function flood_load_star_revenge_2_levels()
    game = GAME_STAR_REVENGE_2
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Star Revenge 2: Night Of Doom"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_2_act_2_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",              { x =  4380, y = 1163, z =  -5434, a =  0x9000 }, 1.5,  1,   FLOOD_WATER, { x = 2956, y = -3756, z = -3887, a = 0x0000 })
    flood_define_level(false, LEVEL_WF,               "c2",               { x = 2307, y = 3637, z = 2592, a =  -0x2000 }, 2.9,  1,   FLOOD_LAVA, { x = -1244, y = -4463, z = 8620, a = 0x0000 })
    flood_define_level(false, LEVEL_JRB,              "c3",              { x = -1687, y = 3799, z = 9599,  a =  -0x3000 }, 0.5,  1,   FLOOD_WATER, { x = -3553, y = -989, z = -8749, a = 0x0000 })	
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = 14420, y = 4835,  z = 2664, a = 0x3000 }, 2.0,  1,   FLOOD_WATER, { x = 1077, y = -566, z = 5611, a = 0x0000 })
    flood_define_level(false, LEVEL_BBH,              "c5",              { x = -1284,   y = 6662, z = -741,  a =  0x4000 }, 0.7,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x = -5782, y = 3329,  z = -1624, a = 0x3000 }, 1.7,  1,   FLOOD_WATER, { x = -2835, y = -956, z = -3847, a = 0x0000 })
    flood_define_level(false, LEVEL_BITDW,            "b1",            { x = -7661, y = 6467, z = -4869, a = 0x5000 }, 1.8,  1,   FLOOD_LAVA, { x = -1681, y = -2686, z = 2433, a = 0x0000 })
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",             { x = -336, y = 155,  z = -1277, a = 0x3000 }, 10.0,  1,   FLOOD_MUD, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",              { x = -276, y = 310, z = 7934, a =  -0x4000 }, 1.25,  1,   FLOOD_WATER, { x = 26, y = 838, z = -578, a = 0x0000 })
    flood_define_level(false, LEVEL_HMC,              "c6",             { x = -7154, y = 3474,  z = -2167, a = 0x3000 }, 1.25,  1,   FLOOD_WATER, { x = 5678, y = -1344, z = -3589, a = 0x0000 })
    flood_define_level(false, LEVEL_LLL,              "c7",             { x = 10506, y = 4465,  z = 3351, a = 0x3000 }, 0.5,  1,   FLOOD_WATER, { x = -3660, y = -65, z = -5236, a = 0x0000 })
    flood_define_level(false, LEVEL_SSL,              "c8",             { x = -2534, y = 1937,  z = 7885, a = 0x3000 }, 0.45,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,              "c9",              { x = -3267, y = 5547, z = 4294, a =  -0x2000 }, 1.0,  1,   FLOOD_WATER, { x = -1858, y = 154, z = 5308, a = 0x0000 })
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x = 2851, y = 5488,  z = 9914, a = 0x3000 }, 1.0,  1,   FLOOD_WATER, { x = 11310, y = -2790, z = -10732, a = 0x0000 })
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x = 7869, y = 4622,  z = -9457, a = 0x3000 }, 1.0,  1,   FLOOD_LAVA, nil)
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",             { x = -1852, y = -193,  z = -3882, a = 0x3000 }, 0.75,  1,   FLOOD_LAVA, nil)
    flood_define_level(false, LEVEL_SL,               "c10",               { x =  5952,  y = -1870, z = 4777,  a =  0x8000 }, 1.0,  1,   FLOOD_LAVA, { x = 4473, y = -7836, z = 3848, a = 0x0000 })
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",             { x = -6122, y = 97,  z = 6011, a = 0x3000 }, 0.5,  1,   FLOOD_SAND, nil)
    flood_define_level(false, LEVEL_WDW,              "c11",             { x = 72, y = 2301,  z = 5031, a = 0x3000 }, 1.2,  1,   FLOOD_WATER, { x = 120, y = -7264, z = -7853, a = 0x0000 })
    flood_define_level(false, LEVEL_TTM,              "c12",              { x =  5886,  y = 3847, z = -7471,  a =  0x8000 }, 1.25,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,              "c13",              { x =  -7702, y = 1238, z = 2251, a =  0x0000 }, 1.5,  1,   FLOOD_WATER,  nil)
    flood_define_level(false, LEVEL_TTC,              "c14",              { x = -7037, y = 4496, z = 6878, a =  0x8000 }, 0.5,  1,   FLOOD_WATER, { x = 6734, y = 1809, z = 1879, a = 0x0000 })
    flood_define_level(false, LEVEL_RR,               "c15",               { x =  8378, y = 6407, z = 5869, a =  0x0000 }, 1.0,  1,   FLOOD_WATER, { x = 12122, y = -4272, z = -15531, a = 0x0000 })
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =  -3622, y = 3026,  z = 8739, a = 0x3000 }, 0.5,  1,   FLOOD_WATER, { x = -6986, y = -7463, z = -8793, a = 0x0000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =  9138, y = 261,  z = -4801, a = 0x3000 }, 2.0,  1,   FLOOD_WATER, { x = -5493, y = -2569, z = 6208, a = 0x0000 })
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x = -3613, y = 1979,  z = -3793, a = 0x3000 }, 2.0,  1,   FLOOD_WATER, nil)

    -------- Easy Mode by SuperRodrigo0 -------- START 27

    flood_define_level(true, LEVEL_BOB,              "easy",              { x = -3990, y = -1476, z = -2363, a =  0x9000 }, 1.5,  1,   FLOOD_WATER, { x = 2956, y = -3756, z = -3887, a = 0x0000 })
    flood_define_level(true, LEVEL_BOB,              "easy",              { x =  4380, y = 1163, z =  -5434, a =  0x9000 }, 1.5,  1,   FLOOD_WATER, { x = -3744, y = -698, z = 1065, a = 0x0000 })
    flood_define_level(true, LEVEL_WF,               "easy",               { x = 4498, y = 1117, z = -153, a =  -0x2000 }, 1.75,  1,   FLOOD_LAVA, { x = -1244, y = -4463, z = 8620, a = 0x0000 })
    flood_define_level(true, LEVEL_WF,               "easy",               { x = 2307, y = 3637, z = 2592, a =  -0x2000 }, 1.25,  1,   FLOOD_LAVA, { x = 4100, y = 1501, z = 383, a = 0x0000 })
    flood_define_level(true, LEVEL_CCM,             "easy",             { x = 14420, y = 4835,  z = 2664, a = 0x3000 }, 2.0,  1,   FLOOD_WATER, { x = 1077, y = -566, z = 5611, a = 0x0000 })
    flood_define_level(true, LEVEL_JRB,              "easy",              { x = 1471, y = 138, z = 14500,  a =  -0x3000 }, 0.5,  1,   FLOOD_WATER, { x = -3553, y = -989, z = -8749, a = 0x0000 })
    flood_define_level(true, LEVEL_JRB,              "easy",              { x = -1687, y = 3799, z = 9599,  a =  -0x3000 }, 0.75,  1,   FLOOD_WATER, { x = 1544, y = 830, z = 13729, a = 0x0000 })
    flood_define_level(true, LEVEL_BBH,              "easy",              { x = -633,   y = -2098, z = 2379,  a =  0x4000 }, 0.75,  1,   FLOOD_WATER, { x = -6711, y = -4492, z = -3730, a = 0x0000 })
    flood_define_level(true, LEVEL_BBH,              "easy",              { x = 6223,   y = -866, z = 8929,  a =  0x4000 }, 1.5,  1,   FLOOD_WATER, { x = -2966, y = -762, z = 2925, a = 0x0000 })
    flood_define_level(true, LEVEL_BBH,              "easy",              { x = 7153,   y = 2296, z = -3952,  a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = 8683, y = 1628, z = 5083, a = 0x0000 })
    flood_define_level(true, LEVEL_BBH,              "easy",              { x = -1284,   y = 6662, z = -741,  a =  0x4000 }, 5.0,  1,   FLOOD_WATER, { x = 7026, y = 2999, z = -3669, a = 0x0000 })
    flood_define_level(true, LEVEL_COTMC,             "easy",             { x = 1426, y = 2169,  z = 748, a = 0x3000 }, 1.5,  1,   FLOOD_WATER, { x = -2835, y = -956, z = -3847, a = 0x0000 })
    flood_define_level(true, LEVEL_COTMC,             "easy",             { x = -5782, y = 3329,  z = -1624, a = 0x3000 }, 0.7,  1,   FLOOD_WATER, { x = -216, y = 1749, z = 1717, a = 0x0000 })
    flood_define_level(true, LEVEL_BITDW,            "easy",            { x = -3308, y = 185, z = 2186, a = 0x5000 }, 1.75,  1,   FLOOD_WATER, { x = -1681, y = -2686, z = 2433, a = 0x0000 })
    flood_define_level(true, LEVEL_BITDW,            "easy",            { x = -7661, y = 6467, z = -4869, a = 0x5000 }, 1.25,  1,   FLOOD_WATER, { x = -5110, y = 1001, z = 1865, a = 0x0000 })
    flood_define_level(true, LEVEL_BOWSER_1,        "easy",             { x = -336, y = 155,  z = -1277, a = 0x3000 }, 10.0,  1,   FLOOD_MUD, nil)
    flood_define_level(true, LEVEL_PSS,              "easy",              { x = -276, y = 310, z = 7934, a =  -0x4000 }, 1.25,  1,   FLOOD_WATER, { x = 26, y = 838, z = -578, a = 0x0000 })
    flood_define_level(true, LEVEL_HMC,             "easy",             { x = 7447, y = 3722,  z = -4973, a = 0x3000 }, 1.25,  1,   FLOOD_WATER, { x = 5678, y = -1344, z = -3589, a = 0x0000 })
    flood_define_level(true, LEVEL_HMC,             "easy",             { x = -7154, y = 3474,  z = -2167, a = 0x3000 }, 0.75,  1,   FLOOD_WATER, { x = 7447, y = 3722, z = -4973, a = 0x0000 })
    flood_define_level(true, LEVEL_LLL,             "easy",             { x = 6490, y = -574,  z = 4786, a = 0x3000 }, 0.5,  1,   FLOOD_WATER, { x = -3660, y = -65, z = -5236, a = 0x0000 })
    flood_define_level(true, LEVEL_LLL,             "easy",             { x = 10506, y = 4465,  z = 3351, a = 0x3000 }, 1.0,  1,   FLOOD_WATER, { x = 6514, y = -256, z = 4736, a = 0x0000 })
    flood_define_level(true, LEVEL_SSL,             "easy",             { x = -780, y = -1932,  z = 3783, a = 0x3000 }, 0.5,  1,   FLOOD_WATER, { x = 13750, y = -1675, z = -2496, a = 0x0000 })
    flood_define_level(true, LEVEL_SSL,             "easy",             { x = -2534, y = 1937,  z = 7885, a = 0x3000 }, 1.5,  1,   FLOOD_WATER, { x = -4538, y = -1304, z = -1449, a = 0x0000 })
    flood_define_level(true, LEVEL_DDD,              "easy",              { x = -3267, y = 5547, z = 4294, a =  -0x2000 }, 1.2,  1,   FLOOD_WATER, { x = -1858, y = 154, z = 5308, a = 0x0000 })
    flood_define_level(true, LEVEL_TOTWC,             "easy",             { x = -5857, y = -2,  z = 523, a = 0x3000 }, 1.0,  1,   FLOOD_WATER, { x = 11310, y = -2790, z = -10732, a = 0x0000 })
    flood_define_level(true, LEVEL_TOTWC,             "easy",             { x = 2851, y = 5488,  z = 9914, a = 0x3000 }, 1.0,  1,   FLOOD_WATER, { x = -10319, y = 538, z = 1414, a = 0x0000 })
    flood_define_level(true, LEVEL_BITFS,             "easy",             { x = -1790, y = 1094,  z = -2042, a = 0x3000 }, 1.25,  1,   FLOOD_LAVA, { x = -674, y = -9395, z = 8577, a = 0x0000 })
    flood_define_level(true, LEVEL_BITFS,             "easy",             { x = 7869, y = 4622,  z = -9457, a = 0x3000 }, 4.0,  1,   FLOOD_LAVA, { x = 3195, y = -1476, z = -3344, a = 0x0000 })
    flood_define_level(true, LEVEL_BOWSER_2,           "easy",             { x = -1852, y = -193,  z = -3882, a = 0x3000 }, 0.75,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_SL,               "easy",               { x =  5952,  y = -1870, z = 4777,  a =  0x8000 }, 1.0,  1,   FLOOD_LAVA, { x = 4473, y = -7836, z = 3848, a = 0x0000 })
    flood_define_level(true, LEVEL_WMOTR,             "easy",             { x = -6122, y = 97,  z = 6011, a = 0x3000 }, 0.5,  1,   FLOOD_SAND, nil)
    flood_define_level(true, LEVEL_WDW,             "easy",             { x = 1353, y = -335,  z = -7946, a = 0x3000 }, 1.25,  1,   FLOOD_WATER, { x = 120, y = -7264, z = -7853, a = 0x0000 })
    flood_define_level(true, LEVEL_WDW,             "easy",             { x = 72, y = 2301,  z = 5031, a = 0x3000 }, 1.5,  1,   FLOOD_WATER, { x = 1338, y = -63, z = -7917, a = 0x0000 })
    flood_define_level(true, LEVEL_TTM,              "easy",              { x =  3339,  y = -2171, z = 3586,  a =  0x8000 }, 1.25,  1,   FLOOD_WATER, { x = 1085, y = -5223, z = 7050, a = 0x0000 })
    flood_define_level(true, LEVEL_TTM,              "easy",              { x =  -1482,  y = 924, z = -8099,  a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x = -6691, y = -1713, z = 4036, a = 0x0000 })
    flood_define_level(true, LEVEL_TTM,              "easy",              { x =  5886,  y = 3847, z = -7471,  a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x = 2366, y = 1932, z = -8362, a = 0x0000 })
    flood_define_level(true, LEVEL_THI,              "easy",              { x =  -7702, y = 1238, z = 2251, a =  0x0000 }, 1.5,  1,   FLOOD_WATER,  nil)
    flood_define_level(true, LEVEL_TTC,              "easy",              { x = -7037, y = 4496, z = 6878, a =  0x8000 }, 0.5,  1,   FLOOD_WATER, { x = 6734, y = 1809, z = 1879, a = 0x0000 })
    flood_define_level(true, LEVEL_RR,               "easy",               { x =  -4018, y = 468, z = 429, a =  0x0000 }, 1.0,  1,   FLOOD_WATER, { x = 12122, y = -4272, z = -15531, a = 0x0000 })
    flood_define_level(true, LEVEL_RR,               "easy",               { x =  8378, y = 6407, z = 5869, a =  0x0000 }, 0.75,  1,   FLOOD_WATER, { x = -3924, y = 1128, z = -156, a = 0x0000 })
    flood_define_level(true, LEVEL_BITS,             "easy",             { x = 5574, y = -3919,  z = 2135, a = 0x3000 }, 0.5,  1,   FLOOD_WATER, { x = -6986, y = -7463, z = -8793, a = 0x0000 })
    flood_define_level(true, LEVEL_BITS,             "easy",             { x =  -3622, y = 3026,  z = 8739, a = 0x3000 }, 1.5,  1,   FLOOD_WATER, { x = 5019, y = -4142, z = 1988, a = 0x0000 })
    flood_define_level(true, LEVEL_CASTLE_GROUNDS,   "easy",             { x =  9138, y = 261,  z = -4801, a = 0x3000 }, 2.0,  1,   FLOOD_WATER, { x = -5493, y = -2569, z = 6208, a = 0x0000 })
    flood_define_level(true, LEVEL_CASTLE_COURTYARD,   "easy",             { x = -3613, y = 1979,  z = -3793, a = 0x3000 }, 2.0,  1,   FLOOD_WATER, nil)
end

local function flood_load_star_revenge_1_5_redone_levels()
    game = GAME_STAR_REVENGE_1_5_REDONE
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Star Revenge 1.5: Star Takeover Redone"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_1.5_redone_logo")	
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	

    flood_define_level(false, LEVEL_BOB,              "c1",            { x =    600, y = 4555, z =  -3090, a =  0x4000 }, 2.75, 1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",            { x =   5720, y = 4480, z =  -5830, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x =    530, y = -1850, z = -4950, a =  0x0000 })
    flood_define_level(false, LEVEL_TOTWC,            "wc",            { x =      0, y = 4920, z =  -3620, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x =    -10, y = -2835, z = -4410, a =  0x0000 })	
    flood_define_level(false, LEVEL_JRB,              "c3",            { x =  -7100, y =  140, z =   9095, a =  0x9500 }, 1.0,  1,   FLOOD_WATER, { x =   7065, y = -1200, z = -2665, a = -0x5000 })
    flood_define_level(false, LEVEL_CCM,              "c4",            { x =  11320, y = 4485, z =   1030, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,              "c5",            { x =  -5140, y = 6555, z =   1950, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = -10670, y = -4115, z = -1075, a =  0x0000 })
    flood_define_level(false, LEVEL_BITFS,            "b2",            { x =   2770, y = 3330, z =   5950, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",            { x =  -7750, y =  435, z =  15395, a =  0x8000 }, 2.75, 1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_PSS,              "pss",           { x =  -4255, y = 6830, z =   9920, a =  0x4000 }, 4.5,  1,   FLOOD_WATER, { x =  12880, y = -4415, z =  5015, a =  0x8000 })	
    flood_define_level(false, LEVEL_HMC,              "c6",            { x =   5160, y = 3450, z =  -5370, a =  0x8000 }, 1.5,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,              "c7",            { x =   5640, y = 1755, z =  -8290, a =  0x0000 }, 2.0,  1,   FLOOD_MUD,   { x =  -2630, y = -1250, z =  3890, a =  0x8000 })
    flood_define_level(false, LEVEL_SSL,              "c8",            { x =  -6750, y = 3800, z =  -3430, a =  0x4000 }, 5.0,  1,   FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",            { x =  -8100, y = 3300, z =  -6530, a =  0x2000 }, 3.0,  1,   FLOOD_SAND,  { x =  -1500, y = -2435, z =  6500, a =  0x8000 })  	
    flood_define_level(false, LEVEL_DDD,              "c9",            { x =   6520, y = 4870, z =   9890, a = -0x4000 }, 3.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_SL,               "c10",           { x =  -3320, y = 3690, z =   1810, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x =      0, y =  1590, z = -1530, a =  0x0000 })
    flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -6710, y =  250, z =  -9590, a =  0x4000 }, 1.75, 1,   FLOOD_LAVA,  nil) 	
    flood_define_level(false, LEVEL_WDW,              "c11",           { x =   7770, y = 4040, z =  -9365, a = -0x2000 }, 2.0,  1,   FLOOD_WATER, { x =   2770, y = -3325, z =  8260, a =  0x8000 })	
    flood_define_level(false, LEVEL_TTM,              "c12",           { x =    590, y = 6635, z =   9180, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, { x =  -7460, y = -5270, z =  1220, a =  0x4000 })
    flood_define_level(false, LEVEL_RR,               "c15",           { x =   2210, y = 2970, z = -11150, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x =   -600, y =  1380, z = -6345, a =  0x8000 })
    flood_define_level(false, LEVEL_RR,               "c15-2",         { x =  12160, y = 1950, z =    490, a =  0x4000 }, 2.5,  1,   FLOOD_SAND,  { x =   6770, y =  1935, z =   -50, a =  0x4000 })
    flood_define_level(false, LEVEL_RR,               "c15-3",         { x =   4115, y = 3230, z =   7520, a = -0x4000 }, 2.5,  1,   FLOOD_WATER, { x =  -1390, y =  1270, z = 13640, a =  0x8000 })
    flood_define_level(false, LEVEL_RR,               "c15-4",         { x = -13280, y = 2990, z =   3305, a =  0x8000 }, 3.0,  1,   FLOOD_LAVA,  { x = -11820, y =  1320, z =  3555, a =  0x6000 })	
    flood_define_level(false, LEVEL_ENDING,           "ending",        { x =  -6990, y = 1500, z =   8260, a =  0x6000 }, 5.0,  1,   FLOOD_WATER, { x =   -515, y = -1970, z =    55, a =  0x8000 })	
    flood_define_level(false, LEVEL_THI,              "c13",           { x =  -6910, y = 3890, z =  -3075, a =  0x4000 }, 3.5,  1,   FLOOD_WATER, { x =  -2165, y = -4175, z =  3905, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITS,             "b3",            { x =   7300, y = 1480, z =  -6185, a =  0x2000 }, 1.5,  1,   FLOOD_SAND,  { x =   5155, y =   100, z = -2430, a =  0x8000 })
    flood_define_level(false, LEVEL_BITS,             "b3-2",          { x =  -6450, y = 1155, z = -11105, a =  0x0000 }, 2.0,  1,   FLOOD_LAVA,  { x =  -6030, y =   100, z = -2760, a =  0x8000 })
    flood_define_level(false, LEVEL_BITS,             "b3-3",          { x =   6040, y =  -30, z =   9585, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x =   6030, y =     0, z =  2790, a =  0x0000 })
    flood_define_level(false, LEVEL_BITS,             "b3-4",          { x =  -6420, y = 3100, z =   7930, a = -0x3000 }, 1.25, 1,   FLOOD_MUD,   { x =  -4925, y =     0, z =  2265, a =  0x0000 })	
    flood_define_level(false, LEVEL_TTC,              "c14",           { x =      0, y =    0, z = -17185, a =  0x4000 }, 0.5, 1,   FLOOD_WATER, nil) 		
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",            { x =  14365, y = 2970, z =  -8350, a =  0x4000 }, 1.5,  1,   FLOOD_WATER, { x =  -3780, y = -1640, z = -2730, a =  0x5000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",            { x =   2710, y = 4210, z =  -7580, a =  0x4000 }, 7.5,  1,   FLOOD_WATER, { x =   9810, y =  2000, z =  2510, a = -0x4000 })	
end

local function flood_load_star_revenge_7_5_levels()
    game = GAME_STAR_REVENGE_7_5
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Star Revenge 7.5: Kedowser's Return"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_7.5_logo")
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvDoorWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,            "c1",        { x =   2750, y =  1170, z =   4250, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =   3180, y =  -970, z =   2830, a =  0x8000 }) 
    flood_define_level(false, LEVEL_WF,             "c2",        { x =  -3200, y =  1595, z =   3390, a = -0x6000 }, 1.0,  1,  FLOOD_LAVA,  { x =  -6720, y = -1480, z =   -210, a =  0x4000 }) 
    flood_define_level(false, LEVEL_JRB,            "c3",        { x =   4600, y =  2850, z = -11815, a =  0x0000 }, 2.75, 1,  FLOOD_WATER, { x =  -7820, y = -1015, z =  11955, a =  0x0000 }) 
    flood_define_level(false, LEVEL_CCM,            "c4",        { x =   -795, y =  1990, z =  -3850, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, { x =   2715, y = -3700, z =  -4965, a = -0x4000 }) 
    flood_define_level(false, LEVEL_PSS,            "pss",       { x =  -8445, y =  1730, z =  -8010, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x =   8415, y = -3090, z = -10705, a =  0x4000 }) 
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",     { x = -11505, y = -2085, z =   4005, a =  0x4000 }, 2.25, 1,  FLOOD_WATER, nil) 	
    flood_define_level(false, LEVEL_BITDW,          "b1",        { x =  -6990, y =  3330, z =  -5925, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_BOWSER_1,       "bowser-1",  { x =    385, y =  1385, z =     35, a = -0x4000 }, 5.0,  1,  FLOOD_WATER, nil) 	
    flood_define_level(false, LEVEL_BBH,            "c5",        { x =   5970, y = -1115, z =  -1180, a =  0x6000 }, 2.5,  1,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_HMC,            "c6",        { x =  -4170, y =  1500, z =  -3870, a = -0x2000 }, 1.75, 1,  FLOOD_WATER, nil)  
    flood_define_level(false, LEVEL_LLL,            "c7",        { x =   8460, y =   600, z =  -3020, a =  0x0000 }, 1.25, 1,  FLOOD_LAVA,  { x =  12855, y = -1905, z =  -6550, a =  0x0000 }) 
    flood_define_level(false, LEVEL_LLL,            "c7-2",      { x =  -8445, y =   600, z =  -3040, a = -0x8000 }, 2.25, 1,  FLOOD_LAVA,  { x = -14335, y = -1770, z =  -6830, a =  0x4000 }) 	
    flood_define_level(false, LEVEL_SSL,            "c8",        { x =  -9560, y =  3000, z =  12080, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_DDD,            "c9",        { x =   3310, y =  2595, z =  -5380, a =  0x0000 }, 3.5,  1,  FLOOD_SAND,  { x =  11590, y = -2540, z =  -2915, a =  0x0000 }) 
    flood_define_level(false, LEVEL_BITFS,          "b2",        { x =  -4060, y =  3955, z =   3235, a =  0x8000 }, 1.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOWSER_2,       "bowser-2",  { x =  -2005, y =  1445, z =     -5, a =  0x4000 }, 5.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_SL,             "c10",       { x =  -9610, y =  1845, z =   2745, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, { x =   -325, y = -3025, z =   7410, a = -0x4000 }) 	
    flood_define_level(false, LEVEL_WDW,            "c11",       { x =   7070, y = -2580, z =  -6300, a = -0x4000 }, 2.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,            "c11-2",     { x = -13545, y =  1750, z =   3755, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -9640, y = -1110, z =   4340, a =  0x8000 }) 		
    flood_define_level(false, LEVEL_TTM,            "c12",       { x =  -8525, y =  3705, z =  -7315, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13",       { x =  -1800, y =  2345, z =  10720, a =  0x4000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTC,            "c14",       { x =  -4570, y =   375, z =  -2325, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_RR,             "c15",       { x =   3655, y =  2625, z =  -5740, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_SA,             "sa",        { x =  -2400, y =  3525, z =      0, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -1655, y = -2420, z =      0, a = -0x4000 }) 
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",        { x =  -6810, y =   610, z =   2425, a =  0x8000 }, 3.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE,         "c",         { x =   1670, y =  2100, z =  -3930, a =  0x0000 }, 2.75, 1,  FLOOD_WATER, nil)	
end

local function flood_load_star_revenge_4_9_levels()
    game = GAME_STAR_REVENGE_4_9
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Star Revenge 4.9: Adulterated Reality"
    TEX_ROMHACK_LOGO = get_texture_info("star_revenge_4.9_logo")	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  -9010, y =  4850, z =  -6410, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =  10180, y =  3600, z = -17885, a =  0x0000 }, 2.5,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  10025, y =  5200, z =   2870, a =  0x8000 }, 2.75, 1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =   6250, y =  6750, z =  -7540, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   1080, y =  7980, z =  -6785, a =  0x8000 }, 1.0,  1,  FLOOD_MUD,   { x =  9083, y =  5726, z =  2518, a =  0x9000 }) 
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =   7225, y =  8295, z =   -660, a = -0x4000 }, 1.0,  1,  FLOOD_WATER, nil) 	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =  -3880, y =  5910, z =  -1555, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =  -7020, y = 14710, z =  -6960, a =  0x2000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =   2575, y =  6900, z =  -3520, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  -1210, y =  7725, z =  15960, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  10440, y =  6900, z = -10285, a =  0x4000 }, 1.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =    800, y =  4360, z = -10280, a =  0x0000 }, 0.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =  -2217, y =  6240, z =  -3301, a =  0x8000 }, 1.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =   1500, y =  3520, z =   -600, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",            { x =  -9720, y =  2550, z = -10520, a =  0x4000 }, 1.8,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =  10190, y =  4390, z =  -4145, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =  23725, y = 10805, z =   2520, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTC,              "c14",            { x =   5665, y =  4050, z = -14060, a =  0x4000 }, 0.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTC,              "c14-2",          { x =    160, y = 10800, z =   9370, a =  0x8000 }, 5.0,  2,  FLOOD_WATER, { x =   155, y =   575, z =   660, a =  0x8000 }) 
    flood_define_level(false, LEVEL_TTC,              "c14-3",          { x =   6080, y =  4640, z =  -5450, a =  0x4000 }, 1.5,  3,  FLOOD_WATER, { x =     0, y =  -145, z =   750, a =  0x4000 })
    flood_define_level(false, LEVEL_TTC,              "c14-4",          { x =      0, y =  6435, z =   3500, a =  0x0000 }, 3.0,  4,  FLOOD_WATER, { x =   155, y =  -830, z = -1385, a = -0x4000 }) 	
    flood_define_level(false, LEVEL_RR,               "c15",            { x =  -1489, y = 12026, z = -10489, a = -0x4000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,               "c15-2",          { x =   -905, y =  9150, z =  -4055, a =  0x0000 }, 1.75, 2,  FLOOD_WATER, { x =   305, y =    15, z =  2270, a =  0x8000 }) 	
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =  11965, y = 14975, z = -12585, a =  0x0000 }, 3.0,  2,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",             { x = -11075, y =  4950, z =   3630, a =  0x0000 }, 1.5,  2,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =   4120, y =  8485, z = -12650, a =  0x8000 }, 1.5,  3,  FLOOD_WATER, { x = -4030, y = -3380, z =  -150, a =  0x8000 }) 	
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =      0, y =   900, z =   4820, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  10210, y =  -345, z =  -3605, a = -0x4000 }, 3.5,  3,  FLOOD_WATER, nil)	
end

local function flood_load_sm64_last_impact_levels()
    game = GAME_SM64_LAST_IMPACT
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64 Last Impact"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_last_impact_logo")

    flood_define_level(false, LEVEL_BOB,              "c1",             { x = -7355, y =  1130, z =  18640, a =  0x6000 }, 3.0,  1,  FLOOD_WATER, nil)
	flood_define_level(false, LEVEL_BOB,              "c1-2",           { x =     0, y =  3050, z =   -810, a = -0x2000 }, 4.0,  2,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =  3740, y =   -95, z = -14350, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = -9823, y =   115, z =  25695, a = -0x4000 }, 1.0,  1,  FLOOD_WATER, { x = -2900, y = -791, z =   7739, a = -0x4000 })
    flood_define_level(false, LEVEL_CCM,              "b3-4",           { x =  4675, y =  1810, z =  15831, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  1194, y = -597, z =    439, a =  0x0000 })
    flood_define_level(false, LEVEL_CCM,              "b3-4",           { x =   895, y =   123, z =  -4787, a =  0x0000 }, 4.0,  2,  FLOOD_WATER, { x = -3005, y = -335, z =  -2734, a =  0x0000 })	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x = -4003, y =  6009, z =  -7829, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x = -6406, y = 1642, z =  -3658, a =  0x4700 }) 
    flood_define_level(false, LEVEL_JRB,              "c3-2",           { x =   570, y =  2420, z =    830, a =  0x8000 }, 2.5,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   -40, y =  7065, z =  -6915, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =   120, y =   940, z =   9235, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =  3690, y = -2165, z = -6690, a = -0x6000 }) 
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =  9185, y =  8275, z =  17350, a =  0x8000 }, 2.5,  1,  FLOOD_LAVA,  nil) 	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x = -2225, y =  3405, z = -16585, a = -0x5000 }, 1.5,  1,  FLOOD_WATER, { x =  5050, y = -1528, z =  8135, a = -0x3000 }) 
    flood_define_level(false, LEVEL_HMC,              "b3-4",           { x =  2369, y =     8, z = -15773, a =  0x0000 }, 5.5,  2,  FLOOD_WATER, { x =  2332, y =   144, z =   805, a =  0x8000 })
    flood_define_level(false, LEVEL_HMC,              "b3-4",           { x =  5279, y =  4486, z =   7847, a = -0x4000 }, 1.65, 2,  FLOOD_WATER, { x =   586, y =   176, z =  4755, a =  0x0000 })
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =  3405, y =  1680, z =   -700, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =  -755, y =  8875, z =   8165, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   447, y =  4774, z =   536, a =  0x0000 }) 
    flood_define_level(false, LEVEL_TOTWC,            "b3-4",           { x =  2048, y =  2742, z =  -1960, a =  0x8000 }, 1.0,  2,  FLOOD_WATER, { x =  5156, y =   280, z = -1735, a =  0x8000 })
    flood_define_level(false, LEVEL_TOTWC,            "b3-4",           { x =  -137, y =  1504, z =  -1674, a =  0x0000 }, 1.0,  3,  FLOOD_WATER, { x =   527, y =   140, z =  7214, a =  0x5000 })	
    flood_define_level(false, LEVEL_LLL,              "c7",             { x = -3075, y =  3095, z =   5985, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,              "b3-4",           { x = 24652, y =  2679, z =   4364, a =  0x8000 }, 2.5,  3,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x = 12640, y =  1795, z =  -1285, a =  0x0000 }, 1.5,  1,  FLOOD_LAVA,  { x =  9035, y =   150, z = -3430, a = 0x12000 })
    flood_define_level(false, LEVEL_SSL,              "c8-2",           { x = -7110, y =  1910, z =  10800, a =  0x0000 }, 2.8,  1,  FLOOD_WATER, { x =  2060, y =  -300, z = 16480, a =  0x8000 })	
    flood_define_level(false, LEVEL_SSL,              "b3-4",           { x =  -171, y =  2984, z =   1606, a =  0x8000 }, 4.4,  2,  FLOOD_WATER, { x = 14760, y = -5698, z =  1095, a =  0x8000 })
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =  3760, y =  2280, z =     75, a = -0x4000 }, 2.15, 1,  FLOOD_WATER, { x = -2702, y =  -152, z = -1935, a =  0x6000 })
    flood_define_level(false, LEVEL_DDD,              "b3-4",           { x = -6034, y =  1336, z =   5502, a =  0x8000 }, 3.9,  3,  FLOOD_WATER, { x = -1016, y =   373, z = -2873, a =  0x0000 })	
    flood_define_level(false, LEVEL_SA,               "sa",             { x =  2925, y =  2430, z =  -4790, a =  0x0000 }, 1.25, 1,  FLOOD_WATER, { x = -1920, y =   395, z =  2850, a =  0x8000 })
    flood_define_level(false, LEVEL_SA,               "b3-4",           { x =  8073, y =  4650, z =   2288, a =  0x8000 }, 3.6,  3,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x = 19078, y = -2129, z =  -5300, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x =  -295, y = -7545, z =    70, a =  0x8000 })
    flood_define_level(false, LEVEL_SL,               "c10",            { x = 11020, y = 10361, z = -12355, a =  0x8000 }, 4.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "b3-4",           { x =  1611, y =  1560, z =   -374, a = -0x6000 }, 2.8,  2,  FLOOD_MUD,   { x =  3040, y =   131, z = -4957, a = -0x1000 })	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =     0, y =  4985, z =      0, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTM,              "b3-4",           { x = -1747, y =  -200, z =   7212, a =  0x8000 }, 2.0,  2,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTM,              "b3-4",           { x = -6483, y =  4365, z =  11274, a = -0x4000 }, 6.0,  3,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,              "c13",            { x = -6800, y =  8950, z =   4625, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =  -834, y =   -26, z =  6388, a = -0x2000 })
    flood_define_level(false, LEVEL_TTC,              "c14",            { x = -8845, y = 10190, z =  -4550, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,               "c15",            { x =  8395, y =  3355, z =  -8930, a = -0x3000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,               "c15",            { x =  1978, y =  6679, z =  -1233, a =  0x0000 }, 5.5,  1,  FLOOD_WATER, { x = -4011, y =  1197, z =   630, a =  0x0000 })
    flood_define_level(false, LEVEL_BITS,             "b3",             { x = -1575, y =  3950, z =   6600, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x = -1930, y =   400, z =  4600, a = -0x4000 })
    flood_define_level(false, LEVEL_BITS,             "b3-2",           { x = -6435, y =  3815, z =  -2115, a = -0x4000 }, 1.9,  1,  FLOOD_WATER, { x = -6265, y =   913, z =  -472, a =  0x8000 })
    flood_define_level(false, LEVEL_BITS,             "b3-3",           { x =  2420, y =  4370, z =  -6855, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  2250, y =   300, z = -4675, a =  0x4000 })
    flood_define_level(false, LEVEL_BITS,             "b3-4",           { x =  6470, y =  4130, z =   1605, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x =  4835, y =   300, z =  1805, a =  0x0000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "b3-4",           { x =  5422, y =   -12, z =   -352, a = -0x4000 }, 2.5,  2,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CASTLE,           "b3-4",           { x =  1454, y =  1944, z =   6031, a = -0x4000 }, 2.0,  2,  FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x = -6000, y =  1470, z =   2025, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =    40, y =   400, z = -3285, a =  0x0000 })	
end

local function flood_load_sm64_the_dark_stars_levels()
    game = GAME_SM64_THE_DARK_STARS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64: The Dark Stars"
	TEX_ROMHACK_LOGO = get_texture_info("the_dark_stars_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  13150, y =  6000, z =  -2105, a =  0x4000 }, 1.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   6485, y =  2400, z = -14290, a =  0x4000 }, 1.25, 1,  FLOOD_MUD,   { x =  12255, y =  315, z = -8490, a = 0x8000 })	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   8875, y =  3205, z =   1240, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = -10210, y =  -990, z = -16890, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4-2",           { x = -14900, y = 19420, z = -14085, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x = -15220, y =-7360, z = -16725, a = 0x8000 })	
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   -565, y = 11650, z = -17430, a =  0x8000 }, 2.75, 1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =   1670, y =  4610, z = -14525, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x =    765, y = 1290, z =    200, a = 0x8000 })	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x = -19925, y =  6375, z =   1715, a =  0x4000 }, 1.75, 1,  FLOOD_MUD,   nil) 	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x = -23440, y =  3900, z =   -210, a =  0x6000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,              "c6-2",           { x = -22350, y =  6300, z =   -200, a =  0x6000 }, 3.0,  1,  FLOOD_WATER, { x = -23115, y =  710, z =  -4010, a = 0x8000 })	
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  19095, y =  5360, z =   5430, a =  0x8000 }, 0.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =   5200, y =  7800, z =   6375, a =  0x4000 }, 1.25, 1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_DDD,              "c9",             { x = -10820, y =  6100, z =   -340, a =  0x4000 }, 3.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =  -6310, y =  5985, z =   2425, a =  0x8000 }, 2.25, 1,  FLOOD_WATER, { x =    250, y = 1905, z =    335, a = 0x8000 })	
    flood_define_level(false, LEVEL_SL,               "c10",            { x =   7535, y =  5775, z = -11690, a =  0x0000 }, 3.5,  1,  FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =    369, y =  6552, z =  -6000, a =  0x0000 }, 3.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BITS,             "b3-2",           { x = -11680, y =  5550, z =  -4860, a =  0x4000 }, 2.5,  2,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =  -4625, y =  1520, z =   4950, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =   7590, y =  2470, z =  -1230, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)	
end

local function flood_load_eternal_realm_levels()
    game = GAME_ETERNAL_REALM
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Eternal Realm"
	TEX_ROMHACK_LOGO = get_texture_info("eternal_realm_logo")	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  7195, y =  8890, z =  -8390, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   -185, y =  1350, z =    640, a = 0x8000 })	
    flood_define_level(false, LEVEL_WF,               "c2",             { x =  1070, y = 12750, z = -16500, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  4585, y =  7440, z =  11945, a =  0x4000 }, 3.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = -3735, y =  5000, z = -14580, a =  0x0000 }, 3.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_BBH,              "c5",             { x = 13945, y =  5945, z =   2265, a =  0x8000 }, 2.75, 1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x = -1240, y =  5490, z =   6430, a =  0x8000 }, 3.15, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x = -2475, y =  3180, z = -12275, a =  0x0000 }, 2.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =  7795, y =  4440, z = -11280, a =  0x0000 }, 5.4,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,            "wmotr-2",        { x =  6510, y =  2100, z =      0, a =  0x0000 }, 2.25, 1,  FLOOD_WATER, { x =  12975, y = -2590, z = -10080, a = 0x8000 }) 
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =  6230, y =  6055, z =   8045, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x = -3130, y = 11300, z =  -4960, a =  0x2000 }, 4.0,  1,  FLOOD_WATER, nil)	
end

local function flood_load_through_the_ages_levels()
    game = GAME_THROUGH_THE_AGES
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS 
    romhackText = "Through The Ages"	
	TEX_ROMHACK_LOGO = get_texture_info("sm64_through_the_ages_logo")
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	

    flood_define_level(false, LEVEL_BOB,              "c1",           { x =     -5, y =  4760, z =    -10, a =  0x8000 }, 7.0,  1,  FLOOD_WATER, { x =      0, y =   620, z = -10070, a =  0x0000 })	
    flood_define_level(false, LEVEL_BOB,              "c1-2",         { x =   3270, y =  2635, z =  -1350, a = -0x4000 }, 1.5,  2,  FLOOD_WATER, { x =  -2935, y =  3010, z =  -1355, a =  0x4000 })	
    flood_define_level(false, LEVEL_WF,               "c2",           { x =  -1530, y =  4100, z =  10000, a = -0x6000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "c3",           { x =    -55, y =  6000, z =   -240, a =  0x0000 }, 4.0,  1,  FLOOD_WATER, { x =   3985, y = -1530, z =  -2100, a =  0x0000 })
    flood_define_level(false, LEVEL_JRB,              "c3-2",         { x =  -1575, y =   -50, z =   2080, a =  0x8000 }, 2.75, 3,  FLOOD_WATER, { x =   1875, y = -1960, z =  -1490, a = -0x4000 })	
    flood_define_level(false, LEVEL_CCM,              "c4",           { x =  11340, y =  5175, z =   6165, a = -0x6000 }, 4.0,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CCM,              "c4-2",         { x =    435, y =  1200, z =    650, a =  0x4000 }, 4.0,  2,  FLOOD_SAND,  { x =  13010, y = -1970, z =    800, a = -0x4000 })
    flood_define_level(false, LEVEL_CCM,              "c4-3",         { x =   4250, y =  3620, z =   3550, a = -0x2000 }, 3.0,  3,  FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_BBH,              "c5",           { x =  -6090, y =  3940, z =  -1150, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "c5-2",         { x =  11430, y =   850, z = -12265, a =  0x4000 }, 1.5,  2,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_HMC,              "c6",           { x =  -2860, y =  6405, z =  -9640, a =  0x5000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,              "c6-2",         { x =  -7440, y =  5205, z =  -8485, a =  0x5000 }, 1.5,  2,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_HMC,              "c6-3",         { x =  -8165, y =  1175, z =   1270, a =  0x4000 }, 2.5,  3,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_LLL,              "c7",           { x = -11345, y =  5120, z = -15640, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,              "c7-2",         { x =   1050, y =   955, z =  -9185, a =  0x0000 }, 1.5,  4,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_LLL,              "c7-3",         { x =  16625, y =   495, z =   -620, a = -0x4000 }, 1.0,  5,  FLOOD_LAVA,  { x = -15490, y =   755, z =  -2045, a =  0x4000 })	
    flood_define_level(false, LEVEL_SSL,              "c8-2",         { x = -12995, y =  2850, z =   -595, a =  0x4000 }, 1.5,  3,  FLOOD_WATER, { x =   7845, y =   290, z =   -665, a = -0x4000 })	
    flood_define_level(false, LEVEL_DDD,              "c9",           { x =     40, y =  5090, z =   1450, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "c10",          { x =   2670, y =  5600, z =  -3180, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_SL,               "c10",          { x =  -3440, y =  8810, z = -21040, a = -0x4000 }, 1.75, 3,  FLOOD_WATER, nil)			
end

local function flood_load_super_trump_64_levels()
    game = GAME_SUPER_TRUMP_64
    LEVEL_LOBBY = LEVEL_BORDER
	romhackText = "Super Trump 64"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")
    LEVEL_BORDER = level_register('level_border_entry', COURSE_NONE, 'The Border', 'border', 28000, 0x28, 0x28, 0x28)	

    flood_define_level(false, LEVEL_BORDER, "1", { x = -2990, y = 9875, z = -10470, a =  0x4000 }, 4.5,  1,  FLOOD_SAND, nil)
end

-- SM64 Masters Challenge ported to Flood by SuperRodrigo0
local function flood_load_sm64_masters_challenge_levels()
    game = GAME_SM64_MASTERS_CHALLENGE
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64 Master's Challenge"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_masters_challenge_logo")	

    flood_define_level(false, LEVEL_BOB,            "c1",            { x = 2914, y = 3009,  z = -5873, a =  0x8000 }, 1.4,  1,   FLOOD_SAND, { x = -7241, y = -2493,  z = 7107, a =  0x0000 })
    flood_define_level(false, LEVEL_WF,             "c2",             { x =  1108,  y = 1670,  z = -1760, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,            "c3",            { x = -4469, y = 2494,  z = -5804, a = -0x4000 }, 1.8,  1,   FLOOD_LAVA, { x = -5531, y = -4276,  z = -2614, a =  0x8000 })
    flood_define_level(false, LEVEL_CCM,            "c4",            { x =  4925, y = -2158,  z = -2491, a = 0x0000 }, 1.1,  1,   FLOOD_WATER, { x = -750, y = -6999,  z = -6194, a =  -0x4000 })
    flood_define_level(false, LEVEL_CCM,            "c4-2",            { x =  -3616, y = 3478,  z = -4524, a = -0x4000 }, 1.7,  1,   FLOOD_WATER, { x = -1351, y = -1708,  z = -7795, a =  0x4000 })
    flood_define_level(false, LEVEL_TOTWC,          "wc",          { x = -5329, y = 5336,  z = 7009, a =  0x4000 }, 5.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,            "c5",            { x =  -4164, y = -4319,  z = 6260, a =  0x4000 }, 0.7,  1,   FLOOD_WATER, { x = 1653, y = -4983,  z = 933, a =  0x4000 })
    flood_define_level(false, LEVEL_BBH,            "c5-2",            { x =  -40, y = 2909,  z = 1978, a =  0x8000 }, 0.7,  1,   FLOOD_WATER, { x = -6704, y = -246,  z = 6112, a =  0x4000 })
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x = -3988,  y = 4590,  z = -388,    a = -0x8000 }, 2.7,  1,   FLOOD_LAVA, { x = -5498, y = -3803,  z = 4580, a =  -0x4000 })
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x = -72, y = 2307,  z =  -1062,  a = -0x4000 }, 2.5,  1,   FLOOD_MUD, nil)
    flood_define_level(false, LEVEL_PSS,            "pss",            { x = -2382, y = 1938,  z = 6235, a =  0x0000 }, 2.5,  1,   FLOOD_SAND, { x = -6880, y = -4057,  z = -7175, a =  0x4000 })
    flood_define_level(false, LEVEL_PSS,            "pss-2",            { x = 6933, y = 9282,  z = 7653, a =  0x8000 }, 3.4,  1,   FLOOD_SAND, { x = -2841, y = 2719,  z = 3994, a =  0x8000 })
    flood_define_level(false, LEVEL_HMC,            "c6",            { x =  -3976, y = -1849,  z = -8603, a =  0x0000 }, 1.3,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,            "c6-2",            { x =  8459, y = 4017,  z = 6869, a =  -0x4000 }, 1.4,  1,   FLOOD_WATER, { x = 4816, y = 52,  z = -7548, a =  -0x4000 })
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x =  4085, y = -1067, z = -6, a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = -3596, y = -2045,  z = 412, a =  0x4000 })	
    flood_define_level(false, LEVEL_LLL,            "c7",            { x =  5182, y = -4,  z =  8091, a = 0x4000 }, 0.5,  1,   FLOOD_MUD,  nil)
    flood_define_level(false, LEVEL_SSL,            "c8",            { x = -2009,   y = 4010,  z =  5595, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, { x = -2117, y = -5336,  z = -2077, a =  -0x4000 })
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",          { x =  -3797, y = 3852,  z = -5878, a =  0x4000 }, 3.1,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_DDD,            "c9",            { x =  -8582,  y = 1497,  z = 1362, a =  0x4000 }, 1.0,  1,   FLOOD_WATER, { x = -6636, y = -2661,  z = 238, a =  -0x4000 })
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =  -4809, y = 12272,   z =  67, a = -0x4000 }, 1.5,  1,   FLOOD_WATER,  { x = -5675, y = 1029,  z = 316, a =  0x4000 })
    flood_define_level(false, LEVEL_BOWSER_2,       "bowser-2",       { x = 364, y = 1154,   z = 184, a = -0x0000 }, 2.1,  1,   FLOOD_WATER,  nil)
    flood_define_level(false, LEVEL_SL,             "c10",             { x =  1065, y = 4608,  z =  -26, a =  0x0000 }, 1.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13",            { x =  735, y = 6128,  z =  4299, a =  0x0000 }, 0.25,  1,   FLOOD_LAVA,  nil) 
    flood_define_level(false, LEVEL_RR,             "c15",             { x =  7125, y = 15306, z =  3687,  a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, nil)	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",            { x = -5, y = 7588,  z = -4015, a =  0x0000 }, 3.1, 1,   FLOOD_WATER, nil)

---- Easy Mode ---- flood start 26

    flood_define_level(true, LEVEL_BOB,            "easy",            { x = 4188, y = -366,  z = -2068, a =  -0x4000 }, 1.4,  1,   FLOOD_SAND, { x = -7241, y = -2493,  z = 7107, a =  0x0000 })
    flood_define_level(true, LEVEL_BOB,            "easy",            { x = 2914, y = 3009,  z = -5873, a =  0x8000 }, 2.5,  1,   FLOOD_SAND, { x = 2678, y = -160,  z = -1370, a =  0x4000 })
    flood_define_level(true, LEVEL_WF,             "easy",             { x =  5376,  y = -3961,  z = 3907, a =  0x0000 }, 2.0,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_WF,             "easy",             { x =  1108,  y = 1670,  z = -1760, a =  0x8000 }, 0.6,  1,   FLOOD_WATER, { x = 5637, y = -3541,  z = 3919, a =  0x8000 })
    flood_define_level(true, LEVEL_JRB,            "easy",            { x = -4469, y = 2494,  z = -5804, a = -0x4000 }, 1.8,  1,   FLOOD_LAVA, { x = -5531, y = -4276,  z = -2614, a =  0x8000 })
    flood_define_level(true, LEVEL_CCM,            "easy",            { x =  -9966, y = -3040,  z = -3895, a = 0x8000 }, 1.1,  1,   FLOOD_WATER, { x = -750, y = -6999,  z = -6194, a =  -0x4000 })
    flood_define_level(true, LEVEL_CCM,            "easy",            { x =  4925, y = -2158,  z = -2491, a = 0x0000 }, 0.5,  1,   FLOOD_WATER, { x = -10108, y = -2630,  z = -6412, a =  0x0000 })
    flood_define_level(true, LEVEL_CCM,            "easy",            { x =  -3616, y = 3478,  z = -4524, a = -0x4000 }, 1.7,  1,   FLOOD_WATER, { x = -1351, y = -1708,  z = -7795, a =  0x4000 })
    flood_define_level(true, LEVEL_TOTWC,          "easy",          { x = -5329, y = 5336,  z = 7009, a =  0x4000 }, 5.0,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_BBH,            "easy",            { x =  -1082, y = -4319,  z = 1020, a =  0x4000 }, 0.7,  1,   FLOOD_WATER, { x = 1653, y = -4983,  z = 933, a =  -0x4000 })
    flood_define_level(true, LEVEL_BBH,            "easy",            { x =  -40, y = 2909,  z = 1978, a =  0x8000 }, 0.7,  1,   FLOOD_WATER, { x = -48, y = 134,  z = 1903, a =  0x8000 })
    flood_define_level(true, LEVEL_BITDW,          "easy",          { x = -2768,  y = -1433,  z = 3686,    a = -0x4000 }, 2.7,  1,   FLOOD_LAVA, { x = -5498, y = -3803,  z = 4580, a =  -0x4000 })
    flood_define_level(true, LEVEL_BITDW,          "easy",          { x = -3988,  y = 4590,  z = -388,    a = -0x8000 }, 1.8,  1,   FLOOD_LAVA, { x = -2391, y = -663,  z = 3885, a =  0x8000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",          { x = 2396, y = -1092,  z =  -6045,  a = -0x4000 }, 2.5,  1,   FLOOD_MUD, nil)
    flood_define_level(true, LEVEL_VCUTM,          "easy",          { x = -72, y = 2307,  z =  -1062,  a = -0x4000 }, 0.75,  1,   FLOOD_MUD, { x = 2947, y = -574,  z = -6016, a =  0x0000 })
    flood_define_level(true, LEVEL_PSS,            "easy",            { x = -2382, y = 1938,  z = 6235, a =  0x0000 }, 2.5,  1,   FLOOD_SAND, { x = -6880, y = -4057,  z = -7175, a =  0x4000 })
    flood_define_level(true, LEVEL_PSS,            "easy",            { x = 6933, y = 9282,  z = 7653, a =  0x8000 }, 3.4,  1,   FLOOD_SAND, { x = -2841, y = 2719,  z = 3994, a =  0x8000 })
    flood_define_level(true, LEVEL_HMC,            "easy",            { x =  -3976, y = -1849,  z = -8603, a =  0x0000 }, 1.3,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_HMC,            "easy",            { x =  8459, y = 4017,  z = 6869, a =  -0x4000 }, 1.4,  1,   FLOOD_WATER, { x = 4816, y = 52,  z = -7548, a =  -0x4000 })
    flood_define_level(true, LEVEL_LLL,            "easy",            { x =  5182, y = -4,  z =  8091, a = 0x4000 }, 0.5,  1,   FLOOD_MUD,  nil)
    flood_define_level(true, LEVEL_COTMC,          "easy",          { x =  4085, y = -1067, z = -6, a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = -3596, y = -2045,  z = 412, a =  0x4000 })
    flood_define_level(true, LEVEL_SSL,            "easy",            { x = 1132,   y = -664,  z = -6457, a =  0x8000 }, 2.0,  1,   FLOOD_WATER, { x = -2117, y = -5336,  z = -2077, a =  0x4000 })
    flood_define_level(true, LEVEL_SSL,            "easy",            { x = -2009,   y = 4010,  z =  5595, a =  0x8000 }, 1.5,  1,   FLOOD_WATER, { x = 3736, y = -122,  z = -6481, a =  -0x4000 })
    flood_define_level(true, LEVEL_WMOTR,          "easy",          { x =  -3797, y = 3852,  z = -5878, a =  0x4000 }, 3.1,  1,   FLOOD_WATER, nil)	
    flood_define_level(true, LEVEL_DDD,            "easy",            { x =  -8582,  y = 1497,  z = 1362, a =  0x4000 }, 1.0,  1,   FLOOD_WATER, { x = -6636, y = -2661,  z = 238, a =  -0x4000 })
    flood_define_level(true, LEVEL_BITFS,          "easy",          { x =  -864, y = 6354,  z = 289, a = 0x4000 }, 1.5,  1,   FLOOD_WATER,  { x = -5675, y = 1029,  z = 316, a =  0x4000 })
    flood_define_level(true, LEVEL_BITFS,          "easy",          { x =  -4809, y = 12272,   z =  67, a = -0x4000 }, 1.5,  1,   FLOOD_WATER,  { x = -743, y = 6682,  z = 291, a =  -0x4000 })
    flood_define_level(true, LEVEL_BOWSER_2,       "easy",       { x = 2723, y = -2196,   z = 2355, a = 0x4000 }, 2.1,  1,   FLOOD_WATER,  nil)
    flood_define_level(true, LEVEL_BOWSER_2,       "easy",       { x = 364, y = 1154,   z = 184, a = -0x0000 }, 0.5,  1,   FLOOD_WATER,  { x = 3975, y = -1788,  z = 1000, a =  0x4000 })
    flood_define_level(true, LEVEL_SL,             "easy",             { x =  3039, y = -2048,  z = 4084, a =  -0x4000 }, 1.0,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_SL,             "easy",             { x =  1065, y = 4608,  z =  -26, a =  0x0000 }, 3.0,  1,   FLOOD_WATER, { x = 2899, y = -1724,  z = 4480, a =  0x6000 })
    flood_define_level(true, LEVEL_RR,             "easy",             { x =  -6074, y = -772, z =  -9436,  a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, nil)
    flood_define_level(true, LEVEL_RR,             "easy",             { x =  314, y = 5187, z = 3042,  a = -0x4000 }, 0.4,  1,   FLOOD_LAVA, { x = -10219, y = 4722,  z = 4093, a =  0x8000 })
    flood_define_level(true, LEVEL_RR,             "easy",             { x =  5662, y = 5246, z = 4297,  a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 6752, y = 3086,  z = 1196, a =  0x8000 })
    flood_define_level(true, LEVEL_RR,             "easy",             { x =  1286, y = 11366, z = 6982,  a = -0x4000 }, 0.8,  1,   FLOOD_LAVA, { x = 9758, y = 8606,  z = 4296, a =  0x0000 })
    flood_define_level(true, LEVEL_RR,             "easy",             { x =  7125, y = 15306, z =  3687,  a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 1286, y = 11782,  z = 6982, a =  0x0000 })
    flood_define_level(true, LEVEL_THI,            "easy",            { x = -2974, y = -608,  z = 9761, a =  0x0000 }, 0.25,  1,   FLOOD_LAVA,  nil) 
    flood_define_level(true, LEVEL_THI,            "easy",            { x =  735, y = 6128,  z =  4299, a =  0x0000 }, 0.4,  1,   FLOOD_LAVA,  { x = -3263, y = -2864,  z = 12277, a =  0x8000 })
    flood_define_level(true, LEVEL_CASTLE_GROUNDS, "easy",            { x = -5, y = 7588,  z = -4015, a =  0x0000 }, 3.1, 1,   FLOOD_WATER, nil)
end

local function flood_load_yoshis_adventure_64_levels()
    game = GAME_YOSHIS_ADVENTURE_64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Yoshi's Adventure 64"
	TEX_ROMHACK_LOGO = get_texture_info("yoshis_adventure_64_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  -8615, y =   1380, z =  -6130, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -965, y =  -470, z = -5130, a =  0x8000 })
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   8430, y =   3780, z =   2005, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  -1450, y =   3790, z =   4640, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =  -3330, y =   3360, z =  -7925, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =    -30, y =   1160, z = -21055, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =  15290, y =   3680, z = -13250, a = -0x4000 }, 3.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",       { x =  -8365, y =   2995, z =    280, a =  0x4000 }, 4.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =  -7345, y =   1370, z =  -7875, a =  0x8000 }, 3.5,  1,  FLOOD_LAVA,  { x = -2190, y = -2115, z =  4055, a =  0x8000 })
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  -3685, y =  10685, z =    170, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  -9700, y =   4060, z =  -2655, a =  0x8000 }, 3.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",       { x =    -85, y =   -355, z =  -5500, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =    20, y =  -170, z =  7325, a =  0x8000 })	
    flood_define_level(false, LEVEL_SL,               "c10",            { x =   1615, y =   2550, z =  -9885, a =  0x0000 }, 2.5,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =  -6345, y =   2205, z =  12335, a =  0x0000 }, 2.0,  1,  FLOOD_SAND,  { x = -7160, y = -1265, z = 13665, a =  0x8000 })
    flood_define_level(false, LEVEL_WDW,              "c11-2",          { x =   8175, y =   2990, z = -15310, a = -0x4000 }, 0.5,  1,  FLOOD_SAND,  { x =  -820, y =  -450, z = 11600, a =  0x8000 })	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =   5110, y =   3160, z =   1185, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x = -9110, y = -6865, z =    90, a =  0x8000 })	
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =    730, y =    900, z =    515, a =  0x8000 }, 1.75, 1,  FLOOD_WATER, { x =  -635, y = -2555, z =  6480, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =   -155, y =   2345, z =   -815, a =  0x0000 }, 1.25, 1,  FLOOD_WATER, { x =  2230, y = -3315, z =  6400, a =  0x8000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =   3480, y =   1640, z =  -4155, a =  0x0000 }, 10.0, 1,  FLOOD_WATER, nil)	
end

-- Super Mario Treasure World ported to Flood by SuperRodrigo0
local function flood_load_super_mario_treasure_world_levels()
    game = GAME_SUPER_MARIO_TREASURE_WORLD
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario Treasure World"
	TEX_ROMHACK_LOGO = get_texture_info("treasure_world_logo")		

    flood_define_level(false, LEVEL_BOB,            "bob",            { x = 2330, y = 2210,  z = -2495, a =  -0x4000 }, 2.6,  1,   FLOOD_WATER, { x = -2419, y = -3563, z = -549, a =  0x8000 })
    flood_define_level(false, LEVEL_BOB,            "bob",            { x = -3940, y = 2063,  z = 1525, a =  -0x4000 }, 2.1,  1,   FLOOD_WATER, { x = -5229, y = -2599, z = 5972, a =  0x8000 })
    flood_define_level(false, LEVEL_WF,             "wf",             { x =  9251,  y = 6176,  z = -10081, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 4351, y = -3248, z = -1679, a =  0x8000 })
    flood_define_level(false, LEVEL_WF,             "wf",             { x =  -7470,  y = 5058,  z = 1449, a =  0x8000 }, 1.7,  1,   FLOOD_WATER, { x = -2181, y = 35, z = -4605, a =  -0x4000 })
    flood_define_level(false, LEVEL_WF,             "wf",             { x = 10608,  y = 6200,  z = 8197, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = 2560, y = -1044, z = 7386, a =  -0x4000 })
    flood_define_level(false, LEVEL_TOTWC,          "totwc",          { x = 3787, y = 4259,  z = 6031 , a =  -0x4000 }, 3.1,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,           "totwc",          { x = 1883, y = 4511,  z = -2605 , a =  -0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 8255, y = 1183, z = -4929, a = 0x0000 })
    flood_define_level(false, LEVEL_JRB,            "jrb",            { x = 7491, y = 2950,  z = -13598, a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 4865, y = -3976,  z = 13924, a =  0x4000 })
    flood_define_level(false, LEVEL_JRB,            "jrb",            { x = 3305, y = -1825,  z = 14241, a = -0x4000 }, 0.7,  1,   FLOOD_LAVA, { x = 4605, y = -2869,  z = 4252, a =  -0x4000 })
    flood_define_level(false, LEVEL_JRB,            "jrb",            { x = -13170, y = 9569,  z = -13406, a = 0x4000 }, 3.8,  1,   FLOOD_LAVA, { x = -4821, y = 772,  z = -10451, a =  -0x3000 })
    flood_define_level(false, LEVEL_JRB,            "jrb",            { x = 10718, y = 4371,  z = -12824, a = 0x0000 }, 1.65,  1,   FLOOD_LAVA, { x = 2232, y = 2131,  z = -7361, a = 0x9000 })
    flood_define_level(false, LEVEL_CCM,            "ccm",            { x = -10286, y = 4677,  z = 732, a = 0x0000 }, 3.55,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,            "ccm",            { x = 5740, y = 3477,  z = -11847, a = 0x0000 }, 1.05,  1,   FLOOD_WATER, { x = -4116, y = -936,  z = -12208, a =  0x4000 })
    flood_define_level(false, LEVEL_BBH,            "bbh",            { x = 11381, y = 3005,  z = -3900, a =  0x8000 }, 2.45,  1,   FLOOD_WATER, { x = 295, y = -4447,  z = 11116, a =  0x6000 })
    flood_define_level(false, LEVEL_BBH,            "bbh",            { x = 9046, y = 3971,  z = 9425, a =  0x4000 }, 2.1,  1,   FLOOD_WATER, { x = 5976, y = -3044,  z = 6237, a =  0x2000 })
    flood_define_level(false, LEVEL_BBH,            "bbh",            { x = -11900, y = 1415,  z = -6328, a =  0x0000 }, 1.5,  1,   FLOOD_WATER, { x = 2136, y = -2944,  z = 8721, a = -0x4000 })
    flood_define_level(false, LEVEL_BBH,            "bbh",            { x = -265, y = 3936,  z = 1089, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x = 469, y = -3462,  z = 1610, a = 0x8000 })
    flood_define_level(false, LEVEL_SA,             "sa",             { x = 6690, y = 4861,  z = -9207, a =  -0x4000 }, 2.6,  1,   FLOOD_WATER, { x = 4853, y = -2338, z = 2713, a = 0x8000 })
    flood_define_level(false, LEVEL_BITDW,          "bitdw",          { x = 9320,  y = 6328,  z = 5878,    a = -0x4000 }, 1.2,  1,   FLOOD_WATER, { x = -7772, y = -5730,  z = 3596, a = -0x2000 })
    flood_define_level(false, LEVEL_COTMC,          "cotmc",          { x = 11530, y = 5340, z = -11592, a = 0x0000 }, 2.5,  1,   FLOOD_LAVA, { x = -3710, y = -7836, z = 7465, a = 0x6500 })
    flood_define_level(false, LEVEL_COTMC,          "cotmc",          { x = 9933, y = 2699,  z = 2009, a = 0x8000 }, 3.0,  1,   FLOOD_LAVA, { x = -429, y = -7005, z = 8292, a = 0x1500 })
    flood_define_level(false, LEVEL_COTMC,          "cotmc",          { x = -4369, y = -2155,  z = -3558, a = 0x8000 }, 1.0,  1,   FLOOD_LAVA, { x = -7663, y = -5244, z = 11313, a = 0x8000 })
    flood_define_level(false, LEVEL_HMC,            "hmc",            { x =  8012, y = 7533,  z = -8096, a =  0x0000 }, 2.9,  1,   FLOOD_LAVA, nil)
    flood_define_level(false, LEVEL_HMC,            "hmc",            { x = -7491, y = 5113,  z = 7911, a =  0x4000 }, 2.6,  1,   FLOOD_WATER, { x = -3283, y = -4177,  z = 2953, a = -0x4000 })
    flood_define_level(false, LEVEL_LLL,            "lll",            { x = -1636, y = 2861,  z = -7492, a = 0x4000 }, 1.2,  1,   FLOOD_WATER, { x = 8317, y = -4834, z = 9705, a = 0x8000 })
    flood_define_level(false, LEVEL_SSL,            "ssl",            { x = -14970,   y = 275,  z = -6054, a =  0x4000 }, 0.7,  1,   FLOOD_SAND, { x = -1570, y = -6491, z = -3647, a = 0x8000 })
    flood_define_level(false, LEVEL_VCUTM,          "vcutm",          { x = -3239, y = 1814,  z = -4483,  a = 0x8000 }, 0.5,  1,   FLOOD_SAND, { x = -184, y = -6433,  z = 12184, a = 0x8000 })
    flood_define_level(false, LEVEL_VCUTM,          "vcutm",          { x = 8220, y = -718,  z = 12621,  a = 0x4000 }, 1.1,  1,   FLOOD_SAND, { x = 3004, y = -6366,  z = 10882, a = 0x4000 })
    flood_define_level(false, LEVEL_VCUTM,          "vcutm",          { x = 1415, y = 5065,  z = -11390,  a = 0x0000 }, 2.5,  1,   FLOOD_SAND, { x = 13012, y = -6414,  z = -10339, a = 0x0000 })
    flood_define_level(false, LEVEL_VCUTM,          "vcutm",          { x = -8437, y = -1268,  z = 12019,  a = 0x0000 }, 1.9,  1,   FLOOD_SAND, { x = -4811, y = -6490,  z = 723, a = -0x4000 })
    flood_define_level(false, LEVEL_VCUTM,          "vcutm",          { x = 6639, y = 2669,  z = -7756,  a = -0x4000 }, 1.1,  1,   FLOOD_SAND, { x = 7543, y = -3555,  z = -6410, a = 0x0000 })
    flood_define_level(false, LEVEL_DDD,            "ddd",            { x =  5703,  y = 1204,  z = -5293, a =  -0x6000 }, 1.4,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,            "ddd",            { x =  14196,  y = 5558,  z = 11844, a =  -0x7000 }, 1.7,  1,   FLOOD_WATER, { x = 5031, y = 1184, z = 7138, a = 0x4000 })
    flood_define_level(false, LEVEL_SL,             "sl",             { x = 2041, y = 4356,  z = 1974, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = -6053, y = -6086, z = 11932, a = 0x8000 })
    flood_define_level(false, LEVEL_SL,             "sl",             { x = -5514, y = 5246,  z = -5416, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 467, y = -554, z = 449, a = -0x5000 })
    flood_define_level(false, LEVEL_BITFS,          "bifs",           { x = 12473, y = 5778, z = -12280, a = 0x0000 }, 1.2,  1,   FLOOD_SAND, { x = -11629, y = -9380, z = -4519, a = 0x0000 })
    flood_define_level(false, LEVEL_BITFS,          "bifs",           { x = 512, y = 2621, z = 10459, a = -0x4000 }, 1.1,  1,   FLOOD_SAND, { x = -6072, y = -735, z = -9766, a = 0x8000 })
    flood_define_level(false, LEVEL_WDW,            "wdw",            { x = 2120, y = 4520,  z = -3796, a =  0x8000 }, 1.8,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,            "pss",            { x = 5383, y = 1071,  z = -4373, a =  -0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 9513, y = -9011,  z = -542, a = -0x3000 })
    flood_define_level(false, LEVEL_PSS,            "pss",            { x = -9827, y = 8930,  z = -7507, a =  0x8000 }, 0.7,  1,   FLOOD_WATER, { x = 656, y = 846,  z = -4753, a = -0x6000 })
    flood_define_level(false, LEVEL_TTM,            "ttm",            { x = -6599, y = 5438,  z = -1960, a =  0x8000 }, 2.2,  1,   FLOOD_WATER,  nil) 
    flood_define_level(false, LEVEL_THI,            "thi",            { x = -12184, y = 3642,  z = -10059, a =  0x6000 }, 0.7,  1,   FLOOD_WATER,  nil) 
    flood_define_level(false, LEVEL_TTC,            "ttc",            { x = -7738, y = 4355,  z = -11469, a =  -0x4000 }, 1.72,  1,   FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_TTC,            "ttc",            { x = 12527, y = 1592,  z = -5626, a =  -0x4000 }, 1.8,  1,   FLOOD_LAVA,  { x = 7791, y = -4224, z = 11748, a = -0x3000 }) 
    flood_define_level(false, LEVEL_TTC,            "ttc",            { x = 4156, y = 5687,  z = 12665, a =  -0x4000 }, 1.2,  1,   FLOOD_LAVA,  { x = -11692, y = 1318, z = 4834, a = 0x0000 })
    flood_define_level(false, LEVEL_RR,             "rr",             { x = 13274, y = -864, z = -14632,  a = -0x4000 }, 1.1,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",          { x =  -2828, y = 1069,  z = 8915, a =  0x4000 }, 1.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",          { x =  -4193, y = 4204,  z = -1343, a =  0x8000 }, 0.6,  1,   FLOOD_WATER, { x = -1660, y = -838, z = 8, a = -0x4000 })	
    flood_define_level(false, LEVEL_WMOTR,          "wmotr",          { x = 6516, y = 3256,  z = -3967, a =  0x8000 }, 0.6,  1,   FLOOD_WATER, { x = 1594, y = -1051, z = 7, a = 0x5000 })	
    flood_define_level(false, LEVEL_BITS,           "bits",           { x = -6084, y = 8692,  z = 11968, a =  0x8000 }, 1.3,  1,   FLOOD_WATER,  nil) 
    flood_define_level(false, LEVEL_ENDING,         "ending",         { x = -4941, y = 1756,  z = -1739, a =  -0x6000 }, 1.8, 1,   FLOOD_WATER, { x = -5688, y = -2790, z = 4199, a = 0x6000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "castlegrounds",     { x = 4174, y = 2509,  z = 5375, a =  0x4000 }, 3.1, 1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "castlecourtyard", { x = 5739, y = 2590,  z = -4089, a =  0x8000 }, 3.5, 1,   FLOOD_WATER, { x = -662, y = -2066, z = 5258, a = 0x8000 }) 
    flood_define_level(false, LEVEL_CASTLE,         "castle",            { x = 309, y = 5084, z = -9311, a = 0x0000 } , 2.5, 1,   FLOOD_WATER,  { x = -1556, y = -3151, z = 8851, a = 0x8000 })

---- Easy Mode ---- /flood start 55

    flood_define_level(true, LEVEL_BOB,            "easy",            { x = 2330, y = 2210,  z = -2495, a =  -0x4000 }, 2.6,  1,   FLOOD_WATER, { x = -2419, y = -3563,  z = -549, a =  0x8000 })
    flood_define_level(true, LEVEL_BOB,            "easy",            { x = -3940, y = 2063,  z = 1525, a =  -0x4000 }, 2.1,  1,   FLOOD_WATER, { x = -5229, y = -2599,  z = 5972, a =  0x8000 })
    flood_define_level(true, LEVEL_WF,             "easy",            { x =  9251,  y = 6176,  z = -10081, a =  0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 4351, y = -3248,  z = -1679, a =  0x8000 })
    flood_define_level(true, LEVEL_WF,             "easy",            { x =  -7470,  y = 5058,  z = 1449, a =  0x8000 }, 1.7,  1,   FLOOD_WATER, { x = -2181, y = 35,  z = -4605, a =  -0x4000 })
    flood_define_level(true, LEVEL_WF,             "easy",            { x = 10608,  y = 6200,  z = 8197, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = 2560, y = -1044, z = 7386, a =  -0x4000 })
    flood_define_level(true, LEVEL_TOTWC,          "easy",            { x = 3787, y = 4259,  z = 6031 , a =  -0x4000 }, 3.1,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_TOTWC,          "easy",            { x = 1883, y = 4511,  z = -2605 , a =  -0x4000 }, 2.7,  1,   FLOOD_WATER, { x = 8255, y = 1183, z = -4929, a = 0x0000 })
    flood_define_level(true, LEVEL_JRB,            "easy",            { x = 7491, y = 2950,  z = -13598, a = -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 4865, y = -3976,  z = 13924, a =  0x4000 })
    flood_define_level(true, LEVEL_JRB,            "easy",            { x = 3305, y = -1825,  z = 14241, a = -0x4000 }, 0.7,  1,   FLOOD_LAVA, { x = 4605, y = -2869,  z = 4252, a =  -0x4000 })
    flood_define_level(true, LEVEL_JRB,            "easy",            { x = -13170, y = 9569,  z = -13406, a = 0x4000 }, 3.8,  1,   FLOOD_LAVA, { x = -4821, y = 772,  z = -10451, a =  -0x3000 })
    flood_define_level(true, LEVEL_JRB,            "easy",            { x = 10718, y = 4371,  z = -12824, a = 0x0000 }, 1.65,  1,   FLOOD_LAVA, { x = 2232, y = 2131,  z = -7361, a = 0x9000 })
    flood_define_level(true, LEVEL_CCM,            "easy",            { x = -10286, y = 4677,  z = 732, a = 0x0000 }, 3.55,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_CCM,            "easy",            { x = 5740, y = 3477,  z = -11847, a = 0x0000 }, 1.05,  1,   FLOOD_WATER, { x = -4116, y = -936,  z = -12208, a =  0x4000 })
    flood_define_level(true, LEVEL_BBH,            "easy",            { x = 11381, y = 3005,  z = -3900, a =  0x8000 }, 2.45,  1,   FLOOD_WATER, { x = 295, y = -4447,  z = 11116, a =  0x6000 })
    flood_define_level(true, LEVEL_BBH,            "easy",            { x = 9046, y = 3971,  z = 9425, a =  0x4000 }, 2.1,  1,   FLOOD_WATER, { x = 5976, y = -3044,  z = 6237, a =  0x2000 })
    flood_define_level(true, LEVEL_BBH,            "easy",            { x = -11900, y = 1415,  z = -6328, a =  0x0000 }, 1.5,  1,   FLOOD_WATER, { x = 2136, y = -2944,  z = 8721, a = -0x4000 })
    flood_define_level(true, LEVEL_BBH,            "easy",            { x = -265, y = 3936,  z = 1089, a =  0x8000 }, 3.0,  1,   FLOOD_WATER, { x = 469, y = -3462,  z = 1610, a = 0x8000 })
    flood_define_level(true, LEVEL_SA,             "easy",            { x = 6690, y = 4861,  z = -9207, a =  -0x4000 }, 2.6,  1,   FLOOD_WATER, { x = 4853, y = -2338, z = 2713, a = 0x8000 })
    flood_define_level(true, LEVEL_BITDW,          "easy",            { x = -1052,  y = -1010,  z = -3597,    a = 0x8000 }, 1.8,  1,   FLOOD_WATER, { x = -7772, y = -5730,  z = 3596, a = -0x2000 })
    flood_define_level(true, LEVEL_BITDW,          "easy",            { x = 9320,  y = 6328,  z = 5878,    a = -0x4000 }, 1.4,  1,   FLOOD_WATER, { x = 2099, y = -2450,  z = -3135, a = 0x4000 })
    flood_define_level(true, LEVEL_COTMC,          "easy",            { x = 10342, y = -1855, z = -5512, a = 0x0000 }, 2.3,  1,   FLOOD_LAVA, { x = -3710, y = -7836, z = 7465, a = 0x6500 })
    flood_define_level(true, LEVEL_COTMC,          "easy",            { x = 11530, y = 5340, z = -11592, a = 0x0000 }, 1.5,  1,   FLOOD_LAVA, { x = 10531, y = -1281, z = -5267, a = -0x6000 })
    flood_define_level(true, LEVEL_COTMC,          "easy",            { x = 9933, y = 2699,  z = 2009, a = 0x8000 }, 2.8,  1,   FLOOD_LAVA, { x = 802, y = -6775, z = 10912, a = 0x2000 })
    flood_define_level(true, LEVEL_COTMC,          "easy",          { x = -7022, y = -1965,  z = -9667, a = 0x0000 }, 1.0,  1,   FLOOD_LAVA, { x = -7663, y = -5244, z = 11313, a = 0x8000 })
    flood_define_level(true, LEVEL_HMC,            "easy",            { x =  4227, y = -4348,  z = -1355, a =  -0x4000 }, 3.2,  1,   FLOOD_LAVA, nil)
    flood_define_level(true, LEVEL_HMC,            "easy",            { x =  8012, y = 7533,  z = -8096, a =  0x0000 }, 2.5,  1,   FLOOD_LAVA, { x = 5085, y = -3501, z = -2240, a = 0x7500 })
    flood_define_level(true, LEVEL_HMC,            "easy",            { x = -7491, y = 5113,  z = 7911, a =  0x4000 }, 2.6,  1,   FLOOD_WATER, { x = -3283, y = -4177,  z = 2953, a = -0x4000 })
    flood_define_level(true, LEVEL_LLL,            "easy",            { x = 3647, y = 3018,  z = -6132, a = 0x0000 }, 1.2,  1,   FLOOD_WATER, { x = 8317, y = -4834, z = 9705, a = 0x8000 })
    flood_define_level(true, LEVEL_SSL,            "easy",            { x = 4713,   y = -2966,  z = 9751, a = 0x4000 }, 0.7,  1,   FLOOD_SAND, { x = -1570, y = -6491, z = -3647, a = 0x8000 })
    flood_define_level(true, LEVEL_SSL,            "easy",            { x = -14970,   y = 275,  z = -6054, a =  0x4000 }, 0.6,  1,   FLOOD_SAND, { x = 4061, y = -2841, z = 5925, a = 0x8000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",            { x = -1077, y = -4773,  z = -12886,  a = 0x8000 }, 0.5,  1,   FLOOD_SAND, { x = -184, y = -6433,  z = 12184, a = 0x8000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",            { x = -3239, y = 1814,  z = -4483,  a = 0x8000 }, 0.5,  1,   FLOOD_SAND, { x = -10142, y = -2418,  z = -2896, a = 0x8000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",            { x = 8220, y = -718,  z = 12621,  a = 0x4000 }, 1.1,  1,   FLOOD_SAND, { x = 3004, y = -6366,  z = 10882, a = 0x4000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",            { x = 1415, y = 5065,  z = -11390,  a = 0x0000 }, 2.5,  1,   FLOOD_SAND, { x = 13012, y = -6414,  z = -10339, a = 0x0000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",            { x = -8437, y = -1268,  z = 12019,  a = 0x0000 }, 1.7,  1,   FLOOD_SAND, { x = -4811, y = -6490,  z = 723, a = -0x4000 })
    flood_define_level(true, LEVEL_VCUTM,          "easy",            { x = 6639, y = 2669,  z = -7756,  a = -0x4000 }, 0.9,  1,   FLOOD_SAND, { x = 7543, y = -3555,  z = -6410, a = 0x0000 })
    flood_define_level(true, LEVEL_DDD,            "easy",            { x = -8350,  y = -2191,  z = -1146, a =  0x4000 }, 2.6,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_DDD,            "easy",            { x =  5459,  y = 3318,  z = 9041, a =  -0x6000 }, 2.7,  1,   FLOOD_WATER, { x = 5580, y = -3466,  z = -6956, a = 0x7000 })
    flood_define_level(true, LEVEL_DDD,            "easy",            { x =  14196,  y = 5558,  z = 11844, a =  -0x7000 }, 1.7,  1,   FLOOD_WATER, { x = 5031, y = 1184, z = 7138, a = 0x4000 })
    flood_define_level(true, LEVEL_SL,             "easy",            { x = 2041, y = 4356,  z = 1974, a =  0x8000 }, 2.5,  1,   FLOOD_WATER, { x = -6053, y = -6086, z = 11932, a = 0x8000 })
    flood_define_level(true, LEVEL_SL,             "easy",            { x = -5514, y = 5246,  z = -5416, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 467, y = -554, z = 449, a = -0x5000 })
    flood_define_level(true, LEVEL_BITFS,          "easy",            { x = 4279, y = -1805, z = -3728, a = -0x4000 }, 1.3,  1,   FLOOD_SAND, { x = -11629, y = -9380, z = -4519, a = 0x0000 })
    flood_define_level(true, LEVEL_BITFS,          "easy",            { x = 12473, y = 5778, z = -12280, a = 0x0000 }, 1.1,  1,   FLOOD_SAND, { x = 4272, y = -1453, z = -3462, a = 0x8000 })
    flood_define_level(true, LEVEL_BITFS,          "easy",            { x = 512, y = 2621, z = 10459, a = -0x4000 }, 1.1,  1,   FLOOD_SAND, { x = -6072, y = -735, z = -9766, a = 0x8000 })
    flood_define_level(true, LEVEL_WDW,            "easy",            { x = 12123, y = 2473, z = -12086, a = -0x2000 }, 1.6,  1,   FLOOD_WATER,  { x = -12095, y = -5320, z = 11968, a = 0x8000 }) 
    flood_define_level(true, LEVEL_WDW,            "easy",            { x = 2120, y = 4520,  z = -3796, a =  0x8000 }, 1.0,  1,   FLOOD_WATER,  { x = 7161, y = 1220, z = 5686, a = 0x6000 }) 
    flood_define_level(true, LEVEL_PSS,            "easy",            { x = 5383, y = 1071,  z = -4373, a =  -0x4000 }, 3.0,  1,   FLOOD_WATER, { x = 9513, y = -9011,  z = -542, a = -0x3000 })
    flood_define_level(true, LEVEL_PSS,            "easy",            { x = -8416, y = 1990,  z = -12478, a =  0x4000 }, 0.7,  1,   FLOOD_WATER, { x = 656, y = 846,  z = -4753, a = -0x6000 })
    flood_define_level(true, LEVEL_PSS,            "easy",            { x = -9827, y = 8930,  z = -7507, a =  0x8000 }, 0.7,  1,   FLOOD_WATER, { x = -8183, y = 2310,  z = -12493, a = -0x3000 })
    flood_define_level(true, LEVEL_TTM,            "easy",            { x = -376, y = -4329,  z = -3704, a =  0x4000 }, 2.2,  1,   FLOOD_WATER,  nil) 
    flood_define_level(true, LEVEL_TTM,            "easy",            { x = -6599, y = 5438,  z = -1960, a =  0x8000 }, 2.2,  1,   FLOOD_WATER, { x = 3492, y = -4143,  z = -5320, a = -0x3000 })
    flood_define_level(true, LEVEL_THI,            "easy",            { x = 8227, y = 676,  z = 11554, a =  0x0000 }, 1.6,  1,   FLOOD_WATER,  nil) 
    flood_define_level(true, LEVEL_THI,            "easy",            { x = -82, y = 449,  z = -8970, a =  0x4000 }, 0.5,  1,   FLOOD_WATER, { x = 8792, y = -262,  z = 11875, a = -0x4000 })
    flood_define_level(true, LEVEL_THI,            "easy",            { x = -12184, y = 3642,  z = -10059, a =  0x6000 }, 1.3,  1,   FLOOD_WATER, { x = -6342, y = -953,  z = -12776, a = -0x4000 })
    flood_define_level(true, LEVEL_TTC,            "easy",            { x = -9786, y = 151,  z = -10509, a =  -0x4000 }, 2.0,  1,   FLOOD_LAVA,  nil)
    flood_define_level(true, LEVEL_TTC,            "easy",            { x = -7738, y = 4355,  z = -11469, a =  -0x4000 }, 1.0,  1,   FLOOD_LAVA, { x = -8555, y = 122,  z = -11346, a = 0x4000 })
    flood_define_level(true, LEVEL_TTC,            "easy",            { x = 12527, y = 1592,  z = -5626, a =  -0x4000 }, 1.8,  1,   FLOOD_LAVA,  { x = 7791, y = -4224, z = 11748, a = -0x3000 }) 
    flood_define_level(true, LEVEL_TTC,            "easy",            { x = 4156, y = 5687,  z = 12665, a =  -0x4000 }, 1.2,  1,   FLOOD_LAVA,  { x = -11692, y = 1318, z = 4834, a = 0x0000 })
    flood_define_level(true, LEVEL_RR,             "easy",            { x = 2306, y = -3047, z = -5154,  a = 0x0000 }, 1.5,  1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_RR,             "easy",            { x = 13274, y = -864, z = -14632,  a = -0x4000 }, 0.15,  1,   FLOOD_WATER, { x = 2319, y = -4122, z = -5946, a = 0x4000 })
    flood_define_level(true, LEVEL_WMOTR,          "easy",            { x = 1108, y = 570,  z = 5000, a =  0x8000 }, 1.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(true, LEVEL_WMOTR,          "easy",            { x =  -14486, y = 1395,  z = -6872, a =  -0x4000 }, 0.6,  1,   FLOOD_WATER, { x = -1660, y = -838, z = 8, a = -0x4000 })	
    flood_define_level(true, LEVEL_WMOTR,          "easy",            { x =  -8058, y = 2513,  z = -14968, a =  -0x4000 }, 0.6,  1,   FLOOD_WATER, { x = -15217, y = 161, z = -3838, a = 0x8000 })
    flood_define_level(true, LEVEL_WMOTR,          "easy",            { x =  -4193, y = 4204,  z = -1343, a =  0x8000 }, 0.4,  1,   FLOOD_WATER, { x = -8058, y = 2513, z = -14968, a = 0x4000 })
    flood_define_level(true, LEVEL_WMOTR,          "easy",            { x = 15255, y = 364,  z = 1849, a =  0x8000 }, 0.6,  1,   FLOOD_WATER, { x = 1594, y = -1051, z = 7, a = 0x5000 })
    flood_define_level(true, LEVEL_WMOTR,          "easy",            { x = 6516, y = 3256,  z = -3967, a =  0x8000 }, 0.8,  1,   FLOOD_WATER, { x = 15504, y = 27, z = -644, a = 0x8000 })
    flood_define_level(true, LEVEL_BITS,           "easy",            { x = -5383, y = -212,  z = -4196, a =  0x8000 }, 1.6,  1,   FLOOD_WATER,  nil) 
    flood_define_level(true, LEVEL_BITS,           "easy",            { x = -2631, y = 3149,  z = -13766, a =  -0x1000 }, 0.5,  1,   FLOOD_WATER, { x = -8794, y = -1059, z = -3843, a = -0x4000 })
    flood_define_level(true, LEVEL_BITS,           "easy",            { x = -5855, y = 6010,  z = -3161, a =  0x8000 }, 0.3,  1,   FLOOD_WATER, { x = 8332, y = 3760, z = -9616, a = -0x2000 })
    flood_define_level(true, LEVEL_BITS,           "easy",            { x = -6084, y = 8692,  z = 11968, a =  0x8000 }, 0.8,  1,   FLOOD_WATER, { x = -6642, y = 4775, z = -1813, a = 0x8000 })
    flood_define_level(true, LEVEL_ENDING,         "easy",            { x = -4941, y = 1756,  z = -1739, a =  -0x6000 }, 1.8, 1,   FLOOD_WATER, { x = -5688, y = -2790, z = 4199, a = 0x6000 })
    flood_define_level(true, LEVEL_CASTLE_GROUNDS, "easy",            { x = 4174, y = 2509,  z = 5375, a =  0x4000 }, 3.1, 1,   FLOOD_WATER, nil)
    flood_define_level(true, LEVEL_CASTLE_COURTYARD, "easy",          { x = 5739, y = 2590,  z = -4089, a =  0x8000 }, 3.5, 1,   FLOOD_WATER, { x = -662, y = -2066, z = 5258, a = 0x8000 }) 
    flood_define_level(true, LEVEL_CASTLE,         "easy",            { x = 309, y = 5084, z = -9311, a = 0x0000 } , 2.5, 1,   FLOOD_WATER,  { x = -1556, y = -3151, z = 8851, a = 0x8000 })
end

local function flood_load_super_mario_8mb_levels()
    game = GAME_SUPER_MARIO_8MB
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Super Mario 8MB"
	TEX_ROMHACK_LOGO = get_texture_info("super_mario_8mb_logo")	

    flood_define_level(false, LEVEL_BOB,    "c1", { x = -5650, y =   830, z = -4985, a =  0x0000 }, 1.5,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,     "sa", { x =  6450, y =   300, z = -1835, a =  0x8000 }, 2.5,  1, FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_VCUTM,  "vc", { x =  2870, y = 15710, z = 13510, a =  0x2000 }, 3.0,  1, FLOOD_WATER, { x = 1620, y = 13745, z = -8720, a = 0x0000 })
    flood_define_level(false, LEVEL_BITDW,  "b1", { x =  7040, y = 13350, z =  5320, a = -0x4000 }, 0.75, 1, FLOOD_WATER, { x = 1620, y = 14000, z = -9890, a = 0x0000 })
end

local function flood_load_sonic_adventure_64_levels()
    game = GAME_SONIC_ADVENTURE_64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Sonic Adventure 64"
	TEX_ROMHACK_LOGO = get_texture_info("sonic_adventure_64_logo")	

    flood_define_level(false, LEVEL_BOB, "c1", { x =  5000, y =  -190, z =  17035, a =  0x8000 }, 1.25, 1,  FLOOD_WATER, nil)
end

local function flood_load_sleepy_time_64_levels()
    game = GAME_SLEEPY_TIME_64
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Sleepy Time 64"
	TEX_ROMHACK_LOGO = get_texture_info("sleepy_time_64_logo")	

    flood_define_level(false, LEVEL_PSS,    "pss",   { x =  6860, y =  5730, z =  1430, a =  0x8000 }, 3.0,  1, FLOOD_WATER, { x =   510, y = -2615, z = -630, a = -0x4000 })
    flood_define_level(false, LEVEL_SA,     "sa",    { x = -1525, y =  1490, z = -8935, a =  0x0000 }, 1.5,  1, FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,  "wmotr", { x =  4885, y =  -850, z =  8440, a =  0x8000 }, 1.0,  1, FLOOD_LAVA,  { x = -4765, y =  -510, z = 8000, a =  0x8000 })
    flood_define_level(false, LEVEL_CASTLE, "c",     { x = -2605, y = -1110, z =  8195, a =  0x8000 }, 0.75, 1, FLOOD_WATER, nil)
end

local function flood_load_shining_stars_2_levels()
    game = GAME_SHINING_STARS_2
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Shining Stars 2: Mirror Madness"
	TEX_ROMHACK_LOGO = get_texture_info("shining_stars_2_logo")	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  -1080, y =    390, z =  -1430, a =  0x0000 }, 0.75, 1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   1495, y =  -1185, z = -18690, a =  0x4000 }, 1.5,  1,  FLOOD_WATER, { x = -2815, y =  -5020, z = -18330, a =  0x0000 })
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   1400, y =   1490, z = -10465, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =  -2885, y =  14300, z =  -7400, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x = -7970, y =   3095, z =   9720, a =  0x0000 })
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =  -3700, y =  -3815, z = -15095, a =  0x8000 }, 0.60, 1,  FLOOD_WATER, { x =  -730, y =  -3510, z =   6930, a =  0x0000 })
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =   6625, y =  16265, z = -11065, a = -0x4000 }, 10.0, 1,  FLOOD_WATER, { x =  5640, y =  -5980, z =   6425, a = -0x4000 })
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =    -95, y =   4250, z =   1245, a =  0x6000 }, 2.0,  1,  FLOOD_WATER, { x = -2290, y =  -4870, z =  -1375, a =  0x8000 })	
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =   1785, y =   3810, z =   -255, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x = -3550, y =  -2305, z =   2970, a =  0x8000 })	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =  21705, y =   1520, z =  -4005, a =  0x0000 }, 2.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =     40, y =    390, z =   -845, a =  0x4000 }, 1.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =   1905, y =   -970, z = -18730, a =  0x4000 }, 1.25, 1,  FLOOD_LAVA,  { x =  1770, y =  -4705, z = -19740, a = -0x4000 })	
    flood_define_level(false, LEVEL_SA,               "sa",             { x =   7640, y =   2040, z =  -7540, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =   -770, y =   -750, z =   8750, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, { x =  -345, y =   -700, z =  -7935, a =  0x8000 })	
    flood_define_level(false, LEVEL_SL,               "c10",            { x =   1150, y =   1490, z = -10700, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =  -1850, y =   9285, z =  -5820, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =  -3700, y =  -3815, z = -15095, a =  0x0000 }, 0.60, 1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_THI,              "c13",            { x =  15485, y =   1905, z =  -3785, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_TTC,              "c14",            { x =   9220, y =   2745, z =   9235, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_RR,               "c15",            { x =   6450, y =   2390, z =  -7315, a =  0x0000 }, 1.75, 1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =  -7335, y =   1590, z = -17840, a =  0x0000 }, 0.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =   3460, y =   2360, z =  -5570, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  nil)				
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x = -10155, y =    -25, z =   -240, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x = -10155, y =   -180, z =   -240, a =  0x8000 }, 2.0,  1,  FLOOD_LAVA,  { x =  1770, y =      0, z =  -8240, a =  0x8000 })	
end

local function flood_load_kaizo_mario_64_2_levels()
    game = GAME_KAIZO_MARIO_64_2
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS	
	romhackText = "Kaizo Mario 64 2"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")
	gLevelValues.metalCapDurationCotmc  = 1
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvWingCap, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		
    hook_behavior(id_bhvMetalCap, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_BOB,            "c1",            { x = -1410, y = 5150, z = 1165, a =  0x4000 }, 2.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",             { x = 0,  y = 6000, z = 0,   a =  0x0000 }, 6.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,            "c3",            { x =  4867, y =  1913, z =  853,  a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x =  5138, y = -4912, z =  201,  a = 0x0000 })
    flood_define_level(false, LEVEL_JRB,            "c3-ship",       { x =  20, y =  1260, z =  2910,  a =  0x8000 }, 7.0,  2,   FLOOD_WATER, { x = 675, y = -220, z = -2685,  a =  0x0000 })
    flood_define_level(false, LEVEL_CCM,            "c4",            { x = -50,  y = 5580, z = -150,  a =  0x4000 }, 5.0,  1,   FLOOD_WATER, { x =  3336, y = -3800, z =  0,    a = 0x0000 })
    flood_define_level(false, LEVEL_CCM,            "c4-slide",      { x = -5620, y =  6656, z = -6145, a =  0x4000 }, 5.5,  2,  FLOOD_WATER, { x = -6498, y = -5836, z = -6937, a = 0x0000 })	
    flood_define_level(false, LEVEL_BBH,            "c5",            { x =   655, y =  3280, z =   245,  a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x = 2860, y = -2845, z = 2050, a = 0x8000 })	
    flood_define_level(false, LEVEL_PSS,            "pss",            { x =  3127, y =  7035, z = -5650, a =  0x4000 }, 5.0,  1,   FLOOD_WATER, { x = -6387, y = -4000, z =  5723, a = 0x8000 })
    flood_define_level(false, LEVEL_BITDW,          "b1",          { x = 6770,  y = 2870,  z =  0,    a = -0x4000 }, 3.5,  1,   FLOOD_WATER,  nil) 
    flood_define_level(false, LEVEL_HMC,            "c6",            { x = -7357, y =  2161, z =  7362, a =  0x6000 }, 4.5,  1,   FLOOD_WATER, { x = -3538, y = -3979, z =  3568, a = 0x8000 })
    flood_define_level(false, LEVEL_COTMC,          "mc",          { x =  4,    y =  360,  z = -6138, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,          "vc",          { x = 4520,  y = 0,  z = -4670, a =  0x8000 }, 3.5,  1,   FLOOD_WATER, { x = -6410, y = -3200, z = 1240, a = 0x4000 })	
    flood_define_level(false, LEVEL_LLL,            "c7",            { x =  0, y =  770, z = -6700,  a = 0x8000 }, 1.0,  1,   FLOOD_LAVA, nil)	
    flood_define_level(false, LEVEL_LLL,            "c7-volcano",    { x =  1790, y =  3230, z = 1460,  a = 0x8000 }, 3.5,  2,   FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_SSL,            "c8",            { x = -2040,  y =  1590, z = -1025,  a =  0x0000 }, 3.0,  1,   FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,            "c8-pyramid",    { x =  512,  y =  4815, z = -551,  a =  0x4000 }, 3.0,  2,   FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_DDD,            "c9",            { x = -4020, y = 3835,  z = -1435,    a = -0x4000 }, 1.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITFS,          "b2",          { x =  1224, y =  5478, z =  84,   a =  0x0000 }, 3.0,  1,   FLOOD_LAVA, nil)	
    flood_define_level(false, LEVEL_SL,             "c10",             { x = 0,   y =  4865, z = 0,  a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,             "c10-igloo",      { x = -5,   y =  0, z = 2575,  a =  0x8000 }, 3.0,  2,   FLOOD_WATER, { x = -390, y = 145, z = -1740, a = 0x4000 })		
    flood_define_level(false, LEVEL_WDW,            "c11",            { x =  1467, y =  4096, z =  93,   a = -0x4000 }, 3.5,  1,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,            "c12",            { x =  0, y =  3555, z = 0,  a =  0x0000 }, 6.0,  1,   FLOOD_WATER, { x = -430, y = -4125, z = 7745, a = 0x0000 })	
    flood_define_level(false, LEVEL_THI,            "c13",            { x = -12,    y = 3891,  z = -1556, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_THI,            "c13-tiny",       { x = 100,    y = 1170,  z = -400, a =  0x4000 }, 5.0,  2,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_THI,            "c13-cave",       { x = -1955,    y = 1535,  z = -1090, a =  0x4000 }, 6.0,  3,   FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,            "c14",            { x =  2208, y =  7051, z =  2217, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_RR,             "c15",             { x =  3555,    y =  4770, z = -2330, a =  0x0000 }, 2.5,  1,   FLOOD_WATER, { x = 2560, y = 9630, z = 2070, a = 0x4000 })
    flood_define_level(false, LEVEL_BITS,           "b3",           { x =  369,  y =  6552, z = -6000, a =  0x0000 }, 4.0,  1,   FLOOD_LAVA,  { x = -7039, y = 7000, z = 4, a = 0x4000 })	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",           { x =  0,    y =  7583, z = -4015, a =  0x0000 }, 7.0,  1,   FLOOD_WATER, nil)	
end

-- SM74EEEE ported to Flood by SuperRodrigo0
local function flood_load_super_mario_74_EEEE_levels()
    game = GAME_SM74EEEE
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "SM74EEEE"
	TEX_ROMHACK_LOGO = get_texture_info("sm74_eeee_logo")	
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

  flood_define_level(false, LEVEL_BOB,              "c1",              { x =  -219, y = 2269,  z =  -4594, a =  0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = 3334, y = -962, z = -5298, a = 0x0000 })
  flood_define_level(false, LEVEL_WF,               "c2",               { x =  -2203,  y = 5567,  z = -712, a =  -0x4000 }, 4.0,  1,   FLOOD_WATER, { x = 3579, y = -2848, z = -905, a = 0x8000 })
  flood_define_level(false, LEVEL_JRB,              "c3",              { x =  2275, y = 2995, z = -3055,  a =  -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = -960, y = -4385, z = -800, a = 0x0000 })
  flood_define_level(false, LEVEL_COTMC,            "mc",            { x =  3310, y = 7520, z = -380,  a =  0x0000 }, 1.5,  1,   FLOOD_LAVA, { x = 1094, y = 307, z = -4421, a = 0x0000 }) 
  flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -4405,  y = 5550,  z =  1720,    a = 0x4000 }, 1.1,  1,   FLOOD_WATER, { x = -3910, y = -705, z = -5155, a = 0x0000 })
  flood_define_level(false, LEVEL_CCM,              "c4",              { x =  4859, y = 1501,  z = 293, a = -0x8000 }, 1.9,  1,   FLOOD_WATER, { x = 2409, y = -39, z = -5916,  a = 0x0000 })
  flood_define_level(false, LEVEL_VCUTM,            "vc",            { x = -2499,  y = 2365,  z = 4007, a =  0x0000 }, 1.4,  1,   FLOOD_WATER, { x = 6257, y = -1286, z = -1315,  a = -0x4000 }) 
  flood_define_level(false, LEVEL_PSS,              "pss",              { x = 2647, y = 5026,  z =  -3954, a =  -0x2000 }, 4.3,  1,   FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_HMC,              "c6",              { x = 5065, y = 2347, z = 4229, a =  0x8000 }, 1.0,  1,   FLOOD_LAVA,  { x = -5755, y = 675, z = 2165, a = 0x0000 })
  flood_define_level(false, LEVEL_LLL,              "c7",              { x = -1080, y = 11805,  z =  500, a = -0x0000 }, 2.6,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_SSL,              "c8",              { x = 4260, y = 5165, z = 4800, a =  0x8000 }, 1.5,  1,   FLOOD_SAND,  { x = -2188, y = -565,  z = -5767, a = 0x0000 })
  flood_define_level(false, LEVEL_DDD,              "c9",              { x = 3718, y = 2256, z = -4753, a =  0x0000 }, 1.6,  1,   FLOOD_LAVA, { x = 2917, y = -3223, z = -5590, a = 0x0000 })
  flood_define_level(false, LEVEL_TOTWC,            "wc",            {  x =  -2985,  y = 4564,  z = -242, a =  0x0000 }, 2.0,  1,   FLOOD_LAVA, { x = 132, y = -2164, z = 814, a = 0x0000 })
  flood_define_level(false, LEVEL_BITFS,            "b2",            { x = -4878, y = 6639, z = -6502, a =  0x0000 }, 0.7,  1,   FLOOD_SAND, { x = -537, y = 4080, z = -2322, a = 0x0000 })
  flood_define_level(false, LEVEL_SL,               "c10",               { x = -2261, y = 4320, z =  3279, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = 2239, y = -253, z = -3367, a = 0x8000 })  
  flood_define_level(false, LEVEL_WDW,              "c11",              { x =  -2335, y =  3277, z =  -1160,   a = 0x4000 }, 1.0,  1,   FLOOD_WATER, { x = -3896, y = -1366, z = 5741, a = 0x4000 })  
  flood_define_level(false, LEVEL_TTM,              "c12",              { x = 3200,  y = 4630, z = -4320,  a =  0x4000 }, 1.3,  1,   FLOOD_WATER, { x = -50,  y = -4485, z = 2200, a = 0x0000 })
  flood_define_level(false, LEVEL_THI,              "c13",              { x =  6319,  y = 4826,  z = -787,   a =  0x0000 }, 1.5,  1,   FLOOD_SAND, nil)
  flood_define_level(false, LEVEL_TTC,              "c14",              { x = -2329, y = 11814, z = 649, a =  0x0000 }, 0.75,  1,   FLOOD_MUD, nil)
  flood_define_level(false, LEVEL_RR,               "c15",               { x = 90, y = 10815, z = -4320, a =  0x8000 }, 0.6,  1,   FLOOD_LAVA, nil)
  flood_define_level(false, LEVEL_SA,               "sa",               { x =  -2770,  y = 2092,  z = 6215, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 7765,  y = -50, z = -5920, a = -0x4000 })
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",               { x = -143, y = 743,  z = -1668, a =  -0x4000 }, 1.5, 1,   FLOOD_LAVA, nil)
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",            { x = 524,  y = 3624, z = -2779, a =  -0x4000 }, 1.9,  1,   FLOOD_WATER, { x = 469, y = -627, z = -5215, a = -0x4500 })
  flood_define_level(false, LEVEL_CASTLE,           "c",           { x = 39,    y = 2135, z =  3501, a = 0x4000 }, 5.0,  1,   FLOOD_LAVA, { x = -260,  y = -1315, z = -4345, a = 0x0000 })

---- Easy Mode ---- flood start 25

  flood_define_level(true, LEVEL_BOB,              "easy",              { x =  -186, y = 2744,  z = 3868, a =  0x4000 }, 1.6,  1,   FLOOD_LAVA, { x = 3334, y = -962, z = -5298, a = 0x0000 })
  flood_define_level(true, LEVEL_BOB,              "easy",              { x =  -219, y = 2269,  z =  -4594, a =  0x0000 }, 0.55,  1,   FLOOD_LAVA, { x = 369, y = 2597, z = 3901, a = -0x4000 })
  flood_define_level(true, LEVEL_WF,               "easy",               { x = -2203,  y = 5567,  z = -712, a =  -0x4000 }, 4.0,  1,   FLOOD_WATER, { x = 3579, y = -2848, z = -905, a = 0x8000 })
  flood_define_level(true, LEVEL_JRB,              "easy",              { x = 2191, y = -903, z = 2410,  a = 0x8000 }, 1.5,  1,   FLOOD_LAVA, { x = -960, y = -4385, z = -800, a = 0x0000 })
  flood_define_level(true, LEVEL_JRB,              "easy",              { x =  2275, y = 2995, z = -3055,  a =  -0x4000 }, 1.8,  1,   FLOOD_LAVA, { x = -266, y = 409, z = 3145, a = 0x6000 })
  flood_define_level(true, LEVEL_COTMC,            "easy",            { x =  3310, y = 7520, z = -380,  a =  0x0000 }, 1.5,  1,   FLOOD_LAVA, { x = 1778, y = 1041, z = 1914,  a = 0x4000 }) 
  flood_define_level(true, LEVEL_BITDW,            "easy",            { x = -1786,  y = 1959,  z = 3112,  a = 0x0000 }, 1.2,  1,   FLOOD_WATER, { x = -3910, y = -705, z = -5155, a = 0x0000 })
  flood_define_level(true, LEVEL_BITDW,            "easy",            { x =  -4405,  y = 5550,  z =  1720,  a = 0x4000 }, 1.1,  1,   FLOOD_WATER, { x = -3645, y = 2289, z = 1171, a = 0x4000 })
  flood_define_level(true, LEVEL_CCM,              "easy",              { x =  4859, y = 1501,  z = 293, a = -0x8000 }, 1.9,  1,   FLOOD_WATER, { x = 2409, y = -39, z = -5916,  a = 0x0000 })
  flood_define_level(true, LEVEL_VCUTM,            "easy",            { x = 458,  y = 2440,  z = 4228, a =  0x0000 }, 1.4,  1,   FLOOD_WATER, { x = 6257, y = -1286, z = -1315,  a = -0x4000 }) 
  flood_define_level(true, LEVEL_VCUTM,            "easy",            { x = -2499,  y = 2365,  z = 4007, a =  0x8000 }, 1.1,  1,   FLOOD_WATER, { x = 456, y = 1066, z = 5458,  a = 0x8000 }) 
  flood_define_level(true, LEVEL_PSS,              "easy",              { x = 2647, y = 5026,  z =  -3954, a =  -0x2000 }, 4.3,  1,   FLOOD_WATER, nil)  
  flood_define_level(true, LEVEL_HMC,              "easy",              { x = 573, y = 2912, z = 3654, a = -0x4000 }, 1.4,  1,   FLOOD_LAVA,  { x = -5755, y = 675, z = 2165, a = 0x0000 })
  flood_define_level(true, LEVEL_HMC,              "easy",              { x = 5065, y = 2347, z = 4229, a = 0x8000 }, 1.1,  1,   FLOOD_LAVA,  { x = 3053, y = 2347, z = 578, a = 0x4000 })
  flood_define_level(true, LEVEL_LLL,              "easy",               { x =  564,   y = 206,   z = -1177,   a =  0x8000 }, 5,  1,   FLOOD_WATER, nil)
  flood_define_level(true, LEVEL_LLL,              "easy",               { x = -1080, y = 11805,  z =  500, a = 0x0000 }, 3,  1,   FLOOD_WATER,  { x =  1776, y = 1182, z = -340 ,  a =  0x0000 })
  flood_define_level(true, LEVEL_SSL,              "easy",              { x = 4260, y = 5165, z = 4800, a =  0x8000 }, 2.1,  1,   FLOOD_SAND,  { x = 5143, y = -1004,  z = -44, a = 0x0000 })
  flood_define_level(true, LEVEL_DDD,              "easy",              { x = 3718, y = 2256, z = -4753, a =  0x0000 }, 1.2,  1,   FLOOD_LAVA, { x = 3735, y = -152, z = 4008, a = 0x8000 })
  flood_define_level(true, LEVEL_TOTWC,            "easy",            {  x =  -2985,  y = 4564,  z = -242, a =  0x0000 }, 2.0,  1,   FLOOD_LAVA, { x = 132, y = -2164, z = 814, a = 0x0000 })
  flood_define_level(true, LEVEL_BITFS,            "easy",            { x = -4878, y = 6639, z = -6502, a =  0x0000 }, 0.7,  1,   FLOOD_SAND, { x = -300, y = 4247, z = -1458, a = -0x4000 })
  flood_define_level(true, LEVEL_SL,               "easy",               { x = -2261, y = 4320, z =  3279, a =  0x4000 }, 2.0,  1,   FLOOD_WATER, { x = 2239, y = -253, z = -3367, a = 0x8000 })  
  flood_define_level(true, LEVEL_WDW,              "easy",              { x =  -2335, y =  3277, z =  -1160,   a = 0x4000 }, 1.2,  1,   FLOOD_WATER, { x = 4659, y = 538, z = -2519, a = 0x0000 })  
  flood_define_level(true, LEVEL_TTM,              "easy",              { x = -62,  y = 604, z = 1016,  a =  0x4000 }, 1.3,  1,   FLOOD_WATER, { x = -50,  y = -4485, z = 2200, a = 0x0000 })
  flood_define_level(true, LEVEL_TTM,              "easy",              { x = 3200,  y = 4630, z = -4320,  a =  0x4000 }, 1.27,  1,   FLOOD_WATER, { x = -2598,  y = 604, z = -323, a = -0x6500 })
  flood_define_level(true, LEVEL_THI,              "easy",              { x =  6319,  y = 4826,  z = -787,   a =  0x0000 }, 0.83,  1,   FLOOD_SAND, { x = 5116,  y = 449, z = -2824, a = 0x0000 })
  flood_define_level(true, LEVEL_TTC,              "easy",              { x = 2384, y = 2778, z = -3500, a = -0x4000 }, 2.0,  1,   FLOOD_MUD, { x = -2188,  y = -4893, z = -4541, a = 0x4000 })
  flood_define_level(true, LEVEL_TTC,              "easy",              { x = -670, y = 5847, z = 4555, a =  0x0000 }, 1.5,  1,   FLOOD_MUD, { x = 1571, y = 1336, z = -396, a = 0x4000 })
  flood_define_level(true, LEVEL_TTC,              "easy",              { x = -1279, y = 6014, z = -5442, a =  0x0000 }, 0.67,  1,   FLOOD_MUD, { x = -1233, y = 5047, z = 5558, a = 0x4000 })
  flood_define_level(true, LEVEL_TTC,              "easy",              { x = -2329, y = 11814, z = 649, a =  0x0000 }, 1.27,  1,   FLOOD_MUD, { x = -1305, y = 6158, z = -4933, a = 0x8000 })
  flood_define_level(true, LEVEL_RR,               "easy",               { x = 1429, y = 906, z = -6642, a =  0x4000 }, 1.5,  1,   FLOOD_LAVA, nil)
  flood_define_level(true, LEVEL_RR,               "easy",               { x = -2305, y = 3703, z = 2976, a =  0x8000 }, 0.75,  1,   FLOOD_LAVA, { x = 166, y = 906, z = -6678, a = -0x4000 })
  flood_define_level(true, LEVEL_RR,               "easy",               { x = 2558, y = 7572, z = 4584, a =  0x4000 }, 1.2,  1,   FLOOD_LAVA, { x = -2605, y = 816, z = 109, a = 0x4000 })
  flood_define_level(true, LEVEL_RR,               "easy",               { x = 90, y = 10815, z = -4320, a =  0x8000 }, 0.72,  1,   FLOOD_LAVA, { x = 2573, y = 7924, z = 4818, a = 0x8000 })
  flood_define_level(true, LEVEL_SA,               "easy",               { x =  -2770,  y = 2092,  z = 6215, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 7765,  y = -50, z = -5920, a = -0x4000 })
  flood_define_level(true, LEVEL_CASTLE_COURTYARD, "easy",               { x = -143, y = 743,  z = -1668, a =  -0x4000 }, 1.5, 1,   FLOOD_LAVA, nil)
  flood_define_level(true, LEVEL_WMOTR,            "easy",            { x = 524,  y = 3624, z = -2779, a =  -0x4000 }, 1.9,  1,   FLOOD_WATER, { x = 469, y = -627, z = -5215, a = -0x4500 })
  flood_define_level(true, LEVEL_CASTLE,           "easy",           { x = 39,    y = 2135, z =  3501, a = 0x4000 }, 5.0,  1,   FLOOD_LAVA, { x = -260,  y = -1315, z = -4345, a = 0x0000 })
end	

-- SM74EEEEEE 2 ported to Flood by SuperRodrigo0
local function flood_load_super_mario_74_EEEEEE_2_levels()
    game = GAME_SM74EEEEEE_2
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "SM74EEEEEE 2"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")	
    hook_behavior(id_bhvFadingWarp, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

  flood_define_level(false, LEVEL_BOB,              "c1",              { x =  -3911, y = 4681,  z = -1744, a =  0x8000 }, 1.0,  1,   FLOOD_LAVA, { x = 3322,  y = -754, z = -5559, a = 0x0000 })
  flood_define_level(false, LEVEL_WF,               "c2",               { x = -2218, y = 6397,  z = -1402, a =  0x0000 }, 7.1,  1,   FLOOD_WATER, { x = 3595,  y = -1747, z = 3310, a = 0x8000 })
  flood_define_level(false, LEVEL_JRB,              "c3",              { x =  2275, y = 2995, z = -3055,  a =  -0x4000 }, 1.5,  1,   FLOOD_LAVA, { x = -960, y = -4385, z = -800, a = 0x0000 })
  flood_define_level(false, LEVEL_COTMC,            "mc",            { x =  3310, y = 7520, z = -380,  a =  0x0000 }, 2.0,  1,   FLOOD_LAVA, { x = 949, y = 307, z = -4470, a = 0x0000 })
  flood_define_level(false, LEVEL_BITDW,            "b1",            { x =  -5605,  y = 7014,  z = -2872,  a = 0x0000 }, 1.8,  1,   FLOOD_WATER, { x = -3910, y = -705, z = -5155, a = 0x0000 })
  flood_define_level(false, LEVEL_CCM,              "c4",              { x = 3397, y = 452, z = -4974, a = -0x4000 }, 1.9,  1,   FLOOD_WATER, { x = 3567, y = -2627, z = 2858,  a = 0x0000 })
  flood_define_level(false, LEVEL_VCUTM,            "vc",            { x = -2693,  y = 6458,  z = 5736, a =  0x8000 }, 2.1,  1,   FLOOD_WATER, { x = -6901, y = -3430, z = -2557,  a = 0x5000 })
  flood_define_level(false, LEVEL_PSS,              "pss",              { x = 2647, y = 5026,  z =  -3954, a =  -0x2000 }, 3.5,  1,   FLOOD_WATER, nil)  
  flood_define_level(false, LEVEL_HMC,              "c6",              { x = -1936, y = 2728, z = -1834, a =  0x8000 }, 1.1,  1,   FLOOD_LAVA,  { x = -5755, y = 675, z = 2165, a = 0x0000 })
  flood_define_level(false, LEVEL_HMC,              "c6",              { x = 4978, y = 2347, z = 4301, a =  0x8000 }, 3.3,  1,   FLOOD_LAVA,  { x = -1514, y = -3863, z = -2785, a = 0x5000 })
  flood_define_level(false, LEVEL_LLL,              "c7",              { x = -1080, y = 11805,  z =  500, a = -0x0000 }, 2.6,  1,   FLOOD_WATER, nil)
  flood_define_level(false, LEVEL_SSL,              "c8",              { x = 4260, y = 5165, z = 4800, a =  0x8000 }, 0.9,  1,   FLOOD_SAND, { x = -2364, y = -283, z = -5965, a = -0x2000 })
  flood_define_level(false, LEVEL_DDD,              "c9",              { x = 3718, y = 2256, z = -4753, a =  0x0000 }, 1.5,  1,   FLOOD_LAVA, { x = 2917, y = -3223, z = -5590, a = 0x0000 })
  flood_define_level(false, LEVEL_TOTWC,            "wc",            { x =  -779,  y = 4626,  z = 155, a = -0x4000 }, 1.8,  1,   FLOOD_LAVA, { x = 132, y = -2164, z = 814, a = 0x0000 })
  flood_define_level(false, LEVEL_BITFS,            "b2",            { x = -4878, y = 6639, z = -6502, a =  0x0000 }, 0.5,  1,   FLOOD_SAND, { x = 496, y = 4086, z = -6216, a = 0x0000 })
  flood_define_level(false, LEVEL_SL,               "c10",               { x = -2261, y = 4320, z =  3279, a =  0x4000 }, 1.0,  1,   FLOOD_WATER, { x = 4735, y = 152, z = 4474, a = 0x2000 })  
  flood_define_level(false, LEVEL_WDW,              "c11",              { x =  -5615, y = 6365, z = -4191, a = 0x4000 }, 1.8,  1,   FLOOD_WATER, { x = -4145, y = -1190, z = 5711, a = 0x4000 }) 
  flood_define_level(false, LEVEL_TTM,              "c12",              { x = 3200,  y = 4630, z = -4320,  a =  0x4000 }, 1.3,  1,   FLOOD_WATER, { x = -50,  y = -4485, z = 2200, a = 0x0000 })
  flood_define_level(false, LEVEL_THI,              "c13",              { x = 6374, y = 4826, z = -928, a =  0x0000 }, 1.0,  1,   FLOOD_LAVA, { x = -7491,  y = 400, z = 7408, a = 0x6000 })
  flood_define_level(false, LEVEL_TTC,              "c14",              { x = 223, y = 13057, z = -84, a = -0x4000 }, 1.15,  1,   FLOOD_MUD, { x = -452,  y = -4881, z = 1580, a = 0x8000 })
  flood_define_level(false, LEVEL_RR,               "c15",               { x = 90, y = 10815, z = -4320, a =  0x8000 }, 0.79,  1,   FLOOD_LAVA, { x = 744,  y = -2916, z = 404, a = 0x8000 })
  flood_define_level(false, LEVEL_SA,               "sa",               { x =  -2767,  y = 2092,  z = 6210, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 7765,  y = -50, z = -5920, a = -0x4000 })
  flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",               { x = -143, y = 743,  z = -1668, a =  -0x4000 }, 1.5, 1,   FLOOD_LAVA, nil)
  flood_define_level(false, LEVEL_WMOTR,            "wmotr",            { x = 120,  y = 4446, z = 2035, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = -322, y = -638, z = -4658, a = -0x5500 })
  flood_define_level(false, LEVEL_CASTLE,           "c",           { x = 39,    y = 2135, z =  3501, a = 0x4000 }, 5.0,  1,   FLOOD_LAVA, { x = -260,  y = -1315, z = -4345, a = 0x0000 })
  
----------------------------- Easy Mode by SuperRodrigo0 ----------------------------- START 26

  flood_define_level(true, LEVEL_BOB,              "easy",              { x =  -186, y = 2744,  z = 3868, a =  0x4000 }, 1.6,  1,   FLOOD_LAVA, { x = 3322,  y = -754, z = -5559, a = 0x0000 })
  flood_define_level(true, LEVEL_BOB,              "easy",              { x =  -3911, y = 4681,  z = -1744, a =  0x8000 }, 0.55,  1,   FLOOD_LAVA, { x = 369, y = 2597, z = 3901, a = -0x4000 })
  flood_define_level(true, LEVEL_WF,               "easy",               { x = -2218, y = 6397,  z = -1402, a =  0x0000 }, 4.0,  1,   FLOOD_WATER, { x = 3579, y = -2848, z = -905, a = 0x8000 })
  flood_define_level(true, LEVEL_JRB,              "easy",              { x = 2191, y = -903, z = 2410,  a = 0x8000 }, 1.5,  1,   FLOOD_LAVA, { x = -960, y = -4385, z = -800, a = 0x0000 })
  flood_define_level(true, LEVEL_JRB,              "easy",              { x =  2275, y = 2995, z = -3055,  a =  -0x4000 }, 1.8,  1,   FLOOD_LAVA, { x = -266, y = 409, z = 3145, a = 0x6000 })
  flood_define_level(true, LEVEL_COTMC,            "easy",            { x =  3310, y = 7520, z = -380,  a =  0x0000 }, 1.5,  1,   FLOOD_LAVA, { x = 1778, y = 1041, z = 1914,  a = 0x4000 })
  flood_define_level(true, LEVEL_BITDW,            "easy",            { x = -1786,  y = 1959,  z = 3112,  a = 0x0000 }, 1.8,  1,   FLOOD_WATER, { x = -3910, y = -705, z = -5155, a = 0x0000 })
  flood_define_level(true, LEVEL_BITDW,            "easy",            { x =  -5605,  y = 7014,  z = -2872,  a = 0x0000 }, 1.6,  1,   FLOOD_WATER, { x = -3645, y = 2289, z = 1171, a = 0x4000 })
  flood_define_level(true, LEVEL_CCM,              "easy",              { x = -556, y = 197, z = 5882, a = 0x4000 }, 2.0,  1,   FLOOD_WATER, { x = 3567, y = -2627, z = 2858,  a = 0x0000 })
  flood_define_level(true, LEVEL_VCUTM,            "easy",            { x = 367,  y = 730,  z = 5359, a =  0x8000 }, 3.4,  1,   FLOOD_WATER, { x = -6901, y = -3430, z = -2557,  a = 0x5000 })
  flood_define_level(true, LEVEL_VCUTM,            "easy",            { x = -2693,  y = 6458,  z = 5736, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 423, y = 730, z = 5604,  a = 0x8000 })
  flood_define_level(true, LEVEL_PSS,              "easy",              { x = 1099, y = 2624,  z = 3922, a =  -0x2000 }, 5.5,  1,   FLOOD_WATER, nil)  
  flood_define_level(true, LEVEL_PSS,              "easy",              { x = 3945, y = 5553,  z = -3963, a = -0x4000 }, 1.4,  1,   FLOOD_WATER, { x = 826, y = 2656, z = 4625,  a = 0x6000 }) 
  flood_define_level(true, LEVEL_HMC,              "easy",              { x = 737, y = 2912, z = 2976, a = -0x4000 }, 1.32,  1,   FLOOD_LAVA, { x = -5755, y = 675, z = 2165, a = 0x0000 })
  flood_define_level(true, LEVEL_HMC,              "easy",              { x = 4978, y = 2347, z = 4301, a =  0x8000 }, 3.2,  1,   FLOOD_LAVA, { x = 2019, y = -1657, z = -6996, a = 0x4000 })
  flood_define_level(true, LEVEL_LLL,              "easy",              { x = 555, y = 206,  z = -1206, a = -0x2000 }, 5.0,  1,   FLOOD_WATER, nil)
  flood_define_level(true, LEVEL_LLL,              "easy",              { x = -1080, y = 11805,  z =  500, a = -0x0000 }, 3.0,  1,   FLOOD_WATER, { x = 1764, y = 807, z = -530, a = 0x0000 })
  flood_define_level(true, LEVEL_SSL,              "easy",              { x = 4260, y = 5165, z = 4800, a =  0x8000 }, 1.0,  1,   FLOOD_SAND, { x = -753, y = 252, z = 5505, a = 0x3000 })
  flood_define_level(true, LEVEL_DDD,              "easy",              { x = 3718, y = 2256, z = -4753, a =  0x0000 }, 1.2,  1,   FLOOD_LAVA, { x = 3735, y = -152, z = 4008, a = 0x8000 })
  flood_define_level(true, LEVEL_TOTWC,            "easy",            { x =  -779,  y = 4626,  z = 155, a = -0x4000 }, 1.8,  1,   FLOOD_LAVA, { x = 132, y = -2164, z = 814, a = 0x0000 })
  flood_define_level(true, LEVEL_BITFS,            "easy",            { x = 1759, y = 5255, z = -1101, a =  0x4000 }, 0.96,  1,   FLOOD_SAND, { x = 496, y = 4086, z = -6216, a = 0x0000 })
  flood_define_level(true, LEVEL_BITFS,           "easy",            { x = -4878, y = 6639, z = -6502, a =  0x0000 }, 1.4,  1,   FLOOD_SAND, { x = -300, y = 4247, z = -1458, a = -0x4000 })
  flood_define_level(true, LEVEL_SL,               "easy",               { x = 5505, y = 2879, z = 5203, a =  0x4000 }, 1.0,  1,   FLOOD_WATER, { x = 4735, y = 152, z = 4474, a = 0x2000 }) 
  flood_define_level(true, LEVEL_WDW,              "easy",              { x =  -5615, y = 6365, z = -4191, a = 0x4000 }, 1.7,  1,   FLOOD_WATER, { x = 4620, y = 720, z = -1970, a = 0x8000 }) 
  flood_define_level(true, LEVEL_TTM,            "easy",               { x =  -26,  y = 604,  z = 1055,   a =  0x6000 }, 1.3,  1,   FLOOD_WATER,  { x = -50,  y = -4485, z = 2200, a = 0x0000 })
  flood_define_level(true, LEVEL_TTM,            "easy",               { x =  4692,  y = 4630,  z = -3321,   a =  0x8000 }, 1.4,  1,   FLOOD_WATER,  { x = -2697,  y = 604,  z = -445,  a = -0x6000 })
  flood_define_level(true, LEVEL_THI,            "easy",               { x =  6319,  y = 4826,  z = -787,   a =  0x0000 }, 0.7,  1,   FLOOD_LAVA, { x = 4842,  y = 649, z = -2762, a = 0x0000 })
  flood_define_level(true, LEVEL_TTC,              "easy",              { x = 16, y = -3215, z = -1031, a = -0x4000 }, 5.0,  1,   FLOOD_MUD, { x = -452,  y = -4881, z = 1580, a = 0x8000 })
  flood_define_level(true, LEVEL_TTC,            "easy",           { x =  2367,  y = 2778,  z = -3517,   a =  0x8000 }, 1.55,  1,   FLOOD_MUD,  { x = -2217,  y = -4893,  z = -4516,  a =  0x4000 })
  flood_define_level(true, LEVEL_TTC,              "easy",              { x = -2594, y = 9571, z = 5336, a =  0x0000 }, 1.4,  1,   FLOOD_MUD, { x = 1571, y = 1336, z = -396, a = 0x4000 })
  flood_define_level(true, LEVEL_TTC,              "easy",              { x = 233, y = 13057, z = -81, a = -0x4000 }, 1.0,  1,   FLOOD_MUD, { x = -2919, y = 8772, z = 4443, a = 0x8000 })
  flood_define_level(true, LEVEL_RR,               "easy",               { x = 1429, y = 906, z = -6642, a =  0x4000 }, 0.65,  1,   FLOOD_LAVA, { x = 1009,  y = -3369, z = 824, a = 0x8000 })
  flood_define_level(true, LEVEL_RR,               "easy",               { x = -2305, y = 3703, z = 2976, a =  0x8000 }, 0.75,  1,   FLOOD_LAVA, { x = 166, y = 906, z = -6678, a = -0x4000 })
  flood_define_level(true, LEVEL_RR,               "easy",               { x = 2558, y = 7572, z = 4584, a =  0x4000 }, 0.8,  1,   FLOOD_LAVA, { x = -2064, y = 2204, z = -218, a = 0x4000 })
  flood_define_level(true, LEVEL_RR,               "easy",               { x = 90, y = 10815, z = -4320, a =  0x8000 }, 0.75,  1,   FLOOD_LAVA, { x = 2573, y = 7924, z = 4818, a = 0x8000 })
  flood_define_level(true, LEVEL_SA,               "easy",               { x =  -2767,  y = 2092,  z = 6210, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = 7765,  y = -50, z = -5920, a = -0x4000 })
  flood_define_level(true, LEVEL_CASTLE_COURTYARD, "easy",               { x = -143, y = 743,  z = -1668, a =  -0x4000 }, 1.5, 1,   FLOOD_LAVA, nil)
  flood_define_level(true, LEVEL_WMOTR,            "easy",            { x = 120,  y = 4446, z = 2035, a =  0x8000 }, 1.2,  1,   FLOOD_WATER, { x = -322, y = -638, z = -4658, a = -0x5500 })
  flood_define_level(true, LEVEL_CASTLE,           "easy",           { x = 39,    y = 2135, z =  3501, a = 0x4000 }, 5.0,  1,   FLOOD_LAVA, { x = -260,  y = -1315, z = -4345, a = 0x0000 })
end	

local function flood_load_compact_challenges_levels()
    game = GAME_COMPACT_CHALLENGES
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Compact Challenges 1"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,              "c1",  { x =    100, y =   2990, z =  -3510, a =  0x4000 }, 2.0,  1,  FLOOD_BLOOD, nil)
    flood_define_level(false, LEVEL_WF,               "c2",  { x =   -680, y =   3215, z =   2185, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",  { x =   1710, y =    200, z =  -2500, a =  0x4000 }, 1.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",  { x =    -30, y =   1600, z =   3370, a =  0x8000 }, 2.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_HMC,              "c6",  { x =   -755, y =   1095, z =   -730, a =  0x0000 }, 0.75, 1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",  { x =   -480, y =    795, z =    450, a =  0x4000 }, 5.0,  1,  FLOOD_WATER, nil)	
end

local function flood_load_despair_marios_gambit_levels()
    game = GAME_DESPAIR_MARIOS_GAMBIT
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Despair Mario's Gambit 64"
	TEX_ROMHACK_LOGO = get_texture_info("dmg64_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =    835, y =   3660, z =  -2345, a =  0x6000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =   1145, y =   7325, z =   2000, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_WF,               "c2",             { x =    655, y =   6455, z =   3675, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_SA,               "sa",             { x =   1505, y =   4950, z =  -2750, a =  0x0000 }, 6.0,  2,  FLOOD_WATER, nil)				
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  -1805, y =   6190, z =   2705, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =      0, y =   4780, z = -11950, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =     0,  y = -1590, z =  7645, a =  0x8000 })
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =  -9040, y =  10410, z = -12475, a =  0x2000 }, 3.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_BBH,              "c5-2",           { x =  -2105, y =  10885, z =    415, a =  0x8000 }, 3.5,  2,  FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =  -3160, y =   1955, z =   3985, a =  0x8000 }, 2.0,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =   -940, y =   5880, z = -14890, a =  0x4000 }, 2.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",       { x =  -3565, y =   -385, z =      0, a =  0x4000 }, 5.0,  1,  FLOOD_LAVA,  { x =  3470,  y =  -440, z =     15, a = -0x4000 })
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =   -700, y =  10400, z =   4440, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =   7320, y =  11630, z =  -5470, a =  0x6000 }, 2.0,  1,  FLOOD_WATER, { x =  1345,  y =  6810, z = -11620, a =  0x0000 })
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  -8450, y =   4485, z =   1780, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =   6220, y =   5760, z =   3310, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =   8020, y =   5390, z =  -2470, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =   3055, y =  10355, z =  -6490, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",       { x =   1430, y =  14210, z =  -2450, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_SL,               "c10",            { x =   3715, y =   2400, z =   1445, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SL,               "c10-2",          { x =    320, y =   5920, z =   -330, a = -0x4000 }, 2.0,  2,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =      0, y =   6305, z =  -3010, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_THI,              "c13",            { x =    980, y =   8310, z =   4305, a = -0x4000 }, 1.5,  1,  FLOOD_SAND,  nil)		
    flood_define_level(false, LEVEL_RR,               "c15",            { x =  27580, y =   5925, z =    260, a =  0x0000 }, 0.75, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =    860, y =   4710, z =  -9090, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =   7880, y =   1970, z =  -3305, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  6510,  y = -1120, z =    490, a =  0x8000 })
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =   4935, y =   5540, z =    200, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	
end

local function flood_load_super_mario_fallen_stars_levels()
    game = GAME_SUPER_MARIO_FALLEN_STARS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario Fallen Stars"
	TEX_ROMHACK_LOGO = get_texture_info("fallen_stars_logo")

    flood_define_level(false, LEVEL_BOB,   "c1",             { x =  -1180, y =   5255, z =  -7005, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x = -2170,  y = -1490, z = 6650, a =  0x8000 })
    flood_define_level(false, LEVEL_WF,    "c2",             { x = -10865, y =   4180, z =  -4050, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WF,    "c2-2",           { x =   8825, y =   1950, z =  -8340, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BBH,   "c5",             { x =   7090, y =   2400, z =   3565, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW, "b1",             { x =  -1060, y =   6555, z =   1560, a =  0x8000 }, 4.0,  1,  FLOOD_LAVA,  nil)				
end

local function flood_load_super_mario_jammin_journey_levels()
    game = GAME_JAMMIN_JOURNEY
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario's Jammin' Journey 64"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =   3470, y =   4505, z =  -6705, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x = -8735,  y =  -400, z =  -6030, a =  0x0000 })	
    flood_define_level(false, LEVEL_WF,               "c2",             { x =  -4510, y =   4265, z =   4820, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   5120, y =    290, z =  -8730, a =  0x8000 }, 2.25, 1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =   7105, y =   4035, z =   6290, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   8980, y =   6910, z =  -1795, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "c5-2",           { x =    550, y =   9000, z =   -910, a =  0x4000 }, 3.0,  2,  FLOOD_WATER, { x = 26960,  y = -9115, z = -20410, a = -0x2000 })	
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =  12255, y =  17095, z =  -6245, a =  0x0000 }, 5.0,  1,  FLOOD_WATER, { x =  6535,  y = -4485, z = -13745, a = -0x4000 })
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =   1950, y =   9370, z = -13600, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =   4825, y =   2880, z =  -4755, a =  0x0000 }, 3.5,  1,  FLOOD_MUD,   { x =  4825,  y =   355, z =  -4755, a =  0x8000 })
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =    450, y =   1920, z =   -555, a =  0x4000 }, 2.25, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =   7400, y =   2075, z =   5700, a =  0x6000 }, 1.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  10990, y =   5210, z =  -9400, a =  0x4000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  25410, y =   7200, z =  -2150, a =  0x8000 }, 2.5, 1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =    460, y =   4470, z =   -450, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =   2155, y =    865, z =  -1890, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =  10055, y =   3240, z = -13955, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =   1690, y =   1915, z =  -3320, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  -6585, y =   2945, z =  -8920, a =  0x2000 }, 2.0,  1,  FLOOD_WATER, nil)	
end

local function flood_load_super_mario_the_stolen_stars_levels()
    game = GAME_THE_STOLEN_STARS
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Super Mario The Stolen Stars"
	TEX_ROMHACK_LOGO = get_texture_info("the_stolen_stars_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =   9030, y =   6255, z = -11205, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   7445, y =  15690, z =  12040, a =  0x8000 }, 2.0,  1,  FLOOD_LAVA,  { x = 14350,  y = -2650, z =  13090, a =  0x8000 })
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   8105, y =   5345, z =  -5640, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x = -13290, y =  11730, z =  22080, a =  0x8000 }, 2.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",       { x =   -320, y =   5490, z =  -1530, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =  -9280, y =  17875, z =  16915, a =  0x8000 }, 4.0,  1,  FLOOD_SAND,  { x = 14440,  y =  2900, z = -19965, a =  0x0000 })	
    flood_define_level(false, LEVEL_SA,               "sa",             { x =   2355, y =    540, z =  -8310, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =  -4215, y =   2365, z =  10170, a = -0x4000 }, 2.25, 1,  FLOOD_SAND,  nil)	
end

local function flood_load_super_mario_64_lenti_levels()
    game = GAME_SUPER_MARIO_64_LENTILEVELS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64 LentiLevels"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,            "c1",             { x =   3205, y =   4890, z =   3825, a =  0x6000 }, 2.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",             { x =  -3780, y =   5465, z =   -510, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  1860, y =  2260, z = -2450, a = -0x4000 })	
    flood_define_level(false, LEVEL_JRB,            "c3",             { x =   2060, y =   5105, z =   1785, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,            "c4",             { x =    750, y =   4970, z =  -2585, a =  0x0000 }, 4.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BBH,            "c5",             { x =   -675, y =   2455, z =   2325, a =  0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BITDW,          "b1",             { x =    -85, y =   1070, z =   -205, a = -0x4000 }, 2.75, 1,  FLOOD_LAVA,  { x = -4615, y = -4325, z =  4815, a =  0x8000 })	
    flood_define_level(false, LEVEL_PSS,            "pss",            { x =    930, y =   5200, z =    600, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_COTMC,          "mc",             { x =  -3365, y =   2100, z =  -4380, a =  0x6000 }, 2.75, 1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_VCUTM,          "vc",             { x =    725, y =   3340, z =   -650, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, { x =   200, y =  3020, z = -3740, a = -0x4000 })
    flood_define_level(false, LEVEL_TOTWC,          "wc",             { x =    755, y =   1015, z =   2750, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_HMC,            "c6",             { x =  -2860, y =   3050, z =   -800, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,            "c7",             { x =   3630, y =   3495, z =   1060, a =  0x8000 }, 1.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,            "c8",             { x =    -55, y =   3110, z =   1840, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,            "c9",             { x =   -555, y =   2365, z =  -6835, a =  0x8000 }, 1.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SL,             "c10",            { x =   2800, y =   5210, z =   1475, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,          "b2",             { x =   1490, y =   3975, z =  -2570, a = -0x4000 }, 2.0,  1,  FLOOD_SAND,  nil)		
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",             { x =  -2090, y =   7500, z =   -800, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)		
end

local function flood_load_star_revenge_2_5_levels()
    game = GAME_STAR_REVENGE_2_5
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Star Revenge 2.5: Remnant of Doom"
	TEX_ROMHACK_LOGO = get_texture_info("star_revenge_2.5_logo")

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  -2235, y =   4180, z =  -1265, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =  -9365, y =   2300, z =   4050, a =  0x6000 }, 2.5,  1,  FLOOD_LAVA,  { x =   -340, y =    25, z = -4605, a =  0x8000 })	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  -4835, y =   3270, z =  12620, a =  0x6000 }, 1.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =  -9730, y =   3225, z =  -1850, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   5320, y =   1555, z =   8035, a =  0x8000 }, 2.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =  -7590, y =   2425, z =   2170, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =   -180, y =   1305, z =   8645, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  { x =    -25, y = -1870, z =  1185, a =  0x0000 })
    flood_define_level(false, LEVEL_BITDW,            "b1-2",           { x =   -655, y =   3770, z =  -9685, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x =     25, y = -1870, z = -1185, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITDW,            "b1-3",           { x =   8355, y =   1325, z =   -805, a =  0x1000 }, 1.5,  1,  FLOOD_WATER, { x =   1185, y = -1870, z =     0, a =  0x4000 })
    flood_define_level(false, LEVEL_BITDW,            "b1-4",           { x =  -5440, y =   3410, z =  -2920, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  { x =  -6230, y = -2600, z =     0, a = -0x4000 })
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  -6745, y =   3050, z =  -3640, a =  0x0000 }, 2.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x = -10025, y =   3490, z =   8200, a =  0x5000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =   5370, y =   3475, z =   8600, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =      0, y =   -300, z =   3595, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SA,               "sa-2",           { x =      0, y =    300, z =  -3620, a =  0x0000 }, 2.75, 1,  FLOOD_WATER, { x =      0, y =     0, z =  3325, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =   8360, y =   1395, z = -10045, a =  0x4000 }, 1.0,  1,  FLOOD_SAND,  { x =   5910, y =   -90, z = -6530, a =  0x8000 })
    flood_define_level(false, LEVEL_BITFS,            "b2-2",           { x =  -3660, y =   4905, z = -11510, a =  0x1000 }, 1.25, 1,  FLOOD_LAVA,  { x =  -6440, y =   -90, z = -6840, a = -0x4000 })
    flood_define_level(false, LEVEL_BITFS,            "b2-3",           { x =   5065, y =   -640, z =   7410, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  10980, y = -2300, z =  9905, a = -0x4000 })
    flood_define_level(false, LEVEL_BITFS,            "b2-4",           { x = -10795, y =   4690, z =  12800, a =  0x6000 }, 0.75, 1,  FLOOD_MUD,   { x =  -8210, y =  2140, z =  6790, a =  0x0000 })
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",       { x =   6430, y =    425, z =      5, a =  0x0000 }, 1.25, 1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_SL,               "c10",            { x =  -1295, y =   3525, z =   1400, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =  13330, y =   3190, z =   1320, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_THI,              "c13",            { x =  12970, y =    330, z = -12150, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =  12490, y = -4760, z = -8265, a =  0x4000 })	
    flood_define_level(false, LEVEL_THI,              "c13-2",          { x =  -7890, y =   2200, z =  -1355, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_THI,              "c13-3",          { x =  -3040, y =   3570, z =  11060, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, { x =    475, y =  1920, z = -6600, a =  0x0000 })	
    flood_define_level(false, LEVEL_TTC,              "c14",            { x =  -3705, y =   4110, z =   4440, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, { x =   3465, y = -5400, z =  1880, a = -0x4000 })	
    flood_define_level(false, LEVEL_RR,               "c15",            { x =   8945, y =   2430, z =  -4995, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x = -10795, y = -1140, z =  6990, a = -0x4000 })
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =   2180, y =    525, z =   1990, a =  0x8000 }, 2.5,  1,  FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =    160, y =   3990, z = -13705, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, { x =   3535, y = -7120, z =   8815, a =  0x0000 })
    flood_define_level(false, LEVEL_BITS,             "b3-2",           { x =  12125, y =   3660, z = -13560, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, { x =   8795, y =  -940, z =   2405, a = -0x4000 })
end

local function flood_load_rocky_mountain_revisited_levels()
    game = GAME_ROCKY_MOUNTAIN_REVISITED
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64: Rocky Mountain Revisited"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB, "c1",   { x =    240, y =   4780, z =   2805, a =  0x0000 }, 3.0,  2,  FLOOD_WATER, { x =   220, y = -1130, z = -8265, a =  0x0000 })
    flood_define_level(false, LEVEL_BOB, "c1-3", { x =  -7810, y =   7450, z =  -4550, a =  0x8000 }, 3.5,  2,  FLOOD_WATER, { x = -7780, y =  6060, z = -9730, a =  0x0000 })			
    flood_define_level(false, LEVEL_BOB, "c1-2", { x =  10770, y =   1350, z =  -1890, a = -0x4000 }, 4.0,  2,  FLOOD_WATER, { x =  8120, y =  1525, z =   -70, a =  0x4000 })
end

local function flood_load_sm64_twisted_adventures_2_levels()
    game = GAME_SM64_TWISTED_ADVENTURES_2
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Super Mario 64 - Twisted Adventures 2"
    TEX_ROMHACK_LOGO = get_texture_info("twisted_adventures_2_logo")		

    flood_define_level(false, LEVEL_BOB,    "c1",             { x =  -5330, y =   3025, z =  -4315, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,    "c3",             { x =   2110, y =   3135, z =   6800, a =  0x8000 }, 2.0,  1,  FLOOD_SAND,  { x = -6660, y =    75, z = 5820, a =  0x8000 })
    flood_define_level(false, LEVEL_CCM,    "c4",             { x =   2050, y =   4215, z =   5160, a =  0x8000 }, 2.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,  "wc",             { x =   4325, y =   8025, z =  -2625, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE, "c",              { x =   5330, y =    520, z =   1940, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
end

local function flood_load_the_power_star_journey_levels()
    game = GAME_THE_POWER_STAR_JOURNEY
    LEVEL_LOBBY = LEVEL_CASTLE_COURTYARD
	romhackText = "Super Mario The Power Star Journey"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =    780, y =   3400, z =     80, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   1155, y =   2630, z =   1655, a =  0x0000 }, 3.0,  1,  FLOOD_SAND,  nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  -4180, y =   6640, z =    335, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =   2100, y =   8370, z =   1260, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =    250, y =   1440, z =  -4895, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =    -70, y =  12040, z =  -1690, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =  -2865, y =    260, z =    645, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =   3300, y =   4630, z =   3485, a =  0x6000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =   1890, y =   2190, z =  -1440, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =  -3230, y =   2650, z =   1380, a =  0x8000 }, 3.0,  1,  FLOOD_WATER, { x =   4295, y = -3790, z = -4475, a = 0x0000 })	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =  -2080, y =   2430, z =   -410, a = -0x4000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =   3220, y =   5010, z =   3220, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  -1055, y =   3375, z =   1150, a =  0x4000 }, 2.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =   1850, y =   7345, z =   5655, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =   1550, y =   3635, z =    325, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =   3685, y =   4860, z =   2630, a = -0x4000 }, 3.0,  1,  FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_SL,               "c10",            { x =  -2300, y =   1970, z =  -3380, a =  0x2000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =    345, y =    810, z =    620, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, { x =  -1095, y = -3050, z =   735, a = 0x0000 })	
    flood_define_level(false, LEVEL_THI,              "c13",            { x =  -5110, y =   4655, z =   3075, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_TTC,              "c14",            { x =   2125, y =   2060, z =   -490, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_RR,               "c15",            { x =   2585, y =   2875, z =   -490, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =  -5330, y =   3775, z =    -10, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x =   4635, y = -1230, z = -6075, a = 0x0000 })	
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =  -1465, y =   8470, z =   5200, a =  0x8000 }, 3.5,  1,  FLOOD_LAVA,  nil)						
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =  -1635, y =   6880, z =   1200, a =  0x2000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =   -250, y =    905, z =   4910, a =  0x8000 }, 4.0,  1,  FLOOD_LAVA,  nil)
end


local function flood_load_bowsers_dank_rave_1_levels()
    game = GAME_BOWSERS_DANK_RAVE_1
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Bowser's Dank Rave"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,   "c1",             { x =  -2700, y =   3020, z =  -2050, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,    "c2",             { x =    940, y =   6580, z =    790, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,   "c3",             { x =    160, y =  10990, z =  -2360, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BITDW, "b1",             { x =    105, y =  12775, z =  -3585, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
end


local function flood_load_bowsers_dank_rave_2_levels()
    game = GAME_BOWSERS_DANK_RAVE_2
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Bowser's Dank Rave 2: Return of the Illuminati Dubstep Party"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,   "c1",             { x =  11285, y =   7750, z =   1510, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,    "c2",             { x =   -845, y =   3480, z =   4635, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,   "c3",             { x =  -4765, y =   7700, z =  22300, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -2275, y = -3700, z = -3315, a = 0x0000 })	
    flood_define_level(false, LEVEL_JRB,   "c3-2",           { x =    210, y =   7700, z = -22270, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =  -2275, y = -3700, z = -6955, a = 0x8000 })	
    flood_define_level(false, LEVEL_BITDW, "b1",             { x =  -5595, y =  10200, z =  -1595, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITDW, "b1-2",           { x =   3625, y =  10200, z =   4510, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   -365, y = - 400, z =  -365, a = 0x0000 })	
end

local function flood_load_bowsers_dank_rave_3_levels()
    game = GAME_BOWSERS_DANK_RAVE_3
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Bowser's Dank Rave 3: Toadette's MLG Expansion"

    flood_define_level(false, LEVEL_BOB,            "c1",    { x =   -499, y =   2415, z =  -846, a =  0x0000 }, 12.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",    { x =   -845, y =   3480, z =  4635, a =  0x4000 },  6.1,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,            "c3",    { x =   4950, y =   -609, z =  7193, a =  0x4000 },  1.0,  1,  FLOOD_WATER, { x = -2438, y =  -609, z =  258, a =  0x0000 })			
    flood_define_level(false, LEVEL_BITDW,          "b1",    { x =  -3316, y =   6815, z =  3850, a =  0x4000 },  4.6,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOWSER_1,       "c3",    { x =  -5111, y =   6201, z = -1708, a =  0x4000 },  3.0,  1,  FLOOD_WATER, { x =  2934, y = -6179, z = 4356, a = -0x4000 })		
end

local function flood_load_grand_star_levels()
    game = GAME_SUPER_MARIO_AND_THE_GRAND_STAR
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario and the Grand Star"
	TEX_ROMHACK_LOGO = get_texture_info("grand_star_logo")

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =   7715, y =   1980, z = -11910, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =  11000, y =  10580, z = -15230, a =  0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =  24360, y =   3505, z =  -3525, a = -0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =   -160, y =   6095, z = -21540, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   7605, y =   3050, z = -10105, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =  7635,  y =  655, z = -2720, a = 0x8000 })
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =    765, y =  15240, z =   -835, a =  0x8000 }, 8.0,  1,  FLOOD_WATER, { x = 14010,  y = 3290, z = -4610, a =-0x4000 })
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =    380, y =   5490, z = -10095, a =  0x0000 }, 3.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =   7620, y =   3810, z =   -185, a =  0x6000 }, 4.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =   3820, y =      0, z = -21290, a =  0x0000 }, 2.25, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =  20135, y =   1365, z = -18460, a =  0x4000 }, 2.0,  1,  FLOOD_LAVA,  { x =  2740,  y = 2050, z = -2915, a = 0x6000 })	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =  11525, y =   3660, z = -18290, a =  0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  11430, y =   2285, z = -11535, a =  0x0000 }, 1.75, 1,  FLOOD_LAVA,  { x = 18290,  y =  650, z = -18940, a = 0x0000 })
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  17470, y =  10540, z = -19165, a =  0x2000 }, 1.5,  1,  FLOOD_SAND,  { x = 11335,  y = 7880, z = -12585, a = 0x4000 })
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =  14960, y =   6670, z = -22385, a = -0x4000 }, 2.0,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =  11560, y =   3000, z =  -7625, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =   4800, y =   1285, z = -25985, a =  0x4000 }, 1.25, 1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_SL,               "c10",            { x =   3810, y =    380, z = -27420, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =   7615, y =   4570, z =  -1260, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =      0, y =   5850, z =  -8975, a =  0x6000 }, 1.5,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_THI,              "c13",            { x =  -2280, y =   4955, z = -14490, a =  0x0000 }, 1.75, 1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_TTC,              "c14",            { x = -15205, y =   5610, z = -26030, a =  0x4000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_RR,               "c15",            { x =      0, y =   5250, z = -12780, a =  0x8000 }, 1.0,  1,  FLOOD_LAVA,  { x =     0,  y =  550, z =   -950, a = 0x8000 })
    flood_define_level(false, LEVEL_RR,               "c15-2",          { x =   9495, y =   5715, z =   -100, a =  0x0000 }, 2.0,  1,  FLOOD_SAND,  { x =  1100,  y =  550, z =      0, a = 0x4000 })
    flood_define_level(false, LEVEL_RR,               "c15-3",          { x = -21070, y =   6310, z =     20, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x = -1100,  y =  550, z =      0, a =-0x4000 })
    flood_define_level(false, LEVEL_RR,               "c15-4",          { x =   1285, y =   3325, z =   8455, a =  0x0000 }, 2.0,  1,  FLOOD_MUD,   { x =     0,  y =  550, z =    950, a = 0x0000 })
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =   7625, y =   6095, z =  -7650, a =  0x8000 }, 3.0,  1,  FLOOD_LAVA,  { x =  1520,  y =  245, z =  -1555, a = 0x8000 })
    flood_define_level(false, LEVEL_ENDING,           "ending",         { x = -11585, y =   7370, z =   5105, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =     0,  y = 2905, z =      0, a = 0x8000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =   7610, y =   1980, z = -14335, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  14240, y =    915, z =  -1930, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =   7610, y =    450, z = -24850, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)
end

local function flood_load_super_mario_star_levels()
    game = GAME_SUPER_MARIO_STAR
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario Star"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")
    hook_behavior(id_bhvExclamationBox, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)	

    flood_define_level(false, LEVEL_BOB, "c1",             { x =   8090, y =   2240, z =  -2930, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,  "c2",             { x =  -4195, y =   3750, z =   5965, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB, "c3",             { x =  -2580, y =   1740, z =  -1125, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM, "c4",             { x =  -1400, y =   4700, z =  -5220, a =  0x2000 }, 2.0,  1,  FLOOD_WATER, { x =  3405,  y =  -655, z =  -5240, a = 0x0000 })
    flood_define_level(false, LEVEL_BBH, "c5",             { x =    165, y =   7965, z =    690, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_HMC, "c6",             { x =   3050, y =   3460, z =  -1265, a =  0x2000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL, "c7",             { x =    330, y =   2000, z =   1315, a = -0x4000 }, 2.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_DDD, "c9",             { x =   1685, y =    885, z =   3135, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,  "sa",             { x =  -3450, y =    320, z =  -5640, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, { x = -3285,  y = -2670, z =  -1835, a = 0x4000 })	
    flood_define_level(false, LEVEL_SL,  "c10",            { x =   -160, y =   3595, z =  -4615, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW, "c11",            { x =    630, y =   2915, z =  -2800, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM, "c12",            { x =   4175, y =   3430, z =   4310, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_THI, "c13",            { x =   -100, y =   4215, z =   -900, a =  0x6000 }, 2.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_TTC, "c14",            { x =   5035, y =   1545, z =  -4200, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC, "c14-2",          { x =   4440, y =   8965, z =   1700, a = -0x4000 }, 1.75, 1,  FLOOD_WATER, { x = -6330,  y =  4760, z =    -15, a = 0x0000 })
end

local function flood_load_ww_mostrecent_levels()
    game = GAME_WW_MOSTRECENT
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "SM64WW 12-11-2020 (WW Mostrecent)"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_WF,    "c2",             { x =  -1355, y =   1805, z =   -170, a =  0x4000 }, 7.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_PSS,   "pss",            { x =      5, y =   2135, z =   8095, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SA,    "sa",             { x =   2280, y =   2900, z =  -2580, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_WMOTR, "wmotr",          { x =    100, y =    920, z =     75, a =  0x0000 }, 7.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,  "b3",             { x =    600, y =   6290, z =  21670, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)				
end

local function flood_load_super_mario_64_madness_levels()
    game = GAME_SM64_MADNESS
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64 Madness"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_madness_logo")	

    flood_define_level(false, LEVEL_BOB,            "c1",             { x =  -1020, y =   1540, z =    780, a =  0x8000 }, 4.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,             "c2",             { x =  -5280, y =   5820, z =  -2415, a =  0x4000 }, 0.75, 1,  FLOOD_SAND,  { x = 3770,  y =  6635, z =  205, a = -0x4000 })
    flood_define_level(false, LEVEL_JRB,            "c3",             { x =    970, y =   3540, z =   -380, a =  0x2000 }, 2.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CCM,            "c4",             { x =  -7410, y =   2825, z =  -2710, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BBH,            "c5",             { x =   3150, y =   1560, z =   1220, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,            "pss",            { x =    190, y =    170, z =   8205, a =  0x8000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITDW,          "b1",             { x =   5000, y =   2425, z =   2595, a =  0x2000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_VCUTM,          "vc",             { x =    110, y =   2860, z =   1830, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,          "wc",             { x =   1795, y =   3840, z =    -70, a =  0x0000 }, 8.0,  1,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_LLL,            "c7",             { x =   -175, y =   3010, z =   3020, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,            "c8",             { x =  -1130, y =   3890, z =   -915, a =  0x0000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_DDD,            "c9",             { x =   1015, y =   4105, z =    910, a = -0x4000 }, 2.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_SA,             "sa",             { x =   6485, y =    770, z =  -1570, a = -0x4000 }, 1.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SL,             "c10",            { x =   5405, y =   1715, z =   -770, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,            "c12",            { x =  -2725, y =   4170, z =   2400, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_THI,            "c13",            { x =  -1850, y =   3075, z =  -2665, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_TTC,            "c14",            { x =   4010, y =   7000, z =   3230, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x = 6420,  y = -6700, z = -200, a = -0x4000 })	
    flood_define_level(false, LEVEL_BITS,           "b3",             { x =   2340, y =   1445, z =  -4125, a =  0x0000 }, 0.75, 1,  FLOOD_LAVA,  nil)			
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",             { x =   -130, y =    735, z =  -7180, a =  0x0000 }, 2.0,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CASTLE,          "c",             { x =    -10, y =   2695, z =  -4190, a =  0x0000 }, 2.0,  1,  FLOOD_SAND,  nil)		
end

local function flood_load_year_of_the_plumber_levels()
    game = GAME_YEAR_OF_THE_PLUMBER
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Super Mario 64 - Year of the Plumber"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_yotp_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1", { x =   5360, y =   7705, z =  11005, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2", { x =   4990, y =   3125, z =  -7330, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CCM,              "c4", { x =   -760, y =   3425, z =   4965, a =  0x8000 }, 2.0,  1,  FLOOD_LAVA,  nil)		
    flood_define_level(false, LEVEL_CASTLE,           "c",  { x =   2435, y =   1945, z =    -15, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc", { x =   -655, y =   1885, z =   2855, a =  0x2000 }, 5.0,  1,  FLOOD_WATER, nil)	
end

-- SM64: Its A Crash! ported to Flood by SuperRodrigo0
local function flood_load_sm64_its_a_crash_levels()
    game = GAME_SM64_ITS_A_CRASH
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64: It's A Crash!"
	TEX_ROMHACK_LOGO = get_texture_info("its_a_crash_logo")		

    flood_define_level(false, LEVEL_BOB,            "c1",   { x =  3759, y = 2757, z = -9300, a =  0x4000 }, 4.1,  1,  FLOOD_WATER, { x =  6976, y = -5147, z = 8670, a = -0x1000 })
    flood_define_level(false, LEVEL_BOB,            "c1-2", { x =   760, y = 3880, z =  6505, a =  0x8000 }, 3.2,  1,  FLOOD_WATER, { x = -6674, y = -2574, z =  214, a = -0x8000 })
    flood_define_level(false, LEVEL_BOB,            "c1-3", { x = -1281, y = -132, z = 14282, a =  0x4000 }, 4.0,  1,  FLOOD_WATER, { x =  3174, y = -2666, z = 4626, a =  0x3500 })
    flood_define_level(false, LEVEL_BOB,            "c1-4", { x =  4811, y = 2677, z = -1852, a = -0x4000 }, 8.0,  1,  FLOOD_WATER, { x =  2701, y = -1831, z =  286, a =  0x4000 })
    flood_define_level(false, LEVEL_TOTWC,          "wc",   { x = -1097, y = 8077, z =  -302, a = -0x4000 }, 5.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",   { x = -3800, y =  238, z =  1967, a =  0x4000 }, 4.5,  1,  FLOOD_WATER, nil)
end

-- Return To Retroland ported to Flood by SuperRodrigo0
local function flood_load_return_to_retroland_levels()
    game = GAME_RETURN_TO_RETROLAND
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Return To Retroland"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")	

    flood_define_level(false, LEVEL_WF,             "c2",  { x =  3458, y = 5975, z = 3482, a =  0x8000 },  4.0,  1,   FLOOD_WATER, { x =  1866, y = -3282, z = -3930, a = 0x0000 })
    flood_define_level(false, LEVEL_WF,             "c2",  { x = -5281, y = 2628, z = 1653, a =  0x4000 }, 1.25,  1,   FLOOD_WATER, { x =  2816, y =  2414, z =  4113, a = -0x4000 })
    flood_define_level(false, LEVEL_PSS,            "pss", { x =  2494, y = 6323, z = -710, a = -0x4000 }, 2.75,  1,   FLOOD_WATER, { x = -7132, y =  2661, z =  -597, a = 0x6000 })
    flood_define_level(false, LEVEL_PSS,            "pss", { x = -7604, y = 5383, z = 7740, a =  0x4000 }, 0.75,  1,   FLOOD_WATER, { x =  4489, y =  4451, z =  2848, a = 0x0000 })
    flood_define_level(false, LEVEL_CASTLE_GROUNDS, "cg",  { x = -1148, y =  630, z = -420, a =  0x4000 },  2.0,  1,   FLOOD_WATER, nil)
end

-- Letterful Wood Blocks ported to Flood by SuperRodrigo0
local function flood_load_letterful_wood_blocks_levels()
    game = GAME_LETTERFUL_WOOD_BLOCKS
	LEVEL_LOBBY = LEVEL_BOB
	romhackText = "Letterful Wood Blocks"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB, "c1",   { x =  -4132, y = 3129, z =   8123, a = 0x8000 }, 3.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOB, "c1-2", { x = -10853, y = 2721, z =   5545, a = 0x8000 }, 1.7,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOB, "c1-3", { x =  -1889, y = 4281, z =   9638, a = 0x8000 }, 2.2,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOB, "c1-4", { x =  -4360, y = 5168, z = -10172, a = 0x0000 }, 1.9,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BOB, "c1-5", { x =   5578, y = 2755, z =  -1580, a = 0x4000 }, 1.3,  1,  FLOOD_WATER, nil)
end

local function flood_load_king_boo_revenge_2_levels()
    game = GAME_KING_BOOS_REVENGE_2
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "King Boo's Revenge 2"
	TEX_ROMHACK_LOGO = get_texture_info("king_boo_revenge_2_logo")	

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =  19670, y =   -465, z =   7675, a = -0x4000 }, 1.5, 1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   3065, y =   8040, z =  -4560, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   7535, y =  17060, z = -14615, a =  0x4000 }, 2.4, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =  15160, y =  17420, z =  -1855, a =  0x0000 }, 3.8,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =  -2297, y = 5468, z = -940, a = -0x4000 }, 0.6,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =   3275, y =   4565, z = -22300, a =  0x4000 }, 2.8,  1,  FLOOD_WATER, { x = 17, y = -4473, z = 39, a =  0x8000 }) 	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =  -2920, y =  17190, z =  15540, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",       { x =   2120, y =  15005, z =   2330, a =  0x0000 }, 1.6,  1,  FLOOD_WATER, { x = -3386, y = -1548, z = -5923, a = 0x0000 })	
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =  -6735, y =   8755, z =    530, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x = 1985, y = -2396, z = 2072, a = -0x4000 })
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =  10360, y =  11525, z = -10180, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   1565, y =   8370, z =  -3915, a =  0x8000 }, 1.6,  1,  FLOOD_WATER, { x = -5521, y = 302, z = 1603, a = 0x6000 })	
    flood_define_level(false, LEVEL_HMC,              "c6",             { x = -1095, y = 9006, z = -8668, a = -0x4000 }, 3.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =  18675, y =  11255, z = -13250, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x = 19523, y = -8099, z = -7239, a = 0x8000 })
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =   6720, y =  11475, z =   4185, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  -5760, y =  10720, z =  -6455, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =  -8175, y =   7345, z =   9500, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =   7775, y =  16680, z =  -4100, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x = -730, y = 466, z = 12875, a = 0x0000 })	
    flood_define_level(false, LEVEL_SL,               "c10",            { x =  15990, y =   3250, z =  -6650, a =  0x0000 }, 1.8,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =   3180, y =   -410, z = -15910, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",       { x =  -5590, y =  12320, z =   8685, a =  0x0000 }, 0.77,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =  -6580, y =   6880, z =  -8495, a =  0x0000 }, 3.1,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x = -13365, y =  15365, z =  12820, a =  0x0000 }, 3.5,  1,  FLOOD_WATER, { x = -1080, y = -5160, z = -9070, a =  0x4000 })
    flood_define_level(false, LEVEL_THI,              "c13",            { x =  10230, y =   5775, z =   4445, a =  0x0000 }, 3.0,  1,  FLOOD_WATER, { x = 15830, y = -6740, z =  2420, a =  0x4000 }) 
	flood_define_level(false, LEVEL_TTC,              "c14",            { x = 21535, y = 11594, z =  -9967, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x = 9719, y = -5415, z = 12459, a =  0x2000 }) 	
    flood_define_level(false, LEVEL_RR,               "c15",            { x = -2205, y = 5950, z =  13141, a =  0x0000 }, 1.5,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_ENDING,           "ending",         { x =  13550, y = 13970, z =   3580, a =  0x0000 }, 1.05,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =  -4340, y = 2680, z = -19895, a =  0x0000 }, 1.1,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BOWSER_3,         "bowser-3",       { x = -5268, y = -665, z = 7059, a =  0x0000 }, 0.7,  1,  FLOOD_WATER, nil)			
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =  -3920, y =   5740, z =   1100, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CASTLE,           "c",              { x =  -3290, y =   6000, z =  -1175, a =  0x0000 }, 2.1,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "cc",             { x =   8900, y =   2690, z = -10250, a =  0x0000 }, 1.6,  1,  FLOOD_WATER, nil)
end

-- Royal Legacy ported to Flood by SuperRodrigo0
local function flood_load_royal_legacy_levels()
    game = GAME_ROYAL_LEGACY
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Royal Legacy"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,  "c1",           { x = 961, y = 3609, z = -7154, a = 0x8000 }, 4.0,  1,   FLOOD_WATER, { x = 284, y = 210, z = -5639, a = 0x1000 })
    flood_define_level(false, LEVEL_WF,   "c2",            { x = -4278, y = 2320, z = 2360, a = 0x4000 }, 3.3,  1,   FLOOD_WATER, { x = -448, y = -180, z = -959, a = 0x9999 })
    flood_define_level(false, LEVEL_JRB,  "c3",           { x = -530, y = 5163, z = -5808, a = -0x4000 }, 2.2,  1,   FLOOD_LAVA, { x = 494, y = -94, z = -7396, a = 0x8000 })
    flood_define_level(false, LEVEL_CCM,  "c4",           { x = 205, y = 1760, z = -15584, a = 0x4000 }, 1.5,  1,   FLOOD_SAND, { x = 171, y = -0, z = -1512, a = 0x8000 })
    flood_define_level(false, LEVEL_CCM,  "c4-2",           { x = 7937, y = 4445, z = 2212, a = -0x4000 }, 1.5,  1,   FLOOD_SAND, { x = 3473, y = -0, z = 374, a = 0x4000 })
    flood_define_level(false, LEVEL_CCM,  "c4-3",           { x = 208, y = 3795, z = 376, a = -0x4000 }, 3.2,  1,   FLOOD_SAND, { x = -2493, y = 1588, z = -3132, a = 0x0000 })
    flood_define_level(false, LEVEL_CCM,  "c4-4",           { x = -17051, y = 2963, z = -885, a = 0x0000 }, 2.0,  1,   FLOOD_SAND, { x = -10442, y = -148, z = 1123, a = -0x4000 })
    flood_define_level(false, LEVEL_BITS, "b3",          { x = 14845, y = 7694, z = -425, a = 0x4000 }, 2.1,  1,   FLOOD_LAVA, nil)
end

local function flood_load_mario_heroes_64_levels()
    game = GAME_MARIO_HEROES_64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Mario Heroes 64"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,   "c1",             { x =  -1390, y =  14230, z =  25910, a =  0x8000 }, 5.0,  1,  FLOOD_WATER, { x = 0, y = 9000, z = 14250, a = 0x0000 })
    flood_define_level(false, LEVEL_WF,    "c2",             { x =  -6290, y =   2640, z =   5455, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,   "c3",             { x =   7420, y =  -5395, z =  10050, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,   "c4",             { x =   -480, y =  -1620, z =   9380, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_PSS,   "pss",            { x =  13335, y =   -105, z = -10060, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BITDW, "b1",             { x =     30, y  =  5280, z =   -105, a =  0x0000 }, 2.5,  1,  FLOOD_WATER, nil)
end

local function flood_load_muhly_64_levels()
    game = GAME_MUHLY_64
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Muhly 64"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,              "c1",    { x =   6310, y =   2005, z = -18910, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",    { x =  21400, y =   2890, z =  -2260, a = -0x4000 }, 1.25, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WF,               "c2-2",  { x = -18530, y =   2950, z = -12450, a =  0x0000 }, 1.0,  1,  FLOOD_WATER, { x = 5650, y = 1415, z = -24825, a =  0x0000 })
    flood_define_level(false, LEVEL_WF,               "c2-3",  { x =  -3260, y =   2605, z =  -4395, a =  0x4000 }, 2.5,  1,  FLOOD_WATER, { x = 3775, y = 1415, z =  -6500, a = -0x2000 })
    flood_define_level(false, LEVEL_CCM,              "c4",    { x = -10980, y =      0, z =  -7500, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)
end

local function flood_load_unkown_romhack_1_levels()
    game = GAME_UNKNOWN_ROMHACK_1
    LEVEL_LOBBY = LEVEL_CASTLE
	romhackText = "Unknown Romhack 1"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_logo_generic")

    flood_define_level(false, LEVEL_BOB,              "c1",    { x =   -580, y =   3950, z =  -2815, a =  0x4000 }, 4.5, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "c2",    { x =  -3020, y =   1335, z =   1710, a =  0x8000 }, 2.0, 1,  FLOOD_WATER, { x =  1560, y =  -70, z = 7125, a =  0x8000 })
    flood_define_level(false, LEVEL_CCM,              "c4",    { x =  -4850, y =   2900, z =    170, a =  0x4000 }, 6.5, 1,  FLOOD_WATER, { x = -2415, y = 1000, z =  120, a = -0x4000 })
    flood_define_level(false, LEVEL_CASTLE,           "c",     { x =  -3130, y =    895, z =  -2495, a = -0x4000 }, 8.0, 1,  FLOOD_WATER, nil)	
end

local function flood_load_uranium_mario_64_levels()
    game = GAME_URANIUM_MARIO_64
    LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Uranium Mario 64"
	TEX_ROMHACK_LOGO = get_texture_info("uranium_mario_64_logo")
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)			

    flood_define_level(false, LEVEL_BOB,              "c1",             { x =   4920, y =   4295, z =   3185, a =  0x8000 }, 3.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_BOB,              "c1-2",           { x =   -560, y =   1940, z =   -560, a =  0x2000 }, 5.0,  2,  FLOOD_MUD,   { x =    500, y =   225, z =   585, a =  0x8000 })	
    flood_define_level(false, LEVEL_PSS,              "pss",            { x =   -375, y =   2670, z =  -3750, a = -0x3000 }, 2.0,  1,  FLOOD_MUD,   nil)			
    flood_define_level(false, LEVEL_WF,               "c2",             { x =   2390, y =   8035, z =   -140, a =  0x8000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SA,               "sa",             { x =   3470, y =   1730, z =  -1245, a = -0x4000 }, 1.5,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_JRB,              "c3",             { x =   2300, y =   6610, z =  -6070, a = -0x4000 }, 2.0,  1,  FLOOD_LAVA,  nil)
    flood_define_level(false, LEVEL_CCM,              "c4",             { x =  -8220, y =   5740, z =   4580, a =  0x2000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_CCM,              "c4-2",           { x =   -200, y =     75, z =  -3125, a = -0x2000 }, 2.75, 2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,              "c5",             { x =   3650, y =   6880, z =   3645, a =  0x4000 }, 1.75, 1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_BBH,              "c5-2",           { x =    690, y =   1380, z =  -2680, a =  0x0000 }, 3.0,  2,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_BBH,              "c5-3",           { x =  -1500, y =   5515, z =  -1765, a =  0x2000 }, 4.0,  3,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_VCUTM,            "vc",             { x =  -3365, y =   7080, z =  -2920, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =  -6950, y =  -300, z = -6960, a =  0x4000 })
    flood_define_level(false, LEVEL_VCUTM,            "vc-2",           { x = -17165, y =   3940, z =    600, a =  0x4000 }, 1.25, 1,  FLOOD_WATER, { x =  -8235, y =  -300, z = -2165, a =  0x4000 })
    flood_define_level(false, LEVEL_VCUTM,            "vc-3",           { x =   7950, y =   5145, z =   -900, a =  0x0000 }, 1.75, 1,  FLOOD_WATER, { x =   5065, y = -1040, z =  1140, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITDW,            "b1",             { x =  -4875, y =   7565, z =   1230, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_BOWSER_1,         "bowser-1",       { x =  -1480, y =   1605, z =  -3250, a =  0x1000 }, 0.75, 1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_HMC,              "c6",             { x =   2160, y =   9130, z =   4850, a = -0x2000 }, 2.0,  1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_COTMC,            "mc",             { x =  -1730, y =   7340, z =  -7090, a =  0x4000 }, 4.0,  1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_LLL,              "c7",             { x =   9415, y =   5645, z =  -7010, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_LLL,              "c7-2",           { x =  -6035, y =   8305, z =   9050, a = -0x4000 }, 2.5,  1,  FLOOD_WATER, { x = -11310, y =  1600, z =  9910, a = -0x4000 })
    flood_define_level(false, LEVEL_LLL,              "c7-3",           { x =  -1435, y =   7025, z =   6680, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, { x =  -1535, y =  1100, z =  4475, a =  0x4000 })	
    flood_define_level(false, LEVEL_LLL,              "c7-4",           { x =   2150, y =   4480, z =  -5065, a =  0x0000 }, 3.5,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_SSL,              "c8",             { x =  -2520, y =   5750, z =  -7495, a =  0x4000 }, 1.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TOTWC,            "wc",             { x =   -360, y =   2630, z =   3255, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   4560, y = -1295, z = -4060, a =  0x0000 })	
    flood_define_level(false, LEVEL_DDD,              "c9",             { x =  -1330, y =   6305, z =  18005, a =  0x8000 }, 2.25, 1,  FLOOD_MUD,   nil)
    flood_define_level(false, LEVEL_DDD,              "c9-2",           { x =  -2495, y =   9410, z =    650, a =  0x4000 }, 2.0,  2,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_BITFS,            "b2",             { x =  -1335, y =  10830, z =    870, a = -0x4000 }, 2.25, 1,  FLOOD_MUD,   nil)	
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",       { x = -11555, y =   4580, z =  -1030, a =  0x4000 }, 1.75, 1,  FLOOD_MUD,   nil)		
    flood_define_level(false, LEVEL_BOWSER_2,         "bowser-2",       { x =   9705, y =   8115, z =    360, a =  0x8000 }, 2.25, 1,  FLOOD_MUD,   { x =   5020, y =  3170, z = -3450, a =  0x0000 })
    flood_define_level(false, LEVEL_SL,               "c10",            { x =  -5655, y =   7635, z =    -90, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_WDW,              "c11",            { x =  -3460, y =  12485, z =  -7370, a =  0x8000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,            "wmotr",          { x =   2910, y =   4830, z =   -765, a = -0x4000 }, 1.25, 1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTM,              "c12",            { x =  -2335, y =   3390, z = -16120, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, { x =      0, y =  -890, z = -4240, a =  0x8000 })	
    flood_define_level(false, LEVEL_TTM,              "c12-2",          { x =  -7580, y =   9360, z =  13455, a =  0x8000 }, 1.0,  1,  FLOOD_WATER, { x =  -8010, y =  -890, z = 11840, a =  0x8000 })	
    flood_define_level(false, LEVEL_THI,              "c13",            { x =   1645, y =   -300, z =  -9380, a =  0x0000 }, 1.5,  1,  FLOOD_WATER, nil)		
    flood_define_level(false, LEVEL_BITS,             "b3",             { x =   1030, y =   6085, z =  -5120, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, { x =   7060, y = -4340, z =  3845, a =  0x4000 })
    flood_define_level(false, LEVEL_BITS,             "b3-2",           { x =  -1200, y =   4425, z =   5345, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, { x =  -3895, y = -4520, z =  6200, a =  0x4000 })	
    flood_define_level(false, LEVEL_BITS,             "b3-3",           { x =   7870, y =   4680, z =   3850, a =  0x4000 }, 3.0,  2,  FLOOD_WATER, { x =   1045, y = -5755, z = -5040, a = -0x4000 })
    flood_define_level(false, LEVEL_BOWSER_3,         "bowser-3",       { x =  -1520, y =  13875, z =  -7710, a =  0x4000 }, 2.0,  1,  FLOOD_WATER, nil)				
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "cg",             { x =  -2855, y =   6555, z =   1220, a =  0x1000 }, 2.5,  1,  FLOOD_WATER, nil)	
end

local function flood_load_sm64_land_levels()
    game = GAME_SM64_LAND
	LEVEL_LOBBY = LEVEL_CASTLE_GROUNDS
	romhackText = "Super Mario 64 Land"
	TEX_ROMHACK_LOGO = get_texture_info("sm64_land_logo")
    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)		

    flood_define_level(false, LEVEL_CASTLE,           "tutorial",   { x =  -8955, y =   3225, z =      5, a =  0x4000 }, 4.5,  1,  FLOOD_WATER, { x =   1000, y =  -600, z =      5, a =  -0x4000 })
	-- WORLD 1	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "w1",         { x =  -2575, y =   1710, z =  -1650, a = -0x4000 }, 3.75, 1,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_BOB,              "1-1",        { x =  16515, y =   7850, z = -15320, a =  0x0000 }, 2.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "1-2",        { x =    110, y =   2250, z =  16020, a =  0x8000 }, 1.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WF,               "1-3",        { x =   1955, y =   4550, z =     80, a = -0x4000 }, 1.25, 2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BOB,              "1-4",        { x = -11020, y =   4260, z =  -3930, a =  0x4000 }, 2.0,  2,  FLOOD_WATER, { x =  -8990, y =   505, z = -28665, a =  0x0000 })
	-- WORLD 2	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "w2",         { x =   5810, y =    595, z =   2750, a = -0x4000 }, 4.0,  1,  FLOOD_SAND,  { x =  -4030, y =   710, z =   1810, a =  0x8000 })
    flood_define_level(false, LEVEL_JRB,              "2-1",        { x =  17270, y =  12265, z =  -2685, a = -0x4000 }, 3.5,  1,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_JRB,              "2-2",        { x =  22525, y =   2245, z =   -910, a =  0x0000 }, 1.35, 2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_CCM,              "2-3",        { x = -20895, y =   1030, z =   -985, a =  0x4000 }, 1.5,  1,  FLOOD_SAND,  nil)
    flood_define_level(false, LEVEL_CCM,              "2-4",        { x =   4360, y =   -115, z =  -2650, a = -0x4000 }, 1.5,  2,  FLOOD_SAND,  { x =  -6745, y =  -335, z =   6935, a =  0x8000 })
	-- WORLD 3	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "w3",         { x =   1225, y =   2815, z =  -8345, a =  0x0000 }, 5.0,  2,  FLOOD_WATER, { x =   3350, y =   200, z =  -8330, a = -0x4000 })
    flood_define_level(false, LEVEL_BBH,              "3-1",        { x =  -8615, y =   6300, z = -12585, a =  0x0000 }, 1.75, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,              "3-2",        { x =   3815, y =   6540, z =  -4755, a = -0x6000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SSL,              "3-4",        { x =     50, y =   9890, z =   1165, a = -0x4000 }, 2.0,  1,  FLOOD_WATER, nil)
    -- WORLD 4	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "w4",         { x =  -4560, y =   1350, z =  -2895, a =  0x4000 }, 3.5,  2,  FLOOD_WATER, { x =   2180, y =   280, z =   1725, a =  0x0000 })	
    flood_define_level(false, LEVEL_SL,               "4-1",        { x =  10000, y =      0, z =  17290, a =  0x8000 }, 0.75, 2,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_WDW,              "4-2",        { x =   2180, y =   1830, z =  -9710, a =  0x8000 }, 0.75, 2,  FLOOD_LAVA,  nil)	
    flood_define_level(false, LEVEL_TTC,              "4-3",        { x =    740, y =  10170, z =   7270, a =  0x4000 }, 3.0,  2,  FLOOD_WATER, { x =   6960, y =  7940, z =    560, a =  0x0000 })	
    flood_define_level(false, LEVEL_WDW,              "4-4",        { x =  -3000, y =   3000, z =   5265, a =  0x8000 }, 1.75, 1,  FLOOD_WATER, nil)	
    -- WORLD 5	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "w5",         { x =   1540, y =   2915, z =  -4900, a =  0x0000 }, 2.75, 3,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_DDD,              "4-1",        { x =  -2745, y =   2260, z =    950, a =  0x0000 }, 0.85, 1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_DDD,              "4-2",        { x =  -1375, y =   2380, z =   3100, a = -0x4000 }, 2.0,  2,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_HMC,              "4-3",        { x =  -5060, y =   6450, z =  -4500, a =  0x0000 }, 1.5,  2,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_SL,               "4-4",        { x =  27570, y =    555, z = -18725, a =  0x0000 }, 0.1,  1,  FLOOD_WATER, nil)
	-- WORLD 6	
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "w6",         { x =  -3960, y =   1900, z =    420, a =  0x0000 }, 2.5,  3,  FLOOD_WATER, { x =   8230, y =  1320, z =   -370, a = -0x4000 })	
    flood_define_level(false, LEVEL_TTM,              "6-1",        { x =  15405, y =   6975, z =  11470, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_TTM,              "6-2",        { x =  14830, y =   5350, z =   3990, a = -0x4000 }, 2.5,  2,  FLOOD_WATER, { x =   1120, y =  1850, z =  11570, a =  0x4000 })	
    flood_define_level(false, LEVEL_THI,              "6-4",        { x =  10165, y =   1715, z =   -840, a =  0x4000 }, 0.65, 1,  FLOOD_WATER, nil)	
    -- WORLD 7	
    flood_define_level(false, LEVEL_CASTLE_GROUNDS,   "w7",         { x =  -3760, y =   1630, z =    540, a =  0x0000 }, 2.5,  4,  FLOOD_WATER, { x =  10245, y =   600, z =    420, a = -0x4000 })	
    flood_define_level(false, LEVEL_THI,              "7-1",        { x =  26200, y =  -1515, z =   7220, a =  0x8000 }, 0.75, 2,  FLOOD_WATER, nil) 
    flood_define_level(false, LEVEL_RR,               "7-2",        { x =   4380, y =   1535, z =  -7200, a =  0x4000 }, 1.0,  1,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_TTC,              "7-4",        { x =  -2045, y =   5750, z =    -20, a =  0x4000 }, 3.0,  1,  FLOOD_WATER, nil)
	-- WORLD 8		
    flood_define_level(false, LEVEL_CASTLE_COURTYARD, "w8",         { x =   8605, y =   2020, z =   5595, a = -0x4000 }, 3.0,  4,  FLOOD_WATER, { x = -11290, y =  1490, z =  13320, a =  0x4000 })	 
    flood_define_level(false, LEVEL_SA,               "8-1",        { x =  -5230, y =  -5000, z =   4960, a =  0x8000 }, 2.5,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,            "8-2",        { x =  -6470, y =   4605, z =  -5540, a =  0x0000 }, 2.0,  1,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_WMOTR,            "8-2-slide",  { x = -10985, y =   9210, z =   3480, a =  0x8000 }, 3.5,  1,  FLOOD_WATER, { x =   8250, y = -2960, z =   7720, a =  0x8000 })	
    flood_define_level(false, LEVEL_WMOTR,            "8-3",        { x =   9950, y =   8435, z = -10720, a =  0x0000 }, 2.5,  2,  FLOOD_LAVA,  { x =  10340, y =  1710, z =  11420, a =  0x8000 })	
    flood_define_level(false, LEVEL_BITFS,            "8-4",        { x =   7920, y =  -1115, z =   8795, a =  0x8000 }, 0.75, 1,  FLOOD_WATER, nil)
	-- CHAMPIONS ROAD
    flood_define_level(false, LEVEL_BOB,              "cr",         { x =  23080, y =   3535, z =   1170, a =  0x0000 }, 2.0,  4,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_JRB,              "cr-2",       { x =  -3405, y =   5470, z =   3300, a =  0x4000 }, 2.5,  3,  FLOOD_WATER, nil)	
    flood_define_level(false, LEVEL_BBH,              "cr-3",       { x =    430, y =   6660, z =    -25, a =  0x0000 }, 2.75, 2,  FLOOD_WATER, nil)
    flood_define_level(false, LEVEL_HMC,              "cr-4",       { x =  -2220, y =   8580, z =   1690, a =  0x4000 }, 1.75, 3,  FLOOD_WATER, { x =  -5330, y =  3485, z =  -4010, a =  0x4000 })	
    flood_define_level(false, LEVEL_TTM,              "cr-5",       { x =   3230, y =   5440, z =    620, a =  0x4000 }, 2.0,  3,  FLOOD_WATER, nil)
end

for mod in pairs(gActiveMods) do
    if gActiveMods[mod].incompatible ~= nil and gActiveMods[mod].incompatible:find("romhack") then
        if gActiveMods[mod].name:find("\\#FFA500\\Super Mario 74 ") then
            flood_load_super_mario_74_ten_years_after_levels()
        elseif gActiveMods[mod].name:find("Bowser's Dank Rave 1") then
            flood_load_bowsers_dank_rave_1_levels()					
        elseif gActiveMods[mod].name:find("Bowser's Dank Rave 2: Return of the Illuminati's Dubstep Party") then
            flood_load_bowsers_dank_rave_2_levels()		
        elseif gActiveMods[mod].name:find("Bowser's Dank Rave 3: Toadette's MLG Expansion") then
            flood_load_bowsers_dank_rave_3_levels()					
        elseif gActiveMods[mod].name:find("King Boo's Revenge 2") then
            flood_load_king_boo_revenge_2_levels()						
        elseif gActiveMods[mod].name:find("SM64WW") then
            flood_load_ww_mostrecent_levels()		
        elseif gActiveMods[mod].name:find("SM64 MADNESS") then
            flood_load_super_mario_64_madness_levels()	
        elseif gActiveMods[mod].name:find("Year of the Plumber C3 Demo") then
            flood_load_year_of_the_plumber_levels()	
        elseif gActiveMods[mod].name:find("Royal Legacy") then	
            flood_load_royal_legacy_levels()		
        elseif gActiveMods[mod].name:find("Heroes") then	
            flood_load_mario_heroes_64_levels()				
        elseif gActiveMods[mod].name:find("Muhly64") then	
            flood_load_muhly_64_levels()	
        elseif gActiveMods[mod].name:find("Unknown Romhack 1") then	
            flood_load_unkown_romhack_1_levels()				
        elseif gActiveMods[mod].name:find("Super Mario Fallen Stars") then
            flood_load_super_mario_fallen_stars_levels()								
        elseif gActiveMods[mod].name:find("Super Mario: The Stolen Stars") then
            flood_load_super_mario_the_stolen_stars_levels()	
        elseif gActiveMods[mod].name:find("Super Mario 64 LentiLevels") then
            flood_load_super_mario_64_lenti_levels()		
        elseif gActiveMods[mod].name:find("SM64 Rocky Mountain Revisited") then
            flood_load_rocky_mountain_revisited_levels()		
        elseif gActiveMods[mod].name:find("Twisted Adventures 2 Demo") then
            flood_load_sm64_twisted_adventures_2_levels()	
        elseif gActiveMods[mod].name:find("Shining Stars 2") then
            flood_load_shining_stars_2_levels()		
        elseif gActiveMods[mod].name:find("Super Mario Star") then
            flood_load_super_mario_star_levels()					
        elseif gActiveMods[mod].name:find("The Power Star Journey") then
            flood_load_the_power_star_journey_levels()				
        elseif gActiveMods[mod].name:find("Despair") then
            flood_load_despair_marios_gambit_levels()		
        elseif gActiveMods[mod].name:find("Jammin Journey") then
            flood_load_super_mario_jammin_journey_levels()						
        elseif gActiveMods[mod].name:find("Compact") then
            flood_load_compact_challenges_levels()					
        elseif gActiveMods[mod].name:find("SM64: ") and gActiveMods[mod].name:find("It's A Crash!") then	
            flood_load_sm64_its_a_crash_levels()
        elseif gActiveMods[mod].name:find("Return To Retroland") then	
            flood_load_return_to_retroland_levels()
        elseif gActiveMods[mod].name:find("Letterful Wood Blocks") then	
            flood_load_letterful_wood_blocks_levels()			
        elseif gActiveMods[mod].name:find("Super Mario 74") then
            flood_load_super_mario_74_and_extreme_edition_levels()	
        elseif gActiveMods[mod].name:find("Super Mario and the Grand Star") then
            flood_load_grand_star_levels()			
        elseif gActiveMods[mod].name:find("Star Road") then
            flood_load_star_road_levels()
        elseif gActiveMods[mod].name:find("Star Road Autumm") then
            flood_load_star_road_levels()				
        elseif gActiveMods[mod].name:find("SM64: The Green Stars") then
            flood_load_sm64_the_green_stars_levels()				
        elseif gActiveMods[mod].name:find("\\#7dc403\\Luigi's Mansion 64\\#7dc403\\") then		
            flood_load_luigis_mansion_64_levels()
        elseif gActiveMods[mod].name:find("Katze Stuck in the Toilet 64") then		
            flood_load_katze_stuck_in_the_toilet_levels()				
        elseif gActiveMods[mod].name:find("Super Mario and the Marvel Adventure") then		
            flood_load_super_mario_and_the_marvel_adventure_levels()		
        elseif gActiveMods[mod].name:find("Super Mario 64 Moonshine") then		
            flood_load_moonshine_levels()		
        elseif gActiveMods[mod].name:find("Eureka") then		
            flood_load_eureka_levels()			
        elseif gActiveMods[mod].name:find("Scrooge 64") then		
            flood_load_scrooge_64_levels()			
        elseif gActiveMods[mod].name:find("Super Mario Parallel Stars") then		
            flood_load_super_mario_parallel_stars_levels()	
        elseif gActiveMods[mod].name:find("\\#074916\\Luigi and the Forest Ruins") then
            flood_load_luigi_and_the_forest_ruins_levels()			
        elseif gActiveMods[mod].name:find("\\#ff8173\\Mario in the \\#ff0f6b\\Dreamscape \\#ffffff\\") then
            flood_load_mario_in_the_dreamscape_levels()					
        elseif gActiveMods[mod].name:find("\\#fc2819\\Mario \\#3ffc19\\In The \\#19fcea\\Colorful Lands") then
            flood_load_mario_in_the_colorful_lands_levels()			
        elseif gActiveMods[mod].name:find("SM64 \\#0f52ba\\Sapphire\\#ffffff\\ v1.1") then
     		flood_load_super_mario_64_sapphire_levels()					
        elseif gActiveMods[mod].name:find("\\#ff2b1c\\The \\#636363\\Mushroom \\#ffb742\\Cup") then	
            flood_load_the_mushroom_cup_levels()	
        elseif gActiveMods[mod].name:find("The Galactic Journey") then
            flood_load_the_galactic_journey_levels()		
        elseif gActiveMods[mod].name:find("Star Revenge 1.3") then
            flood_load_star_revenge_1_3_redone_levels()		
        elseif gActiveMods[mod].name:find("\\#F00\\S\\#F70\\R\\#FF0\\3:\\#0F0\\Mario \\#00F\\on \\#408\\A \\#90D\\Saoire") then
            flood_load_star_revenge_3_levels()							
        elseif gActiveMods[mod].name:find("\\#FF0730\\Star Revenge 6: \\#08FF00\\Luigi's Adventure ") then
            flood_load_star_revenge_6_levels()		
        elseif gActiveMods[mod].name:find("Brutal Mario 64") then
            flood_load_brutal_mario_64_levels()		
        elseif gActiveMods[mod].name:find("Some Kind of a Crash Game") then
            flood_load_some_kind_of_a_crash_game_levels()	
        elseif gActiveMods[mod].name:find("\\#ff38cd\\Beat \\#ff38cd\\Block \\#ff38cd\\Beatdown") then	
            flood_load_beat_block_beatdown_levels()		
        elseif gActiveMods[mod].name:find("\\#30ff42\\Super Luigi 64: \\#ff7824\\The Flower Cup") then
     		flood_load_super_luigi_64_the_flower_cup_levels()			
        elseif gActiveMods[mod].name:find("Lug's Delightful Dioramas") then
            flood_load_lugs_delightful_dioramas_levels()			
        elseif gActiveMods[mod].name:find("Project Reimagined Demo") then
            flood_load_project_reimagined_demo_levels()
        elseif gActiveMods[mod].name:find("Star Revenge 1: Star Takeover") then
            flood_load_star_revenge_1_levels()	
        elseif gActiveMods[mod].name:find("\\#00BCFF\\Star Revenge 6.9\\#FFFFFF\\: \\#00FF5E\\Luigi Lost in Time") then
            flood_load_star_revenge_6_9_levels()		
        elseif gActiveMods[mod].name:find("\\#F78AF5\\B\\#F94A36\\3\\#4C5BFF\\3\\#EDD83D\\1\\#16C31C\\3") then
            flood_load_b3313_levels()						
        elseif gActiveMods[mod].name:find("\\#00FFFF\\Star Revenge \\#0033FF\\5 \\#0062FF\\Neo Blue Realm") then
            flood_load_star_revenge_5_levels()				
        elseif gActiveMods[mod].name:find("\\#FFC600\\Star \\#00BEFF\\Revenge \\#FF0034\\7\\#E7E7E7\\") then
            flood_load_star_revenge_7_levels()		
        elseif gActiveMods[mod].name:find("Super Mario 64 \\#ff0000\\Extra") then
            flood_load_super_mario_64_extra_levels()	
        elseif gActiveMods[mod].name:find("Super Mario 64 Odyssey") then
            flood_load_super_mario_64_odyssey_levels()	
        elseif gActiveMods[mod].name:find("\\#383bfc\\Star Revenge 4.5: \\#ffed24\\The Kedama Takeover Redone") then
            flood_load_star_revenge_4_5_levels()		
        elseif gActiveMods[mod].name:find("Star Revenge 0.5: Unused Levels") then
            flood_load_star_revenge_0_5_levels()			
        elseif gActiveMods[mod].name:find("Luigi's Mansion 64.5") then		
            flood_load_luigis_mansion_64_super_player_mode_levels()
        elseif gActiveMods[mod].name:find("\\#fc9acb\\Blossoming \\#fdff96\\Bluds") then		
            flood_load_blossoming_bluds_levels()	
        elseif gActiveMods[mod].name:find("Waifu Cauldron") then		
            flood_load_waifu_cauldron_levels()		
        elseif gActiveMods[mod].name:find("tyd64") then
            flood_load_tyd64_levels()
        elseif gActiveMods[mod].name:find("Nice Mario 75") then
            flood_load_nice_mario_75_levels()		
        elseif gActiveMods[mod].name:find("\\#0c33c2\\Ztar Attack \\#c20c0c\\2") then
            flood_load_ztar_attack_2_levels()			
        elseif gActiveMods[mod].name:find("Dream64") then
            flood_load_dream64_levels()	
        elseif gActiveMods[mod].name:find("SM64 ") and gActiveMods[mod].name:find("-") and gActiveMods[mod].name:find(" Twisted Adventures") then
            flood_load_sm64_twisted_adventures_levels()
        elseif gActiveMods[mod].name:find("Super Mario Bros 64") then
            flood_load_super_mario_bros_64_levels()					
        elseif gActiveMods[mod].name:find("\\#a1a1a1\\Winterbottom's Pie Trials") then
            flood_load_winterbottom_pie_trials()			
        elseif gActiveMods[mod].name:find("Servus 64") then
            flood_load_servus_64_levels()
        elseif gActiveMods[mod].name:find("Super Mario Rainbow Road") then
            flood_load_rainbow_road_levels()
        elseif gActiveMods[mod].name:find("\\#66ff82\\Luigi \\#ffffff\\& \\#ff66fa\\The Violet Stars") then
            flood_load_luigi_the_violet_stars_levels()
        elseif gActiveMods[mod].name:find("Super Mario 64 Into Bowser's Castle") then
            flood_load_sm64_into_bowsers_castle_levels()		
        elseif gActiveMods[mod].name:find("\\#00AFFA\\Star Revenge 2.5:\\#9700FF\\ Remnant of Doom") then
            flood_load_star_revenge_2_5_levels()			
	    elseif gActiveMods[mod].name:find("\\#2C82C9\\Star Revenge 1.5: \\#F37934\\Star Takeover Redone") then
            flood_load_star_revenge_1_5_redone_levels()			
        elseif gActiveMods[mod].name:find("Mario's Treasure Dome") then	
            flood_load_marios_treasure_dome_levels()		
        elseif gActiveMods[mod].name:find("Mario's Nightmare 64") then
            flood_load_marios_nightmare_64_levels()
        elseif gActiveMods[mod].name:find("Cursed Castles") then
            flood_load_super_mario_and_the_cursed_castle_levels()		
        elseif gActiveMods[mod].name:find("Star Revenge 2: Night of Doom") then
            flood_load_star_revenge_2_levels()	
        elseif gActiveMods[mod].name:find("\\#D10000\\Star \\#FFB128\\Revenge \\#7238BD\\7.5: Kedowser's Return") then
            flood_load_star_revenge_7_5_levels()		
        elseif gActiveMods[mod].name:find("\\#0035ff\\Star Revenge 4.9:\\#8500af\\ Adulterated Reality") then
            flood_load_star_revenge_4_9_levels()	
        elseif gActiveMods[mod].name:find("\\#FF4500\\SM64 Last Impact") then
            flood_load_sm64_last_impact_levels()
        elseif gActiveMods[mod].name:find("SM64 The Dark Stars") then
            flood_load_sm64_the_dark_stars_levels()			
        elseif gActiveMods[mod].name:find("Eternal Realm") then
            flood_load_eternal_realm_levels()		
        elseif gActiveMods[mod].name:find("\\#ff0000\\ Through The Ages") then
            flood_load_through_the_ages_levels()	
        elseif gActiveMods[mod].name:find("Super Trump 64") then
            flood_load_super_trump_64_levels()	
        elseif gActiveMods[mod].name:find("SM64 \\#ff00ff\\Masters Challenge \\#dddddd\\V0.5") then
            flood_load_sm64_masters_challenge_levels()	
        elseif gActiveMods[mod].name:find("\\#08FF00\\Yoshi's Adventure \\#FF0730\\64") then
            flood_load_yoshis_adventure_64_levels()			
        elseif gActiveMods[mod].name:find("Super Mario Treasure World") then
            flood_load_super_mario_treasure_world_levels()	
        elseif gActiveMods[mod].name:find("\\#0A8DFF\\Super Mario \\#FFFF00\\8MB\\#FFCD00\\") then
            flood_load_super_mario_8mb_levels()	
        elseif gActiveMods[mod].name:find("Sonic Adventure 64 DX") then
            flood_load_sonic_adventure_64_levels()		
        elseif gActiveMods[mod].name:find("Sleepy Time 64") then
            flood_load_sleepy_time_64_levels()		
        elseif gActiveMods[mod].name:find("\\#45fc38\\Uranium \\#38f9fc\\Mario \\#45fc38\\64") then
            flood_load_uranium_mario_64_levels()	
        elseif gActiveMods[mod].name:find("\\#00FF00\\SM\\#FF4500\\64 Land") then
            flood_load_sm64_land_levels()		
        elseif gActiveMods[mod].relativePath == "SM74EEEE" then
            flood_load_super_mario_74_EEEE_levels()		
        elseif gActiveMods[mod].relativePath == "SM74EEEEEE" then
            flood_load_super_mario_74_EEEEEE_levels()
        elseif gActiveMods[mod].relativePath == "SM74EEEEEE 2" then
            flood_load_super_mario_74_EEEEEE_2_levels()		
        elseif gActiveMods[mod].relativePath == "Kaizo Mario 64" then
            flood_load_kaizo_mario_64_levels()					
        elseif gActiveMods[mod].relativePath == "Kaizo Mario 64 2" then
            flood_load_kaizo_mario_64_2_levels()				
        elseif gActiveMods[mod].name:find("Shining Stars") then
            flood_load_super_mario_64_shining_stars_levels()			
        else
            unsupported = true
            djui_popup_create("\\#FF5050\\This Romhack has not been ported to   \\#dcdcdc\\Flood \\#FFC500\\Romhack", 5)
        end
    end
end

if not unsupported and game == GAME_VANILLA then
    flood_load_vanilla_levels()
end